/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow;

import com.google.common.base.Predicates;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessConstantInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessFieldByVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessFieldInObjectContextInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpArrayAccessInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpBaseCaseConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpBreakContinueInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpCallInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpCaseConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpCatchConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpClassDeclarationInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConstantDeclarationInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConstructorCallInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpEntryPointInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpExitPointInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpFinallyEndInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpForeachHostInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpFunctionDeclarationInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpGotoLabelDefinitionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpHostInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpImplicitPromotedFieldAssignmentInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpIncludeInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInterruptScriptInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpLinearInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpLoopHostInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpNullSafeDerefConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpReturnInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpStatementInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpThrowInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpTryInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpVariableDocDeclarationInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpYieldInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpDefaultMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpGoto;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrow;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.RWAccess;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MultiassignmentExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpYieldImpl;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpControlFlowBuilder
extends PhpRecursiveElementVisitor {
    private static final Logger LOG = Logger.getInstance(PhpControlFlowBuilder.class);
    private final Stack<PsiElement> myAlreadyComputedAssignmentDependency;
    private final Collection<Function> myClosures;
    private static final String COMPACT_FUNCTION = "compact";
    private static final String ASSERT_FUNCTION = "assert";
    private final PhpScopeHolder myScopeHolder;
    private final List<PhpInstruction> instructions;
    private final List<PhpMarkerInstruction> myMarkerInstructions;
    private final List<BreakContinueTarget> myBreakContinueTargetList;
    private final List<PhpHostInstruction> myCatchMatchingList;
    private final SmartList<PhpFinallyInstructionsBlock> myFinallyBlocks;
    private final Stack<PhpConditionInstructionImpl> myTrueTargets;
    private final Stack<PhpConditionInstructionImpl> myFalseTargets;
    private Map<String, PhpGotoLabelDefinitionInstructionImpl> myLabelToDefinitionInstruction;
    private MultiMap<String, PhpMarkerInstruction> myLabelToGotoInstruction;
    @Nullable
    private PhpPsiElement myCurrentValue;
    @Nullable
    private PhpAccessInstruction.Access myParentAccess;
    private boolean myCurrentValueIsExpressionResult;
    private PhpAccessInstruction.Access myCurrentValuePostAccess;
    @Nullable
    private PhpInstructionImpl lastInstruction;
    private final PhpEntryPointInstructionImpl myEntryInstruction;
    private final PhpExitPointInstructionImpl myExitInstruction;
    private final Stack<NullSafeMarkerOutInfo> myTopmostNullSafeMemberReferenceOutMarker;

    public PhpControlFlowBuilder(@NotNull PhpScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(0);
        }
        this.myAlreadyComputedAssignmentDependency = new Stack();
        this.myClosures = new LinkedHashSet<Function>();
        this.instructions = new ArrayList<PhpInstruction>();
        this.myMarkerInstructions = new SmartList();
        this.myBreakContinueTargetList = new SmartList();
        this.myCatchMatchingList = new SmartList();
        this.myFinallyBlocks = new SmartList();
        this.myTrueTargets = new Stack();
        this.myFalseTargets = new Stack();
        this.myLabelToDefinitionInstruction = null;
        this.myLabelToGotoInstruction = null;
        this.myCurrentValue = null;
        this.myParentAccess = null;
        this.myCurrentValueIsExpressionResult = false;
        this.myCurrentValuePostAccess = null;
        this.lastInstruction = null;
        this.myEntryInstruction = new PhpEntryPointInstructionImpl();
        this.myExitInstruction = new PhpExitPointInstructionImpl();
        this.myTopmostNullSafeMemberReferenceOutMarker = new Stack();
        this.myScopeHolder = scopeHolder;
    }

    public PhpControlFlow build() {
        this.addInstruction(this.myEntryInstruction);
        this.myClosures.forEach(this.myEntryInstruction::addClosureAfter);
        try {
            if (this.myScopeHolder instanceof Method && ((Method)this.myScopeHolder).getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
                this.addImplicitPromotedFieldAssignments((Method)this.myScopeHolder);
            }
            this.myScopeHolder.acceptChildren((PsiElementVisitor)this);
        }
        catch (StackOverflowError e) {
            if (this.myScopeHolder.getContainingFile().getVirtualFile() != null) {
                LOG.warn("SOE when trying to build control flow on " + this.myScopeHolder.getName() + " in " + this.myScopeHolder.getContainingFile().getVirtualFile().getPath(), (Throwable)e);
            }
            return new PhpControlFlowImpl(PhpControlFlowImpl.EMPTY);
        }
        this.addInstruction(this.myExitInstruction);
        for (PhpMarkerInstruction curInstruction : this.myMarkerInstructions) {
            Collection<PhpInstruction> predInstructions = curInstruction.getPredecessors();
            predInstructions.remove(curInstruction);
            PhpInstructionImpl successor = curInstruction.getSuccessor();
            for (PhpInstruction predInstruction : predInstructions) {
                PhpInstructionImpl newSuccessor = ((PhpInstructionImpl)predInstruction).isUnreachable() ? null : successor;
                ((PhpInstructionImpl)predInstruction).replaceSuccessor(curInstruction, newSuccessor);
                if (newSuccessor == null || !(curInstruction instanceof PhpIfOutMarkerInstruction)) continue;
                newSuccessor.addAmbiguousInstructions(curInstruction.getAmbiguousConditionsInstructions());
            }
            if (successor != null) {
                successor.getPredecessors().remove(curInstruction);
                List predecessorsToAdd = ContainerUtil.filter(predInstructions, p -> !((PhpInstructionImpl)p).isUnreachable());
                successor.getPredecessors().addAll(predecessorsToAdd);
                if (curInstruction instanceof PhpForeachOutInstruction) {
                    ((PhpForeachOutInstruction)curInstruction).myHost.getOutInstructions().add(successor);
                    if (((PhpForeachOutInstruction)curInstruction).getArrayName() != null) {
                        PhpInstruction skippedLoopForeachHostInstruction = (PhpInstruction)ContainerUtil.find((Iterable)predecessorsToAdd, PhpForeachHostInstructionImpl.class::isInstance);
                        if (skippedLoopForeachHostInstruction != null) {
                            successor.setSkipLoopPredecessor(new PhpSkippedLoopInstruction(skippedLoopForeachHostInstruction, ((PhpForeachOutInstruction)curInstruction).getArrayName()));
                        }
                    }
                }
            }
            curInstruction.dispose();
        }
        this.myMarkerInstructions.clear();
        for (int i = 0; i < this.instructions.size(); ++i) {
            ((PhpInstructionImpl)this.instructions.get((int)i)).myNumber = i;
        }
        return new PhpControlFlowImpl(this.instructions.toArray(new PhpInstruction[0]));
    }

    private void addImplicitPromotedFieldAssignments(Method method) {
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isPromotedField()) continue;
            this.addInstruction(new PhpAccessVariableInstructionImpl((PhpPsiElement)parameter, parameter.getName(), PhpAccessInstruction.Access.READ_ACCESS));
            this.addInstruction(new PhpImplicitPromotedFieldAssignmentInstructionImpl(parameter));
        }
    }

    protected void interruptFlow() {
        this.lastInstruction = null;
    }

    private void addInstruction(@NotNull PhpInstructionImpl instruction) {
        if (instruction == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(1);
        }
        if (!(this.lastInstruction == null || instruction instanceof PhpExitPointInstruction && this.lastInstruction.isUnreachable())) {
            this.lastInstruction.join(instruction);
        }
        this.lastInstruction = instruction;
        if (instruction instanceof PhpMarkerInstruction) {
            this.myMarkerInstructions.add((PhpMarkerInstruction)instruction);
        } else {
            this.instructions.add(instruction);
        }
    }

    private PhpStatementInstruction addStatementInstruction(@NotNull Statement statement) {
        if (statement == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(2);
        }
        PhpStatementInstructionImpl statementInstruction = new PhpStatementInstructionImpl(statement);
        this.addInstruction(statementInstruction);
        return statementInstruction;
    }

    private void jump(@NotNull PhpInstructionImpl endInstruction) {
        if (endInstruction == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(3);
        }
        if (this.lastInstruction != null) {
            if (!this.lastInstruction.isUnreachable()) {
                this.lastInstruction.join(endInstruction);
            }
            this.interruptFlow();
        }
    }

    private void popBreakContinueTargets() {
        this.myBreakContinueTargetList.remove(this.myBreakContinueTargetList.size() - 1);
    }

    private void pushBreakContinueTargets(@NotNull Statement statement, @NotNull PhpMarkerInstruction breakTarget, @NotNull PhpMarkerInstruction continueTarget) {
        if (statement == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(4);
        }
        if (breakTarget == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(5);
        }
        if (continueTarget == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(6);
        }
        this.myBreakContinueTargetList.add(new BreakContinueTarget(statement, breakTarget, continueTarget));
    }

    private void pushConditionTargets(@NotNull PhpConditionInstructionImpl trueTarget, @NotNull PhpConditionInstructionImpl falseTarget) {
        if (trueTarget == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(7);
        }
        if (falseTarget == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(8);
        }
        assert (trueTarget.getResult());
        assert (!falseTarget.getResult());
        this.myTrueTargets.push((Object)trueTarget);
        this.myFalseTargets.push((Object)falseTarget);
    }

    private void popConditionTargets() {
        this.myTrueTargets.pop();
        this.myFalseTargets.pop();
    }

    private void resetCurrentValue(@NotNull PhpAccessInstruction.Access access, boolean resetExpressionsResults) {
        if (access == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(9);
        }
        this.resetCurrentValue(access, null, resetExpressionsResults);
    }

    private void resetCurrentValue(@NotNull PhpAccessInstruction.Access access, PsiElement assignedValue, boolean resetExpressionsResults) {
        if (access == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(10);
        }
        if (this.myCurrentValue instanceof Variable) {
            Variable variable;
            if (PhpWorkaroundUtil.isReadReference((PsiElement)this.myCurrentValue) && access == PhpAccessInstruction.Access.READ_ACCESS) {
                access = PhpAccessInstruction.Access.READ_REF_ACCESS;
            }
            if ((variable = (Variable)this.myCurrentValue).canReadName()) {
                CharSequence variableName = variable.getNameCS();
                if (!this.myCurrentValueIsExpressionResult || resetExpressionsResults) {
                    this.addInstruction(new PhpAccessVariableInstructionImpl((PhpPsiElement)variable, variableName, access, assignedValue));
                }
                if (this.myCurrentValuePostAccess != null) {
                    this.addInstruction(new PhpAccessVariableInstructionImpl((PhpPsiElement)variable, variableName, this.myCurrentValuePostAccess, assignedValue));
                }
            }
        } else if (this.myCurrentValue instanceof ConstantReference) {
            ConstantReference constantReference = (ConstantReference)this.myCurrentValue;
            CharSequence constantName = constantReference.getNameCS();
            if (!StringUtil.isEmpty((CharSequence)constantName) && !PhpLangUtil.isBuiltInConstant(constantName)) {
                this.addInstruction(new PhpAccessConstantInstructionImpl(constantReference, access, constantName));
            }
        } else if (this.myCurrentValue instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)this.myCurrentValue;
            CharSequence fieldName = fieldReference.getNameCS();
            if (!(StringUtil.isEmpty((CharSequence)fieldName) || this.myCurrentValueIsExpressionResult && !resetExpressionsResults)) {
                PhpExpression reference = fieldReference.getClassReference();
                if (reference instanceof ClassReference) {
                    if (PhpLangUtil.isSelfReference((ClassReference)reference)) {
                        this.addInstruction(new PhpAccessFieldInObjectContextInstructionImpl(fieldName, fieldReference, access));
                    }
                } else {
                    CharSequence variableName = reference instanceof Variable ? ((Variable)reference).getNameCS() : null;
                    this.addInstruction(new PhpAccessFieldByVariableInstructionImpl(fieldName, variableName, fieldReference, access));
                }
            }
        } else if (this.myCurrentValue instanceof ArrayAccessExpression) {
            ArrayAccessExpression accessExpression = (ArrayAccessExpression)this.myCurrentValue;
            PhpPsiElement value = accessExpression.getValue();
            CharSequence variableName = value instanceof Variable ? ((Variable)value).getNameCS() : null;
            ArrayIndex arrayIndex = accessExpression.getIndex();
            if (arrayIndex != null && (!this.myCurrentValueIsExpressionResult || resetExpressionsResults)) {
                this.addInstruction(new PhpArrayAccessInstructionImpl(variableName, (PsiElement)arrayIndex.getValue(), (PhpPsiElement)accessExpression, access));
            }
        }
        this.myCurrentValue = null;
        this.myCurrentValueIsExpressionResult = true;
        this.myCurrentValuePostAccess = null;
    }

    private void resetCurrentValueWeak(@NotNull PhpAccessInstruction.Access access) {
        if (access == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(11);
        }
        this.resetCurrentValue(this.myParentAccess == null ? access : this.myParentAccess, true);
    }

    private void resetCurrentValue(@NotNull PhpAccessInstruction.Access access) {
        if (access == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(12);
        }
        this.resetCurrentValue(access, true);
    }

    private void resetCurrentValueAfterStatement() {
        this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS, false);
    }

    private void setCurrentValue(@Nullable PhpPsiElement currentValue, boolean isExpressionResult) {
        this.myCurrentValue = currentValue;
        this.myCurrentValueIsExpressionResult = isExpressionResult;
    }

    private void processFollowingDocComment(@Nullable PsiElement value) {
        PhpDocComment docComment;
        if (value != null && (docComment = (PhpDocComment)PhpPsiUtil.findNextSiblingOfAnyType(value, new IElementType[]{PhpDocElementTypes.DOC_COMMENT})) != null) {
            docComment.accept((PsiElementVisitor)this);
        }
    }

    @Nullable
    private BreakContinueTarget getBreakContinueTarget(@Nullable PsiElement argument) {
        while (argument instanceof ParenthesizedExpression) {
            argument = ((ParenthesizedExpression)argument).getArgument();
        }
        if (argument != null) {
            Integer arg = PhpCodeInsightUtil.toInt(argument);
            if (arg == null) {
                return this.getBreakContinueTarget(1);
            }
            return this.getBreakContinueTarget(arg);
        }
        return this.getBreakContinueTarget(1);
    }

    @Nullable
    private BreakContinueTarget getBreakContinueTarget(int number) {
        if (number < 1) {
            number = 1;
        }
        if (number > this.myBreakContinueTargetList.size()) {
            return null;
        }
        return this.myBreakContinueTargetList.get(this.myBreakContinueTargetList.size() - number);
    }

    @NotNull
    private Map<String, PhpGotoLabelDefinitionInstructionImpl> getLabelToDefinitionInstructionMap() {
        if (this.myLabelToDefinitionInstruction == null) {
            this.myLabelToDefinitionInstruction = new THashMap();
        }
        Map<String, PhpGotoLabelDefinitionInstructionImpl> map = this.myLabelToDefinitionInstruction;
        if (map == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(13);
        }
        return map;
    }

    @NotNull
    private MultiMap<String, PhpMarkerInstruction> getLabelToGotoInstructionMap() {
        if (this.myLabelToGotoInstruction == null) {
            this.myLabelToGotoInstruction = new MultiMap();
        }
        MultiMap<String, PhpMarkerInstruction> multiMap = this.myLabelToGotoInstruction;
        if (multiMap == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(14);
        }
        return multiMap;
    }

    public void visitPhpClass(PhpClass clazz) {
        if (!this.shouldProcess((PsiElement)clazz)) {
            return;
        }
        this.addInstruction(PhpControlFlowBuilder.createClassDeclarationInstruction(clazz));
    }

    public void visitPhpNamespace(PhpNamespace namespace) {
        if (!this.shouldProcess((PsiElement)namespace)) {
            return;
        }
    }

    public void visitPhpFunction(Function function) {
        if (!this.shouldProcess((PsiElement)function)) {
            return;
        }
        if (function.isClosure()) {
            for (Variable variable : PhpControlFlowBuilder.getUsedVariables(function, this.myScopeHolder)) {
                if (variable == null) continue;
                variable.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpWorkaroundUtil.isReadReference((PsiElement)variable) ? PhpAccessInstruction.Access.READ_REF_ACCESS : PhpAccessInstruction.Access.READ_ACCESS);
            }
            if (this.lastInstruction != null) {
                this.lastInstruction.addClosureAfter(function);
            } else {
                this.myClosures.add(function);
            }
        } else {
            this.addInstruction(PhpControlFlowBuilder.createFunctionDeclarationInstruction(function));
        }
    }

    @NotNull
    public static Collection<Variable> getUsedVariables(@NotNull Function closure, PhpScopeHolder scopeHolder) {
        if (closure == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(15);
        }
        if (FunctionImpl.isShortArrowFunction(closure)) {
            return PhpControlFlowBuilder.getVariablesUsedInShortArrowFunction(closure, scopeHolder);
        }
        ArrayList<Variable> usedVariables = new ArrayList<Variable>(PhpPsiUtil.getUsedVariables(closure));
        if (scopeHolder instanceof Method) {
            PsiTreeUtil.processElements((PsiElement)closure, element -> {
                if (element instanceof Variable && PhpLangUtil.isThisReference(element)) {
                    usedVariables.add((Variable)element);
                    return false;
                }
                return true;
            });
        }
        ArrayList<Variable> arrayList = usedVariables;
        if (arrayList == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<Variable> getVariablesUsedInShortArrowFunction(@NotNull Function function, PhpScopeHolder outerScope) {
        if (function == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(17);
        }
        List list = ((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)function, Variable.class)).filter(var -> StringUtil.isNotEmpty((String)var.getName()))).filter(var -> !PhpControlFlowBuilder.getParentClosuresParameterNames((PsiElement)var, outerScope).contains(var.getName()))).distinct(PhpNamedElement::getName)).filter((Predicate)Predicates.not(PhpControlFlowBuilder::isAssignedVariable))).toList();
        if (list == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static boolean isAssignedVariable(Variable v) {
        PsiElement parent = v.getParent();
        return parent instanceof AssignmentExpression && ((AssignmentExpression)parent).getVariable() == v;
    }

    private static Collection<String> getParentClosuresParameterNames(PsiElement anchor, PhpScopeHolder outerScope) {
        Function shortArrowFunctionParent;
        HashSet<String> parameterNames = new HashSet<String>();
        while ((shortArrowFunctionParent = (Function)PhpPsiUtil.getParentByCondition(anchor, true, (Condition<? super PsiElement>)((Condition)a -> a instanceof Function && ((Function)a).isClosure()), (Condition<? super PsiElement>)((Condition)a -> a == outerScope))) != null) {
            for (Parameter parameter : shortArrowFunctionParent.getParameters()) {
                parameterNames.add(parameter.getName());
            }
            anchor = shortArrowFunctionParent;
        }
        return parameterNames;
    }

    public void visitPhpUseList(PhpUseList useList) {
        if (!this.shouldProcess((PsiElement)useList)) {
            return;
        }
    }

    public void visitPhpConstant(Constant constant) {
        if (!this.shouldProcess((PsiElement)constant)) {
            return;
        }
        if (constant instanceof PhpDefine) {
            constant.acceptChildren((PsiElementVisitor)this);
        } else {
            PsiElement value = constant.getValue();
            if (value != null) {
                value.accept((PsiElementVisitor)this);
            }
        }
        this.addInstruction(new PhpConstantDeclarationInstructionImpl(constant));
    }

    public void visitPhpExit(PhpExit exitExpression) {
        if (!this.shouldProcess((PsiElement)exitExpression)) {
            return;
        }
        PhpPsiElement argument = exitExpression.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.interrupt();
    }

    public void visitPhpInclude(Include include) {
        if (!this.shouldProcess((PsiElement)include)) {
            return;
        }
        PhpPsiElement argument = include.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.addInstruction(new PhpIncludeInstructionImpl(include));
    }

    public void visitPhpIsset(PhpIsset issetExpression) {
        if (!this.shouldProcess((PsiElement)issetExpression)) {
            return;
        }
        for (PhpExpression variable : issetExpression.getVariables()) {
            if (variable == null) continue;
            this.withParentAccess(PhpAccessInstruction.Access.ISSET_ACCESS, () -> {
                variable.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.ISSET_ACCESS);
            });
        }
    }

    private void withParentAccess(PhpAccessInstruction.Access access, Runnable r) {
        this.myParentAccess = access;
        try {
            r.run();
        }
        finally {
            this.myParentAccess = null;
        }
    }

    public void visitPhpEmpty(PhpEmpty emptyExpression) {
        if (!this.shouldProcess((PsiElement)emptyExpression)) {
            return;
        }
        for (PhpExpression variable : emptyExpression.getVariables()) {
            if (variable == null) continue;
            this.withParentAccess(PhpAccessInstruction.Access.LIGHT_READ_ACCESS, () -> {
                variable.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.LIGHT_READ_ACCESS);
            });
        }
    }

    public void visitPhpPrint(PhpPrintExpression printExpression) {
        if (!this.shouldProcess((PsiElement)printExpression)) {
            return;
        }
        PhpPsiElement argument = printExpression.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
        if (!this.shouldProcess((PsiElement)expression)) {
            return;
        }
        PhpPsiElement argument = expression.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.setCurrentValue(argument, true);
    }

    public void visitPhpUnaryExpression(UnaryExpression expr) {
        if (!this.shouldProcess((PsiElement)expr)) {
            return;
        }
        PhpPsiElement value = expr.getValue();
        if (value != null) {
            value.accept((PsiElementVisitor)this);
            IElementType expressionType = expr.getNode().getElementType();
            if (expressionType == PhpElementTypes.POSTFIX_EXPRESSION) {
                value.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
                return;
            }
            if (expressionType == PhpElementTypes.INFIX_WRITE_EXPRESSION) {
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
                value.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
            } else {
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
        }
        this.setCurrentValue(value, true);
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        if (!this.shouldProcess((PsiElement)expression)) {
            return;
        }
        IElementType type = expression.getOperationType();
        if (PhpLangUtil.isShortCircuitAndOperator(type)) {
            this.processShortCircuitExpression(expression, false);
        } else if (PhpLangUtil.isShortCircuitOrOperator(type)) {
            this.processShortCircuitExpression(expression, true);
        } else if (type == PhpTokenTypes.opCOALESCE) {
            PsiElement trueVariant = expression.getLeftOperand();
            PsiElement falseVariant = expression.getRightOperand();
            this.processTrueFalseExpression(trueVariant, PhpAccessInstruction.Access.ISSET_ACCESS, trueVariant, falseVariant);
        } else if (type != null) {
            PsiElement leftOperand = expression.getLeftOperand();
            PsiElement rightOperand = expression.getRightOperand();
            if (PhpTokenTypes.tsCOMPARE_OPS.contains(type) && PhpPsiUtil.unparenthesize(leftOperand) instanceof Variable && !(PhpPsiUtil.unparenthesize(rightOperand) instanceof Variable)) {
                this.process(rightOperand, leftOperand);
            } else {
                this.process(leftOperand, rightOperand);
            }
        }
    }

    private void process(PsiElement leftOperand, PsiElement rightOperand) {
        if (leftOperand != null) {
            leftOperand.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        if (rightOperand != null) {
            rightOperand.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    public void processShortCircuitExpression(@NotNull BinaryExpression expression, boolean trueBranchFirst) {
        Stack<PhpConditionInstructionImpl> firstBranch;
        if (expression == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(19);
        }
        PhpMarkerInstruction binaryOut = new PhpMarkerInstruction();
        PsiElement leftOperand = expression.getLeftOperand();
        PhpHostInstructionImpl conditionHost = PhpControlFlowBuilder.createHostInstruction((PsiElement)expression);
        PhpConditionInstructionImpl trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction(leftOperand);
        PhpConditionInstructionImpl falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction(leftOperand, trueConditionInstruction);
        this.pushConditionTargets(trueConditionInstruction, falseConditionInstruction);
        if (leftOperand != null) {
            leftOperand.accept((PsiElementVisitor)this);
        }
        this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        this.popConditionTargets();
        this.addInstruction(conditionHost);
        this.addInstruction(trueBranchFirst ? trueConditionInstruction : falseConditionInstruction);
        Stack<PhpConditionInstructionImpl> stack = firstBranch = trueBranchFirst ? this.myTrueTargets : this.myFalseTargets;
        if (firstBranch.empty()) {
            this.jump(binaryOut);
        } else {
            this.jump((PhpInstructionImpl)firstBranch.peek());
        }
        this.lastInstruction = conditionHost;
        PhpConditionInstructionImpl shortCircuitInstruction = trueBranchFirst ? falseConditionInstruction : trueConditionInstruction;
        this.addInstruction(shortCircuitInstruction);
        PsiElement rightOperand = expression.getRightOperand();
        if (rightOperand != null) {
            rightOperand.accept((PsiElementVisitor)this);
        }
        shortCircuitInstruction.setShortCircuitRightOperand(rightOperand);
        this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        this.addInstruction(binaryOut);
    }

    public void visitPhpTernaryExpression(TernaryExpression expression) {
        if (!this.shouldProcess((PsiElement)expression)) {
            return;
        }
        PhpPsiElement condition = expression.getCondition();
        PhpPsiElement trueVariant = expression.getTrueVariant();
        PhpPsiElement falseVariant = expression.getFalseVariant();
        this.processTrueFalseExpression((PsiElement)condition, PhpAccessInstruction.Access.READ_ACCESS, (PsiElement)trueVariant, (PsiElement)falseVariant);
    }

    public void processTrueFalseExpression(@Nullable PsiElement condition, @NotNull PhpAccessInstruction.Access conditionAccess, @Nullable PsiElement trueVariant, @Nullable PsiElement falseVariant) {
        if (conditionAccess == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(20);
        }
        this.processTrueFalseExpression(condition, conditionAccess, trueVariant, falseVariant, () -> {});
    }

    private void processTrueFalseExpression(@Nullable PsiElement condition, @NotNull PhpAccessInstruction.Access conditionAccess, @Nullable PsiElement trueVariant, @Nullable PsiElement falseVariant, Runnable falseVariantCallback) {
        if (conditionAccess == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(21);
        }
        PhpMarkerInstruction ternaryOut = new PhpMarkerInstruction();
        PhpHostInstructionImpl conditionHost = PhpControlFlowBuilder.createHostInstruction(condition);
        PhpConditionInstructionImpl trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction(condition);
        PhpConditionInstructionImpl falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction(condition, trueConditionInstruction);
        this.pushConditionTargets(trueConditionInstruction, falseConditionInstruction);
        if (condition != null) {
            this.myParentAccess = conditionAccess;
            condition.accept((PsiElementVisitor)this);
            this.resetCurrentValue(conditionAccess);
            this.myParentAccess = null;
        }
        this.popConditionTargets();
        this.addInstruction(conditionHost);
        this.addInstruction(trueConditionInstruction);
        if (trueVariant != null) {
            trueVariant.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.jump(ternaryOut);
        this.lastInstruction = conditionHost;
        this.addInstruction(falseConditionInstruction);
        if (falseVariant != null) {
            falseVariant.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            falseVariantCallback.run();
        }
        this.addInstruction(ternaryOut);
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        PsiElement[] children;
        if (!this.shouldProcess((PsiElement)expression)) {
            return;
        }
        for (PsiElement child : children = expression.getChildren()) {
            IElementType childType = child.getNode().getElementType();
            if (PhpElementTypes.HASH_ARRAY_ELEMENT == childType) {
                PsiElement value;
                PsiElement key = PhpPsiUtil.getChildOfType(child, PhpElementTypes.ARRAY_KEY);
                if (key != null) {
                    key.accept((PsiElementVisitor)this);
                    this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
                }
                if ((value = PhpPsiUtil.getChildOfType(child, PhpElementTypes.ARRAY_VALUE)) == null) continue;
                value.accept((PsiElementVisitor)this);
                this.resetCurrentValueWeak(PhpAccessInstruction.Access.READ_ACCESS);
                continue;
            }
            if (PhpElementTypes.ARRAY_VALUE != childType) continue;
            child.accept((PsiElementVisitor)this);
            this.resetCurrentValueWeak(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        if (!this.shouldProcess((PsiElement)expression)) {
            return;
        }
        PhpPsiElement value = expression.getValue();
        if (value != null) {
            value.accept((PsiElementVisitor)this);
            this.resetCurrentValueWeak(PhpAccessInstruction.Access.READ_ACCESS);
        }
        ArrayIndex arrayIndex = expression.getIndex();
        this.acceptArgumentExpression((PhpExpression)arrayIndex);
        this.setCurrentValue((PhpPsiElement)expression, false);
    }

    public void visitPhpFieldReference(FieldReference fieldReference) {
        if (!this.shouldProcess((PsiElement)fieldReference)) {
            return;
        }
        PhpExpression classReference = fieldReference.getClassReference();
        if (classReference != null) {
            for (PhpPsiElement nextPsiSibling = classReference.getNextPsiSibling(); nextPsiSibling != null; nextPsiSibling = nextPsiSibling.getNextPsiSibling()) {
                nextPsiSibling.accept((PsiElementVisitor)this);
            }
            classReference.accept((PsiElementVisitor)this);
            PhpAccessInstruction.Access access = this.myParentAccess == null || this.myParentAccess.isWrite() || this.myParentAccess.isWriteRef() ? PhpAccessInstruction.Access.READ_ACCESS : this.myParentAccess;
            this.resetCurrentValue(access);
        }
        this.setCurrentValue((PhpPsiElement)fieldReference, false);
    }

    private void processNullSafeCapableMemberReference(MemberReference reference, Runnable visitClassReference, Runnable visitRestOfReference) {
        PhpExpression classReference = reference.getClassReference();
        PhpHostInstructionImpl ifConditionHost = PhpControlFlowBuilder.createHostInstruction((PsiElement)classReference);
        boolean isNullSafeDeref = ((MemberReferenceImpl)reference).isNullSafeDereference();
        boolean outerMarkerIsMine = false;
        if (isNullSafeDeref && (this.myTopmostNullSafeMemberReferenceOutMarker.isEmpty() || !((NullSafeMarkerOutInfo)this.myTopmostNullSafeMemberReferenceOutMarker.peek()).myApplicableMemberReferences.contains(reference))) {
            outerMarkerIsMine = true;
            this.myTopmostNullSafeMemberReferenceOutMarker.push((Object)NullSafeMarkerOutInfo.create(reference));
        }
        PhpIfOutMarkerInstruction nullSafeCheckSucceedOutMarker = new PhpIfOutMarkerInstruction();
        PhpNullSafeDerefConditionInstructionImpl notNullInstruction = new PhpNullSafeDerefConditionInstructionImpl((PsiElement)classReference, true);
        PhpNullSafeDerefConditionInstructionImpl nullInstruction = new PhpNullSafeDerefConditionInstructionImpl((PsiElement)classReference, false);
        PhpControlFlowBuilder.setInverseInstruction(notNullInstruction, nullInstruction);
        if (isNullSafeDeref) {
            this.pushConditionTargets(notNullInstruction, nullInstruction);
        }
        visitClassReference.run();
        if (isNullSafeDeref) {
            this.popConditionTargets();
            this.addInstruction(ifConditionHost);
            this.addInstruction(notNullInstruction);
        }
        visitRestOfReference.run();
        if (isNullSafeDeref) {
            if (outerMarkerIsMine) {
                this.jump(((NullSafeMarkerOutInfo)this.myTopmostNullSafeMemberReferenceOutMarker.peek()).myMarker);
            } else {
                this.jump(nullSafeCheckSucceedOutMarker);
            }
            this.lastInstruction = ifConditionHost;
            this.addInstruction(nullInstruction);
            if (outerMarkerIsMine) {
                this.addInstruction(((NullSafeMarkerOutInfo)this.myTopmostNullSafeMemberReferenceOutMarker.peek()).myMarker);
                this.myTopmostNullSafeMemberReferenceOutMarker.pop();
            } else {
                this.addInstruction(nullSafeCheckSucceedOutMarker);
                nullSafeCheckSucceedOutMarker.getPredecessors().remove(nullInstruction);
                nullInstruction.join(((NullSafeMarkerOutInfo)this.myTopmostNullSafeMemberReferenceOutMarker.peek()).myMarker);
            }
        }
    }

    public void visitPhpMethodReference(MethodReference reference) {
        if (!this.shouldProcess((PsiElement)reference)) {
            return;
        }
        ParameterList parameterList = reference.getParameterList();
        PhpExpression classReference = reference.getClassReference();
        this.processNullSafeCapableMemberReference((MemberReference)reference, () -> this.lambda$visitPhpMethodReference$9((PhpPsiElement)classReference, parameterList), () -> {
            if (parameterList != null) {
                parameterList.accept((PsiElementVisitor)this);
            }
            this.processCall((FunctionReference)reference);
        });
    }

    public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
        if (!this.shouldProcess((PsiElement)constantReference)) {
            return;
        }
        PhpExpression classReference = constantReference.getClassReference();
        this.acceptArgumentExpression(classReference);
    }

    public void visitPhpStatement(Statement statement) {
        this.addStatementInstruction(statement);
        super.visitPhpStatement(statement);
        this.resetCurrentValueAfterStatement();
    }

    public void visitPhpIf(If ifStatement) {
        PhpPsiElement elseStatement;
        ElseIf[] elseIfBranches;
        this.addStatementInstruction((Statement)ifStatement);
        PhpIfOutMarkerInstruction ifOutInstruction = new PhpIfOutMarkerInstruction();
        PhpPsiElement condition = ifStatement.getCondition();
        PhpHostInstructionImpl ifConditionHost = PhpControlFlowBuilder.createHostInstruction((PsiElement)condition);
        PhpConditionInstructionImpl trueIfConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction((PsiElement)condition);
        PhpConditionInstructionImpl falseIfConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction((PsiElement)condition, trueIfConditionInstruction);
        this.pushConditionTargets(trueIfConditionInstruction, falseIfConditionInstruction);
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.popConditionTargets();
        this.addInstruction(ifConditionHost);
        this.addInstruction(trueIfConditionInstruction);
        Statement thenStatement = ifStatement.getStatement();
        if (thenStatement != null) {
            thenStatement.accept((PsiElementVisitor)this);
        }
        this.jump(ifOutInstruction);
        this.lastInstruction = ifConditionHost;
        this.addInstruction(falseIfConditionInstruction);
        for (ElseIf elseIfBranch : elseIfBranches = ifStatement.getElseIfBranches()) {
            PhpPsiElement elseIfCondition = elseIfBranch.getCondition();
            PhpHostInstructionImpl elseIfConditionHost = PhpControlFlowBuilder.createHostInstruction((PsiElement)elseIfCondition);
            PhpConditionInstructionImpl trueElseIfConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction((PsiElement)elseIfCondition);
            PhpConditionInstructionImpl falseElseIfConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction((PsiElement)elseIfCondition, trueElseIfConditionInstruction);
            this.pushConditionTargets(trueElseIfConditionInstruction, falseElseIfConditionInstruction);
            if (elseIfCondition != null) {
                elseIfCondition.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
            this.popConditionTargets();
            this.addInstruction(elseIfConditionHost);
            this.addInstruction(trueElseIfConditionInstruction);
            Statement elseIfThenStatement = elseIfBranch.getStatement();
            if (elseIfThenStatement != null) {
                elseIfThenStatement.accept((PsiElementVisitor)this);
            }
            this.jump(ifOutInstruction);
            this.lastInstruction = elseIfConditionHost;
            this.addInstruction(falseElseIfConditionInstruction);
        }
        Else elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null && (elseStatement = elseBranch.getStatement()) != null) {
            elseStatement.accept((PsiElementVisitor)this);
        }
        this.addInstruction(ifOutInstruction);
        if (ifOutInstruction.getPredecessors().size() > 1) {
            ifOutInstruction.addAmbiguousInstructions(Arrays.asList(trueIfConditionInstruction, falseIfConditionInstruction));
        }
    }

    public void visitPhpFor(For forStatement) {
        PhpPsiElement[] repeatedExpressions;
        PhpConditionInstructionImpl falseConditionInstruction;
        PhpConditionInstructionImpl trueConditionInstruction;
        PhpPsiElement[] initialExpressions;
        this.addStatementInstruction((Statement)forStatement);
        PhpMarkerInstruction loopBeginInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction loopEndInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction continueTargetInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction forOutInstruction = new PhpMarkerInstruction();
        this.pushBreakContinueTargets((Statement)forStatement, forOutInstruction, continueTargetInstruction);
        for (PhpPsiElement initialExpression : initialExpressions = forStatement.getInitialExpressions()) {
            initialExpression.accept((PsiElementVisitor)this);
            this.resetCurrentValueAfterStatement();
        }
        this.addInstruction(loopBeginInstruction);
        PhpPsiElement[] conditionalExpressions = forStatement.getConditionalExpressions();
        PhpHostInstructionImpl conditionHost = PhpControlFlowBuilder.createLoopHostInstruction((PsiElement)forStatement);
        if (conditionalExpressions.length > 0) {
            PhpPsiElement[] condition = conditionalExpressions[conditionalExpressions.length - 1];
            trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction((PsiElement)condition);
            falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction((PsiElement)condition, trueConditionInstruction);
        } else {
            trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction(null);
            falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction(null, trueConditionInstruction);
        }
        this.pushConditionTargets(trueConditionInstruction, falseConditionInstruction);
        for (PhpPsiElement conditionalExpression : conditionalExpressions) {
            conditionalExpression.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.popConditionTargets();
        this.addInstruction(conditionHost);
        this.addInstruction(trueConditionInstruction);
        Statement loopBody = forStatement.getStatement();
        if (loopBody != null) {
            loopBody.accept((PsiElementVisitor)this);
        }
        this.addInstruction(continueTargetInstruction);
        for (PhpPsiElement repeatedExpression : repeatedExpressions = forStatement.getRepeatedExpressions()) {
            repeatedExpression.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.addInstruction(loopEndInstruction);
        this.jump(loopBeginInstruction);
        this.lastInstruction = conditionHost;
        this.addInstruction(falseConditionInstruction);
        this.addInstruction(forOutInstruction);
        this.popBreakContinueTargets();
    }

    public void visitPhpWhile(While whileStatement) {
        this.addStatementInstruction((Statement)whileStatement);
        PhpMarkerInstruction loopBeginInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction loopEndInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction whileOutInstruction = new PhpMarkerInstruction();
        this.pushBreakContinueTargets((Statement)whileStatement, whileOutInstruction, loopBeginInstruction);
        this.addInstruction(loopBeginInstruction);
        PhpPsiElement condition = whileStatement.getCondition();
        PhpHostInstructionImpl conditionHost = PhpControlFlowBuilder.createLoopHostInstruction((PsiElement)whileStatement);
        PhpConditionInstructionImpl trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction((PsiElement)condition);
        PhpConditionInstructionImpl falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction((PsiElement)condition, trueConditionInstruction);
        this.pushConditionTargets(trueConditionInstruction, falseConditionInstruction);
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.popConditionTargets();
        this.addInstruction(conditionHost);
        this.addInstruction(trueConditionInstruction);
        Statement whileBody = whileStatement.getStatement();
        if (whileBody != null) {
            whileBody.accept((PsiElementVisitor)this);
        }
        this.addInstruction(loopEndInstruction);
        this.jump(loopBeginInstruction);
        this.lastInstruction = conditionHost;
        this.addInstruction(falseConditionInstruction);
        this.addInstruction(whileOutInstruction);
        this.popBreakContinueTargets();
    }

    public void visitPhpDoWhile(DoWhile doWhileStatement) {
        this.addStatementInstruction((Statement)doWhileStatement);
        PhpMarkerInstruction loopBeginInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction doWhileOutInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction whileConditionStartMarker = new PhpMarkerInstruction();
        this.pushBreakContinueTargets((Statement)doWhileStatement, doWhileOutInstruction, whileConditionStartMarker);
        this.addInstruction(loopBeginInstruction);
        Statement doWhileBody = doWhileStatement.getStatement();
        if (doWhileBody != null) {
            doWhileBody.accept((PsiElementVisitor)this);
        }
        PhpPsiElement condition = doWhileStatement.getCondition();
        PhpHostInstructionImpl conditionHost = PhpControlFlowBuilder.createLoopHostInstruction((PsiElement)doWhileStatement);
        PhpConditionInstructionImpl trueConditionInstruction = PhpControlFlowBuilder.createTrueConditionInstruction((PsiElement)condition);
        PhpConditionInstructionImpl falseConditionInstruction = PhpControlFlowBuilder.createFalseConditionInstruction((PsiElement)condition, trueConditionInstruction);
        this.pushConditionTargets(trueConditionInstruction, falseConditionInstruction);
        this.addInstruction(whileConditionStartMarker);
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.popConditionTargets();
        this.addInstruction(conditionHost);
        this.addInstruction(trueConditionInstruction);
        this.jump(loopBeginInstruction);
        this.lastInstruction = conditionHost;
        this.addInstruction(falseConditionInstruction);
        this.addInstruction(doWhileOutInstruction);
        this.popBreakContinueTargets();
    }

    public void visitPhpForeach(ForeachStatement foreachStatement) {
        Statement loopBodyStatement;
        this.addStatementInstruction((Statement)foreachStatement);
        PhpMarkerInstruction loopBeginInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction loopEndInstruction = new PhpMarkerInstruction();
        PhpPsiElement array = PhpWorkaroundUtil.getForeachArray(foreachStatement);
        PhpForeachOutInstruction foreachOutInstruction = PhpControlFlowBuilder.createForeachOutInstruction((PsiElement)array);
        this.pushBreakContinueTargets((Statement)foreachStatement, foreachOutInstruction, loopEndInstruction);
        if (array != null) {
            array.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.addInstruction(loopBeginInstruction);
        PhpForeachHostInstructionImpl foreachHost = new PhpForeachHostInstructionImpl((PsiElement)foreachStatement);
        foreachOutInstruction.setForeachHost(foreachHost);
        this.addInstruction(foreachHost);
        if (!PhpControlFlowBuilder.nonEmptyLiteralArray((PsiElement)array)) {
            this.jump(foreachOutInstruction);
        }
        this.lastInstruction = foreachHost;
        List<PhpReference> keys = PhpPsiUtil.getChildren((PsiElement)foreachStatement, (Condition<? super PsiElement>)PhpReference.INSTANCEOF);
        for (PhpReference key : keys) {
            if (key == array) continue;
            key.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpControlFlowBuilder.getForeachKeyValueAccessTypeByPrevSibling(key));
        }
        if (!keys.isEmpty()) {
            this.processFollowingDocComment((PsiElement)keys.get(keys.size() - 1));
        }
        if ((loopBodyStatement = foreachStatement.getStatement()) != null) {
            loopBodyStatement.accept((PsiElementVisitor)this);
        }
        this.addInstruction(loopEndInstruction);
        PhpHostInstructionImpl foreachHostEnd = PhpControlFlowBuilder.createHostInstruction((PsiElement)foreachStatement);
        this.addInstruction(foreachHostEnd);
        this.jump(loopBeginInstruction);
        this.lastInstruction = foreachHostEnd;
        this.addInstruction(foreachOutInstruction);
        this.popBreakContinueTargets();
    }

    private static boolean nonEmptyLiteralArray(PsiElement array) {
        return array instanceof ArrayCreationExpression && ArrayCreationExpressionImpl.children((ArrayCreationExpression)array).limit(1).size() >= 1;
    }

    @NotNull
    private static PhpForeachOutInstruction createForeachOutInstruction(PsiElement array) {
        String arrayName;
        if (array instanceof Variable && StringUtil.isNotEmpty((String)(arrayName = ((Variable)array).getName()))) {
            return new PhpForeachOutInstruction(arrayName);
        }
        return new PhpForeachOutInstruction(null);
    }

    private static PhpAccessInstruction.Access getForeachKeyValueAccessTypeByPrevSibling(@NotNull PhpReference key) {
        if (key == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(22);
        }
        if (PhpCodeInsightUtil.isForeachKeyOrValueAssignedByReference(key)) {
            return PhpAccessInstruction.Access.WRITE_REF_ACCESS;
        }
        return PhpAccessInstruction.Access.WRITE_ACCESS;
    }

    public void visitPhpSwitch(PhpSwitch switchStatement) {
        int i;
        this.addStatementInstruction((Statement)switchStatement);
        PhpMarkerInstruction switchOutInstruction = new PhpMarkerInstruction();
        PhpMarkerInstruction defaultStatementBegin = null;
        this.pushBreakContinueTargets((Statement)switchStatement, switchOutInstruction, switchOutInstruction);
        PsiElement switchArgument = switchStatement.getArgument();
        if (switchArgument != null) {
            switchArgument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        PhpCase[] allCases = switchStatement.getAllCases();
        PhpCase defaultCase = switchStatement.getDefaultCase();
        PhpMarkerInstruction[] caseStatementBegins = new PhpMarkerInstruction[allCases.length];
        for (i = 0; i < allCases.length; ++i) {
            if (allCases[i] == defaultCase) {
                caseStatementBegins[i] = defaultStatementBegin = new PhpMarkerInstruction();
                continue;
            }
            PsiElement caseArgument = allCases[i].getArgument();
            if (caseArgument != null) {
                caseArgument.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
            caseStatementBegins[i] = new PhpMarkerInstruction();
            PhpHostInstructionImpl caseHost = PhpControlFlowBuilder.createHostInstruction((PsiElement)allCases[i]);
            this.addInstruction(caseHost);
            PhpCaseConditionInstructionImpl lastCaseConditionInstruction = new PhpCaseConditionInstructionImpl(caseArgument, switchArgument, caseStatementBegins[i]);
            this.addInstruction(lastCaseConditionInstruction);
            this.lastInstruction = caseHost;
            PhpBaseCaseConditionInstructionImpl falseInstruction = new PhpBaseCaseConditionInstructionImpl(caseArgument, switchArgument, false);
            this.addInstruction(falseInstruction);
            falseInstruction.setInverseInstruction(lastCaseConditionInstruction);
            lastCaseConditionInstruction.setInverseInstruction(falseInstruction);
        }
        this.jump(defaultStatementBegin != null ? defaultStatementBegin : switchOutInstruction);
        for (i = 0; i < allCases.length; ++i) {
            this.addInstruction(caseStatementBegins[i]);
            this.processFollowingDocComment(allCases[i].getArgument());
            Statement caseStatement = allCases[i].getStatement();
            if (caseStatement == null) continue;
            caseStatement.accept((PsiElementVisitor)this);
        }
        this.addInstruction(switchOutInstruction);
        this.popBreakContinueTargets();
    }

    public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
        PhpMarkerInstruction matchOutInstruction = new PhpMarkerInstruction();
        this.acceptArgumentExpression(matchExpression.getArgument());
        PhpDefaultMatchArm defaultArm = matchExpression.getDefaultMatchArm();
        List arms = matchExpression.getMatchArms();
        for (int i = 0; i < arms.size(); ++i) {
            List conditions = ((PhpMatchArm)arms.get(i)).getConditions();
            for (int j = 0; j < conditions.size(); ++j) {
                PhpExpression condition = (PhpExpression)conditions.get(j);
                this.acceptArgumentExpression(condition);
                PhpHostInstructionImpl armHost = PhpControlFlowBuilder.createHostInstruction((PsiElement)condition);
                this.addInstruction(armHost);
                this.addInstruction(new PhpMatchArmConditionInstruction((PsiElement)condition, true));
                this.acceptArgumentExpression(((PhpMatchArm)arms.get(i)).getBodyExpression());
                this.jump(matchOutInstruction);
                if (defaultArm == null && i == arms.size() - 1 && j == conditions.size() - 1) continue;
                this.lastInstruction = armHost;
                this.addInstruction(new PhpMatchArmConditionInstruction((PsiElement)condition, false));
            }
        }
        if (defaultArm != null) {
            this.acceptArgumentExpression(defaultArm.getBodyExpression());
        }
        this.addInstruction(matchOutInstruction);
    }

    private void acceptArgumentExpression(PhpExpression argument) {
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    public void visitPhpReturn(PhpReturn returnStatement) {
        this.addStatementInstruction((Statement)returnStatement);
        PsiElement argument = returnStatement.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        this.addInstruction(new PhpExitMarkerInstruction());
        PhpReturnInstructionImpl returnInstruction = new PhpReturnInstructionImpl(returnStatement, argument);
        if (!this.myFinallyBlocks.isEmpty()) {
            PhpFinallyInstructionsBlock lastFinally = (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(0);
            lastFinally.addSuccessor(returnInstruction);
            PhpFinallyInstructionsBlock topFinally = (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(this.myFinallyBlocks.size() - 1);
            this.jump(topFinally.getFirstInstruction());
        }
        this.addInstruction(returnInstruction);
        this.jump(this.myExitInstruction);
    }

    public void visitPhpYield(PhpYield yieldStatement) {
        PsiElement value;
        if (!this.shouldProcess((PsiElement)yieldStatement)) {
            return;
        }
        PsiElement key = yieldStatement.getArgument();
        if (key != null) {
            key.accept((PsiElementVisitor)this);
        }
        if ((value = PhpYieldImpl.getValue(yieldStatement)) != null) {
            value.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new PhpYieldInstructionImpl(key, value));
    }

    public void visitPhpBreak(PhpBreak breakStatement) {
        this.addStatementInstruction((Statement)breakStatement);
        PsiElement argument = breakStatement.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        BreakContinueTarget breakContinueTarget = this.getBreakContinueTarget(argument);
        PhpBreakContinueInstructionImpl breakContinueInstruction = PhpControlFlowBuilder.createBreakContinueInstruction(breakContinueTarget);
        this.addInstruction(breakContinueInstruction);
        if (breakContinueTarget != null) {
            this.processBreakContinueWithFinally(breakContinueTarget, breakContinueTarget.getBreakTarget());
        }
    }

    public void visitPhpContinue(PhpContinue continueStatement) {
        this.addStatementInstruction((Statement)continueStatement);
        PsiElement argument = continueStatement.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        BreakContinueTarget breakContinueTarget = this.getBreakContinueTarget(argument);
        PhpBreakContinueInstructionImpl breakContinueInstruction = PhpControlFlowBuilder.createBreakContinueInstruction(breakContinueTarget);
        this.addInstruction(breakContinueInstruction);
        if (breakContinueTarget != null) {
            this.processBreakContinueWithFinally(breakContinueTarget, breakContinueTarget.getContinueTarget());
        }
    }

    private void processBreakContinueWithFinally(@NotNull BreakContinueTarget breakContinueTarget, @NotNull PhpInstructionImpl nextInstruction) {
        int loopStartOffset;
        int tryStartOffset;
        PhpFinallyInstructionsBlock topFinallyBlock;
        if (breakContinueTarget == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(23);
        }
        if (nextInstruction == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(24);
        }
        if ((topFinallyBlock = this.getTopFinallyBlock()) != null && (tryStartOffset = topFinallyBlock.getTryStartOffset()) > (loopStartOffset = breakContinueTarget.getStatement().getTextRange().getStartOffset())) {
            topFinallyBlock.addSuccessor(nextInstruction);
            this.jump(topFinallyBlock.getFirstInstruction());
            return;
        }
        this.jump(nextInstruction);
    }

    public void visitPhpGoto(PhpGoto gotoStatement) {
        if (!this.shouldProcess((PsiElement)gotoStatement)) {
            return;
        }
        String label = gotoStatement.getName();
        this.addStatementInstruction((Statement)gotoStatement);
        Map<String, PhpGotoLabelDefinitionInstructionImpl> labelToDefinitionInstruction = this.getLabelToDefinitionInstructionMap();
        PhpGotoLabelDefinitionInstructionImpl labelInstruction = labelToDefinitionInstruction.get(label);
        if (labelInstruction == null) {
            PhpMarkerInstruction marker = new PhpMarkerInstruction();
            MultiMap<String, PhpMarkerInstruction> labelToGotoInstruction = this.getLabelToGotoInstructionMap();
            labelToGotoInstruction.putValue((Object)label, (Object)marker);
            this.addInstruction(marker);
            this.interruptFlow();
        } else {
            this.jump(labelInstruction);
        }
    }

    public void visitPhpGotoLabel(PhpGotoLabel gotoLabel) {
        if (!this.shouldProcess((PsiElement)gotoLabel)) {
            return;
        }
        String label = gotoLabel.getName();
        PhpGotoLabelDefinitionInstructionImpl labelInstruction = new PhpGotoLabelDefinitionInstructionImpl(gotoLabel);
        Map<String, PhpGotoLabelDefinitionInstructionImpl> labelToDefinitionInstruction = this.getLabelToDefinitionInstructionMap();
        labelToDefinitionInstruction.put(label, labelInstruction);
        this.addInstruction(labelInstruction);
        MultiMap<String, PhpMarkerInstruction> labelToGotoInstruction = this.getLabelToGotoInstructionMap();
        Collection gotoInstructions = labelToGotoInstruction.get((Object)label);
        for (PhpMarkerInstruction instruction : gotoInstructions) {
            instruction.join(labelInstruction);
        }
    }

    public void visitPhpUnset(PhpUnset unsetStatement) {
        PhpPsiElement[] arguments;
        if (!this.shouldProcess((PsiElement)unsetStatement)) {
            return;
        }
        this.addStatementInstruction((Statement)unsetStatement);
        for (PhpPsiElement argument : arguments = unsetStatement.getArguments()) {
            if (argument == null) continue;
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.UNSET_ACCESS);
        }
    }

    public void visitPhpGlobal(Global globalStatement) {
        if (!this.shouldProcess((PsiElement)globalStatement)) {
            return;
        }
        this.addStatementInstruction((Statement)globalStatement);
        for (Variable variable : globalStatement.getVariables()) {
            if (variable == null) continue;
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_REF_ACCESS);
        }
    }

    public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
        if (!this.shouldProcess((PsiElement)staticStatement)) {
            return;
        }
        this.addStatementInstruction((Statement)staticStatement);
        for (AssignmentExpression declaration : staticStatement.getDeclarations()) {
            PhpPsiElement variable = declaration.getVariable();
            if (variable == null) continue;
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
        }
    }

    public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
        if (!this.shouldProcess((PsiElement)echoStatement)) {
            return;
        }
        this.addStatementInstruction((Statement)echoStatement);
        for (PhpPsiElement argument : echoStatement.getArguments()) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    public void visitPhpThrow(PhpThrow throwStatement) {
        if (!this.shouldProcess((PsiElement)throwStatement)) {
            return;
        }
        this.addStatementInstruction((Statement)throwStatement);
        PhpPsiElement throwExpression = throwStatement.getFirstPsiChild();
        if (throwExpression != null) {
            throwExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitPhpThrowExpression(PhpThrowExpression throwExpression) {
        if (!this.shouldProcess((PsiElement)throwExpression)) {
            return;
        }
        PhpInstructionImpl lastInstructionInThrow = null;
        PhpExpression argument = throwExpression.getArgument();
        if (argument != null) {
            argument.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            lastInstructionInThrow = this.lastInstruction;
        }
        this.addInstruction(new PhpExitMarkerInstruction());
        PhpThrowInstructionImpl throwInstruction = new PhpThrowInstructionImpl(throwExpression, argument, new ArrayList<PhpHostInstruction>(this.myCatchMatchingList));
        if (!this.myFinallyBlocks.isEmpty()) {
            boolean insideCatch;
            PhpFinallyInstructionsBlock topFinally = (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(this.myFinallyBlocks.size() - 1);
            boolean bl = insideCatch = PhpPsiUtil.getParentByCondition((PsiElement)throwExpression, (Condition<? super PsiElement>)Catch.INSTANCEOF) != null;
            if (insideCatch || !topFinally.haveCatchClauses()) {
                if (insideCatch && lastInstructionInThrow != null) {
                    lastInstructionInThrow.setTerminatesAfterFinally();
                }
                this.jump(topFinally.getFirstInstruction());
                PhpFinallyInstructionsBlock lastFinally = (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(0);
                lastFinally.addSuccessor(throwInstruction);
            }
        }
        this.addInstruction(throwInstruction);
        this.jump(this.myExitInstruction);
    }

    public void visitPhpTry(Try tryStatement2) {
        if (!this.shouldProcess((PsiElement)tryStatement2)) {
            return;
        }
        Catch[] catches = tryStatement2.getCatchClauses();
        Finally finallyBlock = tryStatement2.getFinallyBlock();
        int startOffset = tryStatement2.getTextRange().getStartOffset();
        PhpFinallyInstructionsBlock finallyInstructions = PhpFinallyInstructionsBlock.createFinallyInstructionsBlock(finallyBlock, catches.length > 0, startOffset);
        this.addNextFinallyBlock(finallyInstructions);
        PhpMarkerInstruction tryInstructionOut = finallyInstructions == null ? new PhpMarkerInstruction() : finallyInstructions.getFirstInstruction();
        PhpHostInstructionImpl[] catchConditionHosts = new PhpHostInstructionImpl[catches.length];
        for (int i = 0; i < catches.length; ++i) {
            catchConditionHosts[i] = PhpControlFlowBuilder.createHostInstruction((PsiElement)tryStatement2);
            this.myCatchMatchingList.add(catchConditionHosts[i]);
        }
        PhpTryInstructionImpl tryInstruction = new PhpTryInstructionImpl((Statement)tryStatement2);
        this.addInstruction(tryInstruction);
        Statement tryBody = tryStatement2.getStatement();
        if (tryBody != null) {
            tryBody.accept((PsiElementVisitor)this);
        }
        if (!this.myCatchMatchingList.isEmpty() && this.myCatchMatchingList.get(0).getPredecessors().isEmpty()) {
            tryInstruction.addCatchTargets(this.myCatchMatchingList);
        }
        this.jump(tryInstructionOut);
        for (int i = 0; i < catches.length; ++i) {
            this.myCatchMatchingList.remove(this.myCatchMatchingList.size() - 1);
        }
        PhpCatchConditionInstructionImpl lastFalseCatchConditionInstruction = null;
        for (int i = 0; i < catches.length; ++i) {
            PhpHostInstructionImpl conditionHost = catchConditionHosts[i];
            Catch aCatch = catches[i];
            Variable exceptionVariable = aCatch.getException();
            Collection exceptionTypes = aCatch.getExceptionTypes();
            PhpCatchConditionInstructionImpl trueCatchConditionInstruction = PhpControlFlowBuilder.createTrueCatchConditionInstruction(exceptionTypes, exceptionVariable);
            PhpCatchConditionInstructionImpl falseCatchConditionInstruction = PhpControlFlowBuilder.createFalseCatchConditionInstruction(exceptionTypes, exceptionVariable);
            this.addInstruction(conditionHost);
            this.addInstruction(trueCatchConditionInstruction);
            catches[i].accept((PsiElementVisitor)this);
            this.jump(tryInstructionOut);
            this.lastInstruction = conditionHost;
            this.addInstruction(falseCatchConditionInstruction);
            lastFalseCatchConditionInstruction = falseCatchConditionInstruction;
        }
        if (finallyInstructions == null) {
            if (lastFalseCatchConditionInstruction != null) {
                this.jump(this.myExitInstruction);
            }
            this.addInstruction(tryInstructionOut);
        } else {
            Collection<PhpInstruction> finallyBlockPredecessors;
            this.removeTopFinallyBlock();
            if (lastFalseCatchConditionInstruction != null) {
                this.jump(this.myExitInstruction);
            }
            this.addInstruction(tryInstructionOut);
            finallyBlock.accept((PsiElementVisitor)this);
            this.addInstruction(finallyInstructions.getLastInstruction());
            if (lastFalseCatchConditionInstruction != null) {
                this.lastInstruction.join(lastFalseCatchConditionInstruction);
            }
            if (!(finallyBlockPredecessors = tryInstructionOut.getPredecessors()).isEmpty() && finallyBlockPredecessors.stream().allMatch(PhpControlFlowBuilder::exitPointInstruction)) {
                this.interruptFlow();
            }
        }
    }

    private static boolean exitPointInstruction(PhpInstruction instruction) {
        return PhpControlFlowBuilder.exitPointInstruction(instruction, new HashSet<PhpInstruction>());
    }

    private static boolean exitPointInstruction(PhpInstruction instruction, Collection<PhpInstruction> visited) {
        if (!visited.add(instruction)) {
            return false;
        }
        if (instruction instanceof PhpCatchConditionInstruction) {
            return !((PhpCatchConditionInstruction)instruction).getResult();
        }
        if (!(instruction instanceof PhpExitMarkerInstruction)) {
            return instruction instanceof PhpMarkerInstruction && instruction.getPredecessors().stream().filter(predecessor -> predecessor != instruction).allMatch(predecessor -> PhpControlFlowBuilder.exitPointInstruction(predecessor, visited));
        }
        return true;
    }

    private void addNextFinallyBlock(@Nullable PhpFinallyInstructionsBlock finallyBlock) {
        if (finallyBlock != null) {
            if (!this.myFinallyBlocks.isEmpty()) {
                PhpFinallyInstructionsBlock previousFinally = (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(this.myFinallyBlocks.size() - 1);
                finallyBlock.addSuccessor(previousFinally.getFirstInstruction());
                if (previousFinally.haveCatchClauses()) {
                    finallyBlock.setHaveCatchClauses(true);
                }
            }
            this.myFinallyBlocks.add((Object)finallyBlock);
        }
    }

    @Nullable
    private PhpFinallyInstructionsBlock getTopFinallyBlock() {
        if (!this.myFinallyBlocks.isEmpty()) {
            return (PhpFinallyInstructionsBlock)this.myFinallyBlocks.get(this.myFinallyBlocks.size() - 1);
        }
        return null;
    }

    private void removeTopFinallyBlock() {
        if (!this.myFinallyBlocks.isEmpty()) {
            this.myFinallyBlocks.remove(this.myFinallyBlocks.size() - 1);
        }
    }

    public void visitPhpCatch(Catch phpCatch) {
        Statement statement;
        if (!this.shouldProcess((PsiElement)phpCatch)) {
            return;
        }
        Variable exceptionVariable = phpCatch.getException();
        if (exceptionVariable != null) {
            exceptionVariable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
        }
        if ((statement = phpCatch.getStatement()) != null) {
            statement.accept((PsiElementVisitor)this);
        }
    }

    public void visitPhpVariable(Variable variable) {
        if (!this.shouldProcess((PsiElement)variable)) {
            return;
        }
        super.visitPhpVariable(variable);
        this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        this.setCurrentValue((PhpPsiElement)variable, false);
        if (PhpControlFlowBuilder.isShortArrowFunctionArgument((PhpExpression)variable)) {
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    private static boolean isShortArrowFunctionArgument(@NotNull PhpExpression expression) {
        Function function;
        if (expression == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(25);
        }
        return (function = (Function)ObjectUtils.tryCast((Object)expression.getParent(), Function.class)) != null && function.isClosure() && FunctionImpl.isShortArrowFunction(function) && FunctionImpl.getShortArrowFunctionArgument(function) == expression;
    }

    public void visitPhpDocVariable(PhpDocVariable phpDocVariable) {
        CharSequence variableName;
        if (!this.shouldProcess((PsiElement)phpDocVariable)) {
            return;
        }
        super.visitPhpDocVariable(phpDocVariable);
        PhpDocTag tag = (PhpDocTag)PhpPsiUtil.getParentByCondition((PsiElement)phpDocVariable, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF);
        if (tag != null && PhpDocUtil.isDocVarType(tag.getName()) && !StringUtil.isEmpty((CharSequence)(variableName = phpDocVariable.getNameCS()))) {
            this.addInstruction(new PhpVariableDocDeclarationInstructionImpl(variableName, phpDocVariable));
        }
    }

    public void visitPhpConstantReference(ConstantReference reference) {
        if (!this.shouldProcess((PsiElement)reference)) {
            return;
        }
        super.visitPhpConstantReference(reference);
        this.setCurrentValue((PhpPsiElement)reference, false);
    }

    public void visitPhpFunctionCall(FunctionReference reference) {
        String functionName;
        if (!this.shouldProcess((PsiElement)reference)) {
            return;
        }
        PhpPsiElement firstPsiChild = reference.getFirstPsiChild();
        ParameterList parameterList = reference.getParameterList();
        if (firstPsiChild != null && firstPsiChild != parameterList) {
            firstPsiChild.accept((PsiElementVisitor)this);
            if (firstPsiChild instanceof Variable || firstPsiChild instanceof ArrayAccessExpression) {
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
        }
        if (parameterList != null) {
            parameterList.accept((PsiElementVisitor)this);
        }
        if ((functionName = reference.getName()) != null) {
            PsiElement firstParam;
            if (PhpLangUtil.equalsFunctionNames(COMPACT_FUNCTION, functionName)) {
                if (parameterList != null) {
                    for (PsiElement parameter : PhpControlFlowBuilder.unwrapParameters(parameterList)) {
                        String varName;
                        if (!(parameter instanceof PhpPsiElement) || StringUtil.isEmpty((CharSequence)(varName = PhpCodeInsightUtil.toString(parameter)))) continue;
                        PhpAccessInstruction.Access access = parameter instanceof StringLiteralExpression ? PhpAccessInstruction.Access.COMPACT_READ_ACCESS : PhpAccessInstruction.Access.READ_ACCESS;
                        this.addInstruction(new PhpAccessVariableInstructionImpl((PhpPsiElement)parameter, varName, access));
                    }
                }
            } else if (PhpLangUtil.equalsFunctionNames(ASSERT_FUNCTION, functionName) && parameterList != null && (firstParam = parameterList.getParameter(0)) != null) {
                PhpHostInstructionImpl ifConditionHost = PhpControlFlowBuilder.createHostInstruction((PsiElement)reference);
                this.addInstruction(ifConditionHost);
                this.addInstruction(PhpControlFlowBuilder.createFalseConditionInstruction(firstParam, null));
                this.interrupt();
                this.lastInstruction = ifConditionHost;
                this.addInstruction(PhpControlFlowBuilder.createTrueConditionInstruction(firstParam));
            }
        }
        this.processCall(reference);
    }

    private static Collection<PsiElement> unwrapParameters(ParameterList parameterList) {
        return Arrays.stream(parameterList.getParameters()).flatMap(PhpControlFlowBuilder::values).collect(Collectors.toList());
    }

    private static Stream<PsiElement> values(PsiElement array) {
        if (array == null) {
            return Stream.empty();
        }
        if (array instanceof ArrayCreationExpression) {
            return ArrayCreationExpressionImpl.children((ArrayCreationExpression)array).stream().flatMap(e -> e instanceof ArrayHashElement ? StreamEx.of((Object)((ArrayHashElement)e).getValue()) : PhpControlFlowBuilder.values((PsiElement)e.getFirstPsiChild()));
        }
        return Stream.of(array);
    }

    protected void processCall(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(26);
        }
        this.addInstruction(new PhpCallInstructionImpl(reference, this.getCatchMatchingListCopy()));
    }

    public void visitPhpNewExpression(NewExpression expression) {
        if (!this.shouldProcess((PsiElement)expression)) {
            return;
        }
        ClassReference classReference = expression.getClassReference();
        this.acceptArgumentExpression((PhpExpression)classReference);
        ParameterList parameterList = expression.getParameterList();
        if (parameterList != null) {
            parameterList.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new PhpConstructorCallInstructionImpl(expression, this.getCatchMatchingListCopy()));
    }

    private boolean shouldProcess(PsiElement element) {
        return this.myAlreadyComputedAssignmentDependency.isEmpty() || this.myAlreadyComputedAssignmentDependency.peek() != element;
    }

    @NotNull
    private List<PhpHostInstruction> getCatchMatchingListCopy() {
        List<Object> list = this.myCatchMatchingList.size() > 1 ? new ArrayList<PhpHostInstruction>(this.myCatchMatchingList) : ContainerUtil.createMaybeSingletonList((Object)((PhpHostInstruction)ContainerUtil.getFirstItem(this.myCatchMatchingList)));
        if (list == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(27);
        }
        return list;
    }

    public void visitPhpAssignmentExpression(AssignmentExpression expr) {
        PhpPsiElement value;
        if (!this.shouldProcess((PsiElement)expr)) {
            return;
        }
        boolean assignByReference = PhpWorkaroundUtil.isAssignByReference(expr);
        PhpPsiElement variable = expr.getVariable();
        PsiElement dependency = PhpControlFlowBuilder.getAssignmentDependency((PsiElement)variable);
        if (dependency != null) {
            dependency.accept((PsiElementVisitor)this);
        }
        if ((value = expr.getValue()) != null) {
            value.accept((PsiElementVisitor)this);
            this.resetCurrentValue(assignByReference ? PhpAccessInstruction.Access.READ_REF_ACCESS : PhpAccessInstruction.Access.READ_ACCESS);
        }
        if (variable != null) {
            this.processWithSkippedAssignmentDependency((PsiElement)variable, dependency);
            PhpAccessInstruction.Access access = assignByReference ? PhpAccessInstruction.Access.WRITE_REF_ACCESS : PhpAccessInstruction.Access.WRITE_ACCESS;
            this.resetCurrentValue(access, (PsiElement)value, true);
        }
        this.setCurrentValue(variable, true);
    }

    private void processWithSkippedAssignmentDependency(PsiElement variable, PsiElement dependency) {
        this.processWithSkippedAssignmentDependency(dependency, () -> variable.accept((PsiElementVisitor)this));
    }

    private void processWithSkippedAssignmentDependency(PsiElement dependency, Runnable r) {
        this.myAlreadyComputedAssignmentDependency.push((Object)dependency);
        r.run();
        this.myAlreadyComputedAssignmentDependency.pop();
    }

    @Nullable
    private static PsiElement getAssignmentDependency(PsiElement element) {
        if (element instanceof ArrayAccessExpression) {
            PhpPsiElement indexValue;
            ArrayIndex index = ((ArrayAccessExpression)element).getIndex();
            PhpPsiElement phpPsiElement = indexValue = index != null ? index.getValue() : null;
            if (indexValue != null && PhpControlFlowBuilder.assignmentDependency(indexValue)) {
                return indexValue;
            }
        }
        return null;
    }

    private static boolean assignmentDependency(@NotNull PhpPsiElement value) {
        if (value == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(28);
        }
        if (value instanceof Variable || value instanceof ConstantReference || value instanceof FieldReference) {
            return false;
        }
        if (value instanceof ArrayAccessExpression) {
            return PhpControlFlowBuilder.getAssignmentDependency((PsiElement)value) != null;
        }
        return true;
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        PhpPsiElement variable = expression.getVariable();
        PsiElement dependency = PhpControlFlowBuilder.getAssignmentDependency((PsiElement)variable);
        if (dependency != null) {
            dependency.accept((PsiElementVisitor)this);
        }
        PhpPsiElement value = expression.getValue();
        if (expression.getOperationType() == PhpTokenTypes.opCOALESCE_ASGN) {
            if (variable != null) {
                this.processWithSkippedAssignmentDependency(dependency, () -> this.lambda$visitPhpSelfAssignmentExpression$16((PsiElement)variable, (PsiElement)value, dependency));
            }
            return;
        }
        if (value != null) {
            value.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        if (variable != null) {
            this.withParentAccess(PhpAccessInstruction.Access.READ_ACCESS, () -> this.lambda$visitPhpSelfAssignmentExpression$17((PsiElement)variable, dependency));
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            this.processWithSkippedAssignmentDependency((PsiElement)variable, dependency);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
        }
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
        if (!this.shouldProcess((PsiElement)multiassignmentExpression)) {
            return;
        }
        PhpPsiElement value = multiassignmentExpression.getValue();
        if (value != null) {
            value.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
        for (PhpPsiElement variable : MultiassignmentExpressionImpl.getUnpackedVariablesFromMultiAssignment(multiassignmentExpression)) {
            variable.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
        }
    }

    public void visitPhpParameterList(ParameterList list) {
        if (!this.shouldProcess((PsiElement)list)) {
            return;
        }
        PsiElement[] parameters = list.getParameters();
        if (parameters.length == 0) {
            return;
        }
        FunctionReference functionReference = (FunctionReference)ObjectUtils.tryCast((Object)list.getParent(), FunctionReference.class);
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i].accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpControlFlowBuilder.getArgumentAccess(functionReference, i, parameters[i]));
        }
    }

    @NotNull
    public static PhpAccessInstruction.Access getArgumentAccess(@Nullable FunctionReference functionReference, int parameterIndex, @NotNull PsiElement parameter) {
        boolean notPassByRef;
        if (parameter == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(29);
        }
        boolean bl = notPassByRef = functionReference != null && PhpDfaBaseStateConditionDFAnalyzer.isNotNullByPrimitiveTypeCheckers(functionReference);
        if ((!notPassByRef || parameterIndex > 0) && (parameter instanceof Variable || parameter instanceof ArrayAccessExpression || parameter instanceof FieldReference)) {
            return new PhpAccessInstruction.ReadOrReadRefAccess((RWAccess)parameter);
        }
        PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_ACCESS;
        if (access == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(30);
        }
        return access;
    }

    protected void interrupt() {
        this.addInstruction(PhpControlFlowBuilder.createInterruptScriptInstruction());
        this.jump(this.myExitInstruction);
    }

    private static PhpHostInstructionImpl createHostInstruction(PsiElement anchor) {
        return new PhpHostInstructionImpl(anchor);
    }

    private static PhpHostInstructionImpl createLoopHostInstruction(PsiElement anchor) {
        return new PhpLoopHostInstructionImpl(anchor);
    }

    private static PhpConditionInstructionImpl createTrueConditionInstruction(@Nullable PsiElement condition) {
        return new PhpConditionInstructionImpl(condition, true);
    }

    private static PhpConditionInstructionImpl createFalseConditionInstruction(@Nullable PsiElement condition, @Nullable PhpConditionInstructionImpl originalTrueConditionInstruction) {
        PhpConditionInstructionImpl instruction = new PhpConditionInstructionImpl(condition, false);
        PhpControlFlowBuilder.setInverseInstruction(originalTrueConditionInstruction, instruction);
        return instruction;
    }

    private static void setInverseInstruction(@Nullable PhpConditionInstructionImpl originalTrueConditionInstruction, PhpConditionInstructionImpl instruction) {
        if (originalTrueConditionInstruction != null) {
            originalTrueConditionInstruction.setInverseInstruction(instruction);
            instruction.setInverseInstruction(originalTrueConditionInstruction);
        }
    }

    private static PhpCatchConditionInstructionImpl createTrueCatchConditionInstruction(@NotNull Collection<ClassReference> exceptionTypes, @Nullable Variable exception2) {
        if (exceptionTypes == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(31);
        }
        return new PhpCatchConditionInstructionImpl(exceptionTypes, exception2, true);
    }

    private static PhpCatchConditionInstructionImpl createFalseCatchConditionInstruction(@NotNull Collection<ClassReference> exceptionTypes, @Nullable Variable exception2) {
        if (exceptionTypes == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(32);
        }
        return new PhpCatchConditionInstructionImpl(exceptionTypes, exception2, false);
    }

    private static PhpBreakContinueInstructionImpl createBreakContinueInstruction(@Nullable BreakContinueTarget breakContinueTarget) {
        return new PhpBreakContinueInstructionImpl(breakContinueTarget != null ? breakContinueTarget.getStatement() : null);
    }

    private static PhpInterruptScriptInstructionImpl createInterruptScriptInstruction() {
        return new PhpInterruptScriptInstructionImpl();
    }

    private static PhpClassDeclarationInstructionImpl createClassDeclarationInstruction(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpControlFlowBuilder.$$$reportNull$$$0(33);
        }
        return new PhpClassDeclarationInstructionImpl(phpClass);
    }

    private static PhpFunctionDeclarationInstructionImpl createFunctionDeclarationInstruction(Function function) {
        return new PhpFunctionDeclarationInstructionImpl(function);
    }

    private /* synthetic */ void lambda$visitPhpSelfAssignmentExpression$17(PsiElement variable, PsiElement dependency) {
        this.processWithSkippedAssignmentDependency(variable, dependency);
    }

    private /* synthetic */ void lambda$visitPhpSelfAssignmentExpression$16(PsiElement variable, PsiElement value, PsiElement dependency) {
        this.processTrueFalseExpression(variable, PhpAccessInstruction.Access.ISSET_ACCESS, null, value, () -> {
            this.processWithSkippedAssignmentDependency(variable, dependency);
            this.resetCurrentValue(PhpAccessInstruction.Access.WRITE_ACCESS);
        });
    }

    private /* synthetic */ void lambda$visitPhpMethodReference$9(PhpPsiElement classReference, ParameterList parameterList) {
        if (classReference != null) {
            PhpPsiElement nextPsiSibling = classReference.getNextPsiSibling();
            if (nextPsiSibling != null && nextPsiSibling != parameterList) {
                nextPsiSibling.accept((PsiElementVisitor)this);
                this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
            }
            classReference.accept((PsiElementVisitor)this);
            this.resetCurrentValue(PhpAccessInstruction.Access.READ_ACCESS);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 27: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 27: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endInstruction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakTarget";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continueTarget";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trueTarget";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "falseTarget";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowBuilder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionAccess";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakContinueTarget";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextInstruction";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionTypes";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelToDefinitionInstructionMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelToGotoInstructionMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedVariables";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesUsedInShortArrowFunction";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatchMatchingListCopy";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addStatementInstruction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "jump";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pushBreakContinueTargets";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pushConditionTargets";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resetCurrentValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resetCurrentValueWeak";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 27: 
            case 30: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getUsedVariables";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVariablesUsedInShortArrowFunction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processShortCircuitExpression";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processTrueFalseExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getForeachKeyValueAccessTypeByPrevSibling";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processBreakContinueWithFinally";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isShortArrowFunctionArgument";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processCall";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "assignmentDependency";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentAccess";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTrueCatchConditionInstruction";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createFalseCatchConditionInstruction";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createClassDeclarationInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 27: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpFinallyInstructionsBlock {
        private boolean myHaveCatchClauses;
        private final int myTryStartOffset;
        private final PhpMarkerInstruction myFirstInstruction;
        private final PhpFinallyEndInstructionImpl myLastInstruction;

        @Nullable
        public static PhpFinallyInstructionsBlock createFinallyInstructionsBlock(@Nullable Finally finallyBlock, boolean haveCatchClauses, int startOffset) {
            return finallyBlock == null ? null : new PhpFinallyInstructionsBlock(new PhpMarkerInstruction(), new PhpFinallyEndInstructionImpl((PsiElement)finallyBlock), haveCatchClauses, startOffset);
        }

        private PhpFinallyInstructionsBlock(@NotNull PhpMarkerInstruction firstInstruction, @NotNull PhpFinallyEndInstructionImpl lastInstruction, boolean haveCatchClauses, int startOffset) {
            if (firstInstruction == null) {
                PhpFinallyInstructionsBlock.$$$reportNull$$$0(0);
            }
            if (lastInstruction == null) {
                PhpFinallyInstructionsBlock.$$$reportNull$$$0(1);
            }
            this.myFirstInstruction = firstInstruction;
            this.myLastInstruction = lastInstruction;
            this.myHaveCatchClauses = haveCatchClauses;
            this.myTryStartOffset = startOffset;
        }

        private PhpMarkerInstruction getFirstInstruction() {
            return this.myFirstInstruction;
        }

        private PhpFinallyEndInstructionImpl getLastInstruction() {
            return this.myLastInstruction;
        }

        private boolean haveCatchClauses() {
            return this.myHaveCatchClauses;
        }

        private void setHaveCatchClauses(boolean haveCatchClauses) {
            this.myHaveCatchClauses = haveCatchClauses;
        }

        private int getTryStartOffset() {
            return this.myTryStartOffset;
        }

        private void addSuccessor(@NotNull PhpInstructionImpl instruction) {
            if (instruction == null) {
                PhpFinallyInstructionsBlock.$$$reportNull$$$0(2);
            }
            this.myLastInstruction.join(instruction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstInstruction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastInstruction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowBuilder$PhpFinallyInstructionsBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSuccessor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpIfOutMarkerInstruction
    extends PhpMarkerInstruction {
        private PhpIfOutMarkerInstruction() {
        }
    }

    private static class PhpMarkerInstruction
    extends PhpLinearInstructionImpl {
        private PhpMarkerInstruction() {
            super(null);
        }

        @Nullable
        public final PhpInstructionImpl getSuccessor() {
            return this.mySuccessor;
        }

        public void dispose() {
            this.mySuccessor = null;
            this.getPredecessors().clear();
        }
    }

    public static class PhpForeachOutInstruction
    extends PhpMarkerInstruction {
        @Nullable
        private final String myArrayName;
        @Nullable
        private PhpForeachHostInstructionImpl myHost;

        public PhpForeachOutInstruction(@Nullable String arrayName) {
            this.myArrayName = arrayName;
        }

        @Nullable
        public String getArrayName() {
            return this.myArrayName;
        }

        public void setForeachHost(PhpForeachHostInstructionImpl host) {
            this.myHost = host;
        }
    }

    private static class PhpExitMarkerInstruction
    extends PhpMarkerInstruction {
        private PhpExitMarkerInstruction() {
        }
    }

    private static class PhpMatchArmConditionInstruction
    extends PhpConditionInstructionImpl {
        private PhpMatchArmConditionInstruction(@Nullable PsiElement condition, boolean result) {
            super(condition, result);
        }

        @Override
        public boolean isUnreachable() {
            return false;
        }
    }

    private static class NullSafeMarkerOutInfo {
        final Collection<MemberReference> myApplicableMemberReferences;
        final PhpIfOutMarkerInstruction myMarker;

        private NullSafeMarkerOutInfo(Collection<MemberReference> references, PhpIfOutMarkerInstruction marker) {
            this.myApplicableMemberReferences = references;
            this.myMarker = marker;
        }

        private static NullSafeMarkerOutInfo create(MemberReference reference) {
            HashSet<MemberReference> applicableReferences = new HashSet<MemberReference>();
            while (reference != null) {
                applicableReferences.add(reference);
                reference = (MemberReference)ObjectUtils.tryCast((Object)reference.getClassReference(), MemberReference.class);
            }
            return new NullSafeMarkerOutInfo(applicableReferences, new PhpIfOutMarkerInstruction());
        }
    }

    public static class PhpSkippedLoopInstruction
    extends Pair<PhpInstruction, String> {
        public PhpSkippedLoopInstruction(PhpInstruction instruction, String loopArrayName) {
            super((Object)instruction, (Object)loopArrayName);
        }

        public PhpInstruction getOriginalPredecessor() {
            return (PhpInstruction)this.first;
        }

        public String getArrayName() {
            return (String)this.second;
        }
    }

    private static final class BreakContinueTarget {
        private final PhpInstructionImpl myBreakTarget;
        private final PhpInstructionImpl myContinueTarget;
        private final Statement myStatement;

        private BreakContinueTarget(@NotNull Statement statement, @NotNull PhpInstructionImpl breakTarget, @NotNull PhpInstructionImpl continueTarget) {
            if (statement == null) {
                BreakContinueTarget.$$$reportNull$$$0(0);
            }
            if (breakTarget == null) {
                BreakContinueTarget.$$$reportNull$$$0(1);
            }
            if (continueTarget == null) {
                BreakContinueTarget.$$$reportNull$$$0(2);
            }
            this.myStatement = statement;
            this.myBreakTarget = breakTarget;
            this.myContinueTarget = continueTarget;
        }

        public PhpInstructionImpl getBreakTarget() {
            return this.myBreakTarget;
        }

        public PhpInstructionImpl getContinueTarget() {
            return this.myContinueTarget;
        }

        public Statement getStatement() {
            return this.myStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "breakTarget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "continueTarget";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowBuilder$BreakContinueTarget";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

