/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.classAlias.PhpClassAliasUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassAliasImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTargetElementEvaluator
extends TargetElementEvaluatorEx2 {
    private static final TokenSet STRINGS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE});

    @Nullable
    public PsiElement getNamedElement(@NotNull PsiElement element) {
        PhpClassAliasUtil.ExtractResult result;
        FunctionReference reference;
        if (element == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        if (PhpPsiUtil.isOfType(element, STRINGS) && (reference = (FunctionReference)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null && (result = PhpClassAliasUtil.extractClassAlias((FunctionReference)reference)) != null) {
            VirtualFile file = reference.getContainingFile().getVirtualFile();
            return new PhpClassAliasImpl(result.getAliasFqn(), result.getOriginalFqn(), reference.getProject(), file, (Lazy<? extends FunctionReference>)LazyKt.lazyOf((Object)reference));
        }
        return super.getNamedElement(element);
    }

    public boolean isAcceptableNamedParent(@NotNull PsiElement parent) {
        if (parent == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(1);
        }
        if (parent instanceof PhpDocVariable) {
            return false;
        }
        if (parent instanceof Variable) {
            if (((Variable)parent).isDeclaration()) {
                return true;
            }
            return VariableImpl.collectDeclarations(parent, false, ((Variable)parent).getName()).stream().allMatch(v -> v instanceof Variable && !((Variable)v).isDeclaration());
        }
        return super.isAcceptableNamedParent(parent);
    }

    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference reference, int flags) {
        PhpNamedElement resolvedClass;
        PhpUse useElement;
        if (reference == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(2);
        }
        if ((useElement = PhpTargetElementEvaluator.getElementByReference(reference)) != null) {
            return useElement;
        }
        if (reference instanceof ClassReference && (resolvedClass = PhpTargetElementEvaluator.getTargetClass((ClassReference)reference)) != null) {
            return resolvedClass;
        }
        return null;
    }

    @Nullable
    public static PhpNamedElement getTargetClass(@NotNull ClassReference reference) {
        Collection<? extends PhpNamedElement> resolvedClasses;
        PhpNamedElement resolvedClass;
        if (reference == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(3);
        }
        if (ClassReferenceImpl.shouldResolveToConstructor((PhpReference)reference) && (resolvedClass = (PhpNamedElement)ContainerUtil.getOnlyItem(resolvedClasses = ClassReferenceImpl.resolveGlobal((PhpReference)reference, reference.getName(), reference.getNamespaceName(), true))) instanceof PhpClass) {
            return (PhpNamedElement)ObjectUtils.notNull((Object)((PhpClass)resolvedClass).getOwnConstructor(), (Object)resolvedClass);
        }
        return null;
    }

    @Nullable
    public static PhpUse getElementByReference(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(4);
        }
        if (reference instanceof PhpReference && ((PhpReference)reference).isAbsolute()) {
            return null;
        }
        PsiElement element = reference.getElement();
        PsiFile file = element.getContainingFile();
        if (file instanceof PhpFile) {
            String referenceName = PhpTargetElementEvaluator.getName(reference);
            return StreamEx.of((Collection)((PhpFile)file).getTopLevelDefs().values()).select(PhpUse.class).findFirst(declaration -> PhpTargetElementEvaluator.referenceToAlias(reference, element, referenceName, declaration)).orElse(null);
        }
        return null;
    }

    @NotNull
    private static String getName(@NotNull PsiReference reference) {
        PsiElement element;
        if (reference == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(5);
        }
        if ((element = reference.getElement()) instanceof PhpDocRef && PhpPsiUtil.isOfType(element.getFirstChild(), PhpDocTokenTypes.DOC_IDENTIFIER)) {
            String string = element.getFirstChild().getText();
            if (string == null) {
                PhpTargetElementEvaluator.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = reference instanceof PhpDocType ? StringUtil.trimEnd((String)reference.getCanonicalText(), (String)"[]") : reference.getCanonicalText();
        if (string == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean referenceToAlias(@NotNull PsiReference reference, PsiElement element, String referenceName, PhpUse use) {
        if (reference == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(8);
        }
        if (PhpTargetElementEvaluator.equals(referenceName, use.getAliasName(), reference instanceof ConstantReference) && PhpCodeInsightUtil.findScopeForUseOperator(element) == PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)use)) {
            PhpUseList useList = PhpUseImpl.getUseList(element);
            if (useList != null) {
                return useList.isTraitImport();
            }
            if (element instanceof PhpDocRef) {
                return true;
            }
            if (PhpUseImpl.isOfFunction(use)) {
                return reference instanceof FunctionReference;
            }
            if (PhpUseImpl.isOfConst(use)) {
                return reference instanceof ConstantReference;
            }
            if (element instanceof PhpNamespaceReference) {
                return reference.getRangeInElement().getStartOffset() == 0 && !(element.getParent() instanceof PhpNamespace);
            }
            return reference instanceof ClassReference || reference instanceof PhpDocType;
        }
        return false;
    }

    private static boolean equals(String text, String aliasName, boolean caseSensitive) {
        return caseSensitive ? PhpLangUtil.equals(text, aliasName) : PhpLangUtil.equalsIgnoreCase(text, aliasName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/PhpTargetElementEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/PhpTargetElementEvaluator";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNamedParent";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementByReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTargetClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "referenceToAlias";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

