/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.completion.autoImport.PhpAutoImportConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MethodReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MultiassignmentExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodNameIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.util.PhpContractUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PhpCodeInsightUtil {
    public static final Object[] @NlsSafe [] STD_LIB_FUN_WITH_REF_ARGS = new Object[][]{{"apc_dec", 2}, {"apc_fetch", 1}, {"apc_inc", 2}, {"apcu_dec", 2}, {"apcu_fetch", 1}, {"apcu_inc", 2}, {"array_multisort", 0}, {"array_multisort", 1}, {"array_pop", 0}, {"array_push", 0}, {"array_shift", 0}, {"array_splice", 0}, {"array_unshift", 0}, {"array_walk", 0}, {"array_walk_recursive", 0}, {"arsort", 0}, {"asort", 0}, {"call_user_method", 1}, {"call_user_method_array", 1}, {"collator_asort", 1}, {"collator_sort", 1}, {"collator_sort_with_sort_keys", 1}, {"curl_multi_exec", 1}, {"curl_multi_info_read", 1}, {"datefmt_localtime", 2}, {"datefmt_parse", 2}, {"dns_get_mx", 1}, {"dns_get_mx", 2}, {"dns_get_record", 2}, {"dns_get_record", 3}, {"each", 0}, {"enchant_dict_quick_check", 2}, {"end", 0}, {"ereg", 2}, {"eregi", 2}, {"exec", 1}, {"exec", 2}, {"exif_thumbnail", 1}, {"exif_thumbnail", 2}, {"exif_thumbnail", 3}, {"extract", 0}, {"flock", 2}, {"fscanf", 2}, {"fsockopen", 2}, {"fsockopen", 3}, {"ftp_alloc", 2}, {"getimagesize", 1}, {"getimagesizefromstring", 1}, {"getmxrr", 1}, {"getmxrr", 2}, {"getopt", 2}, {"gmp_clrbit", 0}, {"gmp_setbit", 0}, {"grapheme_extract", 4}, {"headers_sent", 0}, {"headers_sent", 1}, {"http_build_url", 3}, {"http_get", 2}, {"http_head", 2}, {"http_negotiate_charset", 1}, {"http_negotiate_content_type", 1}, {"http_negotiate_language", 1}, {"http_post_data", 3}, {"http_post_fields", 4}, {"http_put_data", 3}, {"http_put_file", 3}, {"http_put_stream", 3}, {"http_request", 4}, {"idn_to_ascii", 3}, {"idn_to_utf8", 3}, {"intltz_get_canonical_id", 1}, {"intltz_get_offset", 3}, {"intltz_get_offset", 4}, {"is_callable", 2}, {"krsort", 0}, {"ksort", 0}, {"ldap_control_paged_result_response", 2}, {"ldap_control_paged_result_response", 3}, {"ldap_exop", 4}, {"ldap_exop", 5}, {"ldap_exop_passwd", 4}, {"ldap_get_option", 2}, {"ldap_parse_exop", 2}, {"ldap_parse_exop", 3}, {"ldap_parse_reference", 2}, {"ldap_parse_result", 2}, {"ldap_parse_result", 3}, {"ldap_parse_result", 4}, {"ldap_parse_result", 5}, {"ldap_parse_result", 6}, {"mb_convert_variables", 2}, {"mb_convert_variables", 3}, {"mb_ereg", 2}, {"mb_eregi", 2}, {"mb_parse_str", 1}, {"mbereg", 2}, {"mberegi", 2}, {"mqseries_back", 1}, {"mqseries_back", 2}, {"mqseries_begin", 2}, {"mqseries_begin", 3}, {"mqseries_close", 3}, {"mqseries_close", 4}, {"mqseries_cmit", 1}, {"mqseries_cmit", 2}, {"mqseries_conn", 1}, {"mqseries_conn", 2}, {"mqseries_conn", 3}, {"mqseries_connx", 1}, {"mqseries_connx", 2}, {"mqseries_connx", 3}, {"mqseries_connx", 4}, {"mqseries_disc", 1}, {"mqseries_disc", 2}, {"mqseries_get", 2}, {"mqseries_get", 3}, {"mqseries_get", 4}, {"mqseries_get", 5}, {"mqseries_get", 6}, {"mqseries_get", 7}, {"mqseries_get", 8}, {"mqseries_inq", 5}, {"mqseries_inq", 7}, {"mqseries_inq", 8}, {"mqseries_inq", 9}, {"mqseries_open", 1}, {"mqseries_open", 3}, {"mqseries_open", 4}, {"mqseries_open", 5}, {"mqseries_put", 2}, {"mqseries_put", 3}, {"mqseries_put", 5}, {"mqseries_put", 6}, {"mqseries_put1", 1}, {"mqseries_put1", 2}, {"mqseries_put1", 3}, {"mqseries_put1", 5}, {"mqseries_put1", 6}, {"mqseries_set", 8}, {"mqseries_set", 9}, {"msg_receive", 2}, {"msg_receive", 4}, {"msg_receive", 7}, {"msg_send", 5}, {"mssql_bind", 2}, {"mysqli_bind_result", 2}, {"mysqli_poll", 0}, {"mysqli_poll", 1}, {"mysqli_poll", 2}, {"mysqli_stmt_bind_param", 2}, {"mysqli_stmt_bind_param", 3}, {"mysqli_stmt_bind_result", 1}, {"mysqli_stmt_bind_result", 2}, {"natcasesort", 0}, {"natsort", 0}, {"ncurses_color_content", 1}, {"ncurses_color_content", 2}, {"ncurses_color_content", 3}, {"ncurses_getmaxyx", 1}, {"ncurses_getmaxyx", 2}, {"ncurses_getmouse", 0}, {"ncurses_getyx", 1}, {"ncurses_getyx", 2}, {"ncurses_instr", 0}, {"ncurses_mouse_trafo", 0}, {"ncurses_mouse_trafo", 1}, {"ncurses_mousemask", 1}, {"ncurses_pair_content", 1}, {"ncurses_pair_content", 2}, {"ncurses_wmouse_trafo", 1}, {"ncurses_wmouse_trafo", 2}, {"next", 0}, {"numfmt_parse", 3}, {"numfmt_parse_currency", 2}, {"numfmt_parse_currency", 3}, {"oci_bind_array_by_name", 2}, {"oci_bind_by_name", 2}, {"oci_define_by_name", 2}, {"oci_fetch_all", 1}, {"ocibindbyname", 2}, {"ocidefinebyname", 2}, {"ocifetchinto", 1}, {"ocifetchstatement", 1}, {"odbc_fetch_into", 1}, {"openssl_cms_read", 1}, {"openssl_csr_export", 1}, {"openssl_csr_new", 1}, {"openssl_encrypt", 5}, {"openssl_open", 1}, {"openssl_pkcs12_export", 1}, {"openssl_pkcs12_read", 1}, {"openssl_pkcs7_read", 1}, {"openssl_pkey_export", 1}, {"openssl_private_decrypt", 1}, {"openssl_private_encrypt", 1}, {"openssl_public_decrypt", 1}, {"openssl_public_encrypt", 1}, {"openssl_random_pseudo_bytes", 1}, {"openssl_seal", 1}, {"openssl_seal", 2}, {"openssl_seal", 5}, {"openssl_sign", 1}, {"openssl_x509_export", 1}, {"parse_str", 1}, {"passthru", 1}, {"pcntl_sigprocmask", 2}, {"pcntl_sigtimedwait", 1}, {"pcntl_sigwaitinfo", 1}, {"pcntl_wait", 0}, {"pcntl_wait", 2}, {"pcntl_waitpid", 1}, {"pcntl_waitpid", 3}, {"pfsockopen", 2}, {"pfsockopen", 3}, {"preg_filter", 4}, {"preg_match", 2}, {"preg_match_all", 2}, {"preg_replace", 4}, {"preg_replace_callback", 4}, {"preg_replace_callback_array", 3}, {"prev", 0}, {"proc_open", 2}, {"reset", 0}, {"rsort", 0}, {"settype", 0}, {"shuffle", 0}, {"similar_text", 2}, {"socket_create_pair", 3}, {"socket_getpeername", 1}, {"socket_getpeername", 2}, {"socket_getsockname", 1}, {"socket_getsockname", 2}, {"socket_recv", 1}, {"socket_recvfrom", 1}, {"socket_recvfrom", 4}, {"socket_recvfrom", 5}, {"socket_recvmsg", 1}, {"socket_select", 0}, {"socket_select", 1}, {"socket_select", 2}, {"sodium_add", 0}, {"sodium_crypto_generichash_final", 0}, {"sodium_crypto_generichash_update", 0}, {"sodium_crypto_secretstream_xchacha20poly1305_pull", 0}, {"sodium_crypto_secretstream_xchacha20poly1305_push", 0}, {"sodium_crypto_secretstream_xchacha20poly1305_rekey", 0}, {"sodium_increment", 0}, {"sodium_memzero", 0}, {"sort", 0}, {"sqlite_exec", 2}, {"sqlite_factory", 2}, {"sqlite_open", 2}, {"sqlite_popen", 2}, {"sqlite_query", 3}, {"sqlite_unbuffered_query", 3}, {"sscanf", 2}, {"ssh2_poll", 0}, {"str_ireplace", 3}, {"str_replace", 3}, {"stream_select", 0}, {"stream_select", 1}, {"stream_select", 2}, {"stream_socket_accept", 2}, {"stream_socket_client", 1}, {"stream_socket_client", 2}, {"stream_socket_recvfrom", 3}, {"stream_socket_server", 1}, {"stream_socket_server", 2}, {"system", 1}, {"uasort", 0}, {"uksort", 0}, {"usort", 0}, {"wincache_ucache_dec", 2}, {"wincache_ucache_get", 1}, {"wincache_ucache_inc", 2}, {"xml_parse_into_struct", 2}, {"xml_parse_into_struct", 3}, {"xmlrpc_decode_request", 1}, {"xmlrpc_set_type", 0}, {"yaml_parse", 2}, {"yaml_parse_file", 2}, {"yaml_parse_url", 2}};
    @VisibleForTesting
    public static final Set<String> STD_PURE_FUNCTIONS = Set.of("\\_", "\\abs", "\\acos", "\\acosh", "\\addcslashes", "\\addslashes", "\\apache_get_modules", "\\apache_get_version", "\\apache_getenv", "\\apache_request_headers", "\\array_change_key_case", "\\array_chunk", "\\array_column", "\\array_combine", "\\array_count_values", "\\array_diff", "\\array_diff_assoc", "\\array_diff_key", "\\array_fill", "\\array_fill_keys", "\\array_flip", "\\array_intersect", "\\array_intersect_assoc", "\\array_intersect_key", "\\array_key_exists", "\\array_key_first", "\\array_key_last", "\\array_keys", "\\array_merge", "\\array_merge_recursive", "\\array_pad", "\\array_product", "\\array_rand", "\\array_replace", "\\array_replace_recursive", "\\array_reverse", "\\array_search", "\\array_slice", "\\array_sum", "\\array_uintersect_uassoc", "\\array_unique", "\\array_values", "\\asin", "\\asinh", "\\atan", "\\atan2", "\\atanh", "\\base64_decode", "\\base64_encode", "\\base_convert", "\\basename", "\\bcadd", "\\bccomp", "\\bcdiv", "\\bcmod", "\\bcmul", "\\bcpow", "\\bcpowmod", "\\bcsqrt", "\\bcsub", "\\bindec", "\\boolval", "\\bzcompress", "\\bzdecompress", "\\bzerrno", "\\bzerror", "\\bzerrstr", "\\bzopen", "\\ceil", "\\checkdate", "\\checkdnsrr", "\\chop", "\\chr", "\\chunk_split", "\\class_implements", "\\class_parents", "\\cli_get_process_title", "\\collator_compare", "\\collator_create", "\\collator_get_attribute", "\\collator_get_error_code", "\\collator_get_error_message", "\\collator_get_locale", "\\collator_get_sort_key", "\\collator_get_strength", "\\compact", "\\connection_aborted", "\\connection_status", "\\constant", "\\convert_cyr_string", "\\convert_uudecode", "\\convert_uuencode", "\\cos", "\\cosh", "\\count", "\\count_chars", "\\crc32", "\\crypt", "\\ctype_alnum", "\\ctype_alpha", "\\ctype_cntrl", "\\ctype_digit", "\\ctype_graph", "\\ctype_lower", "\\ctype_print", "\\ctype_punct", "\\ctype_space", "\\ctype_upper", "\\ctype_xdigit", "\\curl_copy_handle", "\\curl_errno", "\\curl_error", "\\curl_escape", "\\curl_file_create", "\\curl_getinfo", "\\curl_multi_errno", "\\curl_multi_getcontent", "\\curl_multi_info_read", "\\curl_share_errno", "\\curl_share_strerror", "\\curl_strerror", "\\curl_unescape", "\\curl_version", "\\current", "\\date", "\\date_create", "\\date_create_from_format", "\\date_create_immutable", "\\date_create_immutable_from_format", "\\date_default_timezone_get", "\\date_diff", "\\date_format", "\\date_get_last_errors", "\\date_interval_create_from_date_string", "\\date_interval_format", "\\date_offset_get", "\\date_parse", "\\date_parse_from_format", "\\date_sun_info", "\\date_sunrise", "\\date_sunset", "\\date_timestamp_get", "\\date_timezone_get", "\\datefmt_create", "\\datefmt_format", "\\datefmt_format_object", "\\datefmt_get_calendar", "\\datefmt_get_calendar_object", "\\datefmt_get_datetype", "\\datefmt_get_error_code", "\\datefmt_get_error_message", "\\datefmt_get_locale", "\\datefmt_get_pattern", "\\datefmt_get_timetype", "\\datefmt_get_timezone", "\\datefmt_get_timezone_id", "\\datefmt_is_lenient", "\\dcngettext", "\\decbin", "\\dechex", "\\decoct", "\\defined", "\\deflate_init", "\\deg2rad", "\\dirname", "\\disk_free_space", "\\diskfreespace", "\\dngettext", "\\doubleval", "\\error_get_last", "\\escapeshellarg", "\\escapeshellcmd", "\\exp", "\\explode", "\\expm1", "\\extension_loaded", "\\fdiv", "\\file_exists", "\\fileatime", "\\filectime", "\\filegroup", "\\fileinode", "\\filemtime", "\\fileowner", "\\fileperms", "\\filesize", "\\filetype", "\\filter_has_var", "\\filter_id", "\\filter_input", "\\filter_input_array", "\\filter_list", "\\filter_var", "\\filter_var_array", "\\floatval", "\\floor", "\\fmod", "\\ftok", "\\func_get_arg", "\\func_get_args", "\\func_num_args", "\\function_exists", "\\gc_enabled", "\\gc_status", "\\gd_info", "\\geoip_continent_code_by_name", "\\geoip_country_code3_by_name", "\\geoip_country_code_by_name", "\\geoip_country_name_by_name", "\\geoip_database_info", "\\geoip_db_avail", "\\geoip_db_filename", "\\geoip_db_get_all_info", "\\geoip_id_by_name", "\\geoip_isp_by_name", "\\geoip_org_by_name", "\\geoip_record_by_name", "\\geoip_region_by_name", "\\geoip_region_name_by_code", "\\geoip_time_zone_by_country_and_region", "\\get_browser", "\\get_called_class", "\\get_cfg_var", "\\get_class", "\\get_class_methods", "\\get_class_vars", "\\get_current_user", "\\get_debug_type", "\\get_declared_classes", "\\get_declared_interfaces", "\\get_declared_traits", "\\get_defined_constants", "\\get_defined_functions", "\\get_defined_vars", "\\get_extension_funcs", "\\get_headers", "\\get_html_translation_table", "\\get_include_path", "\\get_included_files", "\\get_loaded_extensions", "\\get_meta_tags", "\\get_object_vars", "\\get_parent_class", "\\get_required_files", "\\get_resource_id", "\\get_resources", "\\getallheaders", "\\getcwd", "\\getdate", "\\getenv", "\\gethostbyaddr", "\\gethostbyname", "\\gethostbynamel", "\\gethostname", "\\getlastmod", "\\getmygid", "\\getmyinode", "\\getmypid", "\\getmyuid", "\\getprotobyname", "\\getprotobynumber", "\\getrandmax", "\\getrusage", "\\getservbyname", "\\getservbyport", "\\gettext", "\\gettimeofday", "\\gettype", "\\glob", "\\gmdate", "\\gmmktime", "\\gmp_abs", "\\gmp_add", "\\gmp_and", "\\gmp_binomial", "\\gmp_cmp", "\\gmp_com", "\\gmp_div", "\\gmp_div_q", "\\gmp_div_qr", "\\gmp_div_r", "\\gmp_divexact", "\\gmp_export", "\\gmp_fact", "\\gmp_gcd", "\\gmp_gcdext", "\\gmp_hamdist", "\\gmp_import", "\\gmp_init", "\\gmp_intval", "\\gmp_invert", "\\gmp_jacobi", "\\gmp_kronecker", "\\gmp_lcm", "\\gmp_legendre", "\\gmp_mod", "\\gmp_mul", "\\gmp_neg", "\\gmp_nextprime", "\\gmp_or", "\\gmp_perfect_power", "\\gmp_perfect_square", "\\gmp_popcount", "\\gmp_pow", "\\gmp_powm", "\\gmp_prob_prime", "\\gmp_random", "\\gmp_random_bits", "\\gmp_random_range", "\\gmp_root", "\\gmp_rootrem", "\\gmp_scan0", "\\gmp_scan1", "\\gmp_sign", "\\gmp_sqrt", "\\gmp_sqrtrem", "\\gmp_strval", "\\gmp_sub", "\\gmp_testbit", "\\gmp_xor", "\\grapheme_stripos", "\\grapheme_stristr", "\\grapheme_strlen", "\\grapheme_strpos", "\\grapheme_strripos", "\\grapheme_strrpos", "\\grapheme_strstr", "\\grapheme_substr", "\\gzcompress", "\\gzdecode", "\\gzdeflate", "\\gzencode", "\\gzinflate", "\\gzuncompress", "\\hash", "\\hash_algos", "\\hash_copy", "\\hash_equals", "\\hash_file", "\\hash_hkdf", "\\hash_hmac", "\\hash_hmac_algos", "\\hash_hmac_file", "\\hash_init", "\\hash_pbkdf2", "\\headers_list", "\\hebrev", "\\hexdec", "\\hrtime", "\\html_entity_decode", "\\htmlentities", "\\htmlspecialchars", "\\htmlspecialchars_decode", "\\http_build_cookie", "\\http_build_query", "\\http_build_str", "\\http_cache_etag", "\\http_cache_last_modified", "\\http_chunked_decode", "\\http_date", "\\http_deflate", "\\http_get_request_body", "\\http_get_request_body_stream", "\\http_get_request_headers", "\\http_inflate", "\\http_match_etag", "\\http_match_modified", "\\http_match_request_header", "\\http_parse_cookie", "\\http_parse_headers", "\\http_parse_message", "\\http_parse_params", "\\http_request_body_encode", "\\http_request_method_exists", "\\http_request_method_name", "\\http_support", "\\hypot", "\\iconv", "\\iconv_get_encoding", "\\iconv_mime_decode", "\\iconv_mime_decode_headers", "\\iconv_mime_encode", "\\iconv_strlen", "\\iconv_strpos", "\\iconv_strrpos", "\\iconv_substr", "\\idate", "\\image_type_to_extension", "\\image_type_to_mime_type", "\\imagecolorat", "\\imagecolorclosest", "\\imagecolorclosestalpha", "\\imagecolorclosesthwb", "\\imagecolorexact", "\\imagecolorexactalpha", "\\imagecolorresolve", "\\imagecolorresolvealpha", "\\imagecolorsforindex", "\\imagecolorstotal", "\\imagecreate", "\\imagecreatefromstring", "\\imagecreatetruecolor", "\\imagefontheight", "\\imagefontwidth", "\\imageftbbox", "\\imagegetinterpolation", "\\imagegrabscreen", "\\imagegrabwindow", "\\imageistruecolor", "\\imagesx", "\\imagesy", "\\imagettfbbox", "\\imagetypes", "\\implode", "\\in_array", "\\inet_ntop", "\\inet_pton", "\\inflate_get_read_len", "\\inflate_get_status", "\\inflate_init", "\\ini_get", "\\ini_get_all", "\\intcal_get_maximum", "\\intdiv", "\\intl_error_name", "\\intl_get", "\\intl_get_error_code", "\\intl_get_error_message", "\\intl_is_failure", "\\intlcal_after", "\\intlcal_before", "\\intlcal_create_instance", "\\intlcal_equals", "\\intlcal_field_difference", "\\intlcal_from_date_time", "\\intlcal_get", "\\intlcal_get_actual_maximum", "\\intlcal_get_actual_minimum", "\\intlcal_get_available_locales", "\\intlcal_get_day_of_week_type", "\\intlcal_get_error_code", "\\intlcal_get_error_message", "\\intlcal_get_first_day_of_week", "\\intlcal_get_greatest_minimum", "\\intlcal_get_keyword_values_for_locale", "\\intlcal_get_least_maximum", "\\intlcal_get_locale", "\\intlcal_get_maximum", "\\intlcal_get_minimal_days_in_first_week", "\\intlcal_get_minimum", "\\intlcal_get_now", "\\intlcal_get_repeated_wall_time_option", "\\intlcal_get_skipped_wall_time_option", "\\intlcal_get_time", "\\intlcal_get_time_zone", "\\intlcal_get_type", "\\intlcal_get_weekend_transition", "\\intlcal_greates_minimum", "\\intlcal_in_daylight_time", "\\intlcal_is_equivalent_to", "\\intlcal_is_lenient", "\\intlcal_is_set", "\\intlcal_is_weekend", "\\intlcal_to_date_time", "\\intlgregcal_create_instance", "\\intlgregcal_get_gregorian_change", "\\intlgregcal_is_leap_year", "\\intltz_count_equivalent_ids", "\\intltz_create_default", "\\intltz_create_enumeration", "\\intltz_create_time_zone", "\\intltz_create_time_zone_id_enumeration", "\\intltz_from_date_time_zone", "\\intltz_getGMT", "\\intltz_get_canonical_id", "\\intltz_get_display_name", "\\intltz_get_dst_savings", "\\intltz_get_equivalent_id", "\\intltz_get_error_code", "\\intltz_get_error_message", "\\intltz_get_gmt", "\\intltz_get_id", "\\intltz_get_offset", "\\intltz_get_raw_offset", "\\intltz_get_region", "\\intltz_get_tz_data_version", "\\intltz_get_unknown", "\\intltz_has_same_rules", "\\intltz_to_date_time_zone", "\\intltz_use_daylight_time", "\\intlz_create_default", "\\intval", "\\ip2long", "\\iptcparse", "\\is_a", "\\is_array", "\\is_bool", "\\is_countable", "\\is_dir", "\\is_double", "\\is_executable", "\\is_file", "\\is_finite", "\\is_float", "\\is_infinite", "\\is_int", "\\is_integer", "\\is_iterable", "\\is_link", "\\is_long", "\\is_nan", "\\is_null", "\\is_numeric", "\\is_object", "\\is_readable", "\\is_real", "\\is_resource", "\\is_scalar", "\\is_string", "\\is_subclass_of", "\\is_uploaded_file", "\\is_writable", "\\is_writeable", "\\iterator_count", "\\join", "\\json_last_error", "\\json_last_error_msg", "\\key", "\\key_exists", "\\lcfirst", "\\libxml_get_errors", "\\libxml_get_last_error", "\\linkinfo", "\\locale_accept_from_http", "\\locale_canonicalize", "\\locale_compose", "\\locale_filter_matches", "\\locale_get_all_variants", "\\locale_get_default", "\\locale_get_display_language", "\\locale_get_display_name", "\\locale_get_display_region", "\\locale_get_display_script", "\\locale_get_display_variant", "\\locale_get_keywords", "\\locale_get_primary_language", "\\locale_get_region", "\\locale_get_script", "\\locale_lookup", "\\locale_parse", "\\localeconv", "\\localtime", "\\log", "\\log10", "\\log1p", "\\long2ip", "\\lstat", "\\ltrim", "\\max", "\\mb_check_encoding", "\\mb_chr", "\\mb_convert_case", "\\mb_convert_encoding", "\\mb_convert_kana", "\\mb_decode_mimeheader", "\\mb_decode_numericentity", "\\mb_detect_encoding", "\\mb_encode_mimeheader", "\\mb_encode_numericentity", "\\mb_encoding_aliases", "\\mb_ereg_match", "\\mb_ereg_replace", "\\mb_ereg_search", "\\mb_ereg_search_getpos", "\\mb_ereg_search_getregs", "\\mb_ereg_search_pos", "\\mb_ereg_search_regs", "\\mb_ereg_search_setpos", "\\mb_eregi_replace", "\\mb_get_info", "\\mb_http_input", "\\mb_list_encodings", "\\mb_ord", "\\mb_output_handler", "\\mb_preferred_mime_name", "\\mb_scrub", "\\mb_split", "\\mb_str_split", "\\mb_strcut", "\\mb_strimwidth", "\\mb_stripos", "\\mb_stristr", "\\mb_strlen", "\\mb_strpos", "\\mb_strrchr", "\\mb_strrichr", "\\mb_strripos", "\\mb_strrpos", "\\mb_strstr", "\\mb_strtolower", "\\mb_strtoupper", "\\mb_strwidth", "\\mb_substr", "\\mb_substr_count", "\\mbereg_search_setpos", "\\md5", "\\md5_file", "\\memory_get_peak_usage", "\\memory_get_usage", "\\metaphone", "\\method_exists", "\\mhash", "\\mhash_count", "\\mhash_get_block_size", "\\mhash_get_hash_name", "\\mhash_keygen_s2k", "\\microtime", "\\min", "\\mktime", "\\msgfmt_create", "\\msgfmt_format", "\\msgfmt_format_message", "\\msgfmt_get_error_code", "\\msgfmt_get_error_message", "\\msgfmt_get_locale", "\\msgfmt_get_pattern", "\\msgfmt_parse", "\\msgfmt_parse_message", "\\mt_getrandmax", "\\net_get_interfaces", "\\ngettext", "\\nl2br", "\\nl_langinfo", "\\normalizer_get_raw_decomposition", "\\normalizer_is_normalized", "\\normalizer_normalize", "\\number_format", "\\numfmt_create", "\\numfmt_format", "\\numfmt_format_currency", "\\numfmt_get_attribute", "\\numfmt_get_error_code", "\\numfmt_get_error_message", "\\numfmt_get_locale", "\\numfmt_get_pattern", "\\numfmt_get_symbol", "\\numfmt_get_text_attribute", "\\numfmt_parse", "\\ob_etaghandler", "\\ob_iconv_handler", "\\octdec", "\\ord", "\\pack", "\\parse_ini_string", "\\parse_url", "\\pathinfo", "\\pcntl_errno", "\\pcntl_get_last_error", "\\pcntl_getpriority", "\\pcntl_strerror", "\\pcntl_wexitstatus", "\\pcntl_wifcontinued", "\\pcntl_wifexited", "\\pcntl_wifsignaled", "\\pcntl_wifstopped", "\\pcntl_wstopsig", "\\pcntl_wtermsig", "\\pdo_drivers", "\\php_ini_loaded_file", "\\php_ini_scanned_files", "\\php_logo_guid", "\\php_sapi_name", "\\php_strip_whitespace", "\\php_uname", "\\phpversion", "\\pi", "\\pos", "\\posix_ctermid", "\\posix_errno", "\\posix_get_last_error", "\\posix_getcwd", "\\posix_getegid", "\\posix_geteuid", "\\posix_getgid", "\\posix_getgrgid", "\\posix_getgrnam", "\\posix_getgroups", "\\posix_getlogin", "\\posix_getpgid", "\\posix_getpgrp", "\\posix_getpid", "\\posix_getppid", "\\posix_getpwnam", "\\posix_getpwuid", "\\posix_getrlimit", "\\posix_getsid", "\\posix_getuid", "\\posix_initgroups", "\\posix_isatty", "\\posix_strerror", "\\posix_times", "\\posix_ttyname", "\\posix_uname", "\\pow", "\\preg_grep", "\\preg_last_error", "\\preg_last_error_msg", "\\preg_quote", "\\preg_split", "\\property_exists", "\\quoted_printable_decode", "\\quoted_printable_encode", "\\quotemeta", "\\rad2deg", "\\range", "\\rawurldecode", "\\rawurlencode", "\\realpath", "\\realpath_cache_get", "\\realpath_cache_size", "\\resourcebundle_count", "\\resourcebundle_create", "\\resourcebundle_get", "\\resourcebundle_get_error_code", "\\resourcebundle_get_error_message", "\\resourcebundle_locales", "\\round", "\\rtrim", "\\sha1", "\\sha1_file", "\\sin", "\\sinh", "\\sizeof", "\\soundex", "\\spl_classes", "\\spl_object_hash", "\\sprintf", "\\sqrt", "\\stat", "\\str_contains", "\\str_ends_with", "\\str_getcsv", "\\str_pad", "\\str_repeat", "\\str_rot13", "\\str_shuffle", "\\str_split", "\\str_starts_with", "\\str_word_count", "\\strcasecmp", "\\strchr", "\\strcmp", "\\strcoll", "\\strcspn", "\\stream_get_filters", "\\stream_get_transports", "\\stream_get_wrappers", "\\stream_is_local", "\\stream_isatty", "\\strip_tags", "\\stripcslashes", "\\stripos", "\\stripslashes", "\\stristr", "\\strlen", "\\strnatcasecmp", "\\strnatcmp", "\\strncasecmp", "\\strncmp", "\\strpbrk", "\\strpos", "\\strptime", "\\strrchr", "\\strrev", "\\strripos", "\\strrpos", "\\strspn", "\\strstr", "\\strtolower", "\\strtotime", "\\strtoupper", "\\strtr", "\\strval", "\\substr", "\\substr_compare", "\\substr_count", "\\substr_replace", "\\sys_getloadavg", "\\tan", "\\tanh", "\\timezone_abbreviations_list", "\\timezone_identifiers_list", "\\timezone_location_get", "\\timezone_name_from_abbr", "\\timezone_name_get", "\\timezone_offset_get", "\\timezone_open", "\\timezone_transitions_get", "\\timezone_version_get", "\\token_get_all", "\\token_name", "\\transliterator_create", "\\transliterator_create_from_rules", "\\transliterator_create_inverse", "\\transliterator_get_error_code", "\\transliterator_get_error_message", "\\transliterator_list_ids", "\\transliterator_transliterate", "\\trim", "\\ucfirst", "\\ucwords", "\\uniqid", "\\unpack", "\\urldecode", "\\urlencode", "\\utf8_decode", "\\utf8_encode", "\\vsprintf", "\\wordwrap", "\\xml_error_string", "\\xml_get_current_byte_index", "\\xml_get_current_column_number", "\\xml_get_current_line_number", "\\xml_get_error_code", "\\xml_parser_create", "\\xml_parser_create_ns", "\\xml_parser_get_option", "\\zend_version", "\\zlib_decode", "\\zlib_encode", "\\zlib_get_coding_type");
    private static final Condition<PsiElement> USE_OPERATOR_SCOPES_CONDITION = element -> element instanceof PhpFile || element instanceof PhpNamespace;
    public static final Condition<PsiElement> LOOP_STATEMENTS = element -> element instanceof PhpSwitch || element instanceof For || element instanceof While || element instanceof DoWhile || element instanceof ForeachStatement;
    public static final TokenSet tsASSOCIATIVE_OPS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opCONCAT});

    private PhpCodeInsightUtil() {
    }

    @Nullable
    public static Integer toInt(@NotNull PsiElement element) {
        ASTNode elementNode;
        IElementType elementType;
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(0);
        }
        if (PhpElementTypes.NUMBER.equals(elementType = (elementNode = element.getNode()).getElementType())) {
            ASTNode childNode = elementNode.getFirstChildNode();
            if (childNode == null) {
                return null;
            }
            IElementType childNodeType = childNode.getElementType();
            if (PhpTokenTypes.tsINTEGERS.contains(childNodeType)) {
                try {
                    return Integer.parseInt(PhpPsiUtil.getLiteralText(childNode.getPsi()));
                }
                catch (NumberFormatException exception2) {
                    return null;
                }
            }
            if (PhpTokenTypes.FLOAT_LITERAL.equals(childNodeType)) {
                try {
                    return (int)Float.parseFloat(PhpPsiUtil.getLiteralText(childNode.getPsi()));
                }
                catch (NumberFormatException exception3) {
                    return null;
                }
            }
        }
        return null;
    }

    @Nullable
    public static String toString(@NotNull StringLiteralExpression stringLiteralExpression) {
        if (stringLiteralExpression == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(1);
        }
        if (stringLiteralExpression.getChildren().length == 0) {
            return stringLiteralExpression.getContents();
        }
        return null;
    }

    @Nullable
    public static String toString(@NotNull PsiElement element) {
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(2);
        }
        return PhpCodeInsightUtil.toString(element, true);
    }

    @Nullable
    public static String toString(@NotNull PsiElement element, boolean allowCasting) {
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(3);
        }
        ASTNode elementNode = element.getNode();
        IElementType elementType = elementNode.getElementType();
        if (element instanceof StringLiteralExpression) {
            return PhpCodeInsightUtil.toString((StringLiteralExpression)element);
        }
        if (allowCasting && elementType == PhpElementTypes.NUMBER) {
            return PhpPsiUtil.getLiteralText(element);
        }
        return null;
    }

    public static boolean isEmptyBody(@NotNull Function function) {
        GroupStatement child;
        if (function == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(4);
        }
        if ((child = (GroupStatement)PsiTreeUtil.findChildOfType((PsiElement)function, GroupStatement.class)) != null) {
            PsiElement[] children;
            for (PsiElement psiElement : children = child.getChildren()) {
                if (!(psiElement instanceof PhpPsiElement) || psiElement instanceof PhpDocPsiElement) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNull(@Nullable PsiElement value) {
        String name;
        return value instanceof ConstantReference && (name = ((ConstantReference)value).getName()) != null && PhpLangUtil.equalsIgnoreCase("null", name);
    }

    public static boolean isResultUsed(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(5);
        }
        if ((parent = element.getParent()) instanceof PhpUse) {
            return false;
        }
        IElementType parentNodeType = parent.getNode().getElementType();
        if (parent instanceof Statement && parentNodeType == PhpElementTypes.STATEMENT) {
            return false;
        }
        if (parent instanceof For) {
            return ArrayUtil.contains((Object)element, (Object[])((For)parent).getConditionalExpressions());
        }
        if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(parentNodeType)) {
            return false;
        }
        if (parent instanceof UnaryExpression && PhpCodeInsightUtil.isSilenceExpression((UnaryExpression)parent)) {
            return PhpCodeInsightUtil.isResultUsed(parent);
        }
        if (parent instanceof TernaryExpression && element != ((TernaryExpression)parent).getCondition()) {
            return PhpCodeInsightUtil.isResultUsed(parent);
        }
        return true;
    }

    public static boolean isIncrementOrDecrementExpression(@NotNull UnaryExpression expression) {
        if (expression == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(6);
        }
        return PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.INFIX_WRITE_EXPRESSION, PhpElementTypes.POSTFIX_EXPRESSION);
    }

    public static boolean isSilenceExpression(@NotNull UnaryExpression expression) {
        if (expression == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(7);
        }
        return PhpPsiUtil.isOfType(expression.getOperation(), PhpTokenTypes.opSILENCE);
    }

    public static boolean isForeachKeyOrValueAssignedByReference(@NotNull PhpReference key) {
        PsiElement prevSibling;
        if (key == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(8);
        }
        return (prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)key, true)) != null && PhpTokenTypes.opBIT_AND == prevSibling.getNode().getElementType();
    }

    public static boolean hasMagicMethod(@NotNull PhpType type, @NotNull PhpIndex index, @Nullable String magicName) {
        if (type == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(9);
        }
        if (index == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(10);
        }
        if (magicName == null) {
            return false;
        }
        for (String fqn : type.getTypes()) {
            Collection classes = index.getAnyByFQN(fqn);
            for (PhpClass aClass : classes) {
                PhpClass containingClass;
                Method method = aClass.findMethodByName((CharSequence)magicName);
                if (method == null || (containingClass = method.getContainingClass()) == null || PhpLangUtil.isObject(containingClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isScopeForUseOperator(@NotNull PhpPsiElement element) {
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(11);
        }
        return USE_OPERATOR_SCOPES_CONDITION.value((Object)element);
    }

    @Nullable
    public static PhpPsiElement findScopeForUseOperator(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(12);
        }
        return (PhpPsiElement)PhpPsiUtil.getParentByCondition(psiElement, false, USE_OPERATOR_SCOPES_CONDITION);
    }

    public static boolean hasQualifier(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(13);
        }
        return PhpPsiUtil.getChildByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF) != null || PhpPsiUtil.isOfType(reference.getFirstChild(), PhpTokenTypes.kwNAMESPACE);
    }

    public static boolean hasQualifier(@NotNull String name) {
        if (name == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(14);
        }
        return name.contains("\\");
    }

    @NotNull
    public static String createQualifiedName(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn, boolean useCurrentNamespace, boolean allowClassAliases) {
        String namespaceFqn;
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(15);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(16);
        }
        PhpContractUtil.assertFqn(fqn);
        if (PhpType.isPrimitiveType((String)fqn)) {
            String string = PhpLangUtil.toPresentableFQN(fqn);
            if (string == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (PhpCodeInsightUtil.isSameNamespace(scopeForUseOperator, fqn)) {
            String shortName = PhpLangUtil.toShortName(fqn);
            if (PhpCodeInsightUtil.isAliasUsed(scopeForUseOperator, shortName)) {
                String string = fqn;
                if (string == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(18);
                }
                return string;
            }
            String string = shortName;
            if (string == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(19);
            }
            return string;
        }
        String qualifiedName = fqn;
        if (useCurrentNamespace && scopeForUseOperator instanceof PhpNamespace && PhpLangUtil.isFqn(namespaceFqn = ((PhpNamespace)scopeForUseOperator).getFQN()) && !PhpLangUtil.isGlobalNamespaceFQN(namespaceFqn)) {
            String prefix = namespaceFqn + "\\";
            qualifiedName = StringUtil.trimStart((String)fqn, (String)prefix);
        }
        List<PhpUseList> imports = PhpCodeInsightUtil.collectImports(scopeForUseOperator);
        for (PhpUseList anImport : imports) {
            PhpUse[] declarations;
            for (PhpUse declaration : declarations = anImport.getDeclarations()) {
                String name = PhpCodeInsightUtil.createQualifiedName(fqn, declaration.getFQN(), declaration.getAliasName(), allowClassAliases);
                if (name == null || PhpCodeInsightUtil.hasQualifier(name) && name.length() >= qualifiedName.length()) continue;
                qualifiedName = name;
            }
        }
        String string = qualifiedName;
        if (string == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static boolean isAliasUsed(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String name) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(21);
        }
        if (name == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(22);
        }
        List<PhpUseList> imports = PhpCodeInsightUtil.collectImports(scopeForUseOperator);
        for (PhpUseList anImport : imports) {
            PhpUse[] declarations;
            for (PhpUse declaration : declarations = anImport.getDeclarations()) {
                if (!PhpLangUtil.equalsClassNames(declaration.getName(), name)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String createQualifiedName(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(23);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(24);
        }
        return PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, fqn, true, true);
    }

    @NotNull
    public static String createQualifiedName(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn, @Nullable PhpReference nameHolder, boolean useCurrentNamespace) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(25);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(26);
        }
        return PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, fqn, nameHolder, useCurrentNamespace, true);
    }

    @NotNull
    public static String createQualifiedName(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn, @Nullable PhpReference nameHolder, boolean useCurrentNamespace, boolean allowClassAliases) {
        PsiElement parent;
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(27);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(28);
        }
        if (nameHolder != null && (parent = nameHolder.getParent()) instanceof PhpUse && !((PhpUse)parent).isTraitImport()) {
            String string = StringUtil.trimStart((String)fqn, (String)"\\");
            if (string == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(29);
            }
            return string;
        }
        return PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, fqn, useCurrentNamespace, allowClassAliases);
    }

    @Nullable
    public static String createQualifiedName(@NotNull String fqn, @NotNull String importedFqn, @Nullable String alias, boolean allowClassAliases) {
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(30);
        }
        if (importedFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(31);
        }
        PhpContractUtil.assertFqn(fqn);
        PhpContractUtil.assertFqn(importedFqn);
        PhpContractUtil.assertNoQualifier(alias);
        if (PhpLangUtil.equalsClassNames(StringUtil.trimEnd((String)fqn, (String)"[]"), importedFqn)) {
            if (!allowClassAliases && alias != null) {
                return null;
            }
            return alias != null ? (PhpType.isPluralType((String)fqn) ? alias + "[]" : alias) : PhpLangUtil.toShortName(fqn);
        }
        String parentNamespaceFQN = PhpLangUtil.getParentNamespaceFQN(fqn);
        if (PhpCodeInsightUtil.isAliassed(importedFqn, parentNamespaceFQN)) {
            if (alias != null) {
                return alias + StringUtil.trimStart((String)fqn, (String)importedFqn);
            }
            String qualifiedName = StringUtil.trimStart((String)fqn, (String)PhpLangUtil.getParentNamespaceFQN(importedFqn));
            return StringUtil.trimStart((String)qualifiedName, (String)"\\");
        }
        return null;
    }

    private static boolean isAliassed(@NotNull String importedFqn, @NotNull String parentNamespaceFQN) {
        if (importedFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(32);
        }
        if (parentNamespaceFQN == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(33);
        }
        if (!StringUtil.startsWith((CharSequence)parentNamespaceFQN, (CharSequence)importedFqn)) {
            return false;
        }
        return parentNamespaceFQN.length() == importedFqn.length() || parentNamespaceFQN.charAt(importedFqn.length()) == "\\".charAt(0);
    }

    @NotNull
    public static List<PhpUseList> collectImports(@NotNull PhpPsiElement scopeForUseOperator) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(34);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)scopeForUseOperator, () -> {
            List out = Collections.emptyList();
            GroupStatement groupStatement = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)scopeForUseOperator, GroupStatement.class);
            if (groupStatement != null) {
                List scopeChildren;
                List children = PhpPsiUtil.getChildren((PsiElement)groupStatement, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
                if (!children.isEmpty()) {
                    out = children;
                }
                if (scopeForUseOperator.getChildren().length > 1 && !(scopeChildren = PhpPsiUtil.getChildren((PsiElement)scopeForUseOperator, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF)).isEmpty()) {
                    out = scopeChildren;
                }
            }
            return CachedValueProvider.Result.create(out, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (list == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public static List<PhpNamespace> collectNamespaces(@NotNull PsiFile phpFile) {
        List<PhpNamespace> children;
        GroupStatement groupStatement;
        if (phpFile == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(36);
        }
        if ((groupStatement = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)phpFile, GroupStatement.class)) != null && !(children = PhpPsiUtil.getChildren((PsiElement)groupStatement, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF)).isEmpty()) {
            List<PhpNamespace> list = children;
            if (list == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        List<PhpNamespace> list = Collections.emptyList();
        if (list == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(38);
        }
        return list;
    }

    public static boolean isSameNamespace(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(39);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(40);
        }
        PhpContractUtil.assertFqn(fqn);
        String parentNamespace = PhpLangUtil.getParentQualifiedName(fqn);
        if (scopeForUseOperator instanceof PhpFile) {
            return StringUtil.isEmpty((String)parentNamespace);
        }
        if (scopeForUseOperator instanceof PhpNamespace) {
            return PhpLangUtil.equalsClassNames(PhpLangUtil.toFQN(parentNamespace), ((PhpNamespace)scopeForUseOperator).getFQN());
        }
        return false;
    }

    public static boolean hasNameConflicts(@NotNull PhpPsiElement scope, @NotNull PhpNamedElement element) {
        ImportElementType type;
        if (scope == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(41);
        }
        if (element == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(42);
        }
        return (type = ImportElementType.fromElement((PsiElement)element)) != null && PhpCodeInsightUtil.hasNameConflicts(scope, element.getFQN(), type);
    }

    public static boolean hasNameConflicts(@NotNull PhpPsiElement scope, @NotNull String elementFqn, @NotNull ImportElementType elementType) {
        PsiFile file;
        if (scope == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(43);
        }
        if (elementFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(44);
        }
        if (elementType == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(45);
        }
        if ((file = scope.getContainingFile()) instanceof PhpFile) {
            String elementName = PhpLangUtil.toShortName(elementFqn);
            String elementNamespace = PhpLangUtil.getParentNamespaceFQN(elementFqn);
            String scopeNamespace = PhpLangUtil.concat(scope instanceof PhpNamespace ? ((PhpNamespace)scope).getFQN() : "", "\\");
            if (PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, (PhpFile)file, elementName, scopeNamespace)) {
                return true;
            }
            if ((elementType == ImportElementType.FUNCTION || elementType == ImportElementType.CONSTANT) && !PhpLangUtil.isGlobalNamespaceFQN(elementNamespace) && PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, (PhpFile)file, elementName, "\\")) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasNameConflicts(@NotNull PhpPsiElement scope, @NotNull String elementFqn, @NotNull ImportElementType elementType, @NotNull PhpFile file, @NotNull String elementName, @NotNull String scopeNamespace) {
        if (scope == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(46);
        }
        if (elementFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(47);
        }
        if (elementType == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(48);
        }
        if (file == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(49);
        }
        if (elementName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(50);
        }
        if (scopeNamespace == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(51);
        }
        for (PhpNamedElement def : file.getTopLevelDefs().values()) {
            if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, def)) continue;
            return true;
        }
        switch (elementType) {
            case CLASS: {
                for (PhpClass phpClass : PhpIndex.getInstance((Project)scope.getProject()).getClassesByName(elementName)) {
                    if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, (PhpNamedElement)phpClass)) continue;
                    return true;
                }
                for (PhpClass phpClass : PhpIndex.getInstance((Project)scope.getProject()).getInterfacesByName(elementName)) {
                    if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, (PhpNamedElement)phpClass)) continue;
                    return true;
                }
                for (PhpClass phpClass : PhpIndex.getInstance((Project)scope.getProject()).getTraitsByName(elementName)) {
                    if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, (PhpNamedElement)phpClass)) continue;
                    return true;
                }
                break;
            }
            case NAMESPACE: {
                break;
            }
            case FUNCTION: {
                for (Function function : PhpIndex.getInstance((Project)scope.getProject()).getFunctionsByName(elementName)) {
                    if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, (PhpNamedElement)function)) continue;
                    return true;
                }
                break;
            }
            case CONSTANT: {
                for (Constant constant : PhpIndex.getInstance((Project)scope.getProject()).getConstantsByName(elementName)) {
                    if (!PhpCodeInsightUtil.hasNameConflicts(scope, elementFqn, elementType, elementName, scopeNamespace, (PhpNamedElement)constant)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private static boolean hasNameConflicts(@NotNull PhpPsiElement scope, @NotNull String elementFqn, @NotNull ImportElementType elementType, @NotNull String elementName, @NotNull String scopeNamespace, @NotNull PhpNamedElement def) {
        if (scope == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(52);
        }
        if (elementFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(53);
        }
        if (elementType == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(54);
        }
        if (elementName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(55);
        }
        if (scopeNamespace == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(56);
        }
        if (def == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(57);
        }
        if (PhpLangUtil.equalsNamespaceNames(scopeNamespace, def.getNamespaceName())) {
            String defName = def.getName();
            String defFqn = def.getFQN();
            if (def instanceof PhpUse ? PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)def) == scope && (PhpUseImpl.isOfConst((PhpUse)def) ? elementType == ImportElementType.CONSTANT && PhpLangUtil.equalsConstantNames(elementName, defName) && !PhpCodeInsightUtil.equalConstantFqns(elementFqn, defFqn) : (PhpUseImpl.isOfFunction((PhpUse)def) ? elementType == ImportElementType.FUNCTION && PhpLangUtil.equalsIgnoreCase(elementName, defName) && !PhpLangUtil.equalsIgnoreCase(elementFqn, defFqn) : PhpLangUtil.equalsIgnoreCase(elementName, defName) && !PhpLangUtil.equalsIgnoreCase(elementFqn, defFqn))) : (def instanceof PhpClass ? elementType == ImportElementType.CLASS && PhpLangUtil.equalsClassNames(elementName, defName) : (def instanceof PhpNamespace ? elementType == ImportElementType.NAMESPACE && PhpLangUtil.equalsNamespaceNames(elementName, defName) : (def instanceof Function ? elementType == ImportElementType.FUNCTION && PhpLangUtil.equalsFunctionNames(elementName, defName) : def instanceof Constant && elementType == ImportElementType.CONSTANT && PhpLangUtil.equalsConstantNames(elementName, defName))))) {
                return true;
            }
        }
        return false;
    }

    private static boolean equalConstantFqns(@NotNull String elementFqn, @NotNull String defFqn) {
        if (elementFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(58);
        }
        if (defFqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(59);
        }
        return PhpLangUtil.equalsConstantNames(PhpLangUtil.toShortName(elementFqn), PhpLangUtil.toShortName(defFqn)) && PhpLangUtil.equalsNamespaceNames(PhpLangUtil.getParentNamespaceFQN(elementFqn), PhpLangUtil.getParentNamespaceFQN(defFqn));
    }

    @Contract(value="null -> false")
    public static boolean isAutoImportEnabled(@Nullable PhpPsiElement scopeForUseOperator) {
        PhpAutoImportConfiguration.State configuration = PhpAutoImportConfiguration.getInstance().getState();
        return scopeForUseOperator instanceof PhpNamespace && configuration.isAutoImportInNamespaceScope() || scopeForUseOperator instanceof PhpFile && configuration.isAutoImportInFileScope();
    }

    public static boolean canImport(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn, @NotNull PhpGroupUseElement.PhpUseKeyword keyword) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(60);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(61);
        }
        if (keyword == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(62);
        }
        return PhpCodeInsightUtil.canImport(scopeForUseOperator, fqn, PhpLangUtil.toShortName(fqn), keyword);
    }

    public static boolean canImport(@NotNull PhpPsiElement scopeForUseOperator, final @NotNull String fqn, final @NotNull String name, final @NotNull PhpGroupUseElement.PhpUseKeyword keyword) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(63);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(64);
        }
        if (name == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(65);
        }
        if (keyword == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(66);
        }
        PhpContractUtil.assertFqn(fqn);
        final Ref isNameAvailable = new Ref((Object)true);
        scopeForUseOperator.acceptChildren((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpUse(PhpUse use) {
                if (PhpLangUtil.equalsClassNames(name, use.getName()) && !fqn.equals(use.getFQN()) && StringUtil.equals((CharSequence)PhpGroupUseElement.getKeyword(use, (PhpUseList)PhpPsiUtil.getParentByCondition((PsiElement)use, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF)), (CharSequence)keyword.getValue())) {
                    isNameAvailable.set((Object)false);
                }
            }

            public void visitPhpClass(PhpClass clazz) {
                if (keyword == PhpGroupUseElement.PhpUseKeyword.CLASS && PhpLangUtil.equalsClassNames(name, clazz.getName())) {
                    isNameAvailable.set((Object)false);
                }
            }

            public void visitPhpFunction(Function function) {
                if (keyword == PhpGroupUseElement.PhpUseKeyword.FUNCTION && PhpLangUtil.equalsClassNames(name, function.getName())) {
                    isNameAvailable.set((Object)false);
                }
            }

            public void visitPhpConstant(Constant constant) {
                if (keyword == PhpGroupUseElement.PhpUseKeyword.CONSTANT && PhpLangUtil.equalsClassNames(name, constant.getName())) {
                    isNameAvailable.set((Object)false);
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((Boolean)isNameAvailable.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/codeInsight/PhpCodeInsightUtil$1", "visitElement"));
            }
        });
        return (Boolean)isNameAvailable.get();
    }

    @Deprecated
    @Nullable
    public static String alreadyImported(@NotNull PhpPsiElement scopeHolder, @NotNull String fqn) {
        if (scopeHolder == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(67);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(68);
        }
        return PhpCodeInsightUtil.findImportedName(scopeHolder, fqn, PhpGroupUseElement.PhpUseKeyword.CLASS);
    }

    @Nullable
    public static String findImportedName(@NotNull PhpPsiElement scopeHolder, @NotNull String fqn, @NotNull PhpGroupUseElement.PhpUseKeyword keyword) {
        PhpUse declaration;
        if (scopeHolder == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(69);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(70);
        }
        if (keyword == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(71);
        }
        if ((declaration = (PhpUse)PhpCodeInsightUtil.findDeclarations(scopeHolder, fqn).stream().filter(use -> StringUtil.equals((CharSequence)PhpGroupUseElement.getKeyword(use, (PhpUseList)PhpPsiUtil.getParentByCondition((PsiElement)use, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF)), (CharSequence)keyword.getValue())).findFirst().orElse(null)) == null) {
            return null;
        }
        String aliasName = declaration.getAliasName();
        return aliasName == null ? declaration.getName() : aliasName;
    }

    @NotNull
    public static Collection<PhpUse> findDeclarations(@NotNull PhpPsiElement scopeHolder, @NotNull String fqn) {
        if (scopeHolder == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(72);
        }
        if (fqn == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(73);
        }
        List<PhpUseList> lists = PhpCodeInsightUtil.collectImports(scopeHolder);
        SmartList result = new SmartList();
        for (PhpUseList list : lists) {
            PhpUse[] declarations;
            for (PhpUse declaration : declarations = list.getDeclarations()) {
                PhpReference reference = declaration.getTargetReference();
                if (reference == null || !PhpLangUtil.equalsClassNames(reference.getFQN(), fqn)) continue;
                result.add(declaration);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(74);
        }
        return smartList;
    }

    public static boolean isFullyQualified(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(75);
        }
        return reference.getText().startsWith("\\");
    }

    public static boolean isNotInImport(@NotNull PhpReference reference) {
        PsiElement parent;
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(76);
        }
        if ((parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)reference)) instanceof PhpUse) {
            return ((PhpUse)parent).isTraitImport();
        }
        return true;
    }

    public static boolean isImportSupported(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(77);
        }
        return PhpCodeInsightUtil.isNotInImport(reference);
    }

    @NotNull
    public static PhpAccessInstruction.Access getAccess(@NotNull PhpPsiElement anchor) {
        PsiElement variableParent;
        MultiassignmentExpression multiAssignmentExpression;
        if (anchor == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(78);
        }
        if ((multiAssignmentExpression = (MultiassignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)anchor, (Condition<? super PsiElement>)MultiassignmentExpression.INSTANCEOF)) != null) {
            if (MultiassignmentExpressionImpl.getUnpackedVariablesFromMultiAssignment(multiAssignmentExpression).contains(anchor)) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(79);
                }
                return access;
            }
            if (multiAssignmentExpression.getValue() == anchor) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(80);
                }
                return access;
            }
        }
        if ((variableParent = anchor.getParent()) instanceof SelfAssignmentExpression) {
            if (anchor == ((SelfAssignmentExpression)variableParent).getVariable()) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(81);
                }
                return access;
            }
            PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_ACCESS;
            if (access == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(82);
            }
            return access;
        }
        if (variableParent instanceof AssignmentExpression) {
            boolean assignByReference = PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)variableParent);
            if (((AssignmentExpression)variableParent).getVariable() == anchor) {
                PhpAccessInstruction.Access access = assignByReference ? PhpAccessInstruction.Access.WRITE_REF_ACCESS : PhpAccessInstruction.Access.WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(83);
                }
                return access;
            }
            PhpAccessInstruction.Access access = assignByReference ? PhpAccessInstruction.Access.READ_REF_ACCESS : PhpAccessInstruction.Access.READ_ACCESS;
            if (access == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(84);
            }
            return access;
        }
        if (variableParent instanceof ForeachStatement) {
            PsiElement prevSibling;
            ForeachStatement foreach = (ForeachStatement)variableParent;
            if ((foreach.getKey() == anchor || foreach.getValue() == anchor) && (prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)anchor, true)) != null) {
                if (PhpTokenTypes.opBIT_AND == prevSibling.getNode().getElementType()) {
                    PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_REF_ACCESS;
                    if (access == null) {
                        PhpCodeInsightUtil.$$$reportNull$$$0(85);
                    }
                    return access;
                }
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(86);
                }
                return access;
            }
        } else if (variableParent instanceof UnaryExpression) {
            if (PhpPsiUtil.isOfType(variableParent, PhpElementTypes.INFIX_WRITE_EXPRESSION, PhpElementTypes.POSTFIX_EXPRESSION)) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(87);
                }
                return access;
            }
        } else {
            if (variableParent instanceof ParameterList && (anchor instanceof Variable || anchor instanceof ArrayAccessExpression)) {
                PhpAccessInstruction.Access access = PhpControlFlowBuilder.getArgumentAccess((FunctionReference)ObjectUtils.tryCast((Object)variableParent.getParent(), FunctionReference.class), PhpCodeInsightUtil.getParameterIndex((PsiElement)anchor), (PsiElement)anchor);
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(88);
                }
                return access;
            }
            if (variableParent instanceof PhpUnset) {
                PhpAccessInstruction.Access access = anchor instanceof Variable ? PhpAccessInstruction.Access.UNSET_ACCESS : PhpAccessInstruction.Access.READ_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(89);
                }
                return access;
            }
            if (variableParent instanceof PhpEmpty || variableParent instanceof PhpIsset) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.LIGHT_READ_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(90);
                }
                return access;
            }
            if (variableParent instanceof Global) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_REF_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(91);
                }
                return access;
            }
            if (variableParent instanceof Catch) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(92);
                }
                return access;
            }
            if (variableParent instanceof PhpUseList) {
                if (PhpWorkaroundUtil.isReadReference((PsiElement)anchor)) {
                    PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_REF_ACCESS;
                    if (access == null) {
                        PhpCodeInsightUtil.$$$reportNull$$$0(93);
                    }
                    return access;
                }
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(94);
                }
                return access;
            }
            if (PhpPsiUtil.isOfType(variableParent, PhpElementTypes.STATIC_STATEMENT)) {
                PhpAccessInstruction.Access access = PhpAccessInstruction.Access.WRITE_ACCESS;
                if (access == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(95);
                }
                return access;
            }
        }
        PhpAccessInstruction.Access access = PhpAccessInstruction.Access.READ_ACCESS;
        if (access == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(96);
        }
        return access;
    }

    public static boolean isSameElementFieldReference(@Nullable PsiElement anchor, @NotNull CharSequence variableName, @NotNull CharSequence fieldName) {
        PhpExpression classReference;
        if (variableName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(97);
        }
        if (fieldName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(98);
        }
        return anchor instanceof FieldReference && (classReference = ((FieldReference)anchor).getClassReference()) instanceof Variable && PhpLangUtil.equalsVariableNames(variableName, ((Variable)classReference).getNameCS()) && PhpLangUtil.equalsFieldNames(fieldName, ((FieldReference)anchor).getNameCS());
    }

    public static Collection<PsiReference> collectReferencesToAlias(@NotNull PhpUse phpUse) {
        if (phpUse == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(99);
        }
        if (phpUse.isTraitImport()) {
            return Collections.emptyList();
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)phpUse);
        if (scopeForUseOperator == null) {
            return Collections.emptyList();
        }
        if (phpUse.getAliasName() != null) {
            return PhpCodeInsightUtil.searchReferencesToAlias(scopeForUseOperator, (PhpNamedElement)phpUse, phpUse.getName(), false, !PhpUseImpl.isOfConst(phpUse));
        }
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        for (PhpNamedElement phpNamedElement : PhpCodeInsightUtil.resolveTargetReferenceAvoidingDuplicates(phpUse)) {
            references.addAll(PhpCodeInsightUtil.searchReferencesToAlias(scopeForUseOperator, phpNamedElement, phpUse.getName(), false, !(phpNamedElement instanceof Constant)));
        }
        return references;
    }

    public static boolean isUnused(@NotNull PhpUse phpUse) {
        if (phpUse == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(100);
        }
        if (phpUse.isTraitImport()) {
            return false;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)phpUse);
        if (scopeForUseOperator == null) {
            return false;
        }
        if (phpUse.getAliasName() != null) {
            return PhpCodeInsightUtil.searchReferencesToAlias(scopeForUseOperator, (PhpNamedElement)phpUse, phpUse.getName(), true, !PhpUseImpl.isOfConst(phpUse)).isEmpty();
        }
        Collection<? extends PhpNamedElement> elements = PhpCodeInsightUtil.resolveTargetReferenceAvoidingDuplicates(phpUse);
        if (elements.isEmpty()) {
            return false;
        }
        for (PhpNamedElement phpNamedElement : elements) {
            if (PhpCodeInsightUtil.searchReferencesToAlias(scopeForUseOperator, phpNamedElement, phpUse.getName(), true, !(phpNamedElement instanceof Constant)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnnecessary(@NotNull PhpUse phpUse) {
        if (phpUse == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(101);
        }
        if (phpUse.isTraitImport()) {
            return false;
        }
        if (phpUse.getAliasName() != null) {
            return false;
        }
        for (PhpNamedElement phpNamedElement : PhpCodeInsightUtil.resolveTargetReferenceAvoidingDuplicates(phpUse)) {
            if (phpNamedElement instanceof PhpNamespace || !PhpLangUtil.equalsClassNames(phpNamedElement.getNamespaceName(), phpUse.getNamespaceName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<? extends PhpNamedElement> resolveTargetReferenceAvoidingDuplicates(@NotNull PhpUse phpUse) {
        PhpReference targetReference;
        if (phpUse == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(102);
        }
        if ((targetReference = phpUse.getTargetReference()) != null) {
            Collection<PhpNamedElement> collection = targetReference.resolveGlobal(false).stream().collect(Collectors.toMap(Object::getClass, e -> e, (e1, e2) -> e1)).values();
            if (collection == null) {
                PhpCodeInsightUtil.$$$reportNull$$$0(103);
            }
            return collection;
        }
        List list = Collections.emptyList();
        if (list == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(104);
        }
        return list;
    }

    @NotNull
    private static Collection<PsiReference> searchReferencesToAlias(@NotNull PhpPsiElement scopeForUseOperator, @NotNull PhpNamedElement aliasedNamedElement, final @NotNull String aliasedName, final boolean findFirstOnly, final boolean ignoreCase) {
        if (scopeForUseOperator == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(105);
        }
        if (aliasedNamedElement == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(106);
        }
        if (aliasedName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(107);
        }
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)scopeForUseOperator);
        CommonProcessors.CollectProcessor<PsiReference> collector = new CommonProcessors.CollectProcessor<PsiReference>(){

            public boolean process(PsiReference reference) {
                return super.process((Object)reference) && (!findFirstOnly || this.getResults().isEmpty());
            }

            protected boolean accept(PsiReference reference) {
                return PhpCodeInsightUtil.isReferenceToAlias(reference, aliasedName, ignoreCase);
            }
        };
        ReferencesSearch.search((ReferencesSearch.SearchParameters)new PhpAliasSearchParameters((PsiElement)aliasedNamedElement, (SearchScope)searchScope)).forEach((Processor)collector);
        Collection collection = collector.getResults();
        if (collection == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(108);
        }
        return collection;
    }

    private static boolean isReferenceToAlias(@NotNull PsiReference reference, @NotNull String aliasedName, boolean ignoreCase) {
        PsiElement psiElement;
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(109);
        }
        if (aliasedName == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(110);
        }
        if (!PhpCodeInsightUtil.canBeReferenceToUse(psiElement = reference.getElement())) {
            return false;
        }
        String referenceText = StringUtil.trimStart((String)psiElement.getText(), (String)"@");
        return ignoreCase ? StringUtil.startsWithIgnoreCase((String)referenceText, (String)aliasedName) : StringUtil.startsWith((CharSequence)referenceText, (CharSequence)aliasedName);
    }

    public static boolean canBeReferenceToUse(PsiElement psiElement) {
        return PhpPsiUtil.getParentByCondition(psiElement, true, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF) == null || PhpPsiUtil.getParentByCondition(psiElement, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF) != null;
    }

    @Nullable
    public static String getImmediateFQN(@NotNull PhpReference phpReference) {
        if (phpReference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(111);
        }
        return StringUtil.nullize((String)(phpReference.getImmediateNamespaceName() + phpReference.getName()));
    }

    @NotNull
    public static Map<String, String> getAliasesInScope(@NotNull PhpPsiElement scopeHolder) {
        if (scopeHolder == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(112);
        }
        return PhpCodeInsightUtil.getAliasesInScope(scopeHolder, PhpGroupUseElement.PhpUseKeyword.values());
    }

    @NotNull
    public static Map<String, String> getAliasesInScope(@NotNull PhpPsiElement scopeHolder, PhpGroupUseElement.PhpUseKeyword ... keywords) {
        if (scopeHolder == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(113);
        }
        THashMap aliases = new THashMap();
        List<PhpUseList> lists = PhpCodeInsightUtil.collectImports(scopeHolder);
        for (PhpUseList list : lists) {
            PhpUse[] declarations;
            for (PhpUse declaration : declarations = list.getDeclarations()) {
                String keyword = PhpGroupUseElement.getKeyword(declaration, list);
                if (!Arrays.stream(keywords).anyMatch(s -> StringUtil.equals((CharSequence)s.getValue(), (CharSequence)keyword))) continue;
                String original2 = declaration.getFQN();
                String name = declaration.getName();
                aliases.put(name, original2);
            }
        }
        scopeHolder.acceptChildren((PsiElementVisitor)new PhpElementVisitor((Map)aliases){
            final /* synthetic */ Map val$aliases;
            {
                this.val$aliases = map;
            }

            public void visitPhpClass(PhpClass clazz) {
                this.val$aliases.put(clazz.getName(), clazz.getFQN());
            }

            public void visitPhpGroupStatement(GroupStatement groupStatement) {
                groupStatement.acceptChildren((PsiElementVisitor)this);
            }
        });
        THashMap tHashMap = aliases;
        if (tHashMap == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(114);
        }
        return tHashMap;
    }

    public static boolean isStrictTypes(@NotNull PhpFile file) {
        PsiElement phpOpeningTag;
        if (file == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(115);
        }
        if ((phpOpeningTag = file.getFirstChild().getFirstChild()) == null) {
            return false;
        }
        PsiElement declare = PhpPsiUtil.getNextSibling(phpOpeningTag, Conditions.not((Condition)Statement.INSTANCEOF));
        if (declare instanceof Declare) {
            PhpExpression expression = PhpCodeInsightUtil.getStrictTypeDirectiveValue((Declare)declare);
            return expression != null && "1".equals(expression.getText());
        }
        return false;
    }

    @Nullable
    public static PhpExpression getStrictTypeDirectiveValue(Declare declare) {
        PsiElement directive = DeclareImpl.getStrictTypesDirective(declare);
        if (directive == null) {
            return null;
        }
        return (PhpExpression)PhpPsiUtil.getChildByCondition(directive, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
    }

    public static boolean isUnpackedArgument(@NotNull PsiElement parameter) {
        if (parameter == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(116);
        }
        return PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(parameter, true), PhpTokenTypes.opVARIADIC);
    }

    public static boolean isStdPureFunction(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(117);
        }
        if (reference instanceof MethodReference) {
            return false;
        }
        return FunctionReferenceImpl.allowGlobal((PhpReference)reference) && STD_PURE_FUNCTIONS.contains(StringUtil.toLowerCase((String)PhpLangUtil.toFQN(reference.getName()))) || STD_PURE_FUNCTIONS.contains(StringUtil.toLowerCase((String)reference.getFQN()));
    }

    public static boolean isPassByRefParameter(@NotNull PsiElement parameter, boolean global) {
        block10: {
            ClassReference reference;
            int p;
            PsiElement parent;
            block9: {
                ResolveResult[] results;
                Object[] sig;
                int c;
                String name;
                PsiElement parameterList;
                if (parameter == null) {
                    PhpCodeInsightUtil.$$$reportNull$$$0(118);
                }
                if (!((parameterList = parameter.getParent()) instanceof ParameterList)) {
                    return false;
                }
                parent = parameterList.getParent();
                if (!(parent instanceof FunctionReference)) break block9;
                int p2 = PhpCodeInsightUtil.getParameterIndex(parameter);
                Stream<Function> localResolvedFunctions = PhpCodeInsightUtil.localResolveFunctions((FunctionReference)parent);
                if (localResolvedFunctions.anyMatch(e -> PhpCodeInsightUtil.isPassByRef(e, parameter))) {
                    return true;
                }
                FunctionReference functionReference = (FunctionReference)parent;
                if (StringUtil.isEmpty((String)functionReference.getName())) {
                    return false;
                }
                String fqn = functionReference.getFQN();
                String string = name = fqn != null ? PhpLangUtil.toShortName(fqn) : null;
                if (StringUtil.isEmpty((String)name)) {
                    return false;
                }
                Object[][] objectArray = STD_LIB_FUN_WITH_REF_ARGS;
                int n = objectArray.length;
                for (int i = 0; i < n && (c = ((String)(sig = objectArray[i])[0]).compareTo(name)) <= 0; ++i) {
                    if (c != 0 || !sig[1].equals(p2)) continue;
                    return true;
                }
                if (p2 < 0 || !global || !PhpCodeInsightUtil.mayHaveRefParams(functionReference, name)) break block10;
                for (ResolveResult result : results = functionReference.multiResolve(false)) {
                    PsiElement function = result.getElement();
                    if (!(function instanceof Function) || !PhpCodeInsightUtil.isPassByRef((Function)function, parameter)) continue;
                    return true;
                }
                break block10;
            }
            if (parent instanceof NewExpression && (p = PhpCodeInsightUtil.getParameterIndex(parameter)) >= 0 && global && (reference = ((NewExpression)parent).getClassReference()) != null) {
                ResolveResult[] results;
                for (ResolveResult result : results = reference.multiResolve(false)) {
                    Method method;
                    PsiElement resolved = result.getElement();
                    Object object = resolved instanceof Method ? (Method)resolved : (method = resolved instanceof PhpClass ? ((PhpClass)resolved).getConstructor() : null);
                    if (method == null || !PhpCodeInsightUtil.isPassByRef((Function)method, parameter)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Stream<Function> localResolveFunctions(@NotNull FunctionReference functionReference) {
        Set<? extends PhpNamedElement> localMethods;
        if (functionReference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(119);
        }
        if (StringUtil.isEmpty((String)functionReference.getName())) {
            PhpPsiElement nameIdentifier = functionReference.getFirstPsiChild();
            if (nameIdentifier instanceof Variable) {
                HashSet localClosures = new HashSet();
                FunctionReferenceImpl.addAssignedClosures((Variable)nameIdentifier, localClosures);
                return StreamEx.of(localClosures).select(Function.class);
            }
        } else if (functionReference instanceof MethodReferenceImpl && PhpLangUtil.isThisReference((PsiElement)((MethodReference)functionReference).getClassReference()) && (localMethods = MemberReferenceImpl.resolveThisReference((MethodReferenceImpl)functionReference)) != null) {
            return StreamEx.of(localMethods).select(Function.class);
        }
        return Stream.empty();
    }

    private static boolean mayHaveRefParams(@NotNull FunctionReference functionReference, String name) {
        List candidates;
        if (functionReference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(120);
        }
        GlobalSearchScope scope = PhpIndex.getInstance((Project)functionReference.getProject()).getSearchScope();
        if (functionReference instanceof MethodReference) {
            if (PhpCodeInsightUtil.classHasTraitUseRules((MethodReference)functionReference)) {
                return true;
            }
            candidates = FileBasedIndex.getInstance().getValues(PhpMethodNameIndex.KEY, (Object)name, scope);
        } else {
            candidates = FileBasedIndex.getInstance().getValues(PhpFunctionNameIndex.KEY, (Object)name, scope);
        }
        return candidates.stream().anyMatch(Boolean::booleanValue);
    }

    private static boolean classHasTraitUseRules(MethodReference reference) {
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            return false;
        }
        PhpIndex index = PhpIndex.getInstance((Project)reference.getProject());
        return classReference.getGlobalType().getTypes().stream().anyMatch(fqn -> index.getClassesByFQN(fqn).stream().anyMatch(PhpClass::hasTraitUses));
    }

    public static boolean isPassByRef(@NotNull Function function, PsiElement argument) {
        ParameterList parameterList;
        if (function == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(121);
        }
        if ((parameterList = (ParameterList)ObjectUtils.tryCast((Object)argument.getParent(), ParameterList.class)) == null) {
            return false;
        }
        Parameter parameter = PhpParamsInspection.getMappedParam(Arrays.asList(parameterList.getParameters()), Arrays.asList(function.getParameters()), PhpCodeInsightUtil.getParameterIndex(argument));
        return parameter != null && parameter.isPassByRef();
    }

    public static int getParameterIndex(@NotNull PsiElement parameter) {
        PsiElement parent;
        if (parameter == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(122);
        }
        if (!((parent = parameter.getParent()) instanceof ParameterList)) {
            return -1;
        }
        return ArrayUtil.indexOf((Object[])((ParameterList)parent).getParameters(), (Object)parameter);
    }

    @NotNull
    public static PhpType getLocalType(@NotNull PhpReference phpReference) {
        if (phpReference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(123);
        }
        return PhpCodeInsightUtil.getLocalType(phpReference, phpReference.resolveLocal());
    }

    @NotNull
    public static PhpType getLocalType(@NotNull PhpReference phpReference, Collection<? extends PhpNamedElement> targets) {
        if (phpReference == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(124);
        }
        PhpType type = new PhpType();
        if (targets.size() == 0) {
            String signature = phpReference.getSignature();
            for (String sig : StringUtil.split((String)signature, (String)"|")) {
                type.add(sig);
            }
        } else {
            for (PhpNamedElement phpNamedElement : targets) {
                type.add((PsiElement)phpNamedElement);
            }
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpCodeInsightUtil.$$$reportNull$$$0(125);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 35: 
            case 37: 
            case 38: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 103: 
            case 104: 
            case 108: 
            case 114: 
            case 125: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 35: 
            case 37: 
            case 38: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 103: 
            case 104: 
            case 108: 
            case 114: 
            case 125: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteralExpression";
                break;
            }
            case 4: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 13: 
            case 75: 
            case 76: 
            case 77: 
            case 109: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 14: 
            case 22: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 34: 
            case 39: 
            case 60: 
            case 63: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 16: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 40: 
            case 61: 
            case 64: 
            case 68: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 35: 
            case 37: 
            case 38: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 103: 
            case 104: 
            case 108: 
            case 114: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/PhpCodeInsightUtil";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedFqn";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNamespaceFQN";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpFile";
                break;
            }
            case 41: 
            case 43: 
            case 46: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 44: 
            case 47: 
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFqn";
                break;
            }
            case 45: 
            case 48: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 49: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 50: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeNamespace";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defFqn";
                break;
            }
            case 62: 
            case 66: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 67: 
            case 69: 
            case 72: 
            case 112: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpUse";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliasedNamedElement";
                break;
            }
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliasedName";
                break;
            }
            case 111: 
            case 123: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpReference";
                break;
            }
            case 116: 
            case 118: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 119: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/PhpCodeInsightUtil";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImports";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNamespaces";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeclarations";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccess";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTargetReferenceAvoidingDuplicates";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "searchReferencesToAlias";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasesInScope";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toInt";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyBody";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResultUsed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIncrementOrDecrementExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSilenceExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isForeachKeyOrValueAssignedByReference";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasMagicMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isScopeForUseOperator";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findScopeForUseOperator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifier";
                break;
            }
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedName";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 35: 
            case 37: 
            case 38: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 103: 
            case 104: 
            case 108: 
            case 114: 
            case 125: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAliasUsed";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isAliassed";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectImports";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectNamespaces";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isSameNamespace";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "hasNameConflicts";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "equalConstantFqns";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "canImport";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "alreadyImported";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "findImportedName";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findDeclarations";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isFullyQualified";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isNotInImport";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isImportSupported";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getAccess";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isSameElementFieldReference";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "collectReferencesToAlias";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "isUnused";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "isUnnecessary";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "resolveTargetReferenceAvoidingDuplicates";
                break;
            }
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "searchReferencesToAlias";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToAlias";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateFQN";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getAliasesInScope";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypes";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isUnpackedArgument";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "isStdPureFunction";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isPassByRefParameter";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "localResolveFunctions";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveRefParams";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "isPassByRef";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getLocalType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 35: 
            case 37: 
            case 38: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 103: 
            case 104: 
            case 108: 
            case 114: 
            case 125: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpAliasSearchParameters
    extends ReferencesSearch.SearchParameters {
        public PhpAliasSearchParameters(@NotNull PsiElement elementToSearch, @NotNull SearchScope scope) {
            if (elementToSearch == null) {
                PhpAliasSearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                PhpAliasSearchParameters.$$$reportNull$$$0(1);
            }
            super(elementToSearch, scope, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elementToSearch";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/codeInsight/PhpCodeInsightUtil$PhpAliasSearchParameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ImportElementType {
        CLASS,
        NAMESPACE,
        FUNCTION,
        CONSTANT;


        @Nullable
        public static ImportElementType fromElement(@NotNull PsiElement element) {
            if (element == null) {
                ImportElementType.$$$reportNull$$$0(0);
            }
            if (element instanceof PhpClass || element instanceof ClassReference) {
                return CLASS;
            }
            if (element instanceof PhpNamespace || element instanceof PhpNamespaceReference) {
                return NAMESPACE;
            }
            if (element instanceof Function || element instanceof FunctionReference) {
                return FUNCTION;
            }
            if (element instanceof Constant || element instanceof ConstantReference) {
                return CONSTANT;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/codeInsight/PhpCodeInsightUtil$ImportElementType", "fromElement"));
        }
    }
}

