/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.builtInWebServer;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.builtInWebServer.PhpCgiService;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "getPhpCgiPath", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "notification", "Lcom/intellij/notification/SingletonNotificationManager;", "intellij.php.jsDebugger"})
public final class PhpCgiServiceKt {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("PHP-CGI Server", NotificationDisplayType.STICKY_BALLOON, true, null, null, 24, null);
    private static final Logger LOG;

    private static final File getPhpCgiPath(Project project, SingletonNotificationManager notification2) {
        File phpCgi;
        PhpProjectConfigurationFacade phpProjectConfigurationFacade = PhpProjectConfigurationFacade.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)phpProjectConfigurationFacade, (String)"PhpProjectConfigurationFacade.getInstance(project)");
        PhpProjectWorkspaceConfiguration.State state = phpProjectConfigurationFacade.getProjectConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"PhpProjectConfigurationF\u2026ect).projectConfiguration");
        String interpreterName = state.getInterpreterName();
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName);
        if (interpreter == null) {
            SingletonNotificationManager singletonNotificationManager = notification2;
            if (singletonNotificationManager != null) {
                String string = PhpBundle.message("php.interpreter.not.configured.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PhpBundle.message(\"php.i\u2026er.not.configured.title\")");
                String string2 = PhpBundle.message("php.interpreter.not.configured", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PhpBundle.message(\"php.i\u2026erpreter.not.configured\")");
                SingletonNotificationManager.notify$default((SingletonNotificationManager)singletonNotificationManager, (String)string, (String)string2, (Project)project, null, null, (int)24, null);
            }
            LOG.warn("cannot find interpreter " + interpreterName);
            return null;
        }
        if (interpreter.isRemote()) {
            SingletonNotificationManager singletonNotificationManager = notification2;
            if (singletonNotificationManager != null) {
                String string = PhpBundle.message("php.interpreter.is.remote.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PhpBundle.message(\"php.i\u2026rpreter.is.remote.title\")");
                String string3 = PhpBundle.message("php.interpreter.is.remote.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PhpBundle.message(\"php.i\u2026reter.is.remote.message\")");
                SingletonNotificationManager.notify$default((SingletonNotificationManager)singletonNotificationManager, (String)string, (String)string3, (Project)project, null, null, (int)24, null);
            }
            LOG.warn("built-in web server does not support remote interpreters: " + interpreterName);
            return null;
        }
        String home = interpreter.getPathToPhpExecutable();
        File file = phpCgi = home == null ? null : new File(PathUtil.getParentPath((String)home), PhpProjectConfigurationFacade.PHP_CGI);
        if (phpCgi == null || !phpCgi.exists()) {
            SingletonNotificationManager singletonNotificationManager = notification2;
            if (singletonNotificationManager != null) {
                String string = PhpBundle.message("php.cgi.not.found.title", PhpProjectConfigurationFacade.PHP_CGI);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PhpBundle.message(\"php.c\u2026figurationFacade.PHP_CGI)");
                String string4 = PhpBundle.message("php.cgi.not.found", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"PhpBundle.message(\"php.cgi.not.found\")");
                SingletonNotificationManager.notify$default((SingletonNotificationManager)singletonNotificationManager, (String)string, (String)string4, (Project)project, null, null, (int)24, null);
            }
            LOG.warn("php-cgi not found " + interpreterName);
            return null;
        }
        return phpCgi;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PhpCgiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ File access$getPhpCgiPath(Project project, SingletonNotificationManager notification2) {
        return PhpCgiServiceKt.getPhpCgiPath(project, notification2);
    }

    public static final /* synthetic */ NotificationGroup access$getNOTIFICATION_GROUP$p() {
        return NOTIFICATION_GROUP;
    }
}

