/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.builtInWebServer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.builtInWebServer.PhpCgiServiceKt;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.config.PhpProjectWorkspaceConfigurationListener;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import icons.PhpIcons;
import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.io.fastCgi.FastCgiService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/php/builtInWebServer/PhpCgiService;", "Lorg/jetbrains/io/fastCgi/FastCgiService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configurationChangedListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentPhpCgiPath", "", "notification", "Lcom/intellij/notification/SingletonNotificationManager;", "addConfigurationChangedListener", "", "configureConsole", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "createProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "port", "", "getConsoleToolWindowIcon", "Ljavax/swing/Icon;", "getConsoleToolWindowId", "Companion", "intellij.php.jsDebugger"})
public final class PhpCgiService
extends FastCgiService {
    private volatile String currentPhpCgiPath;
    private final AtomicBoolean configurationChangedListenerAdded;
    private final SingletonNotificationManager notification;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void addConfigurationChangedListener() {
        if (!this.configurationChangedListenerAdded.compareAndSet(false, true)) {
            return;
        }
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(PhpProjectWorkspaceConfiguration.TOPIC, (Object)new PhpProjectWorkspaceConfigurationListener(this){
            final /* synthetic */ PhpCgiService this$0;

            public final void interpreterChanged() {
                String string = PhpCgiService.access$getCurrentPhpCgiPath$p(this.this$0);
                if (string == null) {
                    return;
                }
                String phpCgiPath = string;
                File file = PhpCgiServiceKt.access$getPhpCgiPath(PhpCgiService.access$getProject$p(this.this$0), null);
                if (file == null || Intrinsics.areEqual((Object)file.getPath(), (Object)phpCgiPath) ^ true) {
                    PhpCgiService.access$setCurrentPhpCgiPath$p(this.this$0, null);
                    PhpCgiService.access$getProcessHandler$p(this.this$0).reset();
                }
            }
            {
                this.this$0 = phpCgiService;
            }
        });
    }

    @Nullable
    protected OSProcessHandler createProcessHandler(@NotNull Project project, int port) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = PhpCgiServiceKt.access$getPhpCgiPath(project, this.notification);
        if (file == null) {
            return null;
        }
        File phpCgi = file;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        String string = this.currentPhpCgiPath = phpCgi.getPath();
        Intrinsics.checkNotNull((Object)string);
        commandLine.setExePath(string);
        commandLine.addParameter("-e");
        commandLine.addParameter("-b");
        StringBuilder stringBuilder = new StringBuilder();
        InetAddress inetAddress = InetAddress.getLoopbackAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getLoopbackAddress()");
        commandLine.addParameter(stringBuilder.append(inetAddress.getHostAddress()).append(':').append(port).toString());
        VirtualFile file2 = ProjectUtil.guessProjectDir((Project)project);
        if (file2 != null) {
            commandLine.setWorkDirectory(PathUtil.toSystemDependentName((String)file2.getPath()));
        }
        OSProcessHandler handler = new OSProcessHandler(commandLine);
        this.addConfigurationChangedListener();
        return handler;
    }

    protected void configureConsole(@NotNull TextConsoleBuilder consoleBuilder) {
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
        Filter[] filterArray = PhpExecutionUtil.getConsoleMessageFilters(this.getProject(), PhpPathMapper.create(this.getProject()));
        consoleBuilder.filters(Arrays.copyOf(filterArray, filterArray.length));
    }

    @NotNull
    protected String getConsoleToolWindowId() {
        return "PHP-CGI Server";
    }

    @NotNull
    protected Icon getConsoleToolWindowIcon() {
        Icon icon = PhpIcons.PhpIcon;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PhpIcons.PhpIcon");
        return icon;
    }

    public PhpCgiService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.configurationChangedListenerAdded = new AtomicBoolean();
        this.notification = new SingletonNotificationManager(PhpCgiServiceKt.access$getNOTIFICATION_GROUP$p(), NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(project){
            final /* synthetic */ Project $project;

            protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PhpUiUtil.editConfigurable(this.$project, (Configurable)new PhpProjectConfigurable(this.$project));
                notification2.expire();
            }
            {
                this.$project = $captured_local_variable$0;
            }
        });
    }

    public static final /* synthetic */ String access$getCurrentPhpCgiPath$p(PhpCgiService $this) {
        return $this.currentPhpCgiPath;
    }

    public static final /* synthetic */ void access$setCurrentPhpCgiPath$p(PhpCgiService $this, String string) {
        $this.currentPhpCgiPath = string;
    }

    public static final /* synthetic */ Project access$getProject$p(PhpCgiService $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ AsyncValueLoader access$getProcessHandler$p(PhpCgiService $this) {
        return $this.getProcessHandler();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/php/builtInWebServer/PhpCgiService$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/php/builtInWebServer/PhpCgiService;", "project", "Lcom/intellij/openapi/project/Project;", "getInstance$intellij_php_jsDebugger", "intellij.php.jsDebugger"})
    public static final class Companion {
        @NotNull
        public final PhpCgiService getInstance$intellij_php_jsDebugger(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(PhpCgiService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (PhpCgiService)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

