/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.statistics;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.actions.PhpNewClassDialog;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.codeGeneration.PhpNewTestDialog;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNewClassUsageLogger {
    private static final String GROUP = "php.new.action";

    public static void logNewTest(@NotNull Project project, @NotNull AnAction action, @NotNull PhpNewTestDialog dataProvider, @Nullable PhpNamedElement targetElement) {
        String actionId;
        if (project == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(0);
        }
        if (action == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(1);
        }
        if (dataProvider == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(2);
        }
        PhpTestCreateInfo info = dataProvider.getSelectedTestCreateInfo();
        FeatureUsageData data = new FeatureUsageData().addData("target", PhpNewClassUsageLogger.getTargetElementStatus(targetElement)).addData("source", PhpNewClassUsageLogger.getSourceElementStatus(targetElement)).addData("method_count", dataProvider.getSelectedClassMembers().size()).addData("framework", PluginInfoDetectorKt.getPluginInfo(info.getClass()).isDevelopedByJetBrains() ? info.getName() : "third.party");
        PluginInfo actionInfo = PluginInfoDetectorKt.getPluginInfo(action.getClass());
        String string = actionId = actionInfo.isSafeToReport() ? ActionManager.getInstance().getId(action) : "third.party";
        if (actionId == null) {
            actionId = action.getClass().getName();
        }
        data.addData("action_id", actionId);
        PhpClass targetClass = dataProvider.getSelectedTargetClass(project);
        boolean isInheritMemberSelected = targetClass != null && dataProvider.isInheritedMembersOptionSelected() && dataProvider.getSelectedClassMembers().stream().anyMatch(m -> PhpNewClassUsageLogger.getContainingClass((PhpNamedElement)m) != targetClass);
        data.addData("with_inherit_member", isInheritMemberSelected);
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP, "add.new.test", data);
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP, "add.new.test.fields.usage", PhpNewClassUsageLogger.getFieldsUsageData(dataProvider));
    }

    @NotNull
    private static FeatureUsageData getFieldsUsageData(@NotNull PhpNewTestDialog dataProvider) {
        if (dataProvider == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(3);
        }
        FeatureUsageData featureUsageData = new FeatureUsageData().addData("library_was_changed", dataProvider.isLibraryChanged()).addData("directory_was_changed", dataProvider.myDirectoryTextChangedUnderFocus).addData("namespace_was_changed", dataProvider.myNamespaceTextChangedUnderFocus).addData("show_inherited_members_was_changed", dataProvider.myShowInheritedMembersChangedUnderFocus).addData("test_target_text_was_changed", dataProvider.myTestTargetTextChangedUnderFocus).addData("methods_table_was_changed", dataProvider.myMethodsTableWasChangedUnderFocus);
        if (featureUsageData == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(4);
        }
        return featureUsageData;
    }

    @NotNull
    private static String getSourceElementStatus(@Nullable PhpNamedElement element) {
        PhpClass containingClass = PhpNewClassUsageLogger.getContainingClass(element);
        if (containingClass == null) {
            return "empty";
        }
        if (containingClass.isInterface()) {
            return "interface";
        }
        if (containingClass.isTrait()) {
            return "trait";
        }
        return "class";
    }

    @Nullable
    private static PhpClass getContainingClass(@Nullable PhpNamedElement element) {
        return element != null ? (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)element, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) : null;
    }

    @NotNull
    private static String getTargetElementStatus(@Nullable PhpNamedElement element) {
        if (element instanceof PhpClass) {
            return "class";
        }
        if (element instanceof Method) {
            return "method";
        }
        return "none";
    }

    public static void logNewClass(@NotNull Project project, @NotNull PhpNewClassDialog dataProvider) {
        if (project == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(5);
        }
        if (dataProvider == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(6);
        }
        ClassCreationType type = dataProvider.getSelectedClassCreationType();
        FeatureUsageData data = new FeatureUsageData().addData("type", ClassCreationType.BUNDLED.contains((Object)type) ? type.getTemplateName() : "custom").addData("with_custom_vars", dataProvider.hasCustomProperties()).addData("extension", dataProvider.getExtension());
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP, "add.new.class", data);
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP, "add.new.class.fields.usage", PhpNewClassUsageLogger.getFieldsUsageData(dataProvider));
    }

    @NotNull
    private static FeatureUsageData getFieldsUsageData(@NotNull PhpNewClassDialog dataProvider) {
        if (dataProvider == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(7);
        }
        FeatureUsageData featureUsageData = new FeatureUsageData().addData("file_name_was_changed", dataProvider.myFileNameTextChangedUnderFocus).addData("namespace_was_changed", dataProvider.myNamespaceTextChangedUnderFocus).addData("directory_was_changed", dataProvider.myDirectoryTextChangedUnderFocus).addData("template_was_changed", dataProvider.myTemplateTypeChangedUnderFocus).addData("extension_was_changed", dataProvider.myExtensionTypeChangedUnderFocus).addData("super_fqn_was_changed", dataProvider.mySuperFqnTextChangedUnderFocus).addData("implements_table_was_changed", dataProvider.myInterfaceFqnsToImplementTableChangedUnderFocus);
        if (featureUsageData == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(8);
        }
        return featureUsageData;
    }

    public static void logNewFile(@NotNull Project project, @NotNull String extension) {
        if (project == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(9);
        }
        if (extension == null) {
            PhpNewClassUsageLogger.$$$reportNull$$$0(10);
        }
        FeatureUsageData data = new FeatureUsageData().addData("extension", extension);
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP, "add.new.file", data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/statistics/PhpNewClassUsageLogger";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/statistics/PhpNewClassUsageLogger";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logNewTest";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsUsageData";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "logNewClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logNewFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

