/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.copyPaste.importReferences;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.actions.copyPaste.importReferences.PhpImportReferencesDialog;
import com.jetbrains.php.actions.copyPaste.importReferences.PhpReferenceInfo;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.completion.autoImport.PhpAutoImportConfiguration;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.intentions.PhpReplaceWithAliasIntention;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReferencesToImportCopyPasteProcessor
extends CopyPastePostProcessor<PhpReferencesTransferableData> {
    private static final DataFlavor PHP_REFERENCES_FLAVOR = new DataFlavor(PhpReferencesToImportCopyPasteProcessor.class, "php references");
    private static final Logger LOG = Logger.getInstance(PhpReferencesToImportCopyPasteProcessor.class);

    @NotNull
    public List<PhpReferencesTransferableData> collectTransferableData(PsiFile file, Editor editor, int[] startOffsets, int[] endOffsets) {
        if (DumbService.isDumb((Project)file.getProject()) || !(file instanceof PhpFile)) {
            List<PhpReferencesTransferableData> list = Collections.emptyList();
            if (list == null) {
                PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return list;
        }
        SmartList references = new SmartList();
        for (int i = 0; i < startOffsets.length; ++i) {
            for (PsiElement element : CollectHighlightsUtil.getElementsInRange((PsiElement)file, (int)startOffsets[i], (int)endOffsets[i])) {
                PhpNamedElement target;
                if (!(element instanceof PhpReference) || !PhpReferencesToImportCopyPasteProcessor.canBeTransferred((PhpReference)element) || (target = PhpReferencesToImportCopyPasteProcessor.resolveElementToSuitableTarget((PhpReference)element)) == null || !PhpReferenceInsertHandler.shouldInsertImport(element, target, target.getFQN())) continue;
                PhpUse useWithAlias = PhpTargetElementEvaluator.getElementByReference((PsiReference)((PhpReference)element));
                String aliasName = useWithAlias != null ? useWithAlias.getAliasName() : null;
                references.add(new PhpReferenceInfo(target.getFQN(), PhpBaseImportQuickFix.getKeyword((PhpReference)element), aliasName, element.getTextOffset() - startOffsets[i]));
            }
        }
        List<PhpReferencesTransferableData> list = Collections.singletonList(new PhpReferencesTransferableData((Collection<PhpReferenceInfo>)references));
        if (list == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    private static PhpNamedElement resolveElementToSuitableTarget(@NotNull PhpReference element) {
        if (element == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(2);
        }
        if (element instanceof FunctionReference && !(element instanceof MethodReference) || element instanceof ConstantReference || element instanceof ClassReference || element instanceof PhpDocType) {
            PhpNamedElement resolvedElement = (PhpNamedElement)ObjectUtils.tryCast((Object)element.resolve(), PhpNamedElement.class);
            if (resolvedElement instanceof Method) {
                if (((Method)resolvedElement).getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
                    return ((Method)resolvedElement).getContainingClass();
                }
                return null;
            }
            if (resolvedElement instanceof Function || resolvedElement instanceof Constant || resolvedElement instanceof PhpClass) {
                return resolvedElement;
            }
        }
        return null;
    }

    private static boolean canBeTransferred(PhpReference element) {
        return !element.isAbsolute() && !element.getImmediateNamespaceName().contains("\\") && PhpCodeInsightUtil.isNotInImport(element) && (!(element instanceof ClassReference) || !PhpLangUtil.isClassNameSpecial(element.getName())) && element.multiResolve(false).length > 0;
    }

    @NotNull
    public List<PhpReferencesTransferableData> extractTransferableData(Transferable content) {
        block9: {
            List list;
            Object data;
            block8: {
                if (!content.isDataFlavorSupported(PHP_REFERENCES_FLAVOR)) {
                    List list2 = ContainerUtil.emptyList();
                    if (list2 == null) {
                        PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(3);
                    }
                    return list2;
                }
                data = content.getTransferData(PHP_REFERENCES_FLAVOR);
                if (!(data instanceof PhpReferencesTransferableData)) break block8;
                List<PhpReferencesTransferableData> list3 = Collections.singletonList((PhpReferencesTransferableData)data);
                if (list3 == null) {
                    PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(4);
                }
                return list3;
            }
            try {
                if (!(data instanceof List)) break block9;
                list = (List)data;
            }
            catch (Exception e) {
                LOG.warn("Can't extract references before pasting: " + e.getMessage());
            }
            if (list == null) {
                PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(5);
            }
            return list;
        }
        List list = super.extractTransferableData(content);
        if (list == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void processTransferableData(Project project, Editor editor, RangeMarker bounds, int caretOffset, Ref<? super Boolean> indented, List<? extends PhpReferencesTransferableData> values) {
        PhpAutoImportConfiguration.ImportOnPaste importOnPaste = PhpAutoImportConfiguration.getInstance().getState().getImportOnPaste();
        if (importOnPaste == PhpAutoImportConfiguration.ImportOnPaste.NONE) {
            return;
        }
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()), PhpFile.class);
        if (file == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = bounds.getStartOffset();
        HashMap<String, String> aliasesFromTargetScopeReplacements = new HashMap<String, String>();
        Collection<PhpReferenceInfo> references = PhpReferencesToImportCopyPasteProcessor.getReferencesAndCollectAliasReplacements(values, aliasesFromTargetScopeReplacements, file, importOnPaste, offset);
        WriteAction.run(() -> {
            Collection<Pair<PhpReference, String>> referencesToBeReplacedWithFqns = PhpReferencesToImportCopyPasteProcessor.getReferencesToBeReplacedWithFqns(file, aliasesFromTargetScopeReplacements, offset, references);
            for (PhpReferenceInfo phpReferenceInfo : references) {
                PhpPsiElement scope;
                if (aliasesFromTargetScopeReplacements.containsKey(phpReferenceInfo.getFqn()) || (scope = PhpReferencesToImportCopyPasteProcessor.getScope(file, phpReferenceInfo, bounds.getStartOffset())) == null || !PhpReferencesToImportCopyPasteProcessor.shouldImport(phpReferenceInfo, scope) || !PhpReferencesToImportCopyPasteProcessor.canImport(phpReferenceInfo, scope)) continue;
                PhpAliasImporter.insertUseStatementWithKeyword(phpReferenceInfo.getKeyword().getValue(), phpReferenceInfo.getFqn(), phpReferenceInfo.getAliasName(), scope);
            }
            for (Pair pair : referencesToBeReplacedWithFqns) {
                if (!((PhpReference)pair.getFirst()).isValid()) continue;
                PhpReplaceWithAliasIntention.replaceReference(project, (PsiReference)pair.getFirst(), (String)pair.getSecond());
            }
        });
    }

    @NotNull
    private static Collection<Pair<PhpReference, String>> getReferencesToBeReplacedWithFqns(PhpFile file, Map<String, String> aliasReplacements, int offset, Collection<? extends PhpReferenceInfo> references) {
        SmartList referencesToBeReplacesWithFqns = new SmartList();
        for (PhpReferenceInfo phpReferenceInfo : references) {
            PhpPsiElement scope = PhpReferencesToImportCopyPasteProcessor.getScope(file, phpReferenceInfo, offset);
            PhpReference r = (PhpReference)PhpPsiUtil.getParentByCondition(file.findElementAt(phpReferenceInfo.getOffset() + offset), false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF);
            if (r == null) continue;
            if (aliasReplacements.containsKey(phpReferenceInfo.getFqn())) {
                referencesToBeReplacesWithFqns.add(Pair.create((Object)r, (Object)aliasReplacements.get(phpReferenceInfo.getFqn())));
                continue;
            }
            if (scope == null || !PhpReferencesToImportCopyPasteProcessor.shouldImport(phpReferenceInfo, scope) || PhpReferencesToImportCopyPasteProcessor.canImport(phpReferenceInfo, scope)) continue;
            referencesToBeReplacesWithFqns.add(Pair.create((Object)r, (Object)phpReferenceInfo.getFqn()));
        }
        SmartList smartList = referencesToBeReplacesWithFqns;
        if (smartList == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    @NotNull
    private static Collection<PhpReferenceInfo> getReferencesAndCollectAliasReplacements(@NotNull List<? extends PhpReferencesTransferableData> values, Map<String, String> aliasesFromTargetScopeReplacements, @NotNull PhpFile file, @NotNull PhpAutoImportConfiguration.ImportOnPaste paste, int caretOffset) {
        if (values == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(9);
        }
        if (paste == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        Collection result = values.stream().flatMap(value -> value.getReferences().stream()).filter(reference -> PhpReferencesToImportCopyPasteProcessor.shouldImport(file, reference, caretOffset)).distinct().collect(Collectors.toList());
        Map<PhpReferenceInfo, Collection<String>> possibleAliases = PhpReferencesToImportCopyPasteProcessor.collectPossibleAliases(result, file, caretOffset);
        if (result.isEmpty() || paste == PhpAutoImportConfiguration.ImportOnPaste.ALL) {
            Collection collection = result;
            if (collection == null) {
                PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(11);
            }
            return collection;
        }
        PhpImportReferencesDialog dialog = new PhpImportReferencesDialog(file.getProject(), result, possibleAliases, aliasesFromTargetScopeReplacements);
        Collection<Object> collection = dialog.showAndGet() ? dialog.getSelectedElements() : Collections.emptyList();
        if (collection == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private static Map<PhpReferenceInfo, Collection<String>> collectPossibleAliases(Collection<? extends PhpReferenceInfo> result, PhpFile file, int caretOffset) {
        HashMap<PhpReferenceInfo, Collection<String>> map = new HashMap<PhpReferenceInfo, Collection<String>>();
        for (PhpReferenceInfo phpReferenceInfo : result) {
            String alreadyImportedName;
            PhpPsiElement scope = PhpReferencesToImportCopyPasteProcessor.getScope(file, phpReferenceInfo, caretOffset);
            if (scope == null || (alreadyImportedName = PhpCodeInsightUtil.findImportedName(scope, phpReferenceInfo.getFqn(), phpReferenceInfo.getKeyword())) == null || StringUtil.equalsIgnoreCase((CharSequence)phpReferenceInfo.getAliasName(), (CharSequence)alreadyImportedName)) continue;
            map.put(phpReferenceInfo, Collections.singletonList(alreadyImportedName));
        }
        return map;
    }

    private static boolean shouldImport(PhpFile file, PhpReferenceInfo reference, int caretOffset) {
        return PhpReferencesToImportCopyPasteProcessor.shouldImport(reference, PhpReferencesToImportCopyPasteProcessor.getScope(file, reference, caretOffset));
    }

    private static boolean shouldImport(@NotNull PhpReferenceInfo reference, @Nullable PhpPsiElement scope) {
        if (reference == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            return false;
        }
        String aliasName = reference.getAliasName();
        if (aliasName != null) {
            return !StringUtil.equalsIgnoreCase((CharSequence)PhpCodeInsightUtil.findImportedName(scope, reference.getFqn(), reference.getKeyword()), (CharSequence)aliasName);
        }
        String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scope, reference.getFqn());
        return !StringUtil.equalsIgnoreCase((CharSequence)qualifiedName, (CharSequence)PhpLangUtil.toShortName(reference.getFqn()));
    }

    private static boolean canImport(@NotNull PhpReferenceInfo reference, @NotNull PhpPsiElement scope) {
        String aliasName;
        if (reference == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            PhpReferencesToImportCopyPasteProcessor.$$$reportNull$$$0(15);
        }
        if ((aliasName = reference.getAliasName()) != null) {
            return PhpCodeInsightUtil.canImport(scope, reference.getFqn(), aliasName, reference.getKeyword());
        }
        return PhpCodeInsightUtil.canImport(scope, reference.getFqn(), reference.getKeyword());
    }

    @Nullable
    private static PhpPsiElement getScope(PhpFile file, PhpReferenceInfo reference, int caretOffset) {
        PsiElement at = file.findElementAt(reference.getOffset() + caretOffset);
        return at != null ? PhpCodeInsightUtil.findScopeForUseOperator(at) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/copyPaste/importReferences/PhpReferencesToImportCopyPasteProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paste";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/copyPaste/importReferences/PhpReferencesToImportCopyPasteProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesToBeReplacedWithFqns";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesAndCollectAliasReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementToSuitableTarget";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesAndCollectAliasReplacements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "shouldImport";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpReferencesTransferableData
    implements TextBlockTransferableData {
        @NotNull
        private final Collection<PhpReferenceInfo> myReferences;

        public PhpReferencesTransferableData(@NotNull Collection<PhpReferenceInfo> references) {
            if (references == null) {
                PhpReferencesTransferableData.$$$reportNull$$$0(0);
            }
            this.myReferences = references;
        }

        @NotNull
        public Collection<PhpReferenceInfo> getReferences() {
            Collection<PhpReferenceInfo> collection = this.myReferences;
            if (collection == null) {
                PhpReferencesTransferableData.$$$reportNull$$$0(1);
            }
            return collection;
        }

        public DataFlavor getFlavor() {
            return PHP_REFERENCES_FLAVOR;
        }

        public int getOffsetCount() {
            return 0;
        }

        public int getOffsets(int[] offsets, int index) {
            return index;
        }

        public int setOffsets(int[] offsets, int index) {
            return index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "references";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/actions/copyPaste/importReferences/PhpReferencesToImportCopyPasteProcessor$PhpReferencesTransferableData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/actions/copyPaste/importReferences/PhpReferencesToImportCopyPasteProcessor$PhpReferencesTransferableData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

