/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.copyPaste;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.lang.intentions.PhpReplaceQuotesIntention;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.util.PhpStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!this.isSupportedFile(file) || !PhpSmartKeysConfiguration.getInstance().isEscapeSymbolsInStringLiterals()) {
            return null;
        }
        int isSingleString = 0;
        boolean isStringOfSameType = true;
        for (int numOfFragment = 0; numOfFragment < startOffsets.length; ++numOfFragment) {
            int startOffset = startOffsets[numOfFragment];
            PsiElement elementAtCaret = file.findElementAt(startOffset);
            if (elementAtCaret == null || !PhpReplaceQuotesIntention.isStringLiteral(elementAtCaret) || startOffset < elementAtCaret.getTextRange().getStartOffset() || endOffsets[numOfFragment] > elementAtCaret.getTextRange().getEndOffset()) {
                isStringOfSameType = false;
                break;
            }
            boolean isSingleQuote = true;
            if (!(PhpPsiUtil.isOfType(elementAtCaret, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE) || PhpPsiUtil.isOfType(elementAtCaret, PhpTokenTypes.chRSINGLE_QUOTE) || PhpPsiUtil.isOfType(elementAtCaret, PhpTokenTypes.chLSINGLE_QUOTE))) {
                isSingleQuote = false;
            }
            if (isSingleString == 0) {
                int n = isSingleString = isSingleQuote ? 1 : 2;
            }
            if (isSingleQuote && isSingleString == 1 || !isSingleQuote && isSingleString == 2) continue;
            isStringOfSameType = false;
            break;
        }
        if (isStringOfSameType) {
            return PhpStringUtil.unescapeText(text, isSingleString == 1, "\\n", "\\t", "\\r", "\\\\");
        }
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        SelectionModel selectionModel;
        int caretOffset;
        PsiElement element;
        StringLiteralExpression parent;
        if (!PhpSmartKeysConfiguration.getInstance().isEscapeSymbolsInStringLiterals()) {
            String string = text;
            if (string == null) {
                PhpStringLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (this.isSupportedFile(file) && (parent = (StringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)(element = file.findElementAt(caretOffset = (selectionModel = editor.getSelectionModel()).getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : editor.getCaretModel().getOffset())), StringLiteralExpression.class)) != null && parent.getTextOffset() < element.getTextOffset()) {
            if (!parent.isHeredoc()) {
                boolean isParentSingleQuote = parent.isSingleQuote();
                char quote = isParentSingleQuote ? (char)'\'' : '\"';
                BinaryExpression concatExpr = PhpPsiElementFactory.createFirstFromText(project, BinaryExpression.class, quote + text + quote);
                if (concatExpr != null && PhpPsiUtil.isOfType((PsiElement)concatExpr, PhpElementTypes.CONCATENATION_EXPRESSION) && concatExpr.getTextLength() == text.length() + 2) {
                    String string = text;
                    if (string == null) {
                        PhpStringLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                if (!isParentSingleQuote) {
                    int offsetInString = caretOffset - parent.getTextOffset();
                    if (parent.getText().charAt(offsetInString - 1) != '{' || !text.startsWith("$")) {
                        text = PhpStringUtil.escapeText(text, false, Character.valueOf('\\'), Character.valueOf('$'), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r'));
                    }
                } else {
                    text = PhpStringUtil.escapeText(text, true, Character.valueOf('\\'), Character.valueOf('$'), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r'));
                }
            } else {
                boolean isNowDoc = PhpHeredocToStringIntention.isNowdoc((PsiElement)parent);
                text = PhpStringUtil.escapeText(text, isNowDoc, Character.valueOf(isNowDoc ? (char)'\'' : '\"'), Character.valueOf('\\'), Character.valueOf('$'), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r'));
            }
        }
        String string = text;
        if (string == null) {
            PhpStringLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean isSupportedFile(PsiFile file) {
        return file instanceof PhpFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/actions/copyPaste/PhpStringLiteralCopyPasteProcessor", "preprocessOnPaste"));
    }
}

