/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.copyPaste;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.lang.intentions.PhpReplaceQuotesIntention;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReplaceUnnecessaryDoubleQuotesPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (!PhpSmartKeysConfiguration.getInstance().isReplaceUnnecessaryDoubleQuotes()) {
            String string = text;
            if (string == null) {
                PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (file instanceof PhpFile) {
            SelectionModel selectionModel = editor.getSelectionModel();
            int caretOffset = selectionModel.hasSelection() ? selectionModel.getSelectionStart() : editor.getCaretModel().getOffset();
            PsiElement element = file.findElementAt(caretOffset);
            if (PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF) != null) {
                String string = text;
                if (string == null) {
                    PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(1);
                }
                return string;
            }
            PhpFile tempFile = PhpPsiElementFactory.createFirstFromText(project, PhpFile.class, text);
            ArrayList strings = new ArrayList(PsiTreeUtil.findChildrenOfType((PsiElement)tempFile, StringLiteralExpression.class));
            for (StringLiteralExpression string : strings) {
                if (string.isSingleQuote() || PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.areDoubleQuotesNecessary(string) || !PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.isWrappedWithDoubleQuotes(string)) continue;
                string.replace((PsiElement)PhpReplaceQuotesIntention.createLiteralWithChangedQuotes(string));
            }
            String string = tempFile != null ? tempFile.getText().substring(6) : text;
            if (string == null) {
                PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean areDoubleQuotesNecessary(@NotNull StringLiteralExpression expression) {
        if (expression == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(4);
        }
        return PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.isInterpolatedString(expression) || PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.hasSingleQuotes(expression) || PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.hasEscapeSequences(expression);
    }

    private static boolean isInterpolatedString(@NotNull StringLiteralExpression value) {
        if (value == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(5);
        }
        return PhpPsiUtil.getChildByCondition((PsiElement)value, (Condition<? super PsiElement>)Variable.INSTANCEOF) != null;
    }

    private static boolean hasEscapeSequences(@NotNull StringLiteralExpression expression) {
        if (expression == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(6);
        }
        String unescapedText = PhpStringUtil.unescapeText(expression.getText(), false, new String[0]);
        return !expression.getText().equals(unescapedText);
    }

    private static boolean hasSingleQuotes(@NotNull StringLiteralExpression expression) {
        if (expression == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(7);
        }
        return expression.textContains('\'');
    }

    private static boolean isWrappedWithDoubleQuotes(@NotNull StringLiteralExpression expression) {
        if (expression == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(8);
        }
        return expression.getText().charAt(0) == '\"' && expression.getText().charAt(expression.getTextLength() - 1) == '\"';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/copyPaste/PhpReplaceUnnecessaryDoubleQuotesPasteProcessor";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/copyPaste/PhpReplaceUnnecessaryDoubleQuotesPasteProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "areDoubleQuotesNecessary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInterpolatedString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasEscapeSequences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasSingleQuotes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isWrappedWithDoubleQuotes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

