/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpScratchFileCreationHelper
extends ScratchFileCreationHelper {
    private static final String CARET_MARKER = "CARET_MARKER";
    private static final String OPEN_TAG_PART = "<?php\n";

    public boolean prepareText(@NotNull Project project, @NotNull ScratchFileCreationHelper.Context context, @NotNull DataContext dataContext) {
        if (project == null) {
            PhpScratchFileCreationHelper.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpScratchFileCreationHelper.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            PhpScratchFileCreationHelper.$$$reportNull$$$0(2);
        }
        if (PhpScratchFileCreationHelper.containsOpenTag(PhpScratchFileCreationHelper.parseHeader((Project)project, (Language)context.language, (String)context.text))) {
            return true;
        }
        if (PhpScratchFileCreationHelper.startsWithHtml(project, context)) {
            return false;
        }
        String text = PhpScratchFileCreationHelper.reformat((Project)project, (Language)context.language, (String)"<?php\nCARET_MARKER");
        context.caretOffset = text.indexOf(CARET_MARKER);
        context.text = text.substring(0, context.caretOffset) + context.text;
        return true;
    }

    private static boolean startsWithHtml(Project project, ScratchFileCreationHelper.Context context) {
        PsiFile file = PhpScratchFileCreationHelper.parseHeader((Project)project, (Language)context.language, (String)(OPEN_TAG_PART + context.text));
        PsiErrorElement firstError = (PsiErrorElement)SyntaxTraverser.psiTraverser((PsiElement)file).traverse().filter(PsiErrorElement.class).first();
        return firstError != null && PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)firstError, true), PhpTokenTypes.PHP_OPENING_TAG);
    }

    private static boolean containsOpenTag(@Nullable PsiFile file) {
        return ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)file)).traverse().filter(e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.tsPHP_OPENING_TAGS)).isNotEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/actions/PhpScratchFileCreationHelper";
        objectArray[2] = "prepareText";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

