/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.PhpNewBaseAction;
import com.jetbrains.php.actions.PhpNewClassDataProvider;
import com.jetbrains.php.actions.PhpNewClassDialog;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.classes.PhpAddMethodStubsQuickFix;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.extract.extractInterface.PhpExtractInterfaceProcessor;
import com.jetbrains.php.templates.PhpCreateFileFromTemplateDataProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNewClassAction
extends PhpNewBaseAction {
    @NotNull
    public static final BiConsumer<PsiFile, PhpNewClassDataProvider> SUPERCLASSES_IMPLEMENTOR = (psiFile, dataProvider) -> {
        if (!dataProvider.canInheritSuperClasses()) {
            return;
        }
        PhpClass phpClass = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)psiFile, PhpClass.class);
        if (phpClass == null) {
            return;
        }
        PhpNewClassAction.inheritSuperClasses(phpClass, dataProvider);
        PhpNewClassAction.implementAbstractMethods(phpClass, dataProvider);
    };

    public PhpNewClassAction() {
        super(PhpBundle.messagePointer("actions.new.php.class.action.name", new Object[0]), PhpBundle.messagePointer("actions.new.php.class.action.description", new Object[0]));
    }

    @Override
    protected PhpCreateFileFromTemplateDataProvider getDataProvider(@NotNull Project project, @NotNull PsiDirectory dir, @Nullable PsiFile file) {
        PhpNewClassDialog dialog;
        if (project == null) {
            PhpNewClassAction.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            PhpNewClassAction.$$$reportNull$$$0(1);
        }
        if (!(dialog = new PhpNewClassDialog(project, dir)).showAndGet()) {
            return null;
        }
        return dialog;
    }

    @Override
    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull PhpCreateFileFromTemplateDataProvider dataProvider) {
        PhpNewClassDataProvider classDataProvider;
        if (project == null) {
            PhpNewClassAction.$$$reportNull$$$0(2);
        }
        if (dataProvider == null) {
            PhpNewClassAction.$$$reportNull$$$0(3);
        }
        if ((classDataProvider = (PhpNewClassDataProvider)ObjectUtils.tryCast((Object)dataProvider, PhpNewClassDataProvider.class)) == null) {
            return super.createFile(project, dataProvider);
        }
        return PhpNewClassAction.createFile(project, dataProvider, (Consumer<? super PsiFile>)((Consumer)file -> SUPERCLASSES_IMPLEMENTOR.accept((PsiFile)file, classDataProvider)), this.getActionName());
    }

    private static void inheritSuperClasses(@NotNull PhpClass phpClass, @NotNull PhpNewClassDataProvider dataProvider) {
        if (phpClass == null) {
            PhpNewClassAction.$$$reportNull$$$0(4);
        }
        if (dataProvider == null) {
            PhpNewClassAction.$$$reportNull$$$0(5);
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)phpClass);
        PhpNewClassAction.overrideClass(phpClass, scope, dataProvider.getSuperFqn());
        PhpNewClassAction.implementInterfaces(phpClass, scope, dataProvider.getInterfaceFqnsToImplement());
    }

    private static void overrideClass(@NotNull PhpClass phpClass, @Nullable PhpPsiElement scope, @Nullable String superFqn) {
        if (phpClass == null) {
            PhpNewClassAction.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)superFqn) || StringUtil.isNotEmpty((String)phpClass.getSuperFQN())) {
            return;
        }
        String classQualifiedName = scope != null ? PhpCodeInsightUtil.createQualifiedName(scope, superFqn) : superFqn;
        PhpLangUtil.addExtendsClause(phpClass, classQualifiedName);
    }

    private static void implementInterfaces(@NotNull PhpClass phpClass, @Nullable PhpPsiElement scope, @NotNull Collection<String> interfacesToImplement) {
        if (phpClass == null) {
            PhpNewClassAction.$$$reportNull$$$0(7);
        }
        if (interfacesToImplement == null) {
            PhpNewClassAction.$$$reportNull$$$0(8);
        }
        HashSet implementedInterfaces = ContainerUtil.newHashSet((Object[])phpClass.getInterfaceNames());
        for (String interfaceToImplement : interfacesToImplement) {
            String interfaceFqn = PhpLangUtil.toFQN(interfaceToImplement);
            if (StringUtil.isEmpty((String)interfaceToImplement) || !implementedInterfaces.add(interfaceFqn)) continue;
            String interfaceQualifiedName = scope != null ? PhpCodeInsightUtil.createQualifiedName(scope, interfaceFqn) : interfaceFqn;
            PhpExtractInterfaceProcessor.addImplementClause(phpClass.getProject(), phpClass, interfaceQualifiedName);
        }
    }

    private static void implementAbstractMethods(@NotNull PhpClass phpClass, @NotNull PhpNewClassDataProvider dataProvider) {
        if (phpClass == null) {
            PhpNewClassAction.$$$reportNull$$$0(9);
        }
        if (dataProvider == null) {
            PhpNewClassAction.$$$reportNull$$$0(10);
        }
        if (!dataProvider.shouldImplementAbstractMethods()) {
            return;
        }
        PhpAddMethodStubsQuickFix.addMethodStubs(phpClass.getProject(), phpClass, PhpNewClassAction.getAbstractMethodsToImplement(phpClass));
    }

    private static Collection<Method> getAbstractMethodsToImplement(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpNewClassAction.$$$reportNull$$$0(11);
        }
        return ContainerUtil.filter((Collection)phpClass.getMethods(), method -> method.isAbstract() && method.getContainingClass() != phpClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfacesToImplement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/actions/PhpNewClassAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inheritSuperClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "overrideClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "implementInterfaces";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "implementAbstractMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getAbstractMethodsToImplement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

