/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpWorkaroundUtil {
    private static final Collection<String> GENERIC_ARRAYS_NAMES = Set.of("array", "list", "non-empty-array", "non-empty-list", "iterable");

    private PhpWorkaroundUtil() {
    }

    public static boolean isAssignByReference(@NotNull AssignmentExpression assignmentExpression) {
        PsiElement opBitAnd;
        if (assignmentExpression == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(0);
        }
        if ((opBitAnd = PhpPsiUtil.getChildOfType((PsiElement)assignmentExpression, PhpTokenTypes.opBIT_AND)) == null) {
            PsiElement opAssgn = PhpPsiUtil.getChildOfType((PsiElement)assignmentExpression, PhpTokenTypes.opASGN);
            if (opAssgn != null) {
                return opAssgn.getText().contains("&");
            }
            return false;
        }
        return true;
    }

    public static PhpAccessInstruction.Access getArrayAccess(@NotNull PhpAccessVariableInstruction instruction) {
        ArrayAccessExpression arrayExpression;
        PsiElement anchorParent;
        PhpPsiElement anchor;
        if (instruction == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(1);
        }
        if ((anchor = instruction.getAnchor()) instanceof Variable && (anchorParent = anchor.getParent()) instanceof ArrayAccessExpression && (arrayExpression = (ArrayAccessExpression)anchorParent).getValue() == anchor) {
            ArrayAccessExpression outerArray = PhpPsiUtil.getOuterParentOfType(arrayExpression, ArrayAccessExpression.class);
            PhpAccessInstruction.Access outerArrayAccess = PhpCodeInsightUtil.getAccess((PhpPsiElement)outerArray);
            if (outerArray.getParent() instanceof PhpUnset) {
                return PhpAccessInstruction.Access.UNSET_ACCESS;
            }
            if (!outerArrayAccess.isRead()) {
                return PhpAccessInstruction.Access.WRITE_ACCESS;
            }
        }
        return PhpAccessInstruction.Access.READ_ACCESS;
    }

    public static boolean isReadReference(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(2);
        }
        return PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(anchor, true), PhpTokenTypes.opBIT_AND);
    }

    @Nullable
    public static PhpPsiElement getForeachArray(@NotNull ForeachStatement foreachStatement) {
        if (foreachStatement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(3);
        }
        return PhpWorkaroundUtil.findNextPhpPsiElement(foreachStatement.getFirstChild());
    }

    @Nullable
    public static Variable getForeachKey(@NotNull ForeachStatement foreachStatement) {
        PhpPsiElement array;
        if (foreachStatement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(4);
        }
        if ((array = PhpWorkaroundUtil.getForeachArray(foreachStatement)) != null) {
            PhpPsiElement v2;
            PhpPsiElement v1 = PhpWorkaroundUtil.getNextPsiSibling(array);
            PhpPsiElement phpPsiElement = v2 = v1 != null ? PhpWorkaroundUtil.getNextPsiSibling(v1) : null;
            if (v2 instanceof Variable && v1 instanceof Variable) {
                return (Variable)v1;
            }
        }
        return null;
    }

    @Nullable
    public static PhpReference getForeachValue(@NotNull ForeachStatement foreachStatement) {
        if (foreachStatement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(5);
        }
        for (PsiElement lastChild = foreachStatement.getLastChild(); lastChild != null; lastChild = lastChild.getPrevSibling()) {
            if (!(lastChild instanceof PhpReference)) continue;
            return (PhpReference)lastChild;
        }
        return null;
    }

    @Nullable
    public static PhpPsiElement getNextPsiSibling(@NotNull PhpPsiElement psiElement) {
        if (psiElement == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(6);
        }
        return PhpWorkaroundUtil.findNextPhpPsiElement(psiElement.getNextSibling());
    }

    @Nullable
    public static PhpPsiElement findNextPhpPsiElement(@Nullable PsiElement element) {
        for (PsiElement currElement = element; currElement != null; currElement = currElement.getNextSibling()) {
            if (!(currElement.getNode() instanceof CompositeElement)) continue;
            if (currElement instanceof PhpPsiElement) {
                PhpPsiElement phpPsiElement = (PhpPsiElement)currElement;
                if (phpPsiElement instanceof PhpDocComment || PhpPsiUtil.isOfType((PsiElement)phpPsiElement, PhpElementTypes.HTML)) continue;
                return phpPsiElement;
            }
            return null;
        }
        return null;
    }

    public static boolean isIntentionAvailable(@NotNull PsiElement element) {
        if (element == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(7);
        }
        return !(element.getContainingFile() instanceof PhpExpressionCodeFragment) && element.getContainingFile() instanceof PhpFile;
    }

    @Nullable
    public static Parameter getFunctionParameter(@NotNull PsiElement position) {
        ParameterList parameterList;
        if (position == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(8);
        }
        if ((parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(position, false, (Condition<? super PsiElement>)ParameterList.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null) {
            PsiElement parent = parameterList.getParent();
            int index = PhpWorkaroundUtil.getArgumentIndex(position, parameterList);
            if (index != -1) {
                Collection<Function> elements = PhpWorkaroundUtil.resolveTargetFunctions(parent);
                for (Function element : elements) {
                    Parameter lastParameter;
                    Parameter[] funcParameters = element.getParameters();
                    if (index < funcParameters.length) {
                        return funcParameters[index];
                    }
                    if (funcParameters.length <= 0 || !(lastParameter = funcParameters[funcParameters.length - 1]).isVariadic()) continue;
                    return lastParameter;
                }
            }
        }
        return null;
    }

    @NotNull
    public static Collection<Function> resolveTargetFunctions(@Nullable PsiElement element) {
        Object ref = element instanceof FunctionReference ? (FunctionReference)element : (element instanceof NewExpression ? ((NewExpression)element).getClassReference() : (element instanceof PhpAttribute ? ((PhpAttribute)element).getClassReference() : null));
        List list = ref != null ? StreamEx.of((Collection)ref.resolveGlobal(true)).select(Function.class).toList() : Collections.emptyList();
        if (list == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static int getArgumentIndex(@NotNull PsiElement position, @Nullable ParameterList parameterList) {
        if (position == null) {
            PhpWorkaroundUtil.$$$reportNull$$$0(10);
        }
        int index = -1;
        if (parameterList != null) {
            PsiElement[] refParameters = parameterList.getParameters();
            for (int i = 0; i < refParameters.length; ++i) {
                if (!PsiTreeUtil.isAncestor((PsiElement)refParameters[i], (PsiElement)position, (boolean)false)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static int resolveMappedParameterIndex(@Nullable PsiElement argument) {
        if (argument == null) {
            return -1;
        }
        PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(argument);
        if (nameIdentifier != null) {
            List<Parameter> parameters;
            String name;
            int i;
            Function resolvedFunction;
            ParameterListOwner parameterListOwner = (ParameterListOwner)PhpPsiUtil.getParentByCondition(argument, (Condition<? super PsiElement>)((Condition)ParameterListOwner.class::isInstance));
            if (parameterListOwner != null && (resolvedFunction = (Function)ContainerUtil.getFirstItem(PhpAnnotatorVisitor.resolveFunctions(parameterListOwner))) != null && (i = PhpWorkaroundUtil.resolveMappedParameterIndex(name = nameIdentifier.getText(), parameters = Arrays.asList(resolvedFunction.getParameters()))) >= 0) {
                return i;
            }
        }
        return PhpCodeInsightUtil.getParameterIndex(argument);
    }

    public static int resolveMappedParameterIndex(String argumentName, List<Parameter> parameters) {
        int i = ContainerUtil.indexOf(parameters, p -> PhpLangUtil.equalsParameterNames(p.getName(), argumentName));
        if (i >= 0) {
            return i;
        }
        Parameter lastParameter = (Parameter)ContainerUtil.getLastItem(parameters);
        if (lastParameter != null && lastParameter.isVariadic()) {
            return parameters.size() - 1;
        }
        return -1;
    }

    public static Collection<String> getGenericArraysNames() {
        return GENERIC_ARRAYS_NAMES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreachStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpWorkaroundUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpWorkaroundUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTargetFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAssignByReference";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getArrayAccess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReadReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getForeachArray";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getForeachKey";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getForeachValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNextPsiSibling";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIntentionAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParameter";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

