/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.psi.PhpMultipleDeclarationFilter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpMultiProjectDeclarationFilter
implements PhpMultipleDeclarationFilter {
    public <E extends PhpNamedElement> Collection<E> filter(@NotNull PsiElement point, Collection<E> candidates) {
        Collection<Object> closestCandidates;
        Project project;
        Set<VirtualFile> stubRoots;
        if (point == null) {
            PhpMultiProjectDeclarationFilter.$$$reportNull$$$0(0);
        }
        if (!Registry.is((String)"php.use.multiproject.ref.resolver", (boolean)true)) {
            return candidates;
        }
        if (candidates.size() == 1) {
            return candidates;
        }
        if (point.getContainingFile() == null) {
            return candidates;
        }
        PsiFile file = point.getContainingFile();
        if (file.getVirtualFile() == null) {
            return candidates;
        }
        List candidatesList = ContainerUtil.mapNotNull(candidates, candidate -> candidate.getContainingFile() != null && candidate.getContainingFile().getVirtualFile() != null ? new Candidate<PhpNamedElement>((PhpNamedElement)candidate, candidate.getContainingFile().getVirtualFile()) : null);
        if (ContainerUtil.exists((Iterable)candidatesList, arg_0 -> PhpMultiProjectDeclarationFilter.lambda$filter$1(stubRoots = PhpRuntimeLibraryRootsProvider.getLibraryRoots(project = file.getProject()), arg_0))) {
            return candidates;
        }
        VirtualFile referenceVF = file.getVirtualFile();
        List currentProjectCandidates = ContainerUtil.filter((Collection)candidatesList, candidate -> {
            VirtualFile[] contentRoots;
            boolean isInTheSameRoot = false;
            for (VirtualFile contentRoot : contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)candidate.file, (boolean)false) || !VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)referenceVF, (boolean)false)) continue;
                isInTheSameRoot = true;
                break;
            }
            return isInTheSameRoot;
        });
        if (currentProjectCandidates.isEmpty()) {
            return candidates;
        }
        if (currentProjectCandidates.size() == 1) {
            return PhpMultiProjectDeclarationFilter.getNamedElements(currentProjectCandidates);
        }
        if (referenceVF.getPath().contains("/vendor/")) {
            closestCandidates = ContainerUtil.filter((Collection)currentProjectCandidates, candidate -> candidate.file.getPath().contains("vendor"));
            closestCandidates = PhpMultiProjectDeclarationFilter.getClosestResultForVendorFromVendors(referenceVF, closestCandidates);
        } else {
            closestCandidates = ContainerUtil.filter((Collection)currentProjectCandidates, candidate -> !candidate.file.getPath().contains("vendor"));
            if (closestCandidates.isEmpty()) {
                closestCandidates = PhpMultiProjectDeclarationFilter.getCandidatesFromTopVendor(project, referenceVF, currentProjectCandidates);
            }
        }
        return PhpMultiProjectDeclarationFilter.getNamedElements(closestCandidates);
    }

    private static <K extends PhpNamedElement> Collection<K> getNamedElements(Collection<Candidate<K>> candidates) {
        return ContainerUtil.map(candidates, candidate -> candidate.element);
    }

    @NotNull
    private static <K extends PhpNamedElement> Collection<Candidate<K>> getClosestResultForVendorFromVendors(@NotNull VirtualFile referenceFile, @NotNull Collection<Candidate<K>> candidates) {
        if (referenceFile == null) {
            PhpMultiProjectDeclarationFilter.$$$reportNull$$$0(1);
        }
        if (candidates == null) {
            PhpMultiProjectDeclarationFilter.$$$reportNull$$$0(2);
        }
        VirtualFile parentVendorForReference = VfsUtilCore.findContainingDirectory((VirtualFile)referenceFile, (CharSequence)"vendor");
        assert (parentVendorForReference != null);
        List list = ContainerUtil.filter(candidates, candidate -> {
            VirtualFile parentVendor = VfsUtilCore.findContainingDirectory((VirtualFile)candidate.file, (CharSequence)"vendor");
            return parentVendorForReference.equals(parentVendor);
        });
        if (list == null) {
            PhpMultiProjectDeclarationFilter.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static <K extends PhpNamedElement> Collection<Candidate<K>> getCandidatesFromTopVendor(@NotNull Project project, @NotNull VirtualFile referenceFile, @NotNull Collection<Candidate<K>> candidates) {
        Collection vendors;
        if (project == null) {
            PhpMultiProjectDeclarationFilter.$$$reportNull$$$0(4);
        }
        if (referenceFile == null) {
            PhpMultiProjectDeclarationFilter.$$$reportNull$$$0(5);
        }
        if (candidates == null) {
            PhpMultiProjectDeclarationFilter.$$$reportNull$$$0(6);
        }
        if ((vendors = FilenameIndex.getVirtualFilesByName((Project)project, (String)"vendor", (GlobalSearchScope)GlobalSearchScope.everythingScope((Project)project))).size() < 2) {
            Collection<Candidate<K>> collection = candidates;
            if (collection == null) {
                PhpMultiProjectDeclarationFilter.$$$reportNull$$$0(7);
            }
            return collection;
        }
        List closestCandidates = ContainerUtil.filter(candidates, candidate -> {
            VirtualFile vendorOfCandidate = VfsUtilCore.findContainingDirectory((VirtualFile)candidate.file, (CharSequence)"vendor");
            return vendorOfCandidate != null && VfsUtilCore.isAncestor((VirtualFile)vendorOfCandidate.getParent(), (VirtualFile)referenceFile, (boolean)false);
        });
        Collection<Object> collection = !closestCandidates.isEmpty() ? closestCandidates : candidates;
        if (collection == null) {
            PhpMultiProjectDeclarationFilter.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static /* synthetic */ boolean lambda$filter$1(Set stubRoots, Candidate candidate) {
        return VfsUtilCore.isUnder((VirtualFile)candidate.file, (Set)stubRoots);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpMultiProjectDeclarationFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpMultiProjectDeclarationFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClosestResultForVendorFromVendors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesFromTopVendor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClosestResultForVendorFromVendors";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatesFromTopVendor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Candidate<E extends PhpNamedElement> {
        public VirtualFile file;
        public E element;

        private Candidate(E element, VirtualFile file) {
            this.element = element;
            this.file = file;
        }
    }
}

