/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.ElementBase;
import com.intellij.ui.IconManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhpFileIconProvider
implements FileIconProvider {
    PhpFileIconProvider() {
    }

    @Nullable
    public Icon getIcon(@NotNull VirtualFile virtualFile, @Iconable.IconFlags int flags, @Nullable Project project) {
        if (virtualFile == null) {
            PhpFileIconProvider.$$$reportNull$$$0(0);
        }
        if (project == null || virtualFile.getFileType() != PhpFileType.INSTANCE) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (!(psiFile instanceof PhpFile)) {
            return null;
        }
        PhpClass aClass = PhpFileIconProvider.extractOnlyClass((PhpFile)psiFile);
        Icon icon = aClass != null ? aClass.getIcon() : PhpIcons.PHP_FILE;
        return IconManager.getInstance().createLayeredIcon((Iconable)psiFile, icon, ElementBase.transformFlags((PsiElement)psiFile, (int)flags));
    }

    @Nullable
    private static PhpClass extractOnlyClass(@NotNull PhpFile file) {
        List classes;
        if (file == null) {
            PhpFileIconProvider.$$$reportNull$$$0(1);
        }
        if ((classes = ContainerUtil.filter((Collection)file.getTopLevelDefs().values(), e -> e instanceof PhpClass)).size() == 1) {
            PhpClass aClass = (PhpClass)classes.get(0);
            if (StringUtil.containsIgnoreCase((String)file.getName(), (String)aClass.getName())) {
                return aClass;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/PhpFileIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractOnlyClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

