/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class PhpCaches
implements Disposable {
    private static final Key<PhpCaches> PHP_CACHES_KEY = Key.create((String)"PhpCaches");
    public static final int TYPE_CACHE_SIZE = 7000;
    private static Project ourProject;
    private final LowMemoryWatcher myLowMemoryWatcher;
    public volatile Map<String, PhpType> TYPE_COMPLETION_CACHE = new ConcurrentHashMap<String, PhpType>();
    public volatile Map<String, Collection<? extends PhpNamedElement>> SIGNATURES_CACHE = new ConcurrentHashMap<String, Collection<? extends PhpNamedElement>>();
    public volatile Map<String, Collection<PhpClass>> subclassCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
    public volatile Map<String, Collection<PhpClass>> directSubclassesCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
    public volatile Map<String, Collection<PhpClass>> classCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
    public volatile Map<String, Collection<PhpClass>> interfaceCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
    public volatile Map<String, Collection<PhpClass>> traitCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
    public volatile Map<String, Collection<PhpClassAlias>> aliasesClassCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
    public volatile Map<String, Collection<PhpClassAlias>> aliasesInterfaceCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
    public volatile Map<String, Collection<PhpClassAlias>> aliasesTraitCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
    public volatile Map<String, Collection<PhpClassAlias>> allAliasesCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
    public volatile Map<String, Collection<Constant>> caseSensitiveConstantsCache = new ConcurrentHashMap<String, Collection<Constant>>();
    public volatile Map<String, Collection<Constant>> caseInsensitiveConstantsCache = new ConcurrentHashMap<String, Collection<Constant>>();
    public volatile Map<String, Collection<Function>> functionsCache = new ConcurrentHashMap<String, Collection<Function>>();
    public volatile Map<PsiElement, PhpType> TYPE_CACHE = Collections.synchronizedMap(new WeakHashMap(1000));

    public PhpCaches(Project project) {
        this.myLowMemoryWatcher = LowMemoryWatcher.register(() -> this.clearCaches(true));
        PsiModificationTracker.Listener modificationHandler = () -> this.clearCaches(false);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)modificationHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches(boolean onLowMem) {
        if (this.TYPE_COMPLETION_CACHE.size() > 0) {
            this.TYPE_COMPLETION_CACHE = new ConcurrentHashMap<String, PhpType>();
        }
        if (this.SIGNATURES_CACHE.size() > 0) {
            this.SIGNATURES_CACHE = new ConcurrentHashMap<String, Collection<? extends PhpNamedElement>>();
        }
        if (this.classCache.size() > 0) {
            this.classCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
        }
        if (this.interfaceCache.size() > 0) {
            this.interfaceCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
        }
        if (this.traitCache.size() > 0) {
            this.traitCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
        }
        if (this.aliasesClassCache.size() > 0) {
            this.aliasesClassCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
        }
        if (this.aliasesInterfaceCache.size() > 0) {
            this.aliasesInterfaceCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
        }
        if (this.aliasesTraitCache.size() > 0) {
            this.aliasesTraitCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
        }
        if (this.allAliasesCache.size() > 0) {
            this.allAliasesCache = new ConcurrentHashMap<String, Collection<PhpClassAlias>>();
        }
        if (!this.caseSensitiveConstantsCache.isEmpty()) {
            this.caseSensitiveConstantsCache = new ConcurrentHashMap<String, Collection<Constant>>();
        }
        if (!this.caseInsensitiveConstantsCache.isEmpty()) {
            this.caseInsensitiveConstantsCache = new ConcurrentHashMap<String, Collection<Constant>>();
        }
        if (!this.functionsCache.isEmpty()) {
            this.functionsCache = new ConcurrentHashMap<String, Collection<Function>>();
        }
        if (this.subclassCache.size() > 0) {
            this.subclassCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
        }
        if (this.directSubclassesCache.size() > 0) {
            this.directSubclassesCache = new ConcurrentHashMap<String, Collection<PhpClass>>();
        }
        Map<PsiElement, PhpType> type_cache = this.TYPE_CACHE;
        if (!this.TYPE_CACHE.isEmpty()) {
            this.TYPE_CACHE = Collections.synchronizedMap(new WeakHashMap(1000));
            type_cache.clear();
        }
        String string = "VISITOR_RESULT_CACHE_LOCK";
        synchronized ("VISITOR_RESULT_CACHE_LOCK") {
            VariableImpl.VISITOR_RESULT_CACHE.clear();
            VariableImpl.VISITOR_RESULT_CACHE_GLOBAL.clear();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void dispose() {
        this.myLowMemoryWatcher.stop();
        if (ourProject != null) {
            ourProject.putUserData(PHP_CACHES_KEY, null);
        }
        this.clearCaches(true);
    }

    public static PhpCaches getInstance(Project project) {
        ourProject = project;
        PhpCaches manager = (PhpCaches)project.getUserData(PHP_CACHES_KEY);
        if (manager == null) {
            manager = (PhpCaches)ServiceManager.getService((Project)project, PhpCaches.class);
            project.putUserData(PHP_CACHES_KEY, (Object)manager);
        }
        return manager;
    }
}

