/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OverlyComplexBooleanExpressionJSInspection
extends JavaScriptInspection {
    private static final int TERM_LIMIT = 3;
    public int m_limit = 3;

    private int getLimit() {
        return this.m_limit;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionJSBundle.message("maximum.number.of.terms.parameter", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("overly.complex.boolean.expression.error.string", new Object[0]);
        if (string == null) {
            OverlyComplexBooleanExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/OverlyComplexBooleanExpressionJSInspection", "buildErrorString"));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            this.checkExpression((JSExpression)expression);
        }

        public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitJSPrefixExpression(expression);
            this.checkExpression((JSExpression)expression);
        }

        public void visitJSParenthesizedExpression(JSParenthesizedExpression expression) {
            super.visitJSParenthesizedExpression(expression);
            this.checkExpression((JSExpression)expression);
        }

        private void checkExpression(JSExpression expression) {
            if (!this.isBoolean(expression)) {
                return;
            }
            if (this.isParentBoolean(expression)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= OverlyComplexBooleanExpressionJSInspection.this.getLimit()) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        private int countTerms(JSExpression expression) {
            if (expression == null) {
                return 0;
            }
            if (!this.isBoolean(expression)) {
                return 1;
            }
            if (expression instanceof JSBinaryExpression) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
                JSExpression lhs = binaryExpression.getLOperand();
                JSExpression rhs = binaryExpression.getROperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression instanceof JSPrefixExpression) {
                JSPrefixExpression prefixExpression = (JSPrefixExpression)expression;
                JSExpression operand = prefixExpression.getExpression();
                return this.countTerms(operand);
            }
            if (expression instanceof JSParenthesizedExpression) {
                JSParenthesizedExpression parenthesizedExpression = (JSParenthesizedExpression)expression;
                JSExpression contents = parenthesizedExpression.getInnerExpression();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentBoolean(JSExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof JSExpression)) {
                return false;
            }
            return this.isBoolean((JSExpression)parent);
        }

        private boolean isBoolean(JSExpression expression) {
            if (expression instanceof JSBinaryExpression) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
                IElementType sign = binaryExpression.getOperationSign();
                return JSTokenTypes.ANDAND.equals(sign) || JSTokenTypes.OROR.equals(sign);
            }
            if (expression instanceof JSPrefixExpression) {
                JSPrefixExpression prefixExpression = (JSPrefixExpression)expression;
                IElementType sign = prefixExpression.getOperationSign();
                return JSTokenTypes.EXCL.equals(sign);
            }
            if (expression instanceof JSParenthesizedExpression) {
                JSParenthesizedExpression parenthesizedExpression = (JSParenthesizedExpression)expression;
                JSExpression contents = parenthesizedExpression.getInnerExpression();
                return this.isBoolean(contents);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/sixrr/inspectjs/confusing/OverlyComplexBooleanExpressionJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPrefixExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

