/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.assignment;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class AssignmentToFunctionParameterJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("assignment.to.function.parameter.error.string", new Object[0]);
        if (string == null) {
            AssignmentToFunctionParameterJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/assignment/AssignmentToFunctionParameterJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private static final TokenSet INC_DEC = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.PLUSPLUS, JSTokenTypes.MINUSMINUS});

        private Visitor() {
        }

        public void visitJSAssignmentExpression(JSAssignmentExpression jsAssignmentExpression) {
            super.visitJSAssignmentExpression(jsAssignmentExpression);
            JSExpression lhs = jsAssignmentExpression.getLOperand();
            this.checkOperand(lhs);
        }

        public void visitJSPrefixExpression(JSPrefixExpression jsPrefixExpression) {
            super.visitJSPrefixExpression(jsPrefixExpression);
            this.checkIncDec(jsPrefixExpression.getOperationSign(), jsPrefixExpression.getExpression());
        }

        private void checkIncDec(IElementType sign, JSExpression operand) {
            if (!INC_DEC.contains(sign)) {
                return;
            }
            this.checkOperand(operand);
        }

        public void visitJSPostfixExpression(JSPostfixExpression jsPostfixExpression) {
            super.visitJSPostfixExpression(jsPostfixExpression);
            this.checkIncDec(jsPostfixExpression.getOperationSign(), jsPostfixExpression.getExpression());
        }

        private void checkOperand(JSExpression operand) {
            if (operand == null) {
                return;
            }
            if (operand instanceof JSDefinitionExpression) {
                this.checkReference(((JSDefinitionExpression)operand).getExpression(), operand);
            }
            this.checkReference(operand, operand);
        }

        private void checkReference(JSExpression operand, JSExpression errorNode) {
            if (operand instanceof JSReferenceExpression) {
                PsiElement referent = ((PsiReference)operand).resolve();
                if (!(referent instanceof JSParameter)) {
                    return;
                }
                this.registerError((PsiElement)errorNode);
            }
        }
    }
}

