/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspection;
import com.sixrr.inspectjs.InspectionJSFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspectionVisitor
extends JSElementVisitor {
    private BaseInspection inspection = null;
    private ProblemsHolder problemsHolder = null;
    private boolean onTheFly = false;

    public void setInspection(BaseInspection inspection) {
        this.inspection = inspection;
    }

    public void setProblemsHolder(ProblemsHolder problemsHolder) {
        this.problemsHolder = problemsHolder;
    }

    public void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    protected void registerFunctionCallError(JSCallExpression expression) {
        JSExpression methodExpression = expression.getMethodExpression();
        Object errorLocation = null;
        if (methodExpression instanceof JSReferenceExpression) {
            errorLocation = ((JSReferenceExpression)methodExpression).getReferenceNameElement();
        } else if (methodExpression instanceof JSFunction) {
            ASTNode node = ((JSFunction)methodExpression).findNameIdentifier();
            errorLocation = node != null ? node.getPsi() : methodExpression;
        }
        this.registerError((PsiElement)errorLocation);
    }

    protected void registerStatementError(JSSourceElement statement, Object ... args) {
        PsiElement statementToken = statement.getFirstChild();
        if (statementToken != null && statementToken.getTextLength() == 0) {
            statementToken = statementToken.getNextSibling();
        }
        this.registerError(statementToken, args);
    }

    protected void registerFunctionError(JSFunction function2) {
        ASTNode identifier = function2.findNameIdentifier();
        if (identifier == null || !PsiTreeUtil.isAncestor((PsiElement)function2, (PsiElement)identifier.getPsi(), (boolean)true)) {
            PsiElement childForTarget = function2.getFirstChild();
            if (childForTarget instanceof JSAttributeList) {
                childForTarget = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)childForTarget);
            }
            this.registerError(childForTarget);
        } else {
            this.registerError(identifier.getPsi());
        }
    }

    protected void registerVariableError(JSVariable variable) {
        PsiElement nameIdentifier = variable.getNameIdentifier();
        this.registerError(nameIdentifier);
    }

    protected void registerError(PsiElement location) {
        if (location == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = this.inspection.buildErrorString(location);
        this.registerError(location, null, description, fix);
    }

    private void registerError(PsiElement location, @Nullable TextRange textRange, @NotNull @InspectionMessage String description, LocalQuickFix[] fixes) {
        if (description == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(0);
        }
        this.problemsHolder.registerProblem(location, description, this.getProblemHighlightType(location), textRange, fixes);
    }

    protected ProblemHighlightType getProblemHighlightType(PsiElement location) {
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    protected void registerError(PsiElement location, Object ... args) {
        LocalQuickFix[] fix = this.createFixes(location);
        String description = this.inspection.buildErrorString(args);
        this.registerError(location, null, description, fix);
    }

    protected void registerError(PsiElement location, TextRange textRange, Object ... args) {
        LocalQuickFix[] fix = this.createFixes(location);
        String description = this.inspection.buildErrorString(args);
        this.registerError(location, textRange, description, fix);
    }

    protected void registerErrorForChild(PsiElement element, IElementType elementType, Object ... args) {
        ASTNode signNode = element.getNode().findChildByType(elementType);
        assert (signNode != null);
        TextRange signRange = signNode.getTextRange().shiftLeft(element.getTextOffset());
        this.registerError(element, signRange, args);
    }

    private LocalQuickFix @Nullable [] createFixes(PsiElement location) {
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            return null;
        }
        LocalQuickFix[] fixes = this.inspection.buildFixes(location, this.onTheFly);
        if (fixes != null) {
            return fixes;
        }
        InspectionJSFix fix = this.inspection.buildFix(location);
        if (fix == null) {
            return null;
        }
        return new InspectionJSFix[]{fix};
    }

    public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
        if (space == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(1);
        }
    }

    public static PsiElement findValidEditorLocation(PsiElement location) {
        PsiElement editorErrorLocation = PsiTreeUtil.lastChild((PsiElement)location);
        while (editorErrorLocation instanceof PsiErrorElement || editorErrorLocation != null && editorErrorLocation.getTextLength() == 0) {
            editorErrorLocation = PsiTreeUtil.prevLeaf((PsiElement)editorErrorLocation);
        }
        return editorErrorLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "space";
                break;
            }
        }
        objectArray2[1] = "com/sixrr/inspectjs/BaseInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerError";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhiteSpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

