/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.structuralsearch.JSStructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.XmlMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JSMatchingVisitor
extends JSElementVisitor {
    private final GlobalMatchingVisitor myMatchingVisitor;
    private XmlMatchingVisitor myXmlMatchingVisitor = null;

    JSMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
    }

    PsiElement extractOnlyStatement(PsiElement element) {
        if (!(element instanceof JSBlockStatement) || !this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            return element;
        }
        JSBlockStatement blockStatement = (JSBlockStatement)element;
        if (blockStatement.getParent() instanceof JSFunction) {
            return blockStatement;
        }
        JSSourceElement[] statements = blockStatement.getStatementListItems();
        return statements.length == 1 ? statements[0] : blockStatement;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            JSMatchingVisitor.$$$reportNull$$$0(0);
        }
        if (element instanceof XmlElement) {
            this.visitXml(element);
            return;
        }
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiElement statement = this.extractOnlyStatement(other);
        if (statement != other) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(element, statement));
            return;
        }
        super.visitElement(element);
        if (JSStructuralSearchProfile.canBePatternVariable(element)) {
            if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(element)) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(element, other));
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(element, other));
            }
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(SsrFilteringNodeIterator.create((PsiElement)element.getFirstChild()), SsrFilteringNodeIterator.create((PsiElement)other.getFirstChild())));
        }
    }

    private void visitXml(PsiElement element) {
        if (this.myXmlMatchingVisitor == null) {
            this.myXmlMatchingVisitor = new XmlMatchingVisitor(this.myMatchingVisitor);
        }
        element.accept((PsiElementVisitor)this.myXmlMatchingVisitor);
    }

    public void visitJSReferenceExpression(JSReferenceExpression expression) {
        boolean multiMatch;
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof LeafElement && ((LeafElement)other).getElementType() == JSTokenTypes.IDENTIFIER && other.getParent() instanceof JSReferenceExpression) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        JSExpression qualifier = expression.getQualifier();
        boolean typedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)expression);
        boolean bl = multiMatch = expression.getContainingFile() == other.getContainingFile();
        if (!(qualifier == null && typedVar || !(other instanceof JSReferenceExpression) || multiMatch)) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)other;
            if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(expression.getReferenceNameElement(), referenceExpression.getReferenceNameElement()))) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)qualifier, (PsiElement)referenceExpression.getQualifier()));
            }
        } else {
            super.visitJSReferenceExpression(expression);
        }
    }

    public void visitJSAttributeNameValuePair(JSAttributeNameValuePair attributeNameValuePair) {
        JSAttributeNameValuePair other = (JSAttributeNameValuePair)this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(attributeNameValuePair.getNameIdentifier(), other.getNameIdentifier()))) {
            return;
        }
        ASTNode valueNode = attributeNameValuePair.getValueNode();
        if (valueNode == null) {
            return;
        }
        PsiElement value2 = other.getLastChild();
        MatchingHandler handler = (MatchingHandler)valueNode.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            String text = value2.getText();
            int offset = 0;
            int length = text.length();
            if (StringUtil.isQuotedString((String)text)) {
                ++offset;
                --length;
            }
            this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle(value2, offset, length, this.myMatchingVisitor.getMatchContext()));
        } else if (handler != null) {
            this.myMatchingVisitor.setResult(handler.match(attributeNameValuePair.getLastChild(), value2, this.myMatchingVisitor.getMatchContext()));
        } else {
            String text1 = StringUtil.unquoteString((String)valueNode.getText());
            String text2 = StringUtil.unquoteString((String)value2.getText());
            boolean caseSensitiveMatch = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch();
            this.myMatchingVisitor.setResult(caseSensitiveMatch ? text1.equals(text2) : text1.equalsIgnoreCase(text2));
        }
    }

    public void visitJSLiteralExpression(JSLiteralExpression patternLiteral) {
        if (patternLiteral instanceof JSXmlLiteralExpression) {
            this.visitXml((PsiElement)patternLiteral);
        } else {
            JSLiteralExpression matchLiteral = (JSLiteralExpression)this.myMatchingVisitor.getElement(JSLiteralExpression.class);
            if (matchLiteral == null) {
                return;
            }
            if (!this.myMatchingVisitor.setResult(patternLiteral.isQuotedLiteral() == matchLiteral.isQuotedLiteral() && patternLiteral.isRegExpLiteral() == matchLiteral.isRegExpLiteral())) {
                return;
            }
            MatchingHandler handler = (MatchingHandler)patternLiteral.getUserData(CompiledPattern.HANDLER_KEY);
            if (handler instanceof SubstitutionHandler) {
                int offset = 0;
                int length = matchLiteral.getTextLength();
                if (matchLiteral.isQuotedLiteral() || matchLiteral.isRegExpLiteral()) {
                    --length;
                    ++offset;
                }
                SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
                this.myMatchingVisitor.setResult(substitutionHandler.handle((PsiElement)matchLiteral, offset, length, this.myMatchingVisitor.getMatchContext()));
            } else if (handler != null) {
                this.myMatchingVisitor.setResult(handler.match((PsiElement)patternLiteral, (PsiElement)matchLiteral, this.myMatchingVisitor.getMatchContext()));
            } else {
                Object value1 = patternLiteral.getValue();
                Object value2 = matchLiteral.getValue();
                if (value1 instanceof String && value2 instanceof String) {
                    boolean caseSensitiveMatch = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch();
                    String string1 = (String)value1;
                    String string2 = (String)value2;
                    this.myMatchingVisitor.setResult(caseSensitiveMatch ? string1.equals(string2) : string1.equalsIgnoreCase(string2));
                } else if (value1 != null && value2 != null) {
                    this.myMatchingVisitor.setResult(value1.equals(value2));
                } else {
                    this.myMatchingVisitor.setResult(false);
                }
            }
        }
    }

    public void visitJSFunctionDeclaration(JSFunction f1) {
        JSFunction f2 = (JSFunction)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(f1.getKind() == f2.getKind() && this.myMatchingVisitor.match(f1.getNameIdentifier(), f2.getNameIdentifier()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)f1.getAttributeList(), (PsiElement)f2.getAttributeList()) && this.myMatchingVisitor.matchSons((PsiElement)f1.getParameterList(), (PsiElement)f2.getParameterList()) && this.myMatchingVisitor.matchOptionally(f1.getReturnTypeElement(), f2.getReturnTypeElement()) && this.myMatchingVisitor.matchOptionally((PsiElement)f1.getBlock(), (PsiElement)f2.getBlock()));
    }

    public void visitJSFunctionExpression(JSFunctionExpression functionExpression) {
        JSFunctionExpression other = (JSFunctionExpression)this.myMatchingVisitor.getElement(JSFunctionExpression.class);
        if (other == null) {
            return;
        }
        PsiElement body1 = (PsiElement)ObjectUtils.notNull((Object)functionExpression.getBlock(), (Object)functionExpression.getLastChild());
        PsiElement body2 = (PsiElement)ObjectUtils.notNull((Object)other.getBlock(), (Object)other.getLastChild());
        if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            body1 = JSMatchingVisitor.getElementToMatch(body1);
            body2 = JSMatchingVisitor.getElementToMatch(body2);
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSonsOptionally((PsiElement)functionExpression.getAttributeList(), (PsiElement)other.getAttributeList()) && this.myMatchingVisitor.matchSons((PsiElement)functionExpression.getParameterList(), (PsiElement)other.getParameterList()) && this.myMatchingVisitor.match(body1, body2));
    }

    private static PsiElement getElementToMatch(PsiElement element) {
        if (element instanceof JSBlockStatement) {
            List list2 = PsiTreeUtil.getChildrenOfAnyType((PsiElement)element, (Class[])new Class[]{JSStatement.class, PsiComment.class});
            if (list2.size() == 1) {
                element = (PsiElement)list2.get(0);
            } else {
                return element;
            }
        }
        if (element instanceof JSReturnStatement) {
            return ((JSReturnStatement)element).getExpression();
        }
        if (element instanceof JSExpressionStatement) {
            return ((JSExpressionStatement)element).getExpression();
        }
        return element;
    }

    public void visitJSClass(JSClass c1) {
        JSClass c2 = (JSClass)this.myMatchingVisitor.getElement(JSClass.class);
        if (c2 == null) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(c1.getNameIdentifier(), c2.getNameIdentifier()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)c1.getAttributeList(), (PsiElement)c2.getAttributeList()) && this.myMatchingVisitor.matchSonsInAnyOrder((PsiElement)c1.getExtendsList(), (PsiElement)c2.getExtendsList()) && this.myMatchingVisitor.matchSonsInAnyOrder((PsiElement)c1.getImplementsList(), (PsiElement)c2.getImplementsList()) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])c1.getFields(), (PsiElement[])c2.getFields()) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])c1.getFunctions(), (PsiElement[])c2.getFunctions()));
    }

    public void visitJSVarStatement(JSVarStatement vs1) {
        JSVarStatement vs2 = (JSVarStatement)this.myMatchingVisitor.getElement();
        PsiElement firstChild1 = vs1.getFirstChild();
        PsiElement firstChild2 = vs2.getFirstChild();
        if (!this.myMatchingVisitor.setResult(!(firstChild1 instanceof JSAttributeList) || firstChild1.getTextLength() <= 0 || firstChild2 instanceof JSAttributeList && this.myMatchingVisitor.match(firstChild1, firstChild2))) {
            return;
        }
        JSVarStatement.VarKeyword keyword = vs1.getVarKeyword();
        if (!(keyword != JSVarStatement.VarKeyword.CONST && keyword != JSVarStatement.VarKeyword.LET || this.myMatchingVisitor.setResult(vs2.getVarKeyword() == keyword))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])vs1.getVariables(), (PsiElement[])vs2.getVariables()));
    }

    public void visitJSVariable(JSVariable variable1) {
        JSVariable variable2 = (JSVariable)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(variable1.getNameIdentifier(), variable2.getNameIdentifier()) && this.myMatchingVisitor.matchOptionally(variable1.getTypeElement(), variable2.getTypeElement()) && this.myMatchingVisitor.matchOptionally((PsiElement)variable1.getInitializerOrStub(), (PsiElement)variable2.getInitializerOrStub()));
    }

    public void visitJSIfStatement(JSIfStatement if1) {
        JSIfStatement if2 = (JSIfStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)if1.getCondition(), (PsiElement)if2.getCondition()) && this.matchBody((PsiElement)if1.getThen(), (PsiElement)if2.getThen()) && this.matchBody((PsiElement)if1.getElse(), (PsiElement)if2.getElse()));
    }

    public void visitJSForStatement(JSForStatement for1) {
        JSForStatement for2 = (JSForStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)for1.getVarDeclaration(), (PsiElement)for2.getVarDeclaration()) && this.myMatchingVisitor.match((PsiElement)for1.getInitialization(), (PsiElement)for2.getInitialization()) && this.myMatchingVisitor.match((PsiElement)for1.getCondition(), (PsiElement)for2.getCondition()) && this.myMatchingVisitor.match((PsiElement)for1.getUpdate(), (PsiElement)for2.getUpdate()) && this.matchBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
    }

    public void visitJSForInStatement(JSForInStatement for1) {
        JSForInStatement for2 = (JSForInStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)for1.getVarDeclaration(), (PsiElement)for2.getVarDeclaration()) && this.myMatchingVisitor.match((PsiElement)for1.getVariableExpression(), (PsiElement)for2.getVariableExpression()) && this.myMatchingVisitor.match((PsiElement)for1.getCollectionExpression(), (PsiElement)for1.getCollectionExpression()) && this.matchBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
    }

    public void visitJSDoWhileStatement(JSDoWhileStatement while1) {
        JSDoWhileStatement while2 = (JSDoWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.matchBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
    }

    public void visitJSWhileStatement(JSWhileStatement while1) {
        JSWhileStatement while2 = (JSWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.matchBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
    }

    public void visitJSBlock(JSBlockStatement patternBlock) {
        PsiElement matchElement = this.myMatchingVisitor.getElement();
        if (matchElement instanceof JSBlockStatement) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)patternBlock, matchElement));
        } else {
            List patternChildren = PsiTreeUtil.getChildrenOfAnyType((PsiElement)patternBlock, (Class[])new Class[]{JSStatement.class, PsiComment.class});
            if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching() && patternChildren.size() == 1) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)patternChildren.get(0), matchElement));
            } else {
                this.myMatchingVisitor.setResult(false);
            }
        }
    }

    private boolean matchBody(PsiElement patternElement, PsiElement matchElement) {
        if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            List<PsiElement> matchElements;
            if (patternElement == null) {
                return true;
            }
            if (matchElement instanceof JSBlockStatement) {
                List<PsiElement> children = PsiTreeUtil.getChildrenOfAnyType((PsiElement)matchElement, (Class[])new Class[]{JSStatement.class, PsiComment.class});
                matchElements = patternElement instanceof JSBlockStatement || children.size() == 1 ? children : Collections.singletonList(matchElement);
            } else {
                matchElements = Collections.singletonList(matchElement);
            }
            List patternElements = patternElement instanceof JSBlockStatement ? PsiTreeUtil.getChildrenOfAnyType((PsiElement)patternElement, (Class[])new Class[]{JSStatement.class, PsiComment.class}) : Collections.singletonList(patternElement);
            return this.myMatchingVisitor.matchSequentially(patternElements.toArray(PsiElement.EMPTY_ARRAY), matchElements.toArray(PsiElement.EMPTY_ARRAY));
        }
        return this.myMatchingVisitor.matchSequentially(patternElement, matchElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/JSMatchingVisitor", "visitElement"));
    }
}

