/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.graph;

import com.intellij.ProjectTopics;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptConfigGraphCache
implements Disposable {
    public static final Logger LOG = Logger.getInstance(TypeScriptConfigGraphCache.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ConcurrentIntObjectMap<TypeScriptImportGraph> myCache;
    @NotNull
    private final ConcurrentIntObjectMap<TypeScriptImportGraph> myDetachedFilesCache;
    @NotNull
    private final Set<VirtualFile> myFilesToRecalculate;
    private final ConcurrentMap<VirtualFile, Set<VirtualFile>> myTypesFiles;

    @NotNull
    public static TypeScriptConfigGraphCache getService(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(0);
        }
        TypeScriptConfigGraphCache typeScriptConfigGraphCache = (TypeScriptConfigGraphCache)ServiceManager.getService((Project)project, TypeScriptConfigGraphCache.class);
        if (typeScriptConfigGraphCache == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(1);
        }
        return typeScriptConfigGraphCache;
    }

    public TypeScriptConfigGraphCache(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(2);
        }
        this.myCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.myDetachedFilesCache = ConcurrentCollectionFactory.createConcurrentIntObjectSoftValueMap();
        this.myFilesToRecalculate = ContainerUtil.newConcurrentSet();
        this.myTypesFiles = ContainerUtil.createConcurrentSoftMap();
        this.myProject = project;
        project.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (TypeScriptConfigGraphCache.this.myCache.isEmpty() && TypeScriptConfigGraphCache.this.myDetachedFilesCache.isEmpty()) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    boolean isFileContentChange;
                    if (!TypeScriptConfigGraphCache.isAcceptableEvent(vFileEvent)) continue;
                    boolean bl = isFileContentChange = vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFilePropertyChangeEvent && !TypeScriptConfigGraphCache.isFileNameChange((VFilePropertyChangeEvent)vFileEvent);
                    if (!isFileContentChange) {
                        TypeScriptConfigGraphCache.this.reset();
                        break;
                    }
                    TypeScriptConfigGraphCache.this.addToRecalculateQueue(vFileEvent.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache$1", "after"));
            }
        });
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                TypeScriptConfigGraphCache.this.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache$2", "rootsChanged"));
            }
        });
        LowMemoryWatcher.register(this::reset, (Disposable)this);
    }

    private static boolean isFileNameChange(@NotNull VFilePropertyChangeEvent event) {
        if (event == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(3);
        }
        return "name".equals(event.getPropertyName());
    }

    private static boolean isAcceptableEvent(@NotNull VFileEvent event) {
        VirtualFile file2;
        if (event == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(4);
        }
        if ((file2 = event.getFile()) == null) {
            return false;
        }
        if (file2.isDirectory()) {
            return true;
        }
        String extension = file2.getExtension();
        return TypeScriptImportsResolverProvider.getAllFileExtensionsWithoutDot().contains(extension);
    }

    @NotNull
    public final TypeScriptImportGraph getGraph(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.myFilesToRecalculate.isEmpty()) {
            this.processFilesToRecalculate();
        }
        VirtualFile configFile = config2.getConfigFile();
        int id = TypeScriptImportGraph.getFileId(configFile);
        TypeScriptFileImports references = config2.getConfigImportResolveStructure();
        TypeScriptImportGraph graph = (TypeScriptImportGraph)this.myCache.get(id);
        if (graph != null && !graph.getFileImports().equals(references)) {
            TypeScriptImportGraph value = TypeScriptConfigGraphCache.createValue(configFile, references, true);
            if (!this.myCache.replace(id, (Object)graph, (Object)value)) {
                value = (TypeScriptImportGraph)this.myCache.get(id);
            }
            TypeScriptImportGraph typeScriptImportGraph = value;
            if (typeScriptImportGraph == null) {
                TypeScriptConfigGraphCache.$$$reportNull$$$0(6);
            }
            return typeScriptImportGraph;
        }
        if (graph == null) {
            return this.createOrUseGraph(configFile, id, references);
        }
        TypeScriptImportGraph typeScriptImportGraph = graph;
        if (typeScriptImportGraph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(7);
        }
        return typeScriptImportGraph;
    }

    @NotNull
    private TypeScriptImportGraph createOrUseGraph(VirtualFile configFile, int id, TypeScriptFileImports references) {
        ProgressManager.checkCanceled();
        TypeScriptImportGraph value = TypeScriptConfigGraphCache.createValue(configFile, references, false);
        TypeScriptImportGraph existingGraph = (TypeScriptImportGraph)this.myCache.putIfAbsent(id, (Object)value);
        if (existingGraph != null) {
            value = existingGraph;
        }
        TypeScriptImportGraph typeScriptImportGraph = value;
        if (typeScriptImportGraph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(8);
        }
        return typeScriptImportGraph;
    }

    @NotNull
    public final TypeScriptImportGraph getGraph(@NotNull VirtualFile detachedFile) {
        int id;
        TypeScriptImportGraph graph;
        if (detachedFile == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(9);
        }
        if (!this.myFilesToRecalculate.isEmpty()) {
            this.processFilesToRecalculate();
        }
        if ((graph = (TypeScriptImportGraph)this.myDetachedFilesCache.get(id = TypeScriptImportGraph.getFileId(detachedFile))) != null) {
            TypeScriptImportGraph typeScriptImportGraph = graph;
            if (typeScriptImportGraph == null) {
                TypeScriptConfigGraphCache.$$$reportNull$$$0(10);
            }
            return typeScriptImportGraph;
        }
        TypeScriptImportGraph result2 = TypeScriptConfigGraphCache.createValue(detachedFile, new TypeScriptFileImportsImpl(this.myProject, detachedFile), false);
        TypeScriptImportGraph existingValue = (TypeScriptImportGraph)this.myDetachedFilesCache.putIfAbsent(id, (Object)result2);
        TypeScriptImportGraph typeScriptImportGraph = existingValue == null ? result2 : existingValue;
        if (typeScriptImportGraph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(11);
        }
        return typeScriptImportGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processFilesToRecalculate() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        if (this.myFilesToRecalculate.size() == 0) {
            return;
        }
        ArrayList<VirtualFile> toRemove = new ArrayList<VirtualFile>();
        try {
            for (VirtualFile file2 : this.myFilesToRecalculate) {
                ProgressManager.checkCanceled();
                Consumer<TypeScriptImportGraph> consumer = graph -> {
                    if (graph.containsFile(file2)) {
                        TypeScriptConfigGraphCache.recalculateGraphSafe(graph, file2);
                    } else if (TypeScriptImportsResolverProvider.checkForDynamicFiles(this.myProject, file2) && graph.includesInPattern(file2)) {
                        graph.resetGraph();
                    }
                };
                this.myCache.values().forEach(consumer);
                this.myDetachedFilesCache.values().forEach(consumer);
                toRemove.add(file2);
            }
        }
        finally {
            this.myFilesToRecalculate.removeAll(toRemove);
        }
    }

    private static void recalculateGraphSafe(@NotNull TypeScriptImportGraph graph, @NotNull VirtualFile file2) {
        if (graph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(13);
        }
        try {
            graph.recalculateEdges(file2);
        }
        catch (ProcessCanceledException | IllegalStateException e) {
            graph.resetGraph();
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOG.error(e);
        }
    }

    private void addToRecalculateQueue(@Nullable VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (file2 == null) {
            return;
        }
        for (TypeScriptImportGraph graph : this.myCache.values()) {
            if (!graph.isInitialized() || !graph.containsFile(file2) && !graph.includesInPattern(file2)) continue;
            this.myFilesToRecalculate.add(file2);
            return;
        }
        for (TypeScriptImportGraph graph : this.myDetachedFilesCache.values()) {
            if (!graph.isInitialized() || !graph.containsFile(file2)) continue;
            this.myFilesToRecalculate.add(file2);
            return;
        }
    }

    public void addToRecalculateQueue(@NotNull PsiFile file2) {
        if (file2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.addToRecalculateQueue(virtualFile);
    }

    public final boolean isConfigInclude(@NotNull VirtualFile file2, @NotNull TypeScriptConfig config2) {
        if (file2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(15);
        }
        if (config2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        TypeScriptImportGraph graph = this.getGraph(config2);
        return graph.containsFile(file2);
    }

    private void reset() {
        this.myCache.clear();
        this.myDetachedFilesCache.clear();
        this.myFilesToRecalculate.clear();
        this.myTypesFiles.clear();
    }

    @NotNull
    public Set<VirtualFile> getTypesFiles(@NotNull VirtualFile types2) {
        Set files;
        if (types2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(17);
        }
        if ((files = (Set)this.myTypesFiles.get(types2)) != null) {
            Set set = files;
            if (set == null) {
                TypeScriptConfigGraphCache.$$$reportNull$$$0(18);
            }
            return set;
        }
        Set<VirtualFile> result2 = this.calcTypes(types2);
        Set<VirtualFile> prev = this.myTypesFiles.putIfAbsent(types2, result2);
        Set<VirtualFile> set = prev != null ? prev : result2;
        if (set == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> calcTypes(final @NotNull VirtualFile types2) {
        if (types2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(20);
        }
        CompactVirtualFileSet result2 = new CompactVirtualFileSet();
        DelegatingGlobalSearchScope scope = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)this.myProject)){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return super.contains(file2) && VfsUtilCore.isAncestor((VirtualFile)types2, (VirtualFile)file2, (boolean)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache$3", "contains"));
            }
        };
        FileTypeIndex.processFiles((FileType)TypeScriptFileType.INSTANCE, arg_0 -> TypeScriptConfigGraphCache.lambda$calcTypes$1((Set)result2, arg_0), (GlobalSearchScope)scope);
        CompactVirtualFileSet compactVirtualFileSet = result2;
        if (compactVirtualFileSet == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(21);
        }
        return compactVirtualFileSet;
    }

    public void dispose() {
        this.reset();
    }

    @NotNull
    static TypeScriptImportGraph createValue(@NotNull VirtualFile configOrRoot, @NotNull TypeScriptFileImports references, boolean rebuild) {
        if (configOrRoot == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(22);
        }
        if (references == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(23);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested " + (rebuild ? "rebuild" : "build") + " graph for " + configOrRoot.getPath());
        }
        return new TypeScriptImportGraph(references);
    }

    private static /* synthetic */ boolean lambda$calcTypes$1(Set result2, VirtualFile el) {
        result2.add(el);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detachedFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configOrRoot";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrUseGraph";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFileNameChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableEvent";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getGraph";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "recalculateGraphSafe";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addToRecalculateQueue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isConfigInclude";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypesFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calcTypes";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

