/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileInclude;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptConfig {
    @Deprecated
    public static final String OUT_PROPERTY = "out";
    public static final String FILES_PROPERTY = "files";
    public static final String DECLARATION_DIR_PROPERTY = "declarationDir";
    public static final String EXCLUDES_PROPERTY = "exclude";
    public static final String INCLUDES_PROPERTY = "include";
    public static final String COMPILER_OPTIONS_PROPERTY = "compilerOptions";
    public static final String REFERENCES_PROPERTY = "references";
    public static final String REFERENCES_PATH = "path";
    public static final String COMPILE_ON_SAVE = "compileOnSave";
    public static final String INLINE_SOURCE_MAP = "inlineSourceMap";
    public static final String SOURCE_MAP = "sourceMap";
    public static final String ALLOW_SYNTHETIC_DEFAULT_IMPORTS = "allowSyntheticDefaultImports";
    public static final String ES_MODULE_INTEROP = "esModuleInterop";
    public static final String ISOLATE_MODULES = "isolatedModules";
    public static final String IMPORTS_NOT_USED_AS_VALUES = "importsNotUsedAsValues";
    public static final String REACT_NAMESPACE = "reactNamespace";
    public static final String EXTENDS = "extends";
    public static final String TS_CONFIG_JSON = "tsconfig.json";
    public static final String JS_CONFIG_JSON = "jsconfig.json";
    public static final String TARGET_OPTION = "target";
    public static final String JSX_FACTORY = "jsxFactory";
    public static final String JSX = "jsx";
    public static final String OUT_DIR = "outDir";
    public static final String OUT_FILE = "outFile";
    public static final String PATHS = "paths";
    public static final String ROOT_DIRS = "rootDirs";
    public static final String ROOT_DIR = "rootDir";
    public static final String ALLOW_JS = "allowJs";
    public static final String CHECK_JS = "checkJs";
    public static final String STRICT_NULL_CHECKS = "strictNullChecks";
    public static final String STRICT = "strict";
    public static final String STRICT_BIND_CALL_APPLY = "strictBindCallApply";
    public static final String NO_IMPLICIT_ANY = "noImplicitAny";
    public static final String NO_IMPLICIT_THIS = "noImplicitThis";
    public static final String KEYOF_STRINGS_ONLY = "keyofStringsOnly";
    public static final String EXPERIMENTAL_DECORATORS = "experimentalDecorators";
    public static final String COMPOSITE = "composite";
    public static final String BASE_URL = "baseUrl";
    public static final String MODULE_RESOLUTION = "moduleResolution";
    public static final String MODULE = "module";
    public static final String TYPES = "types";
    public static final String LIB = "lib";
    public static final String NO_LIB = "noLib";
    public static final String PRESERVE_SYMLINKS = "preserveSymlinks";
    public static final String TYPE_ROOTS = "typeRoots";
    public static final String SUPPRESS_EXCESS_PROPERTY_ERRORS = "suppressExcessPropertyErrors";
    public static final String RESOLVE_JSON_MODULE = "resolveJsonModule";
    public static final String TYPES_MODULE = "@types";
    public static final String TYPES_MODULE_WITH_SEPARATOR = "@types/";
    public static final String DEFAULT_TYPES_DIRECTORY = "node_modules/@types";
    public static final String MODULE_RESOLUTION_NODE = "node";
    public static final String MODULE_RESOLUTION_CLASSIC = "classic";
    public static final String MODULE_COMMON_JS = "commonjs";
    public static final String PLUGINS = "plugins";
    public static final Collection<String> DEFAULT_EXCLUDE_VALUES = JSLibraryUtil.LIBRARY_ROOT_DIR_NAME_SET;
    public static final LanguageTarget DEFAULT_LANGUAGE_TARGET = LanguageTarget.ES5;
    public static final String INDEX_D_TS = "index.d.ts";

    public boolean isDirectoryBased();

    @NotNull
    public VirtualFile getConfigFile();

    @NotNull
    public VirtualFile getConfigDirectory();

    @NotNull
    public Collection<JSModulePathSubstitution> getPaths();

    @NotNull
    public Collection<PsiFileSystemItem> getRootDirs();

    @NotNull
    public LanguageTarget getLanguageTarget();

    @Nullable
    public VirtualFile getBaseUrl();

    @Nullable
    public String getOutDirectory();

    public boolean hasErrors();

    public boolean isInlineSourceMap();

    public boolean isSourceMap();

    @NotNull
    public Collection<String> getLibNames();

    @NotNull
    public Collection<VirtualFile> getTypeRoots();

    @NotNull
    public ModuleResolution getResolution();

    @NotNull
    public ModuleResolution getEffectiveResolution();

    @NotNull
    public Collection<String> getTypes();

    @NotNull
    public ModuleTarget getModule();

    public boolean isIncludedFile(@NotNull VirtualFile var1, boolean var2);

    public boolean isFromFileList(@NotNull VirtualFile var1);

    @Nullable
    public String getRawCompilerOption(@NotNull String var1);

    public boolean hasExplicitCompileOnSave();

    @NotNull
    public Collection<VirtualFile> getRootDirsFiles();

    @NotNull
    public Collection<String> getExcludePatterns();

    @NotNull
    public Collection<String> getIncludePatterns();

    @NotNull
    public Collection<VirtualFile> getFileList();

    public boolean hasFilesList();

    public boolean hasIncludesList();

    default public boolean hasReferences() {
        return false;
    }

    @NotNull
    public Collection<VirtualFile> getDependencies();

    @NotNull
    public TypeScriptFileInclude getInclude();

    @NotNull
    public TypeScriptImportResolveContext getResolveContext();

    public boolean allowJs();

    public boolean suppressExcessPropertyChecks();

    public boolean checkJs();

    public boolean noImplicitAny();

    public boolean noImplicitThis();

    public boolean strictNullChecks();

    public boolean hasCompilerOption(@NotNull String var1);

    public boolean strictBindCallApply();

    public boolean allowSyntheticDefaultImports();

    default public boolean esModuleInterop() {
        return false;
    }

    public boolean noLib();

    @Nullable
    public VirtualFile getRootDirFile();

    public boolean preserveSymlinks();

    @Nullable
    public String jsxFactory();

    @NotNull
    public TypeScriptFileImports getConfigImportResolveStructure();

    @NotNull
    public TypeScriptFileImportsResolver getImportResolver();

    @NotNull
    public List<String> getPlugins();

    public boolean keyofStringsOnly();

    default public boolean experimentalDecorators() {
        return false;
    }

    @NotNull
    default public ImportsValues importsNotUsedAsValues() {
        ImportsValues importsValues = ImportsValues.REMOVE;
        if (importsValues == null) {
            TypeScriptConfig.$$$reportNull$$$0(0);
        }
        return importsValues;
    }

    default public boolean isComposite() {
        return false;
    }

    @NotNull
    default public Collection<VirtualFile> getReferences() {
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            TypeScriptConfig.$$$reportNull$$$0(1);
        }
        return list2;
    }

    default public boolean resolveJsonModule() {
        return false;
    }

    default public boolean isolatedModules() {
        return false;
    }

    @Nullable
    default public String jsx() {
        return null;
    }

    default public boolean isJSConfig() {
        return JS_CONFIG_JSON.equals(this.getConfigFile().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = IMPORTS_NOT_USED_AS_VALUES;
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum ModuleTarget {
        COMMON_JS,
        OTHER,
        UNKNOWN;

    }

    public static enum ModuleResolution {
        NODE,
        CLASSIC,
        UNKNOWN;

    }

    public static enum ImportsValues {
        REMOVE,
        PRESERVE,
        ERROR;

    }

    public static class LanguageTarget {
        public static final int MAX_PRIORITY = Integer.MAX_VALUE;
        public static final int NON_STANDARD_PRIORITY = 3;
        public static final LanguageTarget ES3 = new LanguageTarget("lib.d.ts", 0);
        public static final LanguageTarget ES5 = new LanguageTarget("lib.d.ts", 1);
        public static final LanguageTarget ES6 = new LanguageTarget("es6", 2);
        public static final LanguageTarget NEXT = new LanguageTarget("esnext.full", Integer.MAX_VALUE);
        @NotNull
        public final String libName;
        public final int priority;

        LanguageTarget(@NotNull String libName, int prio) {
            if (libName == null) {
                LanguageTarget.$$$reportNull$$$0(0);
            }
            this.libName = libName;
            this.priority = prio;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libName", "com/intellij/lang/typescript/tsconfig/TypeScriptConfig$LanguageTarget", "<init>"));
        }
    }
}

