/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.index.TypeScriptLocalTypeEvaluator;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.resolve.JavaScriptTypeHelper;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptTypeHelper
extends JSTypeHelper {
    private static final JSTypeHelper ourTypeHelper = new TypeScriptTypeHelper();

    private TypeScriptTypeHelper() {
    }

    public static JSTypeHelper getInstance() {
        return ourTypeHelper;
    }

    @Override
    public boolean isAssignableToNamedType(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @NotNull ProcessingContext processingContext) {
        if (lOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(0);
        }
        if (rOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(2);
        }
        if (rOpType instanceof JSFunctionTypeImpl || rOpType instanceof JSArrayType && !((JSArrayType)rOpType).isPrimitive()) {
            JSTypeCastUtil.AssignableResult result2 = this.substituteLeftTypeAndCheckAssignable(lOpType, rOpType, processingContext);
            if (result2.isStrict()) {
                return result2.isAssignable();
            }
        } else if (rOpType instanceof JSGenericTypeImpl) {
            if (((JSGenericTypeImpl)rOpType).getArguments().isEmpty()) {
                return lOpType.isDirectlyAssignableType(((JSGenericTypeImpl)rOpType).getType(), processingContext);
            }
            JSTypeCastUtil.AssignableResult hierarchyAssignable = JSTypeCastUtil.isDirectlyAssignableInClassHierarchy(lOpType, rOpType, processingContext);
            if (hierarchyAssignable.isStrict()) {
                return hierarchyAssignable.isAssignable();
            }
            return lOpType.isDirectlyAssignableType((JSType)TypeScriptTypeParser.buildResolvedType(rOpType), processingContext);
        }
        return super.isAssignableToNamedType(lOpType, rOpType, processingContext);
    }

    @Override
    public boolean areNamedTypesAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (lOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(3);
        }
        if (rOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(4);
        }
        if (processingContext == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(5);
        }
        if ((assignableResult = TypeScriptTypeHelper.areNamedTypesClassAssignable(lOpType, rOpType)).isStrict()) {
            return assignableResult.isAssignable();
        }
        if (rOpType.isJavaScript()) {
            if (JSTypeUtils.hasFunctionType(rOpType, false, null) && TypeScriptTypeHelper.checkTypeContainsCallSignaturesWithoutProperties(lOpType.asRecordType())) {
                return true;
            }
            if (JavaScriptTypeHelper.getInstance().areNamedTypesAssignable(lOpType, rOpType, processingContext)) {
                return true;
            }
        }
        JSRecordType rOpResolvedType = rOpType.asRecordType();
        JSRecordType lOpResolvedType = lOpType.asRecordType();
        return lOpResolvedType.isDirectlyAssignableType((JSType)rOpResolvedType, processingContext);
    }

    private static boolean checkTypeContainsCallSignaturesWithoutProperties(@NotNull JSRecordType type) {
        if (type == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(6);
        }
        return !type.hasProperties() && !type.getCallSignatures().isEmpty();
    }

    @NotNull
    public static JSTypeCastUtil.AssignableResult areNamedTypesClassAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType) {
        if (lOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(7);
        }
        if (rOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(8);
        }
        Collection<? extends PsiElement> lOpElements = TypeScriptTypeHelper.resolveTypeElements(lOpType);
        Collection<? extends PsiElement> rOpElements = TypeScriptTypeHelper.resolveTypeElements(rOpType);
        return TypeScriptTypeHelper.areNamedResolvedTypesClassAssignable(lOpType, rOpType, lOpElements, rOpElements);
    }

    @NotNull
    public static JSTypeCastUtil.AssignableResult areNamedResolvedTypesClassAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType, Collection<? extends PsiElement> lOpElements, Collection<? extends PsiElement> rOpElements) {
        if (lOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(9);
        }
        if (rOpType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(10);
        }
        if (lOpElements.isEmpty() || rOpElements.isEmpty()) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_SURE;
            if (assignableResult == null) {
                TypeScriptTypeHelper.$$$reportNull$$$0(11);
            }
            return assignableResult;
        }
        boolean leftEnum = false;
        boolean rightEnum = false;
        for (PsiElement psiElement : lOpElements) {
            if (psiElement instanceof TypeScriptTypeAlias) continue;
            for (PsiElement psiElement2 : rOpElements) {
                if (psiElement2 instanceof TypeScriptTypeAlias) continue;
                if (psiElement == psiElement2 || psiElement instanceof JSClass && psiElement2 instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)psiElement2, (JSClass)psiElement, false)) {
                    JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
                    if (assignableResult == null) {
                        TypeScriptTypeHelper.$$$reportNull$$$0(12);
                    }
                    return assignableResult;
                }
                leftEnum = leftEnum || psiElement instanceof TypeScriptEnum;
                boolean bl = rightEnum = rightEnum || psiElement2 instanceof TypeScriptEnum;
                if ((!leftEnum || !(rOpType instanceof JSNumberType)) && (!rightEnum || !(lOpType instanceof JSNumberType))) continue;
                JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    TypeScriptTypeHelper.$$$reportNull$$$0(13);
                }
                return assignableResult;
            }
        }
        if (leftEnum && rightEnum) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
            if (assignableResult == null) {
                TypeScriptTypeHelper.$$$reportNull$$$0(14);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(15);
        }
        return assignableResult;
    }

    @NotNull
    public static Collection<? extends PsiElement> resolveTypeElements(@NotNull JSNamedType jsType) {
        if (jsType == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(16);
        }
        PsiElement sourceElement = jsType.getSource().getSourceElement();
        if (jsType.isJavaScript()) {
            String qName = JSTypeUtils.getQualifiedNameMatchingType(jsType, false);
            if (sourceElement instanceof ES6Class && Objects.equals(((ES6Class)sourceElement).getQualifiedName(), qName)) {
                List list2 = ContainerUtil.createMaybeSingletonList((Object)sourceElement);
                if (list2 == null) {
                    TypeScriptTypeHelper.$$$reportNull$$$0(17);
                }
                return list2;
            }
        }
        Collection<? extends PsiElement> collection = TypeScriptTypeParser.resolveElementsByType(jsType);
        if (collection == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @Override
    @Nullable
    public JSType getTypeForIndexing(@Nullable JSExpression expression, @NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(19);
        }
        return new TypeScriptLocalTypeEvaluator().evaluate(expression);
    }

    @Override
    @NotNull
    public Object getScopeId(@NotNull JSNamedType type) {
        PsiFile scope;
        if (type == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(20);
        }
        if ((scope = type.getSource().getScope()) == null || !scope.isValid()) {
            Object object = super.getScopeId(type);
            if (object == null) {
                TypeScriptTypeHelper.$$$reportNull$$$0(21);
            }
            return object;
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(scope);
        Object object = config2 == null ? super.getScopeId(type) : config2.getConfigFile();
        if (object == null) {
            TypeScriptTypeHelper.$$$reportNull$$$0(22);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOpType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "areNamedResolvedTypesClassAssignable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeElements";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableToNamedType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areNamedTypesAssignable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeContainsCallSignaturesWithoutProperties";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "areNamedTypesClassAssignable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "areNamedResolvedTypesClassAssignable";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeElements";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForIndexing";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getScopeId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

