/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptComparingUtil {
    private static int getCommonParameterLength(@NotNull JSFunction originalFunction, @NotNull JSFunction candidateFunction, JSParameterListElement @NotNull [] original, JSParameterListElement @NotNull [] candidate, boolean isTypeScriptFunctions) {
        if (originalFunction == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(0);
        }
        if (candidateFunction == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(1);
        }
        if (original == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(2);
        }
        if (candidate == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(3);
        }
        if (original.length == candidate.length) {
            return original.length;
        }
        if (isTypeScriptFunctions) {
            return -1;
        }
        if (candidate.length == 0) {
            return candidateFunction.isReferencesArguments() && TypeScriptComparingUtil.isRestFunction(original) ? 0 : -1;
        }
        if (original.length == 0) {
            return originalFunction.isReferencesArguments() && TypeScriptComparingUtil.isRestFunction(candidate) ? 0 : -1;
        }
        boolean isRestOriginal = original[original.length - 1].isRest();
        boolean isRestCandidate = candidate[candidate.length - 1].isRest();
        int lastNotVarArgs = isRestOriginal ? original.length - 1 : original.length;
        int lastNotVarArgsCandidate = isRestCandidate ? candidate.length - 1 : candidate.length;
        return lastNotVarArgs == lastNotVarArgsCandidate ? lastNotVarArgs : -1;
    }

    private static boolean isRestFunction(JSParameterListElement[] parameters) {
        return parameters.length > 0 && parameters[parameters.length - 1].isRest();
    }

    public static boolean areFunctionsSimilar(@NotNull JSFunction function2, @NotNull JSFunction candidateFunction) {
        if (function2 == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(4);
        }
        if (candidateFunction == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(5);
        }
        ProgressManager.checkCanceled();
        JSParameterListElement[] parameters = function2.getParameters();
        JSParameterListElement[] parametersCandidate = candidateFunction.getParameters();
        boolean isTypeScriptFunctions = function2 instanceof TypeScriptFunction && candidateFunction instanceof TypeScriptFunction;
        int toCount = TypeScriptComparingUtil.getCommonParameterLength(function2, candidateFunction, parameters, parametersCandidate, isTypeScriptFunctions);
        if (toCount == -1) {
            return false;
        }
        for (int i = 0; i < toCount; ++i) {
            JSType candidateType;
            JSParameterListElement parameter = parameters[i];
            JSParameterListElement candidateParameter = parametersCandidate[i];
            if (!StringUtil.equals((CharSequence)parameter.getName(), (CharSequence)candidateParameter.getName())) {
                return false;
            }
            if (!isTypeScriptFunctions) continue;
            if (parameter.isOptional() != candidateParameter.isOptional()) {
                return false;
            }
            if (parameter.isRest() != candidateParameter.isRest()) {
                return false;
            }
            JSType type = parameter.getJSType();
            if (TypeScriptComparingUtil.skipType(type) || TypeScriptComparingUtil.skipType(candidateType = candidateParameter.getJSType()) || TypeScriptComparingUtil.areTypeTextEqual(type, candidateType)) continue;
            return false;
        }
        if (isTypeScriptFunctions) {
            int candidateTypeParametersLength;
            TypeScriptFunction tsFunction = (TypeScriptFunction)function2;
            TypeScriptFunction tsCandidateFunction = (TypeScriptFunction)candidateFunction;
            if (tsFunction.isOverloadImplementation() != tsCandidateFunction.isOverloadImplementation()) {
                return false;
            }
            TypeScriptTypeParameterList typeParameterList = tsFunction.getTypeParameterList();
            TypeScriptTypeParameterList candidateTypeParameterList = tsFunction.getTypeParameterList();
            int typeParametersLength = typeParameterList == null ? 0 : typeParameterList.getTypeParameters().length;
            int n = candidateTypeParametersLength = candidateTypeParameterList == null ? 0 : candidateTypeParameterList.getTypeParameters().length;
            if (typeParametersLength != candidateTypeParametersLength) {
                return false;
            }
            PsiElement returnTypeElement = function2.getReturnTypeElement();
            PsiElement candidateReturnTypeElement = candidateFunction.getReturnTypeElement();
            if (returnTypeElement != null && candidateReturnTypeElement != null) {
                JSType type = function2.getReturnType();
                JSType candidateType = candidateFunction.getReturnType();
                if (!TypeScriptComparingUtil.skipType(type) && !TypeScriptComparingUtil.skipType(candidateType)) {
                    return TypeScriptComparingUtil.areTypeTextEqual(type, candidateType);
                }
            }
        }
        return true;
    }

    public static boolean areTypeTextEqual(@NotNull JSType type, @NotNull JSType candidateType) {
        if (type == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(6);
        }
        if (candidateType == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(7);
        }
        return type.isEquivalentTo(candidateType, null, false);
    }

    @Contract(value="null -> true")
    public static boolean skipType(@Nullable JSType candidateType) {
        return candidateType == null || candidateType instanceof JSCodeBasedType;
    }

    public static boolean areVariablesSimilar(@NotNull JSFieldVariable original, @NotNull JSFieldVariable candidate) {
        boolean areTypeScriptFields;
        if (original == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(8);
        }
        if (candidate == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(9);
        }
        boolean areTypeScriptVariables = original instanceof TypeScriptVariable && candidate instanceof TypeScriptVariable;
        boolean bl = areTypeScriptFields = original instanceof TypeScriptField && candidate instanceof TypeScriptField;
        if (areTypeScriptVariables) {
            TypeScriptVariable originalVariable = (TypeScriptVariable)original;
            TypeScriptVariable candidateVariable = (TypeScriptVariable)candidate;
            if (originalVariable.isConst() != candidateVariable.isConst() || originalVariable.hasBlockScope() != candidateVariable.hasBlockScope()) {
                return false;
            }
        }
        if (areTypeScriptVariables || areTypeScriptFields) {
            JSType type = original.getJSType();
            JSType rType = candidate.getJSType();
            if (TypeScriptComparingUtil.skipType(type) || TypeScriptComparingUtil.skipType(rType)) {
                return true;
            }
            return TypeScriptComparingUtil.areTypeTextEqual(type, rType);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFunction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFunction";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptComparingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonParameterLength";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "areFunctionsSimilar";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "areTypeTextEqual";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "areVariablesSimilar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

