/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.actions.ES6AddImportExecutor;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptAutoImportUtil {
    public static final TokenSet EXPORT_ASSIGNMENTS = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT, TypeScriptStubElementTypes.EXPORT_ASSIGNMENT});

    public static boolean isExportedElement(PsiElement elementToImport, JSImportPlaceInfo placeInfo) {
        TypeScriptModule tsModule;
        PsiElement parent;
        if (elementToImport instanceof ES6ExportSpecifier) {
            return true;
        }
        PsiElement psiElement = parent = elementToImport instanceof JSVariable ? JSDestructuringUtil.getParentSkippingDestructuring((JSElement)((JSVariable)elementToImport)) : elementToImport.getContext();
        if (parent instanceof JSVarStatement) {
            parent = parent.getContext();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        if (!TypeScriptPsiUtil.isTopLevelContainer(parent) || parent instanceof JSFile && !((JSFile)parent).isCommonJSModule() || parent.isEquivalentTo(placeInfo.getContainer())) {
            return false;
        }
        if (parent instanceof TypeScriptModule && (tsModule = (TypeScriptModule)parent).isAugmentation() && !TypeScriptAutoImportUtil.isAugmentationAcceptable(tsModule)) {
            return false;
        }
        TypeScriptModuleAccessibilityChecker checker = TypeScriptModuleAccessibilityChecker.INSTANCE;
        if (checker.check(placeInfo.getPlace(), elementToImport) != null) {
            return false;
        }
        return ES6ImportHandler.isExported(elementToImport) || elementToImport instanceof JSElementBase && ((JSElementBase)elementToImport).isExportedWithDefault();
    }

    private static boolean isAugmentationAcceptable(@NotNull TypeScriptModule tsModule) {
        PsiElement parent;
        if (tsModule == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(0);
        }
        if (!ES6PsiUtil.isExternalModule(parent = tsModule.getParent())) {
            return false;
        }
        JSExportAssignment assignment = TypeScriptAutoImportUtil.getExportAssignment(parent);
        return assignment instanceof TypeScriptExportAssignment;
    }

    public static boolean isContextAcceptable(@NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo placeInfo) {
        boolean isClassType;
        if (elementToImport == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(1);
        }
        if (placeInfo == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(2);
        }
        if (!(placeInfo.getPlace() instanceof JSReferenceExpression)) {
            return true;
        }
        boolean bl = isClassType = elementToImport instanceof JSClass || elementToImport instanceof TypeScriptModule || elementToImport instanceof TypeScriptImportStatement;
        if (elementToImport instanceof TypeScriptModule) {
            if (!((TypeScriptModule)elementToImport).isInternal()) {
                return false;
            }
            PsiElement module = ES6PsiUtil.findExternalModule(elementToImport);
            if (module == null) {
                return false;
            }
        }
        if (placeInfo.isStrictTypeContext() && !isClassType) {
            return false;
        }
        return TypeScriptAutoImportUtil.isElementCanBeUsedInContext(elementToImport, placeInfo, isClassType);
    }

    private static boolean isElementCanBeUsedInContext(@NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo placeInfo, boolean isClassType) {
        if (elementToImport == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(3);
        }
        if (placeInfo == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(4);
        }
        PsiElement parentContext = placeInfo.getParentElement();
        boolean isNewContext = parentContext instanceof JSNewExpression;
        boolean isCallContext = parentContext instanceof JSCallExpression;
        if (!isClassType && isNewContext) {
            return false;
        }
        if (isClassType && isCallContext && !isNewContext) {
            return false;
        }
        return !(elementToImport instanceof TypeScriptCompileTimeType) || !isCallContext;
    }

    public static void addImportStatement(@Nullable Editor editor, @NotNull String name, @NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (name == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(5);
        }
        if (elementToImport == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(6);
        }
        if (place == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(7);
        }
        new ES6AddImportExecutor(editor, place).execute(name, elementToImport);
    }

    public static void showError(Project project, @Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        String name = TypeScriptAddImportStatementFix.getDialogTitle();
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message((String)"dialog.message.cannot.find.module.for.import", (Object[])new Object[0]), (String)name, null);
    }

    public static boolean isSelfExportedAugmentationModule(@NotNull TypeScriptModule container) {
        String reference;
        PsiElement parent;
        JSExportAssignment assignment;
        if (container == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(8);
        }
        if ((assignment = TypeScriptAutoImportUtil.getExportAssignment(parent = container.getContext())) != null && (reference = assignment.getInitializerReference()) != null) {
            JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(reference, (PsiElement)assignment);
            return result2.getElements().contains(container);
        }
        return false;
    }

    public static TypeScriptImportStatement createTypeScriptImport(@NotNull PsiElement place, @NotNull JSImportDescriptor info) {
        if (place == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(9);
        }
        if (info == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(10);
        }
        String builder = TypeScriptAutoImportUtil.createTypeScriptImportText(place, info, true);
        return JSPsiElementFactory.createJSSourceElement(builder, place, TypeScriptImportStatement.class);
    }

    @NotNull
    public static String createTypeScriptImportText(@NotNull PsiElement place, @NotNull JSImportDescriptor info, boolean withSemicolon) {
        if (place == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(11);
        }
        if (info == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(12);
        }
        String moduleName = info.getModuleName();
        JSImportExportType importType = info.getImportType();
        String name = info.getImportedName();
        StringBuilder builder = new StringBuilder("import ");
        if (importType.isTypeScriptRequire()) {
            String quote = JSCodeStyleSettings.getQuote(place);
            builder.append(name).append(" = require(").append(quote).append(moduleName).append(quote).append(')');
        } else {
            builder.append(name).append(" = ").append(moduleName);
        }
        if (withSemicolon) {
            builder.append(JSCodeStyleSettings.getSemicolon(place));
        }
        String string = builder.toString();
        if (string == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public static JSExportAssignment getExportAssignment(@Nullable PsiElement module) {
        if (module == null) {
            return null;
        }
        Object[] children = JSResolveUtil.getStubbedChildren(module, EXPORT_ASSIGNMENTS);
        PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])children);
        return element instanceof JSExportAssignment ? (JSExportAssignment)element : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsModule";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeScriptImportText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAugmentationAcceptable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isContextAcceptable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isElementCanBeUsedInContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addImportStatement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSelfExportedAugmentationModule";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptImport";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptImportText";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

