/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"getLibraryCandidate", "Lcom/intellij/lang/typescript/library/TypeScriptLibraries;", "project", "Lcom/intellij/openapi/project/Project;", "defaultLibraries", "intellij.javascript.impl"})
public final class TypeScriptLibraryKt {
    @NotNull
    public static final TypeScriptLibraries getLibraryCandidate(@NotNull Project project, @NotNull TypeScriptLibraries defaultLibraries) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)defaultLibraries, (String)"defaultLibraries");
        if (project.isDefault() || project.isDisposed()) {
            return defaultLibraries;
        }
        try {
            TypeScriptLibraries result2 = (TypeScriptLibraries)RecursionManager.doPreventingRecursion((Object)"ts.loading.libraries", (boolean)false, (Computable)((Computable)new Computable<TypeScriptLibraries>(project, defaultLibraries){
                final /* synthetic */ Project $project;
                final /* synthetic */ TypeScriptLibraries $defaultLibraries;

                public final TypeScriptLibraries compute() {
                    TypeScriptServiceDirectoryWatcher typeScriptServiceDirectoryWatcher = TypeScriptServiceDirectoryWatcher.getService(this.$project);
                    Intrinsics.checkNotNullExpressionValue((Object)typeScriptServiceDirectoryWatcher, (String)"TypeScriptServiceDirecto\u2026tcher.getService(project)");
                    TypeScriptServiceDirectoryWatcher watcher = typeScriptServiceDirectoryWatcher;
                    String servicePath = watcher.getCachedCustomServiceDirectory();
                    CharSequence charSequence = servicePath;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)servicePath, (Object)watcher.getDefaultServicePath())) {
                        return this.$defaultLibraries;
                    }
                    VirtualFile libDirectory = null;
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isUnitTestMode() && (libDirectory = VirtualFileManager.getInstance().findFileByUrl(servicePath)) != null && libDirectory.isValid()) {
                        return new TypeScriptLibraries(null, libDirectory, false);
                    }
                    File file2 = new File(servicePath);
                    if (!file2.exists() || !new File(file2, "lib.d.ts").exists()) {
                        return this.$defaultLibraries;
                    }
                    libDirectory = LocalFileSystem.getInstance().findFileByIoFile(file2);
                    if (libDirectory == null || !libDirectory.isValid()) {
                        return this.$defaultLibraries;
                    }
                    return new TypeScriptLibraries(file2, null, false);
                }
                {
                    this.$project = project;
                    this.$defaultLibraries = typeScriptLibraries;
                }
            }));
            if (result2 == null) {
                Logger.getInstance(TypeScriptLibraryProvider.class).error("Infinite recursion in typescript #getLibraryCandidate");
                return defaultLibraries;
            }
            return result2;
        }
        catch (Exception ex) {
            if (ex instanceof ControlFlowException) {
                throw (Throwable)ex;
            }
            Logger.getInstance(TypeScriptLibraryProvider.class).error("Error while processing typescript external libraries", (Throwable)ex);
            return new TypeScriptLibraries();
        }
    }
}

