/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptLibraryUtil {
    public static void updateLibrary(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull String libraryName, @NotNull Collection<? extends VirtualFile> filesOutOfScope, boolean strictFileList) {
        ScriptingLibraryModel libraryModel;
        if (project == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(2);
        }
        if (filesOutOfScope == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project.isDisposed()) {
            return;
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        Library library = libTable.getLibraryByName(libraryName);
        if (strictFileList && !TypeScriptLibraryUtil.needUpdateFiles(filesOutOfScope, libraryManager, library)) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        if (library != null) {
            ScriptingLibraryTable libraryTable = libraryManager.getScriptingLibraryTable();
            libraryModel = libraryTable.getModel(library);
            if (libraryModel != null) {
                Set oldFiles = libraryModel.getSourceFiles();
                HashSet<Object> resultSet = new HashSet<Object>();
                if (!strictFileList) {
                    for (VirtualFile source : oldFiles) {
                        if (!source.isValid() || scope.accept(source)) continue;
                        resultSet.add(source);
                    }
                }
                resultSet.addAll(filesOutOfScope);
                libraryModel.setSourceFiles(VfsUtilCore.toVirtualFileArray(resultSet));
            }
        } else {
            if (filesOutOfScope.isEmpty()) {
                return;
            }
            libraryModel = libraryManager.createLibrary(libraryName, VfsUtilCore.toVirtualFileArray(filesOutOfScope), VirtualFile.EMPTY_ARRAY, ArrayUtilRt.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.PROJECT, false);
        }
        if (libraryModel != null) {
            ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
            if (!mappings.isAssociatedWithProject(libraryName)) {
                mappings.associate(null, libraryName);
            }
            TypeScriptLibraryUtil.configureModules(project, libraryModel, modules);
            libraryManager.commitChanges();
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    private static void configureModules(@NotNull Project project, @NotNull ScriptingLibraryModel libraryModel, @NotNull Collection<Module> modules) {
        Object[] allModules;
        if (project == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(4);
        }
        if (libraryModel == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(5);
        }
        if (modules == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(6);
        }
        if ((allModules = ModuleHelper.getModules((Project)project)).length == 1) {
            return;
        }
        if (libraryModel.isPredefined()) {
            return;
        }
        Set associatedModules = libraryModel.getAssociatedModules();
        if (associatedModules != null && !associatedModules.isEmpty() && associatedModules.containsAll(modules)) {
            return;
        }
        HashSet<Module> newModules = new HashSet<Module>();
        if (associatedModules != null) {
            newModules.addAll(associatedModules);
        }
        if (!modules.isEmpty()) {
            newModules.addAll(modules);
        } else {
            ContainerUtil.addAll(newModules, (Object[])allModules);
        }
        libraryModel.setAssociatedModules(newModules);
    }

    public static Collection<Module> getModules(@NotNull Project project, @NotNull Collection<? extends VirtualFile> owners) {
        if (project == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(7);
        }
        if (owners == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(8);
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
        HashSet<Module> modules = new HashSet<Module>();
        for (VirtualFile virtualFile : owners) {
            Module moduleForFile = index.getModuleForFile(virtualFile);
            if (moduleForFile == null) continue;
            modules.add(moduleForFile);
        }
        return modules;
    }

    private static boolean needUpdateFiles(@NotNull Collection<? extends VirtualFile> filesOutOfScope, @NotNull ScriptingLibraryManager libraryManager, @Nullable Library library) {
        if (filesOutOfScope == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(9);
        }
        if (libraryManager == null) {
            TypeScriptLibraryUtil.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (library == null) {
            return !filesOutOfScope.isEmpty();
        }
        ScriptingLibraryTable libraryTable = libraryManager.getScriptingLibraryTable();
        ScriptingLibraryModel libraryModel = libraryTable.getModel(library);
        if (libraryModel == null) {
            return true;
        }
        Set files = libraryModel.getSourceFiles();
        return !files.equals(new HashSet<VirtualFile>(filesOutOfScope));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesOutOfScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owners";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptLibraryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLibrary";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "configureModules";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getModules";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "needUpdateFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

