/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeArgumentsOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentsListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TypeScriptValidateGenericTypesInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptValidateGenericTypesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            TypeScriptValidateGenericTypesInspection.$$$reportNull$$$0(1);
        }
        final TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)holder.getFile());
        if (!holder.isOnTheFly() && provider.skipErrors()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                TypeScriptValidateGenericTypesInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new JSElementVisitor(){

            @Contract(pure=true)
            @NotNull
            private ProblemHighlightType getHighlightingType() {
                ProblemHighlightType problemHighlightType = provider.skipErrors() ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                if (problemHighlightType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return problemHighlightType;
            }

            public void visitTypeScriptClass(TypeScriptClass typeScriptClass) {
                TypeScriptTypeParameterList parameterList = typeScriptClass.getTypeParameterList();
                if (parameterList == null) {
                    return;
                }
                if (parameterList.getTypeParameters().length == 0) {
                    holder.registerProblem((PsiElement)parameterList, JavaScriptBundle.message((String)"typescript.validate.generic.types.inspection.error.not.empty.parameter", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitReferenceListMember(JSReferenceListMember member) {
                JSExpression referenceExpression = member.getExpression();
                if (!(referenceExpression instanceof JSReferenceExpression)) {
                    return;
                }
                String name = StringUtil.notNullize((String)member.getReferenceText());
                this.processTypeOwner((TypeScriptTypeArgumentsListOwner)member, (JSReferenceExpression)referenceExpression, name);
            }

            public void visitTypeScriptSingleType(TypeScriptSingleType singleType) {
                JSReferenceExpression referenceExpression = singleType.getReferenceExpression();
                if (referenceExpression == null) {
                    return;
                }
                String name = StringUtil.notNullize((String)singleType.getQualifiedTypeName());
                this.processTypeOwner((TypeScriptTypeArgumentsListOwner)singleType, referenceExpression, name);
            }

            private void processTypeOwner(@NotNull TypeScriptTypeArgumentsListOwner typeArgumentsListOwner, @NotNull JSReferenceExpression referenceExpression, @NotNull String name) {
                Object[] results;
                ResolveResult resolveResult;
                if (typeArgumentsListOwner == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (name == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!DialectDetector.isTypeScript((PsiElement)typeArgumentsListOwner)) {
                    return;
                }
                if (!(typeArgumentsListOwner instanceof JSTypeArgumentsOwner)) {
                    return;
                }
                TypeScriptTypeArgumentList arguments = typeArgumentsListOwner.getTypeArgumentList();
                JSTypeDeclaration[] declarationParameters = ((JSTypeArgumentsOwner)typeArgumentsListOwner).getTypeArguments();
                int declarationParametersLength = declarationParameters.length;
                if (declarationParametersLength == 0 && arguments != null) {
                    holder.registerProblem((PsiElement)arguments, JavaScriptBundle.message((String)"typescript.validate.generic.types.inspection.error.not.empty.argument", (Object[])new Object[0]), this.getHighlightingType(), new LocalQuickFix[0]);
                }
                if ((resolveResult = (ResolveResult)ArrayUtil.getFirstElement((Object[])(results = referenceExpression.multiResolve(false)))) == null) {
                    return;
                }
                PsiElement element = resolveResult.getElement();
                if ((element instanceof TypeScriptEnum || element instanceof TypeScriptTypeParameter) && arguments != null) {
                    holder.registerProblem((PsiElement)typeArgumentsListOwner, JavaScriptBundle.message((String)"typescript.generics.should.not.be", (Object[])new Object[]{name}), this.getHighlightingType(), new LocalQuickFix[]{JSFixFactory.getInstance().removeGenericArgumentFix((JSElement)arguments)});
                }
                if (!(element instanceof TypeScriptTypeParameterListOwner)) {
                    return;
                }
                TypeScriptTypeParameterList expectedList = ((TypeScriptTypeParameterListOwner)element).getTypeParameterList();
                if (arguments != null && (expectedList == null || expectedList.getTypeParameters().length == 0)) {
                    holder.registerProblem((PsiElement)typeArgumentsListOwner, JavaScriptBundle.message((String)"typescript.generics.should.not.be", (Object[])new Object[]{name}), this.getHighlightingType(), new LocalQuickFix[]{JSFixFactory.getInstance().removeGenericArgumentFix((JSElement)arguments)});
                    return;
                }
                if (expectedList == null) {
                    return;
                }
                TypeScriptTypeParameter[] expectedListTypeParameters = expectedList.getTypeParameters();
                int expectedParametersLength = expectedListTypeParameters.length;
                int expectedNonDefaultParametersLength = this.getNonDefaultParametersAmount(expectedList);
                if (declarationParametersLength >= expectedNonDefaultParametersLength && declarationParametersLength <= expectedParametersLength) {
                    return;
                }
                if (declarationParametersLength > expectedParametersLength) {
                    holder.registerProblem((PsiElement)typeArgumentsListOwner, JavaScriptBundle.message((String)"typescript.validate.generic.types.inspection.error.argument.number.between", (Object[])new Object[]{name, expectedNonDefaultParametersLength, expectedParametersLength}), this.getHighlightingType(), new LocalQuickFix[0]);
                    return;
                }
                if (expectedParametersLength != expectedNonDefaultParametersLength) {
                    holder.registerProblem((PsiElement)typeArgumentsListOwner, JavaScriptBundle.message((String)"typescript.validate.generic.types.inspection.error.argument.number.between", (Object[])new Object[]{name, expectedNonDefaultParametersLength, expectedParametersLength}), this.getHighlightingType(), new LocalQuickFix[]{JSFixFactory.getInstance().addGenericArgumentFix(typeArgumentsListOwner)});
                } else {
                    holder.registerProblem((PsiElement)typeArgumentsListOwner, JavaScriptBundle.message((String)"typescript.validate.generic.types.inspection.error.argument.number", (Object[])new Object[]{name, expectedParametersLength}), this.getHighlightingType(), new LocalQuickFix[]{JSFixFactory.getInstance().addGenericArgumentFix(typeArgumentsListOwner)});
                }
            }

            private int getNonDefaultParametersAmount(@NotNull TypeScriptTypeParameterList expectedList) {
                if (expectedList == null) {
                    1.$$$reportNull$$$0(4);
                }
                return (int)Arrays.stream(expectedList.getTypeParameters()).filter(parameter -> parameter.getDefault() == null).count();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptValidateGenericTypesInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeArgumentsListOwner";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedList";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHighlightingType";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptValidateGenericTypesInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "processTypeOwner";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getNonDefaultParametersAmount";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptValidateGenericTypesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptValidateGenericTypesInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

