/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptDuplicateUnionOrIntersectionTypeInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptDuplicateUnionOrIntersectionTypeInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            TypeScriptDuplicateUnionOrIntersectionTypeInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitTypeScriptUnionOrIntersectionType(TypeScriptUnionOrIntersectionType unionOrIntersectionType) {
                List<TypeScriptType> types2 = TypeScriptDuplicateUnionOrIntersectionTypeInspection.getUnionOrIntersectionTypes(unionOrIntersectionType);
                if (types2.size() <= 1) {
                    return;
                }
                Object2IntOpenHashMap map2 = new Object2IntOpenHashMap();
                HashSet<TypeScriptType> reportedItems = new HashSet<TypeScriptType>();
                for (int i = 0; i < types2.size(); ++i) {
                    TypeScriptType type = types2.get(i);
                    if (type instanceof TypeScriptUnionOrIntersectionType) continue;
                    JSResolvedTypeId resolvedTypeId = type.getJSType().getResolvedTypeId();
                    if (map2.containsKey((Object)resolvedTypeId)) {
                        int index = map2.getInt((Object)resolvedTypeId);
                        reportedItems.add(types2.get(index));
                        reportedItems.add(type);
                        continue;
                    }
                    map2.put((Object)resolvedTypeId, i);
                }
                reportedItems.forEach(reportedType -> {
                    String key = "javascript.validation.message.duplicate.declaration.fix.remove";
                    ReplaceUnionOrIntersectionTypeWithType fix = types2.size() == 2 ? new ReplaceUnionOrIntersectionTypeWithType((TypeScriptType)reportedType, unionOrIntersectionType) : TypeScriptDuplicateUnionOrIntersectionTypeInspection.removeASTNodeBetweenElementAndNearestTokenType((PsiElement)reportedType, key);
                    holder.registerProblem((PsiElement)reportedType, JavaScriptBundle.message((String)"javascript.validation.message.duplicate.declaration", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                });
            }
        };
    }

    @NotNull
    private static List<TypeScriptType> getUnionOrIntersectionTypes(@NotNull TypeScriptUnionOrIntersectionType type) {
        TypeScriptType[] types2;
        if (type == null) {
            TypeScriptDuplicateUnionOrIntersectionTypeInspection.$$$reportNull$$$0(2);
        }
        ArrayList<TypeScriptType> result2 = new ArrayList<TypeScriptType>();
        for (TypeScriptType typeScriptType : types2 = type.getTypes()) {
            if (typeScriptType instanceof TypeScriptParenthesizedType) {
                typeScriptType = ((TypeScriptParenthesizedType)typeScriptType).getInnerType();
            }
            if (typeScriptType == null) continue;
            result2.add(typeScriptType);
        }
        ArrayList<TypeScriptType> arrayList = result2;
        if (arrayList == null) {
            TypeScriptDuplicateUnionOrIntersectionTypeInspection.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    private static LocalQuickFixAndIntentionActionOnPsiElement removeASTNodeBetweenElementAndNearestTokenType(@NotNull PsiElement element, @NotNull String key) {
        Pair<PsiElement, PsiElement> pair;
        if (element == null) {
            TypeScriptDuplicateUnionOrIntersectionTypeInspection.$$$reportNull$$$0(4);
        }
        if (key == null) {
            TypeScriptDuplicateUnionOrIntersectionTypeInspection.$$$reportNull$$$0(5);
        }
        if ((pair = TypeScriptDuplicateUnionOrIntersectionTypeInspection.findRangeToNearestSiblingElement(element)) == null) {
            return null;
        }
        return JSFixFactory.getInstance().removeASTNodeFix(key, false, (PsiElement)pair.first, (PsiElement)pair.second);
    }

    @Nullable
    private static Pair<PsiElement, PsiElement> findRangeToNearestSiblingElement(@NotNull PsiElement element) {
        PsiElement possibleTokenType;
        if (element == null) {
            TypeScriptDuplicateUnionOrIntersectionTypeInspection.$$$reportNull$$$0(6);
        }
        if ((possibleTokenType = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element)) == null) {
            possibleTokenType = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
            if (possibleTokenType == null) {
                return null;
            }
            return Pair.create((Object)element, (Object)possibleTokenType);
        }
        return Pair.create((Object)possibleTokenType, (Object)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptDuplicateUnionOrIntersectionTypeInspection";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptDuplicateUnionOrIntersectionTypeInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionOrIntersectionTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUnionOrIntersectionTypes";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeASTNodeBetweenElementAndNearestTokenType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRangeToNearestSiblingElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceUnionOrIntersectionTypeWithType
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected ReplaceUnionOrIntersectionTypeWithType(@NotNull TypeScriptType typeScriptType, @NotNull TypeScriptUnionOrIntersectionType unionOrIntersectionType) {
            if (typeScriptType == null) {
                ReplaceUnionOrIntersectionTypeWithType.$$$reportNull$$$0(0);
            }
            if (unionOrIntersectionType == null) {
                ReplaceUnionOrIntersectionTypeWithType.$$$reportNull$$$0(1);
            }
            super((PsiElement)typeScriptType, (PsiElement)unionOrIntersectionType);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceUnionOrIntersectionTypeWithType.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                ReplaceUnionOrIntersectionTypeWithType.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ReplaceUnionOrIntersectionTypeWithType.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ReplaceUnionOrIntersectionTypeWithType.$$$reportNull$$$0(5);
            }
            endElement.replace(startElement.copy());
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message((String)"javascript.validation.message.duplicate.declaration.fix.remove", (Object[])new Object[0]);
            if (string == null) {
                ReplaceUnionOrIntersectionTypeWithType.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                ReplaceUnionOrIntersectionTypeWithType.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeScriptType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unionOrIntersectionType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptDuplicateUnionOrIntersectionTypeInspection$ReplaceUnionOrIntersectionTypeWithType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptDuplicateUnionOrIntersectionTypeInspection$ReplaceUnionOrIntersectionTypeWithType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

