/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.editing.JSTypeHintsInlayProvider;
import com.intellij.lang.javascript.editing.JSTypeHintsInlayProviderKt;
import com.intellij.lang.javascript.editing.PsiBasedHintAction;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.editing.TypeScriptTypeHintsInlayProvider;
import com.intellij.lang.typescript.inspection.TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix;
import com.intellij.lang.typescript.inspection.TypeScriptSpecifyTypeExplicitlyQuickFix;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThrowableRunnable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0014J\u001d\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0012\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptTypeHintsInlayProvider;", "Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider;", "()V", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider$Settings;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "previewText", "", "getPreviewText", "()Ljava/lang/String;", "getBaseLanguage", "Lcom/intellij/lang/Language;", "getExtraActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/openapi/actionSystem/AnAction;", "isLanguageSupported", "", "language", "isSupportedDialect", "dialectOfElement", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "AddAllExplicitTypeAnnotationsAction", "AddExplicitTypeAnnotationAction", "Companion", "intellij.javascript.impl"})
public final class TypeScriptTypeHintsInlayProvider
extends JSTypeHintsInlayProvider {
    @NotNull
    private static final SettingsKey<JSTypeHintsInlayProvider.Settings> ourKey;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public SettingsKey<JSTypeHintsInlayProvider.Settings> getKey() {
        return ourKey;
    }

    @Override
    @NotNull
    protected Language getBaseLanguage() {
        JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.TYPESCRIPT;
        Intrinsics.checkNotNullExpressionValue((Object)jSLanguageDialect, (String)"JavaScriptSupportLoader.TYPESCRIPT");
        return (Language)jSLanguageDialect;
    }

    @Override
    protected boolean isSupportedDialect(@Nullable DialectOptionHolder dialectOfElement) {
        return dialectOfElement != null && dialectOfElement.isTypeScript;
    }

    @Override
    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return JSTypeHintsInlayProviderKt.isTypeScript(language);
    }

    @Override
    @NotNull
    protected AnAction[] getExtraActions(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (JSDestructuringUtil.isDestructuring(element.getParent())) {
            return new AnAction[0];
        }
        if (!TypeScriptSpecifyTypeExplicitlyQuickFix.isAvailable(element)) {
            return new AnAction[0];
        }
        if (element instanceof JSParameter && TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix.shouldSuggestMultiParamFix((JSParameter)element)) {
            return new PsiBasedHintAction[]{new AddExplicitTypeAnnotationAction(), new AddAllExplicitTypeAnnotationsAction()};
        }
        return new AddExplicitTypeAnnotationAction[]{new AddExplicitTypeAnnotationAction()};
    }

    @Override
    @Nullable
    public String getPreviewText() {
        return "var z = 3;\n      \nfunction test() { return \"a\" }\n\nclass Clazz {\n  x = 5;\n  m(p: (t: string) => void) {\n    return 5;\n  }\n}\n\nnew Clazz().m(p => {})\nnew Clazz().m((p) => {})\n";
    }

    static {
        Companion = new Companion(null);
        ourKey = new SettingsKey("ts.type.hints");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptTypeHintsInlayProvider$AddExplicitTypeAnnotationAction;", "Lcom/intellij/lang/javascript/editing/PsiBasedHintAction;", "()V", "runOnElement", "", "project", "Lcom/intellij/openapi/project/Project;", "elementAtOffset", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.impl"})
    public static final class AddExplicitTypeAnnotationAction
    extends PsiBasedHintAction {
        @Override
        public void runOnElement(@NotNull Project project, @NotNull PsiElement elementAtOffset) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)elementAtOffset, (String)"elementAtOffset");
            JSElement jSElement = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, (Class[])new Class[]{JSTypeDeclarationOwner.class, JSFunction.class});
            if (jSElement == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)jSElement, (String)"PsiTreeUtil.getParentOfT\u2026on::class.java) ?: return");
            JSElement element = jSElement;
            CommandProcessor.getInstance().executeCommand(project, new Runnable(element){
                final /* synthetic */ JSElement $element;

                public final void run() {
                    WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<Throwable>(this){
                        final /* synthetic */ runOnElement.1 this$0;

                        public final void run() {
                            TypeScriptSpecifyTypeExplicitlyQuickFix.doSpecifyExplicitType(this.this$0.$element);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                }
                {
                    this.$element = jSElement;
                }
            }, JavaScriptBundle.message((String)"typescript.specify.type.explicitly.from.hint", (Object[])new Object[0]), null);
        }

        public AddExplicitTypeAnnotationAction() {
            String string = JavaScriptBundle.message((String)"typescript.specify.type.explicitly.from.hint", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaScriptBundle.message\u2026pe.explicitly.from.hint\")");
            super(string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptTypeHintsInlayProvider$AddAllExplicitTypeAnnotationsAction;", "Lcom/intellij/lang/javascript/editing/PsiBasedHintAction;", "()V", "runOnElement", "", "project", "Lcom/intellij/openapi/project/Project;", "elementAtOffset", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.impl"})
    public static final class AddAllExplicitTypeAnnotationsAction
    extends PsiBasedHintAction {
        @Override
        public void runOnElement(@NotNull Project project, @NotNull PsiElement elementAtOffset) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)elementAtOffset, (String)"elementAtOffset");
            JSParameter jSParameter = (JSParameter)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, JSParameter.class);
            if (jSParameter == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)jSParameter, (String)"PsiTreeUtil.getParentOfT\u2026er::class.java) ?: return");
            JSParameter element = jSParameter;
            CommandProcessor.getInstance().executeCommand(project, new Runnable(element){
                final /* synthetic */ JSParameter $element;

                public final void run() {
                    WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<Throwable>(this){
                        final /* synthetic */ runOnElement.1 this$0;

                        public final void run() {
                            TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix.doSpecifyAllParameterTypes(this.this$0.$element);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                }
                {
                    this.$element = jSParameter;
                }
            }, JavaScriptBundle.message((String)"typescript.specify.all.param.types.explicitly.from.hint", (Object[])new Object[0]), null);
        }

        public AddAllExplicitTypeAnnotationsAction() {
            String string = JavaScriptBundle.message((String)"typescript.specify.all.param.types.explicitly.from.hint", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaScriptBundle.message\u2026es.explicitly.from.hint\")");
            super(string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptTypeHintsInlayProvider$Companion;", "", "()V", "ourKey", "Lcom/intellij/codeInsight/hints/SettingsKey;", "Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider$Settings;", "getOurKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "intellij.javascript.impl"})
    public static final class Companion {
        @NotNull
        public final SettingsKey<JSTypeHintsInlayProvider.Settings> getOurKey() {
            return ourKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

