/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettingsTracker;
import com.intellij.lang.typescript.compiler.ui.TypeScriptDeprecatedSettingsPanel;
import com.intellij.lang.typescript.compiler.ui.TypeScriptExternalSettingsPanel;
import com.intellij.lang.typescript.compiler.ui.TypeScriptNodePackageWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigurable
implements SearchableConfigurable {
    public static final String TYPESCRIPT_CONFIG_ID = "settings.typescriptcompiler";
    private final Project myProject;
    private final TypeScriptCompilerSettings myServiceSettings;
    private TypeScriptDeprecatedSettingsPanel myDeprecatedSettingsPanel;
    private volatile UIHolder myUIHolder;

    public TypeScriptConfigurable(Project project) {
        this.myProject = project;
        this.myServiceSettings = TypeScriptCompilerSettings.getSettings(project);
    }

    @NotNull
    public String getId() {
        return TYPESCRIPT_CONFIG_ID;
    }

    @Nls
    public String getDisplayName() {
        return JavaScriptBundle.message((String)"typescript.compiler.configurable.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.typescript";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myUIHolder == null) {
            this.myUIHolder = new UIHolder();
        }
        return this.myUIHolder.myWrapperPanel;
    }

    public void apply() throws ConfigurationException {
        if (this.myUIHolder == null) {
            return;
        }
        if (this.myProject.isDefault()) {
            this.myUIHolder.apply();
            return;
        }
        WriteAction.run(() -> {
            this.myUIHolder.apply();
            TypeScriptCompilerService.restartServices(this.myProject);
        });
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        }, this.myProject.getDisposed());
    }

    public void reset() {
        if (this.myUIHolder == null) {
            return;
        }
        this.myUIHolder.reset();
    }

    public boolean isModified() {
        if (this.myUIHolder == null) {
            return false;
        }
        return this.myUIHolder.isModified();
    }

    public void disposeUIResources() {
        UIHolder holder = this.myUIHolder;
        if (holder == null) {
            return;
        }
        this.myUIHolder.dispose();
    }

    private final class UIHolder {
        private final JPanel myServiceRelatedOptions;
        private final JBTextField myDefaultOptions;
        private final NodeJsInterpreterField myNodeInterpreterTextField;
        private final JPanel myWrapperPanel;
        private final TypeScriptExternalSettingsPanel myExternalSettingsPanel;
        private JCheckBox myRecompileOnChanges;
        private final TypeScriptNodePackageWrapper myTypeScriptNodePackageWrapper;
        private final JBCheckBox myUseService;
        private final JBCheckBox myShowProjectErrors;
        private final LabeledComponent<JBTextField> myDefaultOptionsComponent;

        private UIHolder() {
            FormBuilder mainFormBuilder = FormBuilder.createFormBuilder();
            this.myNodeInterpreterTextField = new NodeJsInterpreterField(TypeScriptConfigurable.this.myProject, false);
            this.myNodeInterpreterTextField.setInterpreterRef(NodeJsInterpreterRef.createProjectRef());
            mainFormBuilder.addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)((Object)this.myNodeInterpreterTextField));
            this.myTypeScriptNodePackageWrapper = new TypeScriptNodePackageWrapper(TypeScriptConfigurable.this.myProject, this.myNodeInterpreterTextField, TypeScriptConfigurable.this.myServiceSettings);
            mainFormBuilder.addLabeledComponent(JavaScriptBundle.message((String)"typescript.compiler.configurable.options.version", (Object[])new Object[0]), (JComponent)((Object)this.myTypeScriptNodePackageWrapper.getField()));
            this.myUseService = new JBCheckBox(JavaScriptBundle.message((String)"typescript.use.service.configurable.options.enable", (Object[])new Object[0]));
            this.myUseService.setBorder((Border)JBUI.Borders.empty());
            this.myShowProjectErrors = new JBCheckBox(JavaScriptBundle.message((String)"status.text.javascript.language.service.default.project.errors", (Object[])new Object[0]));
            this.myShowProjectErrors.setBorder((Border)JBUI.Borders.empty());
            FormBuilder serviceNestedOptionsBuilder = FormBuilder.createFormBuilder();
            serviceNestedOptionsBuilder.addComponent((JComponent)this.myShowProjectErrors);
            this.myExternalSettingsPanel = new TypeScriptExternalSettingsPanel(TypeScriptCompilerSettingsTracker.getAdditionalSettings(TypeScriptConfigurable.this.myProject), serviceNestedOptionsBuilder);
            this.appendScopeAndRecompileOnChanges(serviceNestedOptionsBuilder);
            this.myDefaultOptions = new JBTextField();
            this.myDefaultOptionsComponent = LabeledComponent.create((JComponent)this.myDefaultOptions, (String)JavaScriptBundle.message((String)"typescript.compiler.configurable.options.command.line", (Object[])new Object[0]), (String)"West");
            serviceNestedOptionsBuilder.addComponent(this.myDefaultOptionsComponent);
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel = new TypeScriptDeprecatedSettingsPanel(TypeScriptConfigurable.this.myProject, TypeScriptConfigurable.this.myServiceSettings);
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel.buildUIFor(serviceNestedOptionsBuilder);
            this.myServiceRelatedOptions = serviceNestedOptionsBuilder.getPanel();
            this.myServiceRelatedOptions.setBorder((Border)JBUI.Borders.emptyLeft((int)25));
            JPanel compilerOptionsWrapper = new JPanel(new BorderLayout());
            compilerOptionsWrapper.add((Component)this.myServiceRelatedOptions, "North");
            this.myUseService.addChangeListener(el -> this.updateVisibility());
            mainFormBuilder.addComponent((JComponent)this.myUseService);
            mainFormBuilder.addComponent((JComponent)compilerOptionsWrapper);
            this.myWrapperPanel = new JPanel(new BorderLayout());
            this.myWrapperPanel.add((Component)mainFormBuilder.getPanel(), "North");
            this.updateVisibility();
        }

        private void updateVisibility() {
            boolean isServiceEnabled = this.myUseService.isSelected();
            UIUtil.setEnabled((Component)this.myServiceRelatedOptions, (boolean)isServiceEnabled, (boolean)true);
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel.updateUI(!isServiceEnabled);
        }

        private void appendScopeAndRecompileOnChanges(FormBuilder parentBuilder) {
            this.myRecompileOnChanges = new JCheckBox(JavaScriptBundle.message((String)"typescript.compiler.configurable.options.track.file.system", (Object[])new Object[0]));
            this.myRecompileOnChanges.setBorder((Border)JBUI.Borders.empty());
            parentBuilder.addComponent((JComponent)this.myRecompileOnChanges);
        }

        private void apply() throws ConfigurationException {
            TypeScriptConfigurable.this.myServiceSettings.setDefaultServiceOptions(this.myDefaultOptions.getText());
            TypeScriptConfigurable.this.myServiceSettings.setNodeInterpreterRefName(this.getNodeInterpreterRefNameForStore());
            TypeScriptConfigurable.this.myServiceSettings.setShowAllProjectErrors(this.myShowProjectErrors.isSelected());
            TypeScriptConfigurable.this.myServiceSettings.setRecompileOnChanges(this.myRecompileOnChanges.isSelected());
            this.myTypeScriptNodePackageWrapper.apply();
            this.myExternalSettingsPanel.apply();
            TypeScriptConfigurable.this.myServiceSettings.setUseService(this.myUseService.isSelected());
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel.apply();
        }

        private void reset() {
            this.myDefaultOptions.setText(TypeScriptConfigurable.this.myServiceSettings.getDefaultServiceOptions());
            this.setNodeInterpreterField(this.myNodeInterpreterTextField);
            this.myShowProjectErrors.setSelected(TypeScriptConfigurable.this.myServiceSettings.isShowAllProjectErrors());
            TypeScriptConfigurable.this.myDeprecatedSettingsPanel.reset();
            this.myDefaultOptions.setText(TypeScriptConfigurable.this.myServiceSettings.getDefaultServiceOptions());
            this.myRecompileOnChanges.setSelected(TypeScriptConfigurable.this.myServiceSettings.isRecompileOnChanges());
            this.myTypeScriptNodePackageWrapper.reset();
            this.myUseService.setSelected(TypeScriptConfigurable.this.myServiceSettings.useService());
            this.myExternalSettingsPanel.reset();
            this.updateVisibility();
        }

        private boolean isModified() {
            return TypeScriptConfigurable.this.myDeprecatedSettingsPanel.isModified() || this.myExternalSettingsPanel.isModified() || this.myUseService.isSelected() != TypeScriptConfigurable.this.myServiceSettings.useService() || this.myShowProjectErrors.isSelected() != TypeScriptConfigurable.this.myServiceSettings.isShowAllProjectErrors() || this.myRecompileOnChanges.isSelected() != TypeScriptConfigurable.this.myServiceSettings.isRecompileOnChanges() || this.myTypeScriptNodePackageWrapper.isModified() || !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myDefaultOptions.getText()), (CharSequence)TypeScriptConfigurable.this.myServiceSettings.getDefaultServiceOptions()) || !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.getNodeInterpreterRefNameForStore()), (CharSequence)TypeScriptConfigurable.this.myServiceSettings.getNodeInterpreterRefName());
        }

        private void setNodeInterpreterField(NodeJsInterpreterField nodeInterpreterTextField) {
            nodeInterpreterTextField.setInterpreterRef(NodeJsInterpreterRef.create(TypeScriptConfigurable.this.myServiceSettings.getNodeInterpreterRefName()));
        }

        @Nullable
        private String getNodeInterpreterRefNameForStore() {
            NodeJsInterpreterRef interpreterRef = this.myNodeInterpreterTextField.getInterpreterRef();
            return interpreterRef.isProjectRef() ? null : interpreterRef.getReferenceName();
        }

        public void dispose() {
            if (TypeScriptConfigurable.this.myDeprecatedSettingsPanel != null) {
                TypeScriptConfigurable.this.myDeprecatedSettingsPanel.dispose();
            }
        }
    }
}

