/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileWithConfigAction;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceStructureBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.StatusText;
import icons.JavaScriptLanguageIcons;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptLanguageServiceToolWindowManager
extends JSLanguageServiceToolWindowManager {
    private final Project myProject;
    private final TypeScriptCompilerSettings mySettings;
    @Nullable
    private volatile TypeScriptServiceStructureBuilder.StructurePanel myStructurePanel;

    public static AnAction createShowSettingsAction(final Project project) {
        return new AnAction(JavaScriptBundle.message((String)"typescript.compiler.notification.editor.configure", (Object[])new Object[0]), null, AllIcons.General.Settings){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"settings.typescriptcompiler", (String)"");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$1", "actionPerformed"));
            }
        };
    }

    TypeScriptLanguageServiceToolWindowManager(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(0);
        }
        super(project, "TypeScript", "reference.tool.windows.typescript", JavaScriptLanguageIcons.Typescript.TypeScript_Compiler, (NotNullLazyValue<AnAction[]>)NotNullLazyValue.createValue(() -> AnAction.EMPTY_ARRAY));
        this.myProject = project;
        this.mySettings = TypeScriptCompilerSettings.getSettings(project);
    }

    @Override
    @NotNull
    protected ConsoleViewImpl createConsole() {
        return new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false){

            public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
                if (s == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (contentType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!TypeScriptLanguageServiceToolWindowManager.this.myProject.isOpen() || TypeScriptLanguageServiceToolWindowManager.this.myProject.isDisposed()) {
                    return;
                }
                super.print(TypeScriptLanguageServiceToolWindowManager.this.trimMessageToPrint(s), ConsoleViewContentType.NORMAL_OUTPUT);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "s";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "contentType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$2";
                objectArray[2] = "print";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public String trimMessageToPrint(@NotNull String s) {
        int defaultLength;
        if (s == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(1);
        }
        int n = defaultLength = JSLanguageServiceQueue.LOGGER.isDebugEnabled() ? 2000 : 150;
        if (((String)s).length() > defaultLength) {
            s = ((String)s).substring(0, defaultLength) + "...(truncated)\n";
        }
        String string = s;
        if (string == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected AnAction @Nullable [] getConsoleActions() {
        AnAction[] anActionArray;
        Object[] actions = super.getConsoleActions();
        AnAction showStructure = new AnAction(JavaScriptBundle.message((String)"action.show.structure.text", (Object[])new Object[0]), null, AllIcons.Actions.PreviewDetails){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ToolWindow window;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((window = TypeScriptLanguageServiceToolWindowManager.this.myToolWindow) != null) {
                    TypeScriptServiceStructureBuilder.StructurePanel panel2 = TypeScriptLanguageServiceToolWindowManager.this.getOrCreateStructurePanel(window);
                    if (panel2 == null) {
                        return;
                    }
                    ContentManager manager2 = window.getContentManager();
                    for (Content content : manager2.getContents()) {
                        String name = panel2.getName();
                        if (!name.equals(content.getDisplayName())) continue;
                        manager2.setSelectedContent(content);
                        panel2.refresh();
                        return;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$3", "actionPerformed"));
            }
        };
        if (actions == null) {
            AnAction[] anActionArray2 = new AnAction[1];
            anActionArray = anActionArray2;
            anActionArray2[0] = showStructure;
        } else {
            anActionArray = (AnAction[])ArrayUtil.append((Object[])actions, (Object)showStructure);
        }
        return anActionArray;
    }

    @Override
    protected AnAction[] getErrorPanelRightActions(boolean all2) {
        if (all2) {
            return super.getErrorPanelRightActions(true);
        }
        String showErrorsText = JavaScriptBundle.message((String)"javascript.language.service.default.project.errors", (Object[])new Object[0]);
        ToggleAction showErrors = new ToggleAction(showErrorsText, showErrorsText, AllIcons.General.ProjectTab){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                return TypeScriptLanguageServiceToolWindowManager.this.mySettings.isShowAllProjectErrors();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                TypeScriptLanguageServiceToolWindowManager.this.setState(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return new AnAction[]{showErrors};
    }

    void setState(boolean state) {
        this.mySettings.setShowAllProjectErrors(state);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        NewErrorTreeViewPanel panel2 = this.getCurrentErrorTreeViewPanel();
        if (panel2 != null) {
            this.updateCurrentErrorsEmptyText(panel2);
        }
    }

    @Override
    @NotNull
    protected String getProjectErrorsTitle() {
        String string = JavaScriptBundle.message((String)"tab.title.compile.errors", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void updateCurrentErrorsEmptyText(@NotNull NewErrorTreeViewPanel panel2) {
        if (panel2 == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        StatusText text = panel2.getEmptyText();
        if (!this.mySettings.useService()) {
            text.clear();
            text.setText(JavaScriptBundle.message((String)"javascript.language.service.tracking.disabled", (Object[])new Object[0]));
            return;
        }
        if (!this.mySettings.isShowAllProjectErrors() && this.hasActiveConsoles()) {
            text.clear();
            text.setText(JavaScriptBundle.message((String)"status.text.no.errors.in.current.file", (Object[])new Object[0]));
            text.appendText(JavaScriptBundle.message((String)"status.text.javascript.language.service.default.project.errors", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    TypeScriptLanguageServiceToolWindowManager.this.setState(true);
                }
            });
            return;
        }
        super.updateCurrentErrorsEmptyText(panel2);
    }

    @Override
    public boolean needActivateProgressPanel() {
        return true;
    }

    @Override
    protected void initDefaultPanels(@Nullable ToolWindow toolWindow) {
        super.initDefaultPanels(toolWindow);
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            this.getOrCreateStructurePanel(toolWindow);
        }
    }

    @Nullable
    private TypeScriptServiceStructureBuilder.StructurePanel getOrCreateStructurePanel(@Nullable ToolWindow toolWindow) {
        TypeScriptServiceStructureBuilder.StructurePanel panel2 = this.myStructurePanel;
        if (panel2 != null) {
            return panel2;
        }
        if (toolWindow != null) {
            this.myStructurePanel = panel2 = TypeScriptServiceStructureBuilder.registerStructureContent(this.myProject, toolWindow, this.myHelpId);
        }
        return panel2;
    }

    @Override
    protected void createCurrentTreeViewPanel() {
        if (TypeScriptCompilerSettings.isTypeScriptToolWindowEnable()) {
            super.createCurrentTreeViewPanel();
        }
    }

    @Override
    public synchronized void resetToolWindow() {
        TypeScriptServiceStructureBuilder.StructurePanel panel2 = this.myStructurePanel;
        if (panel2 != null) {
            Disposer.dispose((Disposable)panel2);
            this.myStructurePanel = null;
        }
        super.resetToolWindow();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "trimMessageToPrint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectErrorsTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "trimMessageToPrint";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentErrorsEmptyText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompileForConfigAction
    extends TypeScriptCompileWithConfigAction {
        private final VirtualFile myConfigFile;

        CompileForConfigAction(VirtualFile configFile) {
            super(configFile.getPresentableUrl(), null, null);
            this.myConfigFile = configFile;
        }

        @Override
        protected boolean canUseOnlyConfigs(@NotNull Project project, TypeScriptCompilerSettings settings) {
            if (project == null) {
                CompileForConfigAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        protected VirtualFile getConfigFile(@Nullable DataContext context) {
            return this.myConfigFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$CompileForConfigAction", "canUseOnlyConfigs"));
        }
    }
}

