/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptCompilerService
extends JSLanguageServiceBase
implements JSLanguageService,
TypeScriptService {
    @NotNull
    public static TypeScriptCompilerService getDefaultService(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(0);
        }
        TypeScriptCompilerService typeScriptCompilerService = (TypeScriptCompilerService)ServiceManager.getService((Project)project, TypeScriptServerServiceImpl.class);
        if (typeScriptCompilerService == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(1);
        }
        return typeScriptCompilerService;
    }

    public static TypeScriptCompilerService getServiceForFile(@NotNull Project project, VirtualFile file2) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(2);
        }
        return TypeScriptCompilerService.getServiceForFile(project, file2, true);
    }

    @Nullable
    public static TypeScriptCompilerService getServiceForFile(@NotNull Project project, VirtualFile file2, boolean checkAcceptable) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(3);
        }
        if (JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file2)) {
            return null;
        }
        return (TypeScriptCompilerService)ReadAction.compute(() -> {
            List<JSLanguageService> services = JSLanguageServiceProvider.getLanguageServices(project);
            for (JSLanguageService service : services) {
                if (!(service instanceof TypeScriptCompilerService) || checkAcceptable && !service.isAcceptable(file2) || !((TypeScriptCompilerService)service).isServiceEnabled(file2)) continue;
                return (TypeScriptCompilerService)service;
            }
            return null;
        });
    }

    public static void restartServices(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TypeScriptCompilerService.restartServices(project, true);
    }

    public static void restartServices(@NotNull Project project, boolean recreateToolWindow) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TypeScriptCompilerService.processForServices(project, (Consumer<? super TypeScriptCompilerService>)((Consumer)service -> {
            if (service.isServiceCreated()) {
                service.terminateStartedProcess(recreateToolWindow);
            }
        }));
    }

    public static void sendCleanCommandToCompiler(Project project, TypeScriptServiceCommandClean command) {
        TypeScriptCompilerService.processForServices(project, (Consumer<? super TypeScriptCompilerService>)((Consumer)service -> {
            if (service.isServiceCreated()) {
                service.sendCleanCommandToCompiler(command);
            }
        }));
    }

    public static void processVfsChangesForFiles(@NotNull Project project, @NotNull List<? extends UpdateFileInfo> files) {
        TypeScriptCompilerService service;
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(6);
        }
        if (files == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (project.isDisposed() || files.isEmpty()) {
            return;
        }
        MultiMap map2 = MultiMap.create();
        for (UpdateFileInfo updateFileInfo : files) {
            VirtualFile file2 = updateFileInfo.getFile();
            if (!file2.isValid() || (service = TypeScriptCompilerService.getServiceForFile(project, file2)) == null) continue;
            map2.putValue((Object)service, (Object)updateFileInfo);
        }
        for (Map.Entry entry : map2.entrySet()) {
            Collection toProcess = (Collection)entry.getValue();
            service = (TypeScriptCompilerService)entry.getKey();
            service.processVfsChangesForFiles(toProcess);
        }
    }

    public abstract void flushCompileQueue();

    public static void processForServices(@NotNull Project project, Consumer<? super TypeScriptCompilerService> consumer) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(8);
        }
        if (project.isDisposed()) {
            return;
        }
        List<JSLanguageService> services = JSLanguageServiceProvider.getLanguageServices(project);
        services.forEach(service -> {
            if (service instanceof TypeScriptCompilerService) {
                consumer.consume((Object)((TypeScriptCompilerService)service));
            }
        });
    }

    public static List<TypeScriptCompilerService> getAll(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(9);
        }
        List<JSLanguageService> services = JSLanguageServiceProvider.getLanguageServices(project);
        return services.stream().filter(el -> el instanceof TypeScriptCompilerService).map(el -> (TypeScriptCompilerService)el).collect(Collectors.toList());
    }

    public TypeScriptCompilerService(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(10);
        }
        this(project, "Console");
    }

    protected TypeScriptCompilerService(@NotNull Project project, @NotNull String consoleId) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(11);
        }
        if (consoleId == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(12);
        }
        super(project, consoleId);
    }

    public abstract void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean var1);

    @Nullable
    public abstract Future<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile var1);

    @Nullable
    public abstract Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull VirtualFile var1);

    public Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(13);
        }
        return this.compileConfigProjectAndGetErrors(config2.getConfigFile());
    }

    protected abstract void processVfsChangesForFiles(@NotNull Collection<UpdateFileInfo> var1);

    @Nullable
    public abstract Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> updateAndGetCompletionItems(@NotNull VirtualFile var1, @NotNull PsiFile var2, @NotNull Document var3, int var4);

    @Nullable
    public abstract Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> getDetailedCompletionItems(@NotNull VirtualFile var1, @NotNull List<TypeScriptCompletionResponse.CompletionEntryDetail> var2, @NotNull Document var3, int var4);

    @Nullable
    public abstract Future<Boolean> update(JSLanguageServiceUpdateContext var1);

    public abstract boolean isServiceEnabled(@NotNull VirtualFile var1);

    @Nls
    @NotNull
    public abstract String getStatusText();

    @NotNull
    public abstract CompletionMergeStrategy getCompletionMergeStrategy(@NotNull CompletionParameters var1, @Nullable PsiFile var2, @NotNull PsiElement var3);

    public abstract boolean isAcceptablePlaceForNavigation(@Nullable PsiElement var1);

    @NotNull
    public abstract JSLanguageServiceUpdateContext createUpdateContext(@Nullable VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultService";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServiceForFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restartServices";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processVfsChangesForFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processForServices";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAll";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compileConfigProjectAndGetErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CompletionMergeStrategy {
        MERGE,
        REPLACE,
        NON;

    }

    public static class UpdateFileInfo {
        @NotNull
        private final VirtualFile myFile;
        private final boolean myVfsChange;

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                UpdateFileInfo.$$$reportNull$$$0(0);
            }
            return virtualFile;
        }

        public boolean isVfsChange() {
            return this.myVfsChange;
        }

        public UpdateFileInfo(@NotNull VirtualFile file2, boolean vfsChange) {
            if (file2 == null) {
                UpdateFileInfo.$$$reportNull$$$0(1);
            }
            this.myFile = file2;
            this.myVfsChange = vfsChange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerService$UpdateFileInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerService$UpdateFileInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

