/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileWithConfigAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileCurrentFileAction
extends TypeScriptCompileWithConfigAction {
    public TypeScriptCompileCurrentFileAction() {
        super(JavaScriptBundle.message((String)"typescript.compiler.action.compile.current", (Object[])new Object[0]), null, null);
    }

    @Override
    protected VirtualFile[] getFiles(Project project, DataContext dataContext) {
        return FileEditorManager.getInstance((Project)project).getSelectedFiles();
    }

    @Override
    protected void logErrors(@NotNull JSLanguageServiceToolWindowManager manager2, @NotNull Collection<? extends JSAnnotationError> infos) {
        if (manager2 == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(0);
        }
        if (infos == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(1);
        }
        manager2.logProjectErrors((ImmutableList<JSAnnotationError>)ContainerUtil.immutableList(new ArrayList<JSAnnotationError>(infos)), true);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null || DumbService.isDumb((Project)project)) {
            return;
        }
        VirtualFile[] files = this.getFiles(project, e.getDataContext());
        if (files.length == 1 && TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(files[0].getFileType())) {
            VirtualFile file2 = files[0];
            String path = TypeScriptCompileCurrentFileAction.getPresentablePath(project, file2);
            e.getPresentation().setText(path);
            e.getPresentation().setEnabledAndVisible(true);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @NlsSafe
    @NotNull
    public static String getPresentablePath(Project project, VirtualFile file2) {
        String result2;
        VirtualFile dir = ProjectUtil.guessProjectDir((Project)project);
        String presentable = file2.getPresentableUrl();
        String string = result2 = dir == null ? presentable : (String)ObjectUtils.coalesce((Object)VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)dir), (Object)presentable);
        if (string == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    protected VirtualFile getConfigFile(@Nullable DataContext context) {
        return TypeScriptCompileCurrentFileAction.getTypeScriptConfigVirtualFile(context);
    }

    @Override
    @NotNull
    protected Consumer<ProgressIndicator> compileWithoutConfig(@NotNull Project project, @Nullable DataContext context) {
        if (project == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(4);
        }
        VirtualFile[] files = this.getFiles(project, context);
        Consumer consumer = indicator -> this.runCompile(project, (ProgressIndicator)indicator, files);
        if (consumer == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(5);
        }
        return consumer;
    }

    @Override
    protected boolean canUseOnlyConfigs(@NotNull Project project, TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptCompileCurrentFileAction.$$$reportNull$$$0(6);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompileCurrentFileAction";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompileCurrentFileAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "compileWithoutConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logErrors";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compileWithoutConfig";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canUseOnlyConfigs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

