/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.OnTheFlyLocalFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MakeMethodStaticFix
implements IntentionAction,
OnTheFlyLocalFix {
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"make.method.static", (Object[])new Object[0]);
        if (string == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(3);
        }
        MakeMethodStaticFix.invoke(descriptor2.getPsiElement());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(4);
        }
        if (editor != null) {
            PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
            return element != null && element.isValid() && PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class}) != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(5);
        }
        if (editor != null) {
            PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
            MakeMethodStaticFix.invoke(element);
        }
    }

    private static void invoke(@NotNull PsiElement element) {
        if (element == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(6);
        }
        JSFunction function2 = (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class});
        Collection usages = Collections.synchronizedCollection(new HashSet());
        ReferencesSearch.search((PsiElement)function2, (SearchScope)function2.getUseScope()).forEach(psiReference -> {
            PsiElement element1 = psiReference.getElement();
            if (!(element1 instanceof JSReferenceExpression)) {
                return true;
            }
            JSReferenceExpression refExpr = (JSReferenceExpression)element1;
            if (refExpr.getQualifier() == null) {
                return true;
            }
            usages.add(refExpr);
            return true;
        });
        ArrayList<Object> elementsToWrite = new ArrayList<Object>();
        elementsToWrite.add(element);
        elementsToWrite.addAll(usages);
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(elementsToWrite)) {
            return;
        }
        JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)function2);
        WriteAction.run(() -> {
            JSAttributeListWrapper wrapper = new JSAttributeListWrapper((JSAttributeListOwner)function2);
            wrapper.overrideModifier(JSAttributeList.ModifierType.STATIC, true);
            wrapper.overrideModifier(JSAttributeList.ModifierType.FINAL, false);
            wrapper.applyTo((JSAttributeListOwner)function2);
            ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
            HashSet<PsiFile> filesToOptimizeImports = new HashSet<PsiFile>();
            boolean actionScript = DialectDetector.isActionScript(element);
            for (JSReferenceExpression refExpr : usages) {
                JSClass currentClass = JSResolveUtil.getClassOfContext((PsiElement)refExpr);
                if (currentClass != null && currentClass.isEquivalentTo((PsiElement)clazz)) {
                    if (actionScript) {
                        JSRefactoringUtil.makeQualified(refExpr, null, false);
                        continue;
                    }
                    JSExpression qualifier = refExpr.getQualifier();
                    if (qualifier instanceof JSThisExpression) {
                        refExpr.deleteChildRange((PsiElement)qualifier, qualifier.getNextSibling());
                    }
                    JSRefactoringUtil.makeQualified(refExpr, (JSQualifiedNamedElement)clazz, true);
                    continue;
                }
                if (actionScript) {
                    if (ImportUtils.needsImport(JSResolveUtil.getPackageNameFromPlace((PsiElement)refExpr), (JSQualifiedNamedElement)clazz)) {
                        FormatFixer formatter = ImportUtils.insertImportStatements((PsiElement)refExpr, Collections.singletonList(clazz.getQualifiedName()));
                        ContainerUtil.addIfNotNull(formatters, (Object)formatter);
                    }
                    filesToOptimizeImports.add(refExpr.getContainingFile());
                }
                JSRefactoringUtil.makeQualified(refExpr, (JSQualifiedNamedElement)clazz, true);
            }
            for (PsiFile file2 : filesToOptimizeImports) {
                formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(file2));
            }
            FormatFixer.fixAll(formatters);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

