/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInsertCastFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String type;
    @IntentionFamilyName
    @NotNull
    private final String myMessage;

    public JSInsertCastFix(String type, @NotNull JSExpression expression) {
        if (expression == null) {
            JSInsertCastFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)expression);
        this.type = type;
        this.myMessage = JavaScriptBundle.message((String)(DialectDetector.isTypeScript((PsiElement)expression) ? "typescript.insert.cast.fix" : "javascript.insert.cast.fix"), (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSInsertCastFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = this.myMessage;
        if (string == null) {
            JSInsertCastFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String shortestTypeName;
        if (project == null) {
            JSInsertCastFix.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            JSInsertCastFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            JSInsertCastFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            JSInsertCastFix.$$$reportNull$$$0(6);
        }
        if (startElement instanceof JSLiteralExpression) {
            String literalType;
            JSLiteralExpression literalExpression = (JSLiteralExpression)startElement;
            JSType typ = JSResolveUtil.getExpressionJSType((JSExpression)literalExpression);
            String string = literalType = typ == null ? null : typ.getTypeText(JSType.TypeTextFormat.CODE);
            if (JSInsertCastFix.isNumericType(this.type) && "String".equals(literalType)) {
                return JSInsertCastFix.isValidNumber(StringUtil.unquoteString((String)literalExpression.getText()));
            }
        }
        return !DialectDetector.isTypeScript(startElement) || !TypeScriptUtil.hasAmbientExternalModuleInQName(this.type) || !TypeScriptUtil.hasAmbientExternalModuleInQName(shortestTypeName = this.getShortestType(startElement));
    }

    private static boolean isValidNumber(String text) {
        try {
            if (text.startsWith("0x") || text.startsWith("0X")) {
                Integer.parseInt(text.substring(2), 16);
            } else if (text.startsWith("0")) {
                Integer.parseInt(text, 8);
            } else {
                Double.parseDouble(text);
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSInsertCastFix.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            JSInsertCastFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            JSInsertCastFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            JSInsertCastFix.$$$reportNull$$$0(10);
        }
        PsiElement element = startElement;
        SmartPsiElementPointer p = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element);
        String shortenedType = this.getShortestType(element);
        element = p.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof JSLiteralExpression) {
            JSLiteralExpression literalExpression = (JSLiteralExpression)element;
            JSType type = JSResolveUtil.getExpressionJSType((JSExpression)literalExpression);
            String literalType = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
            String text = literalExpression.getText();
            if ("String".equals(shortenedType) && JSInsertCastFix.isNumericType(literalType)) {
                JSInsertCastFix.replaceElementWithText(element, "\"" + text + "\"");
                return;
            }
            if (JSInsertCastFix.isNumericType(shortenedType) && "String".equals(literalType)) {
                if (JSInsertCastFix.isValidNumber(text = StringUtil.unquoteString((String)text))) {
                    JSInsertCastFix.replaceElementWithText(element, text);
                }
                return;
            }
        }
        String castText = JSInsertCastFix.getCast(shortenedType, element.getText(), element);
        JSInsertCastFix.replaceElementWithText(element, castText);
    }

    private static boolean isNumericType(String literalType) {
        return "Number".equals(literalType) || "int".equals(literalType) || "uint".equals(literalType);
    }

    private static void replaceElementWithText(PsiElement element, String replacement) {
        element.replace((PsiElement)JSPsiElementFactory.createJSExpression(replacement, element));
    }

    @NotNull
    public static String getCast(@NotNull String type, @NotNull String expr, @NotNull PsiElement context) {
        DialectOptionHolder holder;
        if (type == null) {
            JSInsertCastFix.$$$reportNull$$$0(11);
        }
        if (expr == null) {
            JSInsertCastFix.$$$reportNull$$$0(12);
        }
        if (context == null) {
            JSInsertCastFix.$$$reportNull$$$0(13);
        }
        if ((holder = DialectDetector.dialectOfElement(context)) != null && holder.isTypeScript) {
            if (holder.isJSX() || JSCodeStyleSettings.getSettings((PsiElement)context).PREFER_AS_TYPE_CAST) {
                String string = expr + " as " + type;
                if (string == null) {
                    JSInsertCastFix.$$$reportNull$$$0(14);
                }
                return string;
            }
            String string = "<" + type + ">" + expr;
            if (string == null) {
                JSInsertCastFix.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = type + "(" + expr + ")";
        if (string == null) {
            JSInsertCastFix.$$$reportNull$$$0(16);
        }
        return string;
    }

    private String getShortestType(@NotNull PsiElement context) {
        if (context == null) {
            JSInsertCastFix.$$$reportNull$$$0(17);
        }
        if (DialectDetector.isTypeScript(context) && this.type != null) {
            return TypeScriptUtil.getShortestTypeNameInContext(this.type, context);
        }
        return (String)ImportUtils.importAndShortenReference((String)this.type, (PsiElement)context, (boolean)true, (boolean)true).first;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSInsertCastFix";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSInsertCastFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCast";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCast";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getShortestType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

