/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionCollector {
    private final Map<String, Object> functions = new LinkedHashMap<String, Object>();

    @NotNull
    public static JSFunctionCollector collectAllVisibleClassFunctions(@NotNull JSClass jsClass, @Nullable JSFunctionCollector _functions, final @Nullable Predicate<? super JSFunction> filter) {
        if (jsClass == null) {
            JSFunctionCollector.$$$reportNull$$$0(0);
        }
        final JSFunctionCollector functions = _functions != null ? _functions : new JSFunctionCollector();
        jsClass.processDeclarations((PsiScopeProcessor)new ResolveProcessor(null){
            {
                super(name);
                this.setToProcessHierarchy(true);
                this.setLocalResolve(true);
                this.setToProcessActionScriptImplicits(false);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof JSFunction) {
                    JSFunction function2 = (JSFunction)element;
                    if (function2.isConstructor()) {
                        return true;
                    }
                    if (filter != null && !filter.test(function2)) {
                        return true;
                    }
                    if (function2 instanceof TypeScriptFunction && ((TypeScriptFunction)function2).isOverloadDeclaration()) {
                        return true;
                    }
                    functions.add(function2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/validation/JSFunctionCollector$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ResolveState.initial(), (PsiElement)jsClass, (PsiElement)jsClass);
        JSFunctionCollector jSFunctionCollector = functions;
        if (jSFunctionCollector == null) {
            JSFunctionCollector.$$$reportNull$$$0(1);
        }
        return jSFunctionCollector;
    }

    @Nullable
    public JSFunction findFunctionWithTheSameKind(String name, JSFunction.FunctionKind kind) {
        Object candidate = this.functions.get(name);
        if (candidate instanceof JSFunction) {
            return ((JSFunction)candidate).getKind() == kind ? (JSFunction)candidate : null;
        }
        if (candidate instanceof JSFunction[]) {
            JSFunction[] jsFunctions;
            for (JSFunction fun : jsFunctions = (JSFunction[])candidate) {
                if (fun.getKind() != kind) continue;
                return fun;
            }
        }
        return null;
    }

    public void add(@NotNull JSFunction function2) {
        String s;
        Object functionValue;
        if (function2 == null) {
            JSFunctionCollector.$$$reportNull$$$0(2);
        }
        if ((functionValue = this.functions.get(s = function2.getName())) == null) {
            this.functions.put(s, function2);
        } else if (functionValue instanceof JSFunction) {
            JSFunction oldFunction = (JSFunction)functionValue;
            if (this.findFunctionWithTheSameKind(s, function2.getKind()) == null) {
                this.functions.put(s, new JSFunction[]{oldFunction, function2});
            }
        }
    }

    public void removeFunctionByNameAndKind(String name, JSFunction.FunctionKind kind) {
        Object o = this.functions.get(name);
        if (o instanceof JSFunction && ((JSFunction)o).getKind() == kind) {
            this.functions.remove(name);
        } else if (o instanceof JSFunction[]) {
            JSFunction[] functions = (JSFunction[])o;
            this.functions.put(name, functions[0].getKind() == kind ? functions[1] : functions[0]);
        }
    }

    @NotNull
    public Collection<JSFunction> getFunctions() {
        ArrayList<JSFunction> result2 = new ArrayList<JSFunction>();
        for (Map.Entry<String, Object> entry : this.functions.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof JSFunction[]) {
                ContainerUtil.addAll(result2, (Object[])((JSFunction[])value));
                continue;
            }
            result2.add((JSFunction)value);
        }
        ArrayList<JSFunction> arrayList = result2;
        if (arrayList == null) {
            JSFunctionCollector.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public boolean hasFunctionWithTheSameKind(String name, JSFunction.FunctionKind kind) {
        return this.findFunctionWithTheSameKind(name, kind) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSFunctionCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSFunctionCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllVisibleClassFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectAllVisibleClassFunctions";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

