/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui.newclass;

import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.CreateClassParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardModel
implements CreateClassParameters {
    private final PsiElement myContext;
    private final Module myModule;
    private final boolean myCreatingDependencyNotDependent;
    private String myClassName;
    private String myPackageName;
    private String myTemplateName;
    private PsiDirectory myTargetDirectory;
    private String mySuperclassFqn;
    private Collection<String> myInterfacesFqns;
    private final Map<String, Map<String, String>> myCustomTemplateAttributes;

    public WizardModel(@NotNull PsiElement context, boolean creatingDependencyNotDependent) {
        if (context == null) {
            WizardModel.$$$reportNull$$$0(0);
        }
        this.myCustomTemplateAttributes = new HashMap<String, Map<String, String>>();
        this.myContext = context;
        this.myCreatingDependencyNotDependent = creatingDependencyNotDependent;
        this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    public void setClassName(String className2) {
        this.myClassName = className2;
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    public void setPackageName(String packageName) {
        this.myPackageName = packageName;
    }

    @Override
    public String getTemplateName() {
        return this.myTemplateName;
    }

    public void setTemplateName(String templateName) {
        this.myTemplateName = templateName;
    }

    @Override
    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    @Override
    @Nullable
    public String getSuperclassFqn() {
        return this.mySuperclassFqn;
    }

    public void setSuperclassFqn(String superclassFqn) {
        this.mySuperclassFqn = superclassFqn;
    }

    @Override
    public Collection<String> getInterfacesFqns() {
        return this.myInterfacesFqns;
    }

    public void setInterfacesFqns(Collection<String> interfacesFqns) {
        this.myInterfacesFqns = interfacesFqns;
    }

    public void setCustomVariables(String templateName, Collection<String> customVariablesNames) {
        Map<String, String> map2 = this.myCustomTemplateAttributes.get(templateName);
        if (map2 == null) {
            map2 = new HashMap<String, String>();
            this.myCustomTemplateAttributes.put(templateName, map2);
        }
        map2.keySet().retainAll(customVariablesNames);
        for (String name : customVariablesNames) {
            if (map2.containsKey(name)) continue;
            map2.put(name, null);
        }
    }

    public Map<String, String> getCustomTemplateAttributes(String templateName) {
        return this.myCustomTemplateAttributes.get(templateName);
    }

    public void setCustomTemplateAttributes(String templateName, Map<String, String> map2) {
        this.myCustomTemplateAttributes.put(templateName, map2);
    }

    @Override
    public Map<String, String> getTemplateAttributes() {
        return this.myCustomTemplateAttributes.get(this.myTemplateName);
    }

    public boolean commit() {
        Pair<GlobalSearchScope, PsiDirectory> scopeAndBaseDir = this.getTargetClassScopeAndBaseDir();
        if (this.myContext instanceof PsiDirectory && this.getPackageName().equals(DirectoryIndex.getInstance((Project)this.myContext.getProject()).getPackageName(((PsiDirectory)this.myContext).getVirtualFile()))) {
            this.myTargetDirectory = (PsiDirectory)this.myContext;
            return true;
        }
        this.myTargetDirectory = JSRefactoringUtil.chooseOrCreateDirectoryForClass(this.myContext.getProject(), this.myModule, (GlobalSearchScope)scopeAndBaseDir.first, this.getPackageName(), this.getClassName(), (PsiDirectory)scopeAndBaseDir.second, ThreeState.UNSURE);
        return this.myTargetDirectory != null;
    }

    public Pair<GlobalSearchScope, PsiDirectory> getTargetClassScopeAndBaseDir() {
        if (this.myModule != null) {
            PsiDirectory baseDir = this.myContext instanceof PsiDirectory ? (PsiDirectory)this.myContext : PlatformPackageUtil.getDirectory((PsiElement)this.myContext);
            GlobalSearchScope scope = this.myCreatingDependencyNotDependent ? PlatformPackageUtil.adjustScope((PsiDirectory)baseDir, (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)this.myModule), (boolean)false, (boolean)true) : PlatformPackageUtil.adjustScope((PsiDirectory)baseDir, (GlobalSearchScope)GlobalSearchScope.moduleWithDependentsScope((Module)this.myModule), (boolean)true, (boolean)false);
            return Pair.create((Object)scope, (Object)baseDir);
        }
        return Pair.create((Object)GlobalSearchScope.projectScope((Project)this.myContext.getProject()), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ui/newclass/WizardModel", "<init>"));
    }
}

