/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.search.JSMemberSearchParameters;
import com.intellij.lang.javascript.search.JSMembersSearchImpl;
import com.intellij.util.Query;
import com.intellij.util.QueryFactory;

public final class JSMembersSearch {
    private static final QueryFactory<JSPsiElementBase, JSMemberSearchParameters<JSPsiElementBase>> OVERRIDDEN_MEMBERS_QUERY_FACTORY = new QueryFactory();
    private static final QueryFactory<JSPsiElementBase, JSMemberSearchParameters<JSPsiElementBase>> IMPLEMENTING_MEMBERS_QUERY_FACTORY = new QueryFactory();

    public static Query<JSPsiElementBase> searchOverridingMembers(JSPsiElementBase baseMember, boolean checkDeepInheritance) {
        JSMemberSearchParameters<JSPsiElementBase> parameters = new JSMemberSearchParameters<JSPsiElementBase>(baseMember, checkDeepInheritance);
        return OVERRIDDEN_MEMBERS_QUERY_FACTORY.createUniqueResultsQuery(parameters);
    }

    public static Query<JSPsiElementBase> searchImplementingMembers(JSPsiElementBase baseMember, boolean checkDeepInheritance) {
        JSMemberSearchParameters<JSPsiElementBase> parameters = new JSMemberSearchParameters<JSPsiElementBase>(baseMember, checkDeepInheritance);
        return IMPLEMENTING_MEMBERS_QUERY_FACTORY.createUniqueResultsQuery(parameters);
    }

    static {
        IMPLEMENTING_MEMBERS_QUERY_FACTORY.registerExecutor(new JSMembersSearchImpl.JSImplementingMembersSearch());
        OVERRIDDEN_MEMBERS_QUERY_FACTORY.registerExecutor(new JSMembersSearchImpl.JSOverridingMembersSearch());
    }
}

