/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.JSGetterSetterGenerationMode;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFunctionsRefactoringUtil {
    private JSFunctionsRefactoringUtil() {
    }

    public static JSFunction createGetter(@NotNull PsiElement context, @NotNull JSFunction sourceFunction, @NotNull String name, boolean isStatic) {
        if (context == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (sourceFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(1);
        }
        if (name == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(2);
        }
        JSFunction function2 = JSFunctionsRefactoringUtil.createAccessorInClassFromText(context, JSGetterSetterGenerationMode.Getter, name, isStatic, null, false);
        JSFunctionsRefactoringUtil.copyFunctionBody(sourceFunction, function2);
        return function2;
    }

    @NotNull
    public static JSFunction createAccessorInClassFromText(@NotNull PsiElement context, @NotNull JSGetterSetterGenerationMode generationMode, @NotNull String name, boolean isStatic, @Nullable String innerText, boolean withParameter) {
        if (context == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (generationMode == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(5);
        }
        assert (JSGetterSetterGenerationMode.Getter.equals((Object)generationMode) || JSGetterSetterGenerationMode.Setter.equals((Object)generationMode));
        String paramText = JSGetterSetterGenerationMode.Setter.equals((Object)generationMode) && withParameter ? "value" : "";
        String functionText = "class d{" + (isStatic ? "static " : "") + (JSGetterSetterGenerationMode.Getter.equals((Object)generationMode) ? "get " : "set ") + name + "(" + paramText + ")" + (innerText == null ? "{}" : innerText) + "}";
        JSClass aClass = JSPsiElementFactory.createJSClass(functionText, context);
        JSFunction function2 = (JSFunction)PsiTreeUtil.getChildOfType((PsiElement)aClass, JSFunction.class);
        assert (function2 != null);
        JSFunction jSFunction = function2;
        if (jSFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(6);
        }
        return jSFunction;
    }

    public static JSFunction createSetter(@NotNull PsiElement context, @NotNull JSFunction sourceFunction, @NotNull String name, boolean isStatic) {
        if (context == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(7);
        }
        if (sourceFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(9);
        }
        JSFunction function2 = JSFunctionsRefactoringUtil.createAccessorInClassFromText(context, JSGetterSetterGenerationMode.Setter, name, isStatic, null, false);
        JSFunctionsRefactoringUtil.copyParameters(sourceFunction, function2);
        JSFunctionsRefactoringUtil.copyFunctionBody(sourceFunction, function2);
        return function2;
    }

    @NotNull
    public static JSFunctionExpression createAnonymousFunctionExpression(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(10);
        }
        return JSFunctionsRefactoringUtil.createFunctionExpression(function2, "");
    }

    @NotNull
    public static JSFunctionProperty createFunctionProperty(@NotNull JSFunctionExpression sourceFunction, @NotNull String name) {
        if (sourceFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(11);
        }
        if (name == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(12);
        }
        String text = String.format("{%s %s (){}}", sourceFunction.isGenerator() ? "*" : "", name);
        JSObjectLiteralExpression result2 = JSPsiElementFactory.createJSExpression(text, (PsiElement)sourceFunction, JSObjectLiteralExpression.class);
        JSFunctionProperty property = (JSFunctionProperty)result2.getFirstProperty();
        assert (property != null);
        JSFunctionsRefactoringUtil.copyContent((JSFunction)sourceFunction, (JSFunction)property);
        JSFunctionProperty jSFunctionProperty = property;
        if (jSFunctionProperty == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(13);
        }
        return jSFunctionProperty;
    }

    @NotNull
    public static JSFunction createFunctionDeclaration(@NotNull JSFunctionExpression functionExpression, @NotNull String functionName) {
        if (functionExpression == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(14);
        }
        if (functionName == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(15);
        }
        String text = "function " + (functionExpression.isGenerator() ? "*" : "") + functionName + "(){}";
        JSFunction function2 = JSPsiElementFactory.createJSSourceElement(text, (PsiElement)functionExpression, JSFunction.class);
        JSFunctionsRefactoringUtil.copyContent((JSFunction)functionExpression, function2);
        JSFunction jSFunction = function2;
        if (jSFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(16);
        }
        return jSFunction;
    }

    @NotNull
    public static JSFunctionExpression createFunctionExpression(@NotNull JSFunction sourceFunction, @NotNull String name) {
        if (sourceFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(17);
        }
        if (name == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(18);
        }
        String text = "function " + (sourceFunction.isGenerator() ? "*" : "") + name + "(){}";
        JSFunctionExpression function2 = JSPsiElementFactory.createJSExpression(text, (PsiElement)sourceFunction, JSFunctionExpression.class);
        JSFunctionsRefactoringUtil.copyContent(sourceFunction, (JSFunction)function2);
        JSFunctionExpression jSFunctionExpression = function2;
        if (jSFunctionExpression == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(19);
        }
        return jSFunctionExpression;
    }

    @NotNull
    public static JSFunction createClassMember(@NotNull JSFunction sourceFunction, @NotNull String name) {
        if (sourceFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(20);
        }
        if (name == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(21);
        }
        String prefix = DialectDetector.isActionScript((PsiElement)sourceFunction) ? "function " : "";
        String text = prefix + name + (sourceFunction.isGenerator() ? "*" : "") + "(){}";
        JSFunction function2 = JSChangeUtil.createClassMemberPsiFromTextWithContext(text, (PsiElement)sourceFunction, JSFunction.class);
        assert (function2 != null);
        JSFunctionsRefactoringUtil.copyContent(sourceFunction, function2);
        JSFunction jSFunction = function2;
        if (jSFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(22);
        }
        return jSFunction;
    }

    private static void copyContent(@NotNull JSFunction source, @NotNull JSFunction destination) {
        if (source == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(23);
        }
        if (destination == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(24);
        }
        JSFunctionsRefactoringUtil.copyParameters(source, destination);
        JSFunctionsRefactoringUtil.copyFunctionBody(source, destination);
        JSFunctionsRefactoringUtil.copyModifiers(source, destination);
        JSFunctionsRefactoringUtil.copyFunctionReturnType(source, destination);
        JSFunctionsRefactoringUtil.copyGenericTypeParameters(source, destination);
    }

    public static void copyParameters(@NotNull JSFunction source, @NotNull JSFunction target) {
        if (source == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(25);
        }
        if (target == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(26);
        }
        if (source.getParameters().length > 0) {
            JSParameterList sourceParameterList = source.getParameterList();
            assert (sourceParameterList != null);
            assert (target.getParameterList() != null);
            if (JSFunctionsRefactoringUtil.noBracesAroundSingleParameter(sourceParameterList) && sourceParameterList.getParameters().length == 1) {
                if (JSFunctionsRefactoringUtil.noBracesAroundSingleParameter(target.getParameterList())) {
                    target.getParameterList().deleteChildRange(target.getParameterList().getFirstChild(), target.getParameterList().getLastChild());
                    target.getParameterList().add(sourceParameterList.getParameters()[0].copy());
                } else {
                    target.getParameterList().addAfter(sourceParameterList.getParameters()[0].copy(), target.getParameterList().getFirstChild());
                }
            } else {
                JSChangeUtil.replaceElement((JSElement)target.getParameterList(), (JSElement)sourceParameterList.copy());
            }
        }
    }

    public static boolean noBracesAroundSingleParameter(JSParameterList sourceParameterList) {
        return sourceParameterList.getParameters().length > 0 && sourceParameterList.getFirstChild() == sourceParameterList.getParameters()[0];
    }

    public static void copyFunctionBody(@NotNull JSFunction source, @NotNull JSFunction target) {
        JSBlockStatement targetBlock;
        if (source == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(27);
        }
        if (target == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(28);
        }
        if ((targetBlock = target.getBlock()) == null) {
            return;
        }
        JSFunctionsRefactoringUtil.copyFunctionBody(source, targetBlock);
    }

    public static JSBlockStatement copyFunctionBody(@NotNull JSFunction source, @NotNull JSBlockStatement targetBlock) {
        JSBlockStatement sourceBlock;
        if (source == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(29);
        }
        if (targetBlock == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(30);
        }
        if ((sourceBlock = source.getBlock()) != null) {
            return (JSBlockStatement)JSChangeUtil.replaceStatement((JSStatement)targetBlock, (JSStatement)((JSBlockStatement)sourceBlock.copy()));
        }
        JSExpression body = JSUtils.unparenthesize(JSPsiImplUtils.tryGetArrowFunctionReturnExpression(source));
        if (body != null) {
            String returnText = "return " + body.getText() + JSCodeStyleSettings.getSemicolon((PsiElement)source);
            JSReturnStatement statement = JSPsiElementFactory.createJSStatement(returnText, (PsiElement)source, JSReturnStatement.class);
            targetBlock.addAfter((PsiElement)statement, targetBlock.getFirstChild());
        }
        return targetBlock;
    }

    @NotNull
    public static JSFunctionExpression createArrowFunction(@NotNull JSFunction sourceFunction) {
        JSBlockStatement functionExpressionBody;
        String expressionBodyText;
        if (sourceFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(31);
        }
        String string = expressionBodyText = (functionExpressionBody = sourceFunction.getBlock()) != null ? JSFunctionsRefactoringUtil.getExpressionBodyText(functionExpressionBody) : null;
        if (expressionBodyText != null) {
            return JSFunctionsRefactoringUtil.createArrowFunctionWithSameParameters(sourceFunction, expressionBodyText);
        }
        JSFunctionExpression arrowFunction = JSFunctionsRefactoringUtil.createArrowFunctionWithSameParameters(sourceFunction, "{}");
        JSBlockStatement arrowFunctionBody = arrowFunction.getBlock();
        if (arrowFunctionBody != null && functionExpressionBody != null) {
            JSChangeUtil.replaceStatement((JSStatement)arrowFunctionBody, (JSStatement)functionExpressionBody);
        }
        JSFunctionExpression jSFunctionExpression = arrowFunction;
        if (jSFunctionExpression == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(32);
        }
        return jSFunctionExpression;
    }

    @Nullable
    private static String getExpressionBodyText(@NotNull JSBlockStatement block) {
        List children;
        if (block == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(33);
        }
        if ((children = PsiTreeUtil.getChildrenOfAnyType((PsiElement)block, (Class[])new Class[]{JSSourceElement.class, PsiComment.class})).size() == 1 && children.get(0) instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)children.get(0);
            JSExpression expression = returnStatement.getExpression();
            if (JSPsiImplUtils.parensAroundArrowFunctionBodyRequired(expression)) {
                return "(" + expression.getText() + ")";
            }
            if (expression != null) {
                return expression.getText();
            }
        }
        return null;
    }

    @NotNull
    private static JSFunctionExpression createArrowFunctionWithSameParameters(@NotNull JSFunction sourceFunction, @NotNull String bodyText) {
        JSParameterList parameterList;
        if (sourceFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(34);
        }
        if (bodyText == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(35);
        }
        boolean shortParameterSyntax = (parameterList = sourceFunction.getParameterList()) != null && !JSPsiImplUtils.parensAroundArrowFunctionParametersRequired(parameterList, sourceFunction);
        String text = String.format("%s => %s", shortParameterSyntax ? parameterList.getParameters()[0].getText() : parameterList.getText(), bodyText);
        JSFunctionExpression arrowFunction = JSPsiElementFactory.createJSExpression(text, (PsiElement)sourceFunction, JSFunctionExpression.class);
        assert (arrowFunction.getParameterList() != null);
        JSFunctionsRefactoringUtil.copyModifiers(sourceFunction, (JSFunction)arrowFunction);
        JSFunctionsRefactoringUtil.copyFunctionReturnType(sourceFunction, (JSFunction)arrowFunction);
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)sourceFunction);
        if (dialect != null && dialect.isTSX) {
            JSFunctionsRefactoringUtil.convertGenericArrowParameterForTSX(sourceFunction);
        }
        JSFunctionsRefactoringUtil.copyGenericTypeParameters(sourceFunction, (JSFunction)arrowFunction);
        if (!shortParameterSyntax) {
            JSChangeUtil.replaceElement((JSElement)arrowFunction.getParameterList(), (JSElement)parameterList);
        }
        JSFunctionExpression jSFunctionExpression = arrowFunction;
        if (jSFunctionExpression == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(36);
        }
        return jSFunctionExpression;
    }

    public static void convertGenericArrowParameterForTSX(@NotNull JSFunction sourceFunction) {
        TypeScriptTypeParameter[] typeParameters;
        if (sourceFunction == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(37);
        }
        if (sourceFunction instanceof TypeScriptTypeParameterListOwner && (typeParameters = ((TypeScriptTypeParameterListOwner)sourceFunction).getTypeParameters()).length == 1 && typeParameters[0].getTypeConstraint() == null) {
            TypeScriptTypeParameter typeParameter = typeParameters[0];
            String typeParameterReplacement = typeParameter.getName() + " extends any" + (String)(typeParameter.getDefault() != null ? " =" + typeParameter.getDefault().getText() : "");
            TypeScriptTypeParameter functionTypeParameter = JSFunctionsRefactoringUtil.createTypeParameterFromText(typeParameterReplacement, (PsiElement)typeParameter);
            typeParameter.replace((PsiElement)functionTypeParameter);
        }
    }

    private static void copyFunctionReturnType(@NotNull JSFunction source, @NotNull JSFunction destination) {
        PsiElement returnTypeElement;
        String returnTypeText;
        if (source == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(38);
        }
        if (destination == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(39);
        }
        String string = returnTypeText = (returnTypeElement = source.getReturnTypeElement()) != null ? returnTypeElement.getText() : null;
        if (StringUtil.isNotEmpty((String)returnTypeText)) {
            JSRefactoringUtil.setFunctionReturnType(destination, returnTypeText);
        }
    }

    private static void copyGenericTypeParameters(@NotNull JSFunction source, @NotNull JSFunction destination) {
        if (source == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(40);
        }
        if (destination == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(41);
        }
        if (source instanceof TypeScriptTypeParameterListOwner && destination instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)source).getTypeParameterList();
            JSParameterList destinationParameterList = destination.getParameterList();
            if (typeParameterList != null && destinationParameterList != null) {
                destinationParameterList.getParent().addBefore(typeParameterList.copy(), (PsiElement)destinationParameterList);
            }
        }
    }

    private static void copyModifiers(@NotNull JSFunction source, @NotNull JSFunction target) {
        if (source == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(42);
        }
        if (target == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(43);
        }
        if (target instanceof JSFunctionExpression || target instanceof JSFunctionProperty) {
            JSFunctionsRefactoringUtil.copyAsyncModifier(source, target);
        } else if (source instanceof JSFunctionExpression) {
            JSQualifiedNamedElement parent = ((JSFunctionExpression)source).getElementAssignedTo();
            if (parent instanceof JSAttributeListOwner) {
                JSFunctionsRefactoringUtil.copyAllAttributes((JSAttributeListOwner)parent, (JSAttributeListOwner)target);
            }
            JSFunctionsRefactoringUtil.copyAsyncModifier(source, target);
        } else {
            JSFunctionsRefactoringUtil.copyAllAttributes((JSAttributeListOwner)source, (JSAttributeListOwner)target);
        }
    }

    private static void copyAllAttributes(@NotNull JSAttributeListOwner source, @NotNull JSAttributeListOwner target) {
        if (source == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(44);
        }
        if (target == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(45);
        }
        new JSAttributeListWrapper(source).applyTo(target);
    }

    private static void copyAsyncModifier(@NotNull JSFunction source, @NotNull JSFunction target) {
        if (source == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(46);
        }
        if (target == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(47);
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper((JSAttributeListOwner)target);
        wrapper.overrideModifier(JSAttributeList.ModifierType.ASYNC, JSPsiImplUtils.hasModifier((JSAttributeListOwner)source, JSAttributeList.ModifierType.ASYNC));
        wrapper.applyTo((JSAttributeListOwner)target);
    }

    public static void moveNonFunctionAttributes(@NotNull JSFunction source, @NotNull JSAttributeListOwner target) {
        if (source == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(48);
        }
        if (target == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(49);
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper((JSAttributeListOwner)source);
        if (!(target instanceof JSFunction)) {
            wrapper.overrideModifier(JSAttributeList.ModifierType.ASYNC, false);
        }
        wrapper.applyTo(target);
    }

    @NotNull
    private static TypeScriptTypeParameter createTypeParameterFromText(String typeParameterReplacement, PsiElement context) {
        String genericTypeText = "function foo<" + typeParameterReplacement + ">(){}";
        TypeScriptFunction genericFunction = JSPsiElementFactory.createJSSourceElement(genericTypeText, context, TypeScriptFunction.class);
        TypeScriptTypeParameter[] genericFunctionTypeParameters = genericFunction.getTypeParameters();
        assert (genericFunctionTypeParameters.length > 0);
        TypeScriptTypeParameter typeScriptTypeParameter = genericFunctionTypeParameters[0];
        if (typeScriptTypeParameter == null) {
            JSFunctionsRefactoringUtil.$$$reportNull$$$0(50);
        }
        return typeScriptTypeParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 32: 
            case 36: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 32: 
            case 36: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 20: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFunction";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationMode";
                break;
            }
            case 6: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 32: 
            case 36: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/util/JSFunctionsRefactoringUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 24: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 26: 
            case 28: 
            case 43: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBlock";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/util/JSFunctionsRefactoringUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAccessorInClassFromText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionProperty";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionDeclaration";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionExpression";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassMember";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrowFunction";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrowFunctionWithSameParameters";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameterFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGetter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAccessorInClassFromText";
                break;
            }
            case 6: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 32: 
            case 36: 
            case 50: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSetter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAnonymousFunctionExpression";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionDeclaration";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionExpression";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createClassMember";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyContent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyParameters";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copyFunctionBody";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createArrowFunction";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionBodyText";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createArrowFunctionWithSameParameters";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "convertGenericArrowParameterForTSX";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "copyFunctionReturnType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "copyGenericTypeParameters";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "copyModifiers";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "copyAllAttributes";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "copyAsyncModifier";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "moveNonFunctionAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 32: 
            case 36: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AccessorsGenerator {
        @NotNull
        private final PsiElement myBaseElement;
        @NotNull
        private final String myName;
        private boolean myIsGetter;
        private String myQualifier;
        private String myBeforeText;
        private String myAfterText;
        private JSNamedElement myNamedElement;

        public AccessorsGenerator(@NotNull PsiElement baseElement, @NotNull String name) {
            if (baseElement == null) {
                AccessorsGenerator.$$$reportNull$$$0(0);
            }
            if (name == null) {
                AccessorsGenerator.$$$reportNull$$$0(1);
            }
            this.myIsGetter = true;
            this.myBaseElement = baseElement;
            this.myName = name;
        }

        public String generate() {
            this.myQualifier = this.myQualifier != null ? this.myQualifier + (JSUtils.isPrivateSharpItem((PsiElement)this.myNamedElement) ? ".#" : ".") : "";
            String semicolon = JSCodeStyleSettings.getSemicolon(this.myBaseElement);
            StringBuilder sb = new StringBuilder("{\n");
            if (this.myBeforeText != null) {
                sb.append(this.myBeforeText);
            }
            if (this.myIsGetter) {
                sb.append("return ");
                this.qualifiedName(sb).append(semicolon);
            } else {
                this.qualifiedName(sb).append("=").append("value").append(semicolon);
            }
            if (this.myAfterText != null) {
                sb.append(this.myAfterText);
            }
            sb.append("\n}");
            return sb.toString();
        }

        @NotNull
        private StringBuilder qualifiedName(StringBuilder sb) {
            if (this.myNamedElement instanceof JSDefinitionExpression && ((JSDefinitionExpression)this.myNamedElement).getExpression() instanceof JSIndexedPropertyAccessExpression) {
                StringBuilder stringBuilder = sb.append(this.myQualifier, 0, this.myQualifier.length() - 1).append(this.myName);
                if (stringBuilder == null) {
                    AccessorsGenerator.$$$reportNull$$$0(2);
                }
                return stringBuilder;
            }
            if (this.myQualifier.length() > 0) {
                if (this.myName.startsWith("[")) {
                    StringBuilder stringBuilder = sb.append(this.myQualifier, 0, this.myQualifier.length() - 1).append(this.myName);
                    if (stringBuilder == null) {
                        AccessorsGenerator.$$$reportNull$$$0(3);
                    }
                    return stringBuilder;
                }
                if (this.myName.startsWith("\"") || this.myName.startsWith("'")) {
                    StringBuilder stringBuilder = sb.append(this.myQualifier, 0, this.myQualifier.length() - 1).append("[").append(this.myName).append("]");
                    if (stringBuilder == null) {
                        AccessorsGenerator.$$$reportNull$$$0(4);
                    }
                    return stringBuilder;
                }
            }
            StringBuilder stringBuilder = sb.append(this.myQualifier).append(this.myName);
            if (stringBuilder == null) {
                AccessorsGenerator.$$$reportNull$$$0(5);
            }
            return stringBuilder;
        }

        public AccessorsGenerator setter() {
            this.myIsGetter = false;
            return this;
        }

        public AccessorsGenerator getter() {
            this.myIsGetter = true;
            return this;
        }

        public AccessorsGenerator setQualifier(String qualifier) {
            this.myQualifier = qualifier;
            return this;
        }

        public AccessorsGenerator setBeforeText(String beforeText) {
            this.myBeforeText = beforeText;
            return this;
        }

        public AccessorsGenerator setAfterText(String afterText) {
            this.myAfterText = afterText;
            return this;
        }

        public AccessorsGenerator setNamedElement(JSNamedElement namedElement) {
            this.myNamedElement = namedElement;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/util/JSFunctionsRefactoringUtil$AccessorsGenerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/util/JSFunctionsRefactoringUtil$AccessorsGenerator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "qualifiedName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

