/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.rename;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSGetterSetterRenameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInplaceRenameHandler
extends VariableInplaceRenameHandler {
    protected boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        return editor.getSettings().isVariableInplaceRenameEnabled() && JSInplaceRenameHandler.isValidContext(editor, file2) && JSInplaceRenameHandler.isSuitableForInplaceRename(element, file2);
    }

    public static boolean isSuitableForInplaceRename(@Nullable PsiElement element, @NotNull PsiFile file2) {
        if (file2 == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        if (element instanceof JSLabeledStatement) {
            return true;
        }
        return !(!(element instanceof JSNamedElement) || !JSInplaceRenameHandler.isOnlyLocallyUsed((JSNamedElement)element) || JavaScriptSupportLoader.isMxmlOrFxgFile(InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2)) || JSGetterSetterRenameUtil.isFieldWithAccessors(element) || element instanceof JSVariable && element.getParent() instanceof JSDestructuringShorthandedProperty || element instanceof JSFunction && ((JSFunction)element).isConstructor() && !DialectDetector.isActionScript(element));
    }

    private static boolean isOnlyLocallyUsed(@NotNull JSNamedElement element) {
        if (element == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(3);
        }
        return element.getUseScope() instanceof LocalSearchScope || JSInplaceRenameHandler.getEffectiveUseScopeIfGlobal(element) != null;
    }

    @Nullable
    private static PsiElement getEffectiveUseScopeIfGlobal(@NotNull JSNamedElement element) {
        if (element == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(4);
        }
        if (!JSUseScopeProvider.isLexicalScopeElement((PsiElement)element) || !DialectDetector.isJavaScript((PsiElement)element)) {
            return null;
        }
        String name = element.getName();
        if (name == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile baseFile = psiFile.getVirtualFile();
        if (baseFile == null) {
            return null;
        }
        return PsiSearchHelper.getInstance((Project)element.getProject()).processCandidateFilesForText((GlobalSearchScope)element.getUseScope(), (short)255, true, name, file2 -> baseFile.equals(file2)) ? psiFile : null;
    }

    private static boolean isValidContext(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiReference reference = file2.findReferenceAt(offset);
        if (reference instanceof JSLiteralTextReference || reference != null && !JSDefaultRenameProcessor.isStrictEnoughReference(reference)) {
            return false;
        }
        PsiElement element = file2.findElementAt(offset);
        return element != null && !JSInplaceRenameHandler.isForbiddenContextForInplace(element.getParent());
    }

    public static boolean isForbiddenContextForInplace(PsiElement parent) {
        return parent instanceof JSThisExpression || parent instanceof TypeScriptThisType || parent instanceof JSSuperExpression;
    }

    @Nullable
    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, @NotNull Editor editor) {
        if (elementToRename == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(6);
        }
        return new VariableInplaceRenamer((PsiNamedElement)((PsiNameIdentifierOwner)elementToRename), editor){
            private final Collection<Pair<PsiElement, TextRange>> myStringUsages;
            private boolean myDone;
            {
                this.myStringUsages = Collections.synchronizedList(new ArrayList());
                this.myDone = false;
            }

            protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
                LOG.assertTrue(!this.myDone);
                List<PsiReference> result2 = Collections.synchronizedList(new ArrayList());
                ReferencesSearch.search((PsiElement)this.myElementToRename, (SearchScope)referencesSearchScope).forEach(psiReference -> {
                    if (psiReference instanceof JSSuperExpression || psiReference instanceof JSThisExpression) {
                        return true;
                    }
                    if (JSDefaultRenameProcessor.isStrictEnoughReference(psiReference)) {
                        result2.add((PsiReference)psiReference);
                    } else {
                        this.myStringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)psiReference.getElement(), (Object)psiReference.getRangeInElement()));
                    }
                    return true;
                });
                return result2;
            }

            protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
                if (stringUsages == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.assertTrue(!this.myDone);
                stringUsages.addAll(this.myStringUsages);
                super.collectAdditionalElementsToRename(stringUsages);
            }

            public boolean performInplaceRename() {
                boolean result2 = super.performInplaceRename();
                this.myDone = true;
                return result2;
            }

            protected boolean buildTemplateAndStart(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile) {
                if (!JSDefaultRenameProcessor.collectShorthandPropertyUsages(refs).isEmpty()) {
                    return false;
                }
                boolean result2 = super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
                PsiElement container = PsiTreeUtil.getNonStrictParentOfType((PsiElement)scope, (Class[])new Class[]{PsiFile.class, JSEmbeddedContent.class});
                if (container != null) {
                    this.myLanguage = container.getLanguage();
                }
                return result2;
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element.getNode().getElementType() != JSTokenTypes.STRING_LITERAL) {
                    TextRange textRange = super.getRangeToRename(element);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return textRange;
                }
                if (!(element.getParent() instanceof JSRecordType.PropertySignature)) {
                    TextRange textRange = super.getRangeToRename(element);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return textRange;
                }
                TextRange textRange = JSReferenceUtil.getRangeWithoutQuotes(element);
                if (textRange == null) {
                    1.$$$reportNull$$$0(4);
                }
                return textRange;
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiReference reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (reference instanceof JSLiteralTextReference && ((JSLiteralTextReference)reference).isLiteralKeyReference()) {
                    TextRange textRange = JSReferenceUtil.getRangeWithoutQuotes(reference.getElement());
                    if (textRange == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return textRange;
                }
                TextRange textRange = super.getRangeToRename(reference);
                if (textRange == null) {
                    1.$$$reportNull$$$0(7);
                }
                return textRange;
            }

            @Nullable
            protected PsiElement checkLocalScope() {
                PsiElement localScope = super.checkLocalScope();
                if (localScope != null) {
                    return localScope;
                }
                if (this.myElementToRename instanceof JSNamedElement && this.myElementToRename.getUseScope() instanceof GlobalSearchScope) {
                    return JSInplaceRenameHandler.getEffectiveUseScopeIfGlobal((JSNamedElement)this.myElementToRename);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stringUsages";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/refactoring/rename/JSInplaceRenameHandler$1";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/refactoring/rename/JSInplaceRenameHandler$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeToRename";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "collectAdditionalElementsToRename";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangeToRename";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, final @NotNull Editor editor, final @Nullable DataContext dataContext) {
        if (elementToRename == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(8);
        }
        final Ref renamer = new Ref();
        RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)elementToRename);
        processor.substituteElementToRename(elementToRename, editor, (Pass)new Pass<PsiElement>(){

            public void pass(PsiElement substituted) {
                renamer.set((Object)JSInplaceRenameHandler.super.doRename(substituted, editor, dataContext));
            }
        });
        return (InplaceRefactoring)renamer.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/rename/JSInplaceRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableForInplaceRename";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isOnlyLocallyUsed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEffectiveUseScopeIfGlobal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenamer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

