/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.HighlightingUtils;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.ClassLevelIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseIntroduceHandler<T extends JSElement, S extends BaseIntroduceSettings, D extends JSBaseIntroduceDialog>
implements RefactoringActionHandler {
    protected static final Logger LOG = Logger.getInstance(JSBaseIntroduceHandler.class);
    @NotNull
    private final JSIntroduceTargetChooser<JSExpression> myIntroducedExpressionChooser;
    public static final JSIntroduceTargetChooser<JSExpression> DEFAULT_EXPRESSION_CHOOSER = (editor, elements, callback, presenter) -> callback.pass(ContainerUtil.getLastItem((List)elements));
    private static final String PLACEHOLDER = "_foobar_";

    public JSBaseIntroduceHandler() {
        this(ApplicationManager.getApplication().isUnitTestMode() ? DEFAULT_EXPRESSION_CHOOSER : IntroduceTargetChooser::showChooser);
    }

    public JSBaseIntroduceHandler(@NotNull JSIntroduceTargetChooser<JSExpression> introducedExpressionChooser) {
        if (introducedExpressionChooser == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(0);
        }
        this.myIntroducedExpressionChooser = introducedExpressionChooser;
    }

    protected boolean visitInnerFunctions() {
        return true;
    }

    @Nullable
    @NonNls
    public String getRefactoringId() {
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(1);
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)file2, editor, this.getRefactoringName())) {
            return;
        }
        String featureId = this.getProductivityFeatureId();
        if (featureId != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int start = editor.getSelectionModel().getSelectionStart();
        int end = editor.getSelectionModel().getSelectionEnd();
        List<Pair<JSExpression, TextRange>> candidates = this.getCandidateExpressions(editor, file2, start, end);
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        Consumer<JSExpression> callback = selectedExpression -> {
            Pair expressionDescriptor = (Pair)ContainerUtil.find((Iterable)candidates, e -> e.first == selectedExpression);
            if (expressionDescriptor == null || !this.validateSelectedExpression(file2, editor, (Pair<JSExpression, TextRange>)expressionDescriptor)) {
                return;
            }
            this.introduceWithExpression(editor, file2, (Pair<JSExpression, TextRange>)expressionDescriptor);
        };
        List expressions = ContainerUtil.map(candidates, jsExpressionTextRangePair -> (JSExpression)jsExpressionTextRangePair.getFirst());
        JSBaseIntroduceHandler.chooseElement(this.myIntroducedExpressionChooser, editor, expressions, callback, PsiElement::getText);
    }

    protected void afterIntroduce(boolean isInPlace, JSElement scope, Editor editor) {
    }

    public void introduceWithExpression(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(3);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(4);
        }
        NullableConsumer callback = scope -> {
            if (scope == null) {
                JSExpression expression = (JSExpression)expressionDescriptor.first;
                this.showErrorHint(editor, file2, JavaScriptBundle.message((String)(SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSPrefixExpression.class).filter(ES6PsiUtil::isAwaitExpression).isNotEmpty() ? "javascript.introduce.variable.arrow.await.referenced" : "javascript.introduce.variable.arrow.function.parameter.referenced"), (Object[])new Object[0]));
                return;
            }
            this.introduceWithScope(editor, expressionDescriptor, (JSElement)scope);
        };
        this.findIntroducedScope(editor, expressionDescriptor, (NullableConsumer<JSElement>)callback);
    }

    private void introduceWithScope(final @NotNull Editor editor, final @NotNull Pair<JSExpression, TextRange> expressionDescriptor, final @NotNull JSElement scope) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(5);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(7);
        }
        final Project project = ((JSExpression)expressionDescriptor.getFirst()).getProject();
        final JSExpression[] occurrences = this.findOccurrences(expressionDescriptor, scope);
        final boolean inplaceJavaScriptIntroduce = (this.canInplaceIntroduceForSubexpression() || !JSIntroducedExpressionUtil.willReplacePartOfExpression(expressionDescriptor)) && this.isInplaceIntroduce(editor, scope, ((JSExpression)expressionDescriptor.first).getContainingFile());
        Pass<OccurrencesChooser.ReplaceChoice> callback = new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                BaseIntroduceSettings settings;
                if (!JSBaseIntroduceHandler.this.doPreprocess(project, editor, (Pair<JSExpression, TextRange>)expressionDescriptor, scope)) {
                    return;
                }
                InplaceSettings inplaceSettings = JSBaseIntroduceHandler.this.getInplaceSettings((Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope, choice);
                BaseIntroduceSettings baseIntroduceSettings = settings = choice == null ? JSBaseIntroduceHandler.this.getSettings(project, editor, (Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope) : (BaseIntroduceSettings)inplaceSettings.getSettings();
                if (settings == null) {
                    return;
                }
                editor.getSelectionModel().removeSelection();
                BaseIntroduceContext<BaseIntroduceSettings> introduceContext = new BaseIntroduceContext<BaseIntroduceSettings>((Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope, settings);
                if (inplaceJavaScriptIntroduce) {
                    JSBaseInplaceIntroducer<BaseIntroduceSettings> introducer = JSBaseIntroduceHandler.this.createInplaceIntroducer(introduceContext, scope, editor, project, occurrences, () -> JSBaseIntroduceHandler.this.afterIntroduce(true, scope, editor));
                    introducer.startInplaceIntroduceTemplate();
                } else {
                    CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                        IntroduceInfo info = JSBaseIntroduceHandler.this.doRefactoring(project, editor, introduceContext, true);
                        JSBaseIntroduceHandler.this.performIntroduce(introduceContext);
                        JSBaseIntroduceHandler.this.afterInvoke(project, info);
                    }), JSBaseIntroduceHandler.this.getRefactoringName(), null);
                    JSBaseIntroduceHandler.this.afterIntroduce(false, scope, editor);
                }
            }
        };
        if (inplaceJavaScriptIntroduce) {
            LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap = new LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<JSExpression>>();
            occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList((JSExpression)expressionDescriptor.getFirst()));
            if (occurrences.length > 1) {
                occurrencesMap.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(occurrences));
            }
            this.chooseOccurrencesToReplace(editor, occurrencesMap, callback);
        } else {
            callback.pass(null);
        }
    }

    protected boolean canInplaceIntroduceForSubexpression() {
        return false;
    }

    protected JSExpression @NotNull [] findOccurrences(@NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull JSElement scope) {
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(9);
        }
        JSExpression[] jSExpressionArray = JSUtils.findExpressionOccurrences((PsiElement)scope, expressionDescriptor, this.visitInnerFunctions());
        if (jSExpressionArray == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(10);
        }
        return jSExpressionArray;
    }

    protected boolean isInplaceIntroduce(Editor editor, JSElement scope, PsiFile file2) {
        return (file2.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 || this instanceof JSIntroduceVariableHandler) && editor.getSettings().isVariableInplaceRenameEnabled();
    }

    protected void chooseOccurrencesToReplace(Editor editor, Map<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap, Pass<OccurrencesChooser.ReplaceChoice> callback) {
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser(callback, occurrencesMap);
    }

    protected abstract JSBaseInplaceIntroducer<S> createInplaceIntroducer(BaseIntroduceContext<S> var1, JSElement var2, Editor var3, Project var4, JSExpression[] var5, Runnable var6);

    protected boolean doPreprocess(Project project, Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull JSElement scope) {
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(12);
        }
        return true;
    }

    @Nullable
    protected String getProductivityFeatureId() {
        return null;
    }

    protected static String prependAccessModifier(BaseIntroduceContext<? extends BaseIntroduceSettings> baseIntroduceContext, String baseDeclText) {
        JSExpression expression;
        JSAttributeList.AccessType type;
        String accessText;
        Object settings = baseIntroduceContext.settings;
        if (settings instanceof ClassLevelIntroduceSettings && !StringUtil.isEmpty((String)(accessText = JSChangeVisibilityUtil.accessTypeToCodeString(type = ((ClassLevelIntroduceSettings)settings).getAccessType(), (PsiElement)(expression = (JSExpression)baseIntroduceContext.expressionDescriptor.first))))) {
            baseDeclText = accessText + " " + (String)baseDeclText;
        }
        return baseDeclText;
    }

    public static boolean introduceOverVariableNameRef(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof JSVariable && JSResolveUtil.isSelfReference(element);
    }

    public static boolean calcDependsOnContext(final PsiElement occurrence, final @Nullable TextRange range, final boolean okToAccessThis, final boolean okToAccessOccurrence) {
        if (occurrence == null) {
            return false;
        }
        final Ref localContextDependent = new Ref();
        occurrence.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext(node) && (range == null || range.contains(node.getTextRange()))) {
                    ResolveResult[] results = node.multiResolve(true);
                    if (results.length == 0) {
                        localContextDependent.set((Object)Boolean.TRUE);
                    } else {
                        PsiElement element = results[0].getElement();
                        if ((element instanceof JSVariable || element instanceof JSFunction) && !(JSResolveUtil.findParent(element) instanceof JSClass) && PsiTreeUtil.findCommonParent((PsiElement)element, (PsiElement)occurrence) != occurrence && (occurrence.getParent() != element || okToAccessOccurrence)) {
                            localContextDependent.set((Object)Boolean.TRUE);
                        }
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSThisExpression(JSThisExpression node) {
                if (!okToAccessThis && (range == null || range.contains(node.getTextRange()))) {
                    localContextDependent.set((Object)Boolean.TRUE);
                }
                super.visitJSThisExpression(node);
            }
        });
        return localContextDependent.get() == Boolean.TRUE;
    }

    protected static boolean containsAwaitExpressions(@Nullable JSExpression expression) {
        return SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSPrefixExpression.class).filter(ES6PsiUtil::isAwaitExpression).isNotEmpty();
    }

    protected static boolean containsYieldExpressions(@Nullable JSExpression expression) {
        return SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSYieldExpression.class).isNotEmpty();
    }

    public static void fixWhitespacesForParentheses(JSElement e) {
        PsiElement leaf = PsiTreeUtil.prevLeaf((PsiElement)e);
        if (JSBaseIntroduceHandler.canBeKeyword(leaf)) {
            e.getParent().addBefore(JSChangeUtil.createTokenElement(leaf, JSTokenTypes.WHITE_SPACE, " "), (PsiElement)e);
        }
        if (JSBaseIntroduceHandler.canBeKeyword(leaf = PsiTreeUtil.nextLeaf((PsiElement)e))) {
            e.getParent().addAfter(JSChangeUtil.createTokenElement(leaf, JSTokenTypes.WHITE_SPACE, " "), (PsiElement)e);
        }
    }

    protected void findIntroducedScope(@NotNull Editor editor, @NotNull Pair<? extends JSExpression, ? extends TextRange> expressionDescriptor, @NotNull NullableConsumer<? super JSElement> callback) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(13);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(14);
        }
        if (callback == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(15);
        }
        callback.consume((Object)this.getStatementScope(expressionDescriptor));
    }

    @Nullable
    private JSExecutionScope getStatementScope(Pair<? extends JSExpression, ? extends TextRange> expressionDescriptor) {
        JSExpression expression = (JSExpression)expressionDescriptor.first;
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)expression, JSExecutionScope.class);
        if (scope != null && scope.getNode().getElementType() == JSStubElementTypes.EMBEDDED_EXPRESSION) {
            return (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)scope.getParent(), JSExecutionScope.class);
        }
        if (scope instanceof JSFunctionExpression && (((JSFunctionExpression)scope).isShorthandArrowFunction() || scope.getName() == null)) {
            boolean hasAwait;
            JSParameter[] parameters = ((JSFunction)scope).getParameterVariables();
            THashSet parameterNames = new THashSet();
            for (JSParameter parameter : parameters) {
                String name = parameter.getName();
                if (name == null) continue;
                parameterNames.add((Object)name);
            }
            TextRange range = (TextRange)expressionDescriptor.second;
            boolean hasParamRefs = SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSReferenceExpression.class).filter(r -> r.getQualifier() == null && parameterNames.contains((Object)r.getReferenceName()) && (range == null || range.contains(r.getTextRange()))).isNotEmpty();
            boolean bl = hasAwait = ((JSFunctionExpression)scope).isAsync() && SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSPrefixExpression.class).filter(ES6PsiUtil::isAwaitExpression).isNotEmpty();
            return hasParamRefs ? this.getScopeWhenHavingParameterReferences(scope) : (hasAwait ? this.getScopeWhenHavingAwait(scope) : (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)scope, JSExecutionScope.class));
        }
        return scope;
    }

    protected JSExecutionScope getScopeWhenHavingParameterReferences(JSExecutionScope scope) {
        return scope;
    }

    protected JSExecutionScope getScopeWhenHavingAwait(JSExecutionScope scope) {
        return null;
    }

    @NlsContexts.DialogTitle
    @NotNull
    protected abstract String getRefactoringName();

    protected abstract String getCannotIntroduceMessagePropertyKey();

    protected abstract String getCannotIntroduceVoidExpressionTypeMessagePropertyKey();

    protected static boolean isIntroducingPartOfExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        return JSIntroducedExpressionUtil.isIntroducingPartOfExpression(expressionDescriptor);
    }

    @Nullable
    protected List<Pair<JSExpression, TextRange>> getCandidateExpressions(@NotNull Editor editor, @NotNull PsiFile file2, int start, int end) {
        List<Pair<JSExpression, TextRange>> candidates;
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(17);
        }
        if ((candidates = JSIntroducedExpressionUtil.findExpressionsInRange(file2, start, end)) == null || candidates.isEmpty()) {
            this.showDefaultErrorHint(editor, file2);
            return null;
        }
        if (ActionScriptResolveUtil.isInsideAnonymousEventHandler((PsiElement)candidates.get((int)0).first)) {
            return null;
        }
        return candidates;
    }

    protected boolean validateSelectedExpression(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        PsiElement expressionParent;
        JSExpression expression;
        JSType jsType;
        if (file2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(19);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(20);
        }
        if ((jsType = JSResolveUtil.getExpressionJSType(expression = (JSExpression)expressionDescriptor.first)) instanceof JSVoidType) {
            this.showErrorHint(editor, file2, JavaScriptBundle.message((String)this.getCannotIntroduceVoidExpressionTypeMessagePropertyKey(), (Object[])new Object[0]));
            return false;
        }
        if (SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSThrowExpression.class).isNotEmpty()) {
            this.showErrorHint(editor, file2, JavaScriptBundle.message((String)"javascript.introduce.throw.expressions.unsupported", (Object[])new Object[0]));
            return false;
        }
        if (expression instanceof JSBinaryExpression && JSIntroducedExpressionUtil.willReplacePartOfExpression(expressionDescriptor) && expressionDescriptor.second != null) {
            TextRange range = ((TextRange)expressionDescriptor.second).shiftLeft(expression.getTextOffset());
            String introducedExpressionText = range.substring(expression.getText());
            String expressionTextBefore = expression.getText().substring(0, range.getStartOffset());
            String expressionTextAfter = expression.getText().substring(range.getEndOffset());
            JSExpression firstExpression = JSPsiElementFactory.createJSExpression(expressionTextBefore + PLACEHOLDER + expressionTextAfter, (PsiElement)expression);
            JSExpression secondExpression = JSPsiElementFactory.createJSExpression(introducedExpressionText, (PsiElement)expression);
            if (JSBaseIntroduceHandler.hasSyntaxErrors(firstExpression) || JSBaseIntroduceHandler.hasSyntaxErrors(secondExpression)) {
                this.showErrorHint(editor, file2, JavaScriptBundle.message((String)this.getCannotIntroduceMessagePropertyKey(), (Object[])new Object[0]));
                return false;
            }
            JSReferenceExpression first = (JSReferenceExpression)SyntaxTraverser.psiTraverser((PsiElement)firstExpression).filter(JSReferenceExpression.class).filter(r -> PLACEHOLDER.equals(r.getReferenceName())).first();
            if (first == null || JSParenthesesUtils.needsParenthesis((JSExpression)first, secondExpression, true)) {
                this.showErrorHint(editor, file2, JavaScriptBundle.message((String)"javascript.introduce.breaks.operator.precedence", (Object[])new Object[0]));
                return false;
            }
        }
        if ((expressionParent = expression.getParent()) instanceof JSEmbeddedContent && expressionParent.getParent() == expression.getContainingFile()) {
            this.showErrorHint(editor, file2, JavaScriptBundle.message((String)"javascript.introduce.in.embedded.expression", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean hasSyntaxErrors(JSExpression firstExpression) {
        return SyntaxTraverser.psiTraverser((PsiElement)firstExpression).filter(PsiErrorElement.class).isNotEmpty();
    }

    protected abstract InplaceSettings<S> getInplaceSettings(Pair<JSExpression, TextRange> var1, JSExpression[] var2, PsiElement var3, OccurrencesChooser.ReplaceChoice var4);

    @Nullable
    protected S getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope) {
        ArrayList<RangeHighlighter> highlighters = null;
        if (occurrences.length > 1) {
            highlighters = HighlightingUtils.highlightOccurrences(project, editor, (PsiElement[])occurrences);
        }
        D dialog = this.createDialog(project, this.getReplacementExpression(expressionDescriptor), occurrences, scope);
        if (!this.isSilent()) {
            dialog.show();
        } else {
            ((JSBaseIntroduceDialog)dialog).doSilentOK();
        }
        if (highlighters != null) {
            for (RangeHighlighter highlighter : highlighters) {
                HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, highlighter);
            }
        }
        if (!this.isSilent() && dialog.getExitCode() != 0) {
            return null;
        }
        return (S)dialog;
    }

    protected boolean isSilent() {
        return false;
    }

    protected abstract D createDialog(Project var1, JSExpression var2, JSExpression[] var3, PsiElement var4);

    @Nullable
    protected Pair<BaseIntroduceContext<S>, T> adjustContext(@NotNull BaseIntroduceContext<S> introduceContext, @NotNull T anchorStatement, @NotNull Editor editor, @NotNull Project project) {
        if (introduceContext == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(21);
        }
        if (anchorStatement == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(22);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(23);
        }
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(24);
        }
        Pair<BaseIntroduceContext<S>, T> ctx = this.adjustParenthesizedOccurrences(introduceContext, anchorStatement, project, editor.getDocument());
        introduceContext = (BaseIntroduceContext)ctx.first;
        anchorStatement = (JSElement)ctx.second;
        PsiElement scope = introduceContext.scope;
        if (scope instanceof JSFunctionExpression && ((JSFunctionExpression)scope).isShorthandArrowFunction() && PsiTreeUtil.isAncestor(anchorStatement, (PsiElement)scope, (boolean)true)) {
            return this.adjustLambdaContext(introduceContext, editor, project, scope);
        }
        return Pair.create((Object)introduceContext, anchorStatement);
    }

    protected Pair<BaseIntroduceContext<S>, T> adjustParenthesizedOccurrences(@NotNull BaseIntroduceContext<S> introduceContext, T anchorStatement, Project project, Document document2) {
        if (introduceContext == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(25);
        }
        Pair<JSExpression, TextRange> descriptor2 = introduceContext.expressionDescriptor;
        TextRange relativeRange = descriptor2.second == null ? null : ((TextRange)descriptor2.second).shiftLeft(((JSExpression)descriptor2.first).getTextOffset());
        boolean modified = false;
        for (JSExpression occurrence : introduceContext.occurrences) {
            PsiElement leaf;
            IElementType rightLeaf;
            PsiElement leaf2;
            IElementType leftLeaf = PsiUtilCore.getElementType((PsiElement)JSPsiImplUtils.getFirstLeafChild((PsiElement)occurrence));
            if (JSBaseIntroduceHandler.isLeftPar(leftLeaf) && JSBaseIntroduceHandler.canBeKeyword(leaf2 = PsiTreeUtil.prevLeaf((PsiElement)occurrence))) {
                occurrence.getParent().addBefore(JSChangeUtil.createTokenElement(leaf2, JSTokenTypes.WHITE_SPACE, " "), (PsiElement)occurrence);
                modified = true;
            }
            if (!JSBaseIntroduceHandler.isRightPar(rightLeaf = PsiUtilCore.getElementType((PsiElement)JSPsiImplUtils.getLastLeafChild((PsiElement)occurrence))) || !JSBaseIntroduceHandler.canBeKeyword(leaf = PsiTreeUtil.nextLeaf((PsiElement)occurrence))) continue;
            occurrence.getParent().addAfter(JSChangeUtil.createTokenElement(leaf, JSTokenTypes.WHITE_SPACE, " "), (PsiElement)occurrence);
            modified = true;
        }
        if (!modified) {
            return Pair.create(introduceContext, anchorStatement);
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        return Pair.create(new BaseIntroduceContext((Pair<JSExpression, TextRange>)Pair.create((Object)((JSExpression)descriptor2.first), relativeRange == null ? null : relativeRange.shiftRight(((JSExpression)descriptor2.first).getTextOffset())), introduceContext.occurrences, introduceContext.scope, introduceContext.settings), anchorStatement);
    }

    private static boolean isRightPar(IElementType rightLeaf) {
        return rightLeaf == JSTokenTypes.RPAR || rightLeaf == JSTokenTypes.RBRACKET || rightLeaf == JSTokenTypes.RBRACE;
    }

    private static boolean isLeftPar(IElementType leftLeaf) {
        return leftLeaf == JSTokenTypes.LPAR || leftLeaf == JSTokenTypes.LBRACKET || leftLeaf == JSTokenTypes.LBRACE;
    }

    @Contract(value="null -> false")
    public static boolean canBeKeyword(@Nullable PsiElement leaf) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)leaf);
        return JSKeywordSets.ES6_RESERVED_WORDS.contains(elementType) || JSKeywordSets.TYPESCRIPT_SPECIAL_WORDS.contains(elementType) || JSKeywordSets.FLOW_SPECIAL_WORDS.contains(elementType);
    }

    @Nullable
    private Pair<BaseIntroduceContext<S>, T> adjustLambdaContext(@NotNull @NotNull @NotNull BaseIntroduceContext<S> introduceContext, @NotNull Editor editor, @NotNull Project project, PsiElement scope) {
        if (introduceContext == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(26);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(27);
        }
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(28);
        }
        Pair descriptor2 = introduceContext.expressionDescriptor;
        JSExpression expression = (JSExpression)descriptor2.first;
        List occurrences = Arrays.asList(introduceContext.occurrences);
        Document document2 = editor.getDocument();
        JSExpression returnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)scope);
        if (returnExpression == null) {
            return null;
        }
        TextRange rangeWithin = expression.getTextRange().shiftLeft(returnExpression.getTextOffset());
        boolean isFullyWithin = rangeWithin.getLength() == returnExpression.getTextRange().getLength();
        TextRange expressionFullRange = expression.getTextRange();
        List occurrenceRanges = ContainerUtil.map(occurrences, e -> e.getTextRange().shiftLeft(expressionFullRange.getStartOffset()));
        int scopeTextOffset = scope.getTextOffset();
        PsiFile file2 = scope.getContainingFile();
        String prefix = "{ return ";
        TextRange range = returnExpression.getTextRange();
        document2.insertString(range.getStartOffset(), (CharSequence)prefix);
        document2.insertString(range.getEndOffset() + prefix.length(), (CharSequence)(JSCodeStyleSettings.getSemicolon(scope) + "}"));
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        if (!scope.isValid()) {
            PsiElement at = file2.findElementAt(scopeTextOffset);
            JSFunctionExpression function2 = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)at, JSFunctionExpression.class);
            assert (function2 != null);
            scope = function2;
        }
        JSReturnStatement item = (JSReturnStatement)Objects.requireNonNull(((JSFunctionExpression)scope).getBlock()).getStatementListItems()[0];
        JSExpression newExpression = Objects.requireNonNull(item.getExpression());
        Set remappedRanges = ContainerUtil.map2Set((Collection)occurrenceRanges, r -> r.shiftRight(newExpression.getTextOffset()));
        TextRange shiftedRange = rangeWithin.shiftRight(newExpression.getTextOffset());
        expression = isFullyWithin ? newExpression : (JSExpression)SyntaxTraverser.psiTraverser((PsiElement)newExpression).filter(JSExpression.class).filter(e -> e.getTextRange().equals((Object)shiftedRange)).first();
        occurrences = SyntaxTraverser.psiTraverser((PsiElement)newExpression).filter(JSExpression.class).filter(e -> remappedRanges.contains(e.getTextRange())).toList();
        @NotNull JSReturnStatement anchorStatement = item;
        SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)expression);
        SmartPsiElementPointer anchorPointer = SmartPointerManager.createPointer((PsiElement)anchorStatement);
        List occurrencePointers = ContainerUtil.map((Collection)occurrences, o -> SmartPointerManager.createPointer((PsiElement)o));
        FormatFixer.create((PsiElement)((JSFunctionExpression)scope).getBlock(), FormatFixer.Mode.Reformat).fixFormat();
        expression = (JSExpression)pointer.getElement();
        anchorStatement = (JSElement)anchorPointer.getElement();
        occurrences = ContainerUtil.map((Collection)occurrencePointers, o -> (JSExpression)o.getElement());
        assert (expression != null);
        int diff = expression.getTextRange().getStartOffset() - expressionFullRange.getStartOffset();
        descriptor2 = Pair.create((Object)expression, descriptor2.second == null ? null : (diff >= 0 ? ((TextRange)descriptor2.second).shiftRight(diff) : ((TextRange)descriptor2.second).shiftLeft(-diff)));
        return Pair.create(new BaseIntroduceContext((Pair<JSExpression, TextRange>)descriptor2, (JSExpression[])ContainerUtil.toArray((Collection)occurrences, JSExpression[]::new), scope, introduceContext.settings), (Object)anchorStatement);
    }

    protected boolean isForExpressionStatement(Pair<JSExpression, TextRange> descriptor2, T sourceElement) {
        return ((JSExpression)descriptor2.first).getParent() instanceof JSExpressionStatement && sourceElement == ((JSExpression)descriptor2.first).getParent() && !JSBaseIntroduceHandler.isIntroducingPartOfExpression(descriptor2);
    }

    @Nullable
    IntroduceInfo doRefactoring(Project project, Editor editor, BaseIntroduceContext<S> introduceContext, boolean replaceExpressions) {
        Object settings = introduceContext.settings;
        boolean replaceAllOccurrences = settings.isReplaceAllOccurrences();
        PsiFile file2 = ((JSExpression)introduceContext.expressionDescriptor.first).getContainingFile();
        Object anchorStatement = this.findAnchor(introduceContext, replaceAllOccurrences);
        if (anchorStatement == null) {
            this.showErrorHint(editor, file2, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
            return null;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus(anchorStatement, editor, this.getRefactoringName())) {
            return null;
        }
        @NonNls Object varDeclText = this.getDeclText(introduceContext, anchorStatement);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        Pair<BaseIntroduceContext<S>, T> adjustedContext = this.adjustContext(introduceContext, anchorStatement, editor, project);
        if (adjustedContext == null) {
            this.showErrorHint(editor, file2, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
            return null;
        }
        introduceContext = (BaseIntroduceContext)adjustedContext.first;
        anchorStatement = (JSElement)adjustedContext.second;
        Pair<JSExpression, TextRange> descriptor2 = introduceContext.expressionDescriptor;
        JSExpression expression = (JSExpression)descriptor2.first;
        PsiElement scope = introduceContext.scope;
        List<JSExpression> occurrences = Arrays.asList(introduceContext.occurrences);
        JSRefactoringUtil.registerRefactoringUndo(project, this.getRefactoringId());
        this.beforeInvoke(project, introduceContext, expression);
        SmartPsiElementPointer expressionPointer = SmartPointerManager.createPointer((PsiElement)expression);
        JSIntroducedExpressionUtil.Replacer replacer = JSIntroducedExpressionUtil.createReplacer(descriptor2);
        String type = settings.getVariableType();
        if (type == null) {
            type = new BasicIntroducedEntityInfoProvider(expression, (JSExpression[])ContainerUtil.toArray(occurrences, (ArrayFactory)JSExpression.ARRAY_FACTORY), scope).evaluateType();
            if ((type = JSResolveUtil.getQualifiedTypeName(type)) == null) {
                type = JSClassUtils.getAnyTypeString((PsiElement)expression, true);
            }
        }
        if (DialectDetector.isActionScript((PsiElement)expression) && !JSBaseIntroduceHandler.isIntroducingPartOfExpression(descriptor2)) {
            type = (String)ImportUtils.importAndShortenReference((String)type, (PsiElement)expression, (boolean)true, (boolean)true).first;
        }
        if (this.shouldAddTypeAnnotation(expression, introduceContext.settings) && type != null) {
            varDeclText = (String)varDeclText + ":" + type;
        }
        boolean isForExpressionStatement = this.isForExpressionStatement(descriptor2, anchorStatement);
        JSLanguageDialect languageDialect = DialectDetector.languageDialectOfElement((PsiElement)expression);
        Pair<JSVarStatement, Boolean> preparedDeclarationStatus = this.prepareDeclaration((String)varDeclText, introduceContext, project, languageDialect, anchorStatement, editor);
        JSVarStatement declaration = (JSVarStatement)preparedDeclarationStatus.first;
        boolean replacedOriginal = (Boolean)preparedDeclarationStatus.second;
        SmartPsiElementPointer jsVariablePointer = null;
        SmartPsiElementPointer jsVarStatementPointer = null;
        SmartPsiElementPointer elementToFixFormat = null;
        String varName = null;
        if (!replacedOriginal) {
            JSVariable jsVariable = this.insertVariableDeclaration(anchorStatement, declaration, expression);
            varName = jsVariable.getName();
            PsiElement jsStatement = jsVariable.getParent();
            if (jsStatement instanceof JSVarStatement) {
                jsVarStatementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)((JSVarStatement)jsStatement));
            } else {
                jsVariablePointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)jsVariable);
            }
            elementToFixFormat = SmartPointerManager.createPointer((PsiElement)jsStatement);
        } else {
            jsVarStatementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)declaration);
        }
        JSExpression refExpr = this.createRefExpr((PsiElement)declaration, settings, scope, languageDialect);
        if (replaceExpressions && replaceAllOccurrences) {
            ArrayList<JSExpression> newOccurrences = new ArrayList<JSExpression>();
            for (JSExpression occurrence : occurrences) {
                JSExpression jsExpression;
                if (!(occurrence == expression && replacedOriginal || (jsExpression = JSBaseIntroduceHandler.replaceExpression(replacer, occurrence, refExpr)) == null)) {
                    if (occurrence == expression) {
                        expression = jsExpression;
                    }
                    newOccurrences.add(jsExpression);
                }
                occurrences = newOccurrences;
            }
            ArrayList<JSExpression> toHighlight = new ArrayList<JSExpression>(occurrences);
            ContainerUtil.addIfNotNull(toHighlight, (Object)declaration.getVariables()[0].getInitializer());
            HighlightingUtils.highlightOccurrences(project, editor, (PsiElement[])toHighlight.toArray(JSExpression.EMPTY_ARRAY));
        }
        if (!replaceAllOccurrences && !replacedOriginal) {
            int expressionIndex = occurrences.indexOf(expression);
            expression = JSBaseIntroduceHandler.replaceExpression(replacer, Objects.requireNonNull((JSExpression)expressionPointer.getElement()), refExpr);
            if (expressionIndex >= 0) {
                occurrences.set(expressionIndex, expression);
            }
            expressionPointer = expression != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)expression) : null;
        }
        List<SmartPsiElementPointer<JSExpression>> occurrencePointers = JSBaseIntroduceHandler.createPointers(smartPointerManager, occurrences);
        PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
        Document document2 = editor.getDocument();
        instance.doPostponedOperationsAndUnblockDocument(document2);
        instance.commitDocument(document2);
        if (elementToFixFormat != null) {
            JSBaseIntroduceHandler.fixFormat((SmartPsiElementPointer<? extends PsiElement>)elementToFixFormat, project, editor);
        }
        this.doPostprocess(declaration, settings, editor);
        JSVariable createdVar = null;
        if (jsVarStatementPointer != null) {
            JSVarStatement varStatement = (JSVarStatement)jsVarStatementPointer.getElement();
            if (varStatement != null) {
                String finalVarName = varName;
                JSVariable[] variables = varStatement.getVariables();
                createdVar = varName == null ? variables[0] : Arrays.stream(variables).filter(v -> finalVarName.equals(v.getName())).findFirst().orElse(variables[0]);
            }
        } else {
            createdVar = (JSVariable)jsVariablePointer.getElement();
        }
        JSExpression expressionElement = expressionPointer != null ? (JSExpression)expressionPointer.getElement() : null;
        JSBaseIntroduceHandler.moveExportDefaultDecorators(createdVar, expressionElement);
        return new IntroduceInfo(createdVar, expressionElement, JSBaseIntroduceHandler.derefPointers(occurrencePointers), isForExpressionStatement);
    }

    private void beforeInvoke(@NotNull Project project, @NotNull BaseIntroduceContext<S> introduceContext, @NotNull JSExpression expression) {
        String refactoringId;
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(29);
        }
        if (introduceContext == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(30);
        }
        if (expression == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(31);
        }
        if ((refactoringId = this.getRefactoringId()) != null) {
            RefactoringEventData eventData = new RefactoringEventData();
            eventData.addElement((PsiElement)expression);
            eventData.addElements((PsiElement[])introduceContext.occurrences);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, eventData);
        }
    }

    private void afterInvoke(@NotNull Project project, @Nullable IntroduceInfo info) {
        String refactoringId;
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(32);
        }
        if ((refactoringId = this.getRefactoringId()) != null && info != null) {
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement((PsiElement)info.createdVariable);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
        }
    }

    protected boolean shouldAddTypeAnnotation(JSExpression expression, S settings) {
        return DialectDetector.isActionScript((PsiElement)expression) || DialectDetector.isTypeScript((PsiElement)expression) && JSCodeStyleSettings.isPreferExplicitVariableTypes((PsiElement)expression);
    }

    private static void moveExportDefaultDecorators(JSVariable createdVar, JSExpression expressionElement) {
        JSExpression initializer;
        if (!(expressionElement instanceof JSReferenceExpression)) {
            return;
        }
        PsiElement parent = expressionElement.getParent();
        if (!(parent instanceof ES6ExportDefaultAssignment)) {
            return;
        }
        JSExpression jSExpression = initializer = createdVar == null ? null : createdVar.getInitializer();
        if (initializer instanceof JSClassExpression) {
            JSRefactoringUtil.copyDecorators((JSAttributeListOwner)((ES6ExportDefaultAssignment)parent), (JSAttributeListOwner)((JSClassExpression)initializer));
            JSAttributeList list2 = ((ES6ExportDefaultAssignment)parent).getAttributeList();
            if (list2 != null) {
                list2.delete();
            }
        }
    }

    private JSVariable insertVariableDeclaration(T anchorStatement, JSVarStatement declaration, JSExpression expression) {
        JSInitializerOwner[] allNewVariables = declaration.getDeclarations();
        if (anchorStatement instanceof JSVarStatement && allNewVariables.length == 1 && allNewVariables[0] instanceof JSVariable) {
            for (JSInitializerOwner owner : ((JSVarStatement)anchorStatement).getDeclarations()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)expression, (boolean)false)) continue;
                Set varNames = ContainerUtil.map2Set((Object[])((JSVarStatement)anchorStatement).getVariables(), v -> v.getName());
                if (!SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSReferenceExpression.class).filter(r -> r.getQualifier() == null && varNames.contains(r.getReferenceName())).isNotEmpty()) continue;
                PsiElement newComma = anchorStatement.addBefore(JSChangeUtil.createCommaPsiElement((PsiElement)expression), (PsiElement)owner);
                return (JSVariable)anchorStatement.addBefore(JSPsiElementFactory.createParameterOrVariableItem(allNewVariables[0].getText(), (PsiElement)expression, false, false), newComma);
            }
        }
        return this.addStatementBefore(anchorStatement, declaration);
    }

    @Nullable
    private static JSExpression replaceExpression(@NotNull JSIntroducedExpressionUtil.Replacer replacer, @NotNull JSExpression toReplace, @NotNull JSExpression refExpr) {
        if (replacer == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(33);
        }
        if (toReplace == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(34);
        }
        if (refExpr == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(35);
        }
        if (JSBaseIntroduceHandler.introduceOverVariableNameRef((PsiElement)toReplace)) {
            toReplace.getParent().delete();
            return null;
        }
        return replacer.replaceOccurrence(toReplace, refExpr);
    }

    @NotNull
    private static List<JSExpression> derefPointers(List<? extends SmartPsiElementPointer<JSExpression>> occurrencePointers) {
        List list2 = ContainerUtil.map(occurrencePointers, pointer -> (JSExpression)pointer.getElement());
        if (list2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(36);
        }
        return list2;
    }

    @NotNull
    private static List<SmartPsiElementPointer<JSExpression>> createPointers(SmartPointerManager smartPointerManager, List<? extends JSExpression> occurrences) {
        List list2 = ContainerUtil.mapNotNull(occurrences, occurrence -> occurrence.isValid() ? smartPointerManager.createSmartPsiElementPointer((PsiElement)occurrence) : null);
        if (list2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(37);
        }
        return list2;
    }

    public JSExpression createRefExpr(PsiElement context, S settings, PsiElement scope, JSLanguageDialect languageDialect) {
        return JSPsiElementFactory.createJSExpression(settings.getVariableName(), context);
    }

    protected static void fixFormat(@NotNull SmartPsiElementPointer<? extends PsiElement> jsStatement, @NotNull Project project, @Nullable Editor editor) {
        PsiElement element;
        if (jsStatement == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(38);
        }
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(39);
        }
        if (editor != null) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
        if ((element = jsStatement.getElement()) == null) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent != null) {
            CodeStyleManager.getInstance((Project)jsStatement.getProject()).reformatNewlyAddedElement(parent.getNode(), element.getNode());
        }
    }

    protected void doPostprocess(JSVarStatement declaration, S settings, Editor editor) {
    }

    public void performIntroduce(@NotNull BaseIntroduceContext<S> introduceContext) {
        if (introduceContext == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(40);
        }
    }

    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, BaseIntroduceContext<S> context, Project project, @Nullable JSLanguageDialect languageDialect, T anchorStatement, Editor editor) throws IncorrectOperationException {
        JSExpression initializerReplacementExpression = this.getReplacementExpression(context.expressionDescriptor);
        String text = varDeclText + (initializerReplacementExpression != null ? " = 0" : "") + JSBaseIntroduceHandler.getSemicolonWithStatementASI((JSElement)ObjectUtils.coalesce(anchorStatement, (Object)((JSElement)context.expressionDescriptor.first)), (JSExpression)context.expressionDescriptor.first, true);
        JSVarStatement declaration = JSPsiElementFactory.createJSStatement(text, (PsiElement)context.expressionDescriptor.first, JSVarStatement.class);
        this.replaceInitializer(initializerReplacementExpression, declaration);
        return Pair.create((Object)declaration, (Object)Boolean.FALSE);
    }

    protected static String getSemicolonWithStatementASI(JSElement anchorStatement, JSExpression expression, boolean checkAfter) {
        if (anchorStatement instanceof JSStatement) {
            String text;
            if (checkAfter && PsiTreeUtil.isAncestor((PsiElement)anchorStatement, (PsiElement)expression, (boolean)true)) {
                JSStatement nextStatement = (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)anchorStatement, JSStatement.class);
                if (nextStatement == null) {
                    return JSCodeStyleSettings.getSemicolon((PsiElement)anchorStatement);
                }
                anchorStatement = nextStatement;
            }
            if ((text = anchorStatement.getText()).startsWith("(") || text.startsWith("[")) {
                return ";";
            }
        }
        return JSCodeStyleSettings.getSemicolon((PsiElement)anchorStatement);
    }

    protected void replaceInitializer(JSExpression initializerReplacementExpression, JSVarStatement declaration) {
        JSVariable variable = declaration.getVariables()[0];
        JSExpression initializer = variable.getInitializer();
        if (initializer != null && initializerReplacementExpression != null) {
            initializer.replace(initializerReplacementExpression);
        }
    }

    protected JSExpression getReplacementExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        JSExpression jsExpression = (JSExpression)expressionDescriptor.first;
        if (!JSBaseIntroduceHandler.isIntroducingPartOfExpression(expressionDescriptor)) {
            Pair<JSExpression, TextRange> simplified = JSBaseIntroduceHandler.simplifyExpression(expressionDescriptor);
            if (simplified == expressionDescriptor) {
                return jsExpression;
            }
            expressionDescriptor = simplified;
        }
        String value = this.getIntroducedExpressionText(expressionDescriptor);
        JSVarStatement declaration = JSPsiElementFactory.createJSStatement("var xxx = " + value + JSCodeStyleSettings.getSemicolon((PsiElement)jsExpression), (PsiElement)jsExpression, JSVarStatement.class);
        return declaration.getVariables()[0].getInitializer();
    }

    protected String getIntroducedExpressionText(Pair<JSExpression, TextRange> expressionDescriptor) {
        return JSIntroducedExpressionUtil.createReplacer(expressionDescriptor).getIntroducedExpressionText();
    }

    public static Pair<JSExpression, TextRange> simplifyExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        JSExpression initial;
        if (JSIntroducedExpressionUtil.willReplacePartOfExpression(expressionDescriptor)) {
            return expressionDescriptor;
        }
        JSExpression expression = initial = (JSExpression)expressionDescriptor.first;
        while (expression instanceof JSParenthesizedExpression) {
            expression = ((JSParenthesizedExpression)expression).getInnerExpression();
        }
        if (expression != null && expression != initial) {
            return Pair.create((Object)expression, null);
        }
        return expressionDescriptor;
    }

    @NonNls
    protected String getDeclText(BaseIntroduceContext<S> baseIntroduceContext, T anchor) {
        return this.calcDeclText(baseIntroduceContext, "var", anchor);
    }

    protected String calcDeclText(BaseIntroduceContext<S> baseIntroduceContext, String s, T anchor) {
        boolean isStatic = JSResolveUtil.calculateStaticFromContext((PsiElement)this.getElementForContextTypeCheck(baseIntroduceContext, anchor));
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType(anchor, JSFunction.class);
        if (((String)s).length() > 0) {
            s = (String)s + " ";
        }
        return (isStatic && fun == null ? "static " : "") + (String)s + baseIntroduceContext.settings.getVariableName();
    }

    protected JSElement getElementForContextTypeCheck(BaseIntroduceContext<S> baseIntroduceContext, T anchor) {
        return (JSElement)baseIntroduceContext.expressionDescriptor.first;
    }

    protected JSVariable addStatementBefore(T anchor, JSVarStatement declaration) throws IncorrectOperationException {
        JSVarStatement statement = JSChangeUtil.addSourceElement((JSSourceElement)anchor, declaration, true);
        return statement.getVariables()[0];
    }

    protected T findAnchor(BaseIntroduceContext<S> context, boolean replaceAllOccurrences) {
        JSExpression[] jSExpressionArray;
        JSExpression expression = (JSExpression)context.expressionDescriptor.first;
        if (replaceAllOccurrences) {
            jSExpressionArray = context.occurrences;
        } else {
            JSExpression[] jSExpressionArray2 = new JSExpression[1];
            jSExpressionArray = jSExpressionArray2;
            jSExpressionArray2[0] = expression;
        }
        JSSourceElement anchorStatement = JSBaseIntroduceHandler.getAnchorToInsert(jSExpressionArray);
        return (T)anchorStatement;
    }

    @Nullable
    private static JSSourceElement getAnchorToInsert(JSExpression[] expressions) {
        JSSourceElement statement;
        JSExpression place = expressions[0];
        block0: while (true) {
            PsiElement statementAnchor;
            if ((statementAnchor = JSUtils.findStatementAnchor((PsiElement)place, true)) == null) {
                return null;
            }
            statement = statementAnchor instanceof JSSourceElement && !(statementAnchor instanceof JSExpression) ? (JSSourceElement)statementAnchor : JSUtils.findSourceAnchor(statementAnchor, DialectDetector.isActionScript((PsiElement)place));
            LOG.assertTrue(statement != null);
            PsiElement parent = statement.getParent();
            for (JSExpression expression : expressions) {
                if (PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)expression, (boolean)true) && !JSBaseIntroduceHandler.isOtherIfBranch(parent, expression, (JSElement)place)) continue;
                place = statement;
                continue block0;
            }
            break;
        }
        return statement;
    }

    private static boolean isOtherIfBranch(PsiElement parent, JSExpression expression, JSElement place) {
        if (parent instanceof JSIfStatement) {
            JSStatement then = ((JSIfStatement)parent).getThen();
            JSStatement anElse = ((JSIfStatement)parent).getElse();
            if (PsiTreeUtil.isAncestor((PsiElement)then, (PsiElement)expression, (boolean)false) && PsiTreeUtil.isAncestor((PsiElement)anElse, (PsiElement)place, (boolean)false)) {
                return true;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)anElse, (PsiElement)expression, (boolean)false) && PsiTreeUtil.isAncestor((PsiElement)then, (PsiElement)place, (boolean)false)) {
                return true;
            }
        }
        return false;
    }

    public static JSElement findClassAnchor(PsiElement expression) {
        PsiElement classRef;
        PsiElement anchor = PsiTreeUtil.findFirstParent((PsiElement)expression, e -> e != null && (e.getParent() instanceof JSClass || e.getParent() instanceof JSFile));
        if (!DialectDetector.isActionScript(expression)) {
            return (JSElement)anchor;
        }
        JSFunctionExpression functionExpression = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunctionExpression.class);
        if (!(anchor == null || functionExpression != null && ActionScriptResolveUtil.isAnonymousEventHandler(functionExpression))) {
            return (JSElement)anchor;
        }
        JSElement parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSFile.class, JSClass.class});
        if (parent instanceof JSFile && (classRef = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parent)) instanceof JSClass) {
            parent = (JSElement)classRef;
        }
        return parent;
    }

    protected static JSVariable addToClassAnchor(JSElement anchor, JSVarStatement declaration) throws IncorrectOperationException {
        JSVarStatement varStatement = anchor instanceof JSClass || anchor instanceof JSFile ? (JSVarStatement)anchor.add((PsiElement)declaration) : (JSVarStatement)anchor.getParent().addBefore((PsiElement)declaration, (PsiElement)anchor);
        return varStatement.getVariables()[0];
    }

    public static <TElement> void chooseElement(@NotNull JSIntroduceTargetChooser<TElement> chooser, @NotNull Editor editor, @NotNull List<? extends TElement> elements, final @NotNull Consumer<? super TElement> callback, @NotNull Function<? super TElement, String> presenter) {
        if (chooser == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(41);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(42);
        }
        if (elements == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(43);
        }
        if (callback == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(44);
        }
        if (presenter == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(45);
        }
        JSBaseIntroduceHandler.chooseElement(chooser, editor, elements, new Pass<TElement>(){

            public void pass(TElement element) {
                callback.accept(element);
            }
        }, presenter);
    }

    public static <TElement> void chooseElement(@NotNull JSIntroduceTargetChooser<TElement> chooser, @NotNull Editor editor, @NotNull List<? extends TElement> elements, @NotNull Pass<? super TElement> callback, @NotNull Function<? super TElement, String> presenter) {
        if (chooser == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(46);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(47);
        }
        if (elements == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(48);
        }
        if (callback == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(49);
        }
        if (presenter == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(50);
        }
        if (elements.isEmpty()) {
            return;
        }
        if (elements.size() == 1) {
            callback.pass(elements.get(0));
        } else {
            chooser.invoke(editor, elements, callback, presenter);
        }
    }

    protected void showDefaultErrorHint(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(51);
        }
        if (file2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(52);
        }
        this.showErrorHint(editor, file2, JavaScriptBundle.message((String)this.getCannotIntroduceMessagePropertyKey(), (Object[])new Object[0]));
    }

    protected void showErrorHint(@NotNull Editor editor, @NotNull PsiFile file2, @NlsContexts.DialogMessage @NotNull String message) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(53);
        }
        if (file2 == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(54);
        }
        if (message == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(55);
        }
        CommonRefactoringUtil.showErrorHint((Project)file2.getProject(), (Editor)editor, (String)message, (String)this.getRefactoringName(), null);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(56);
        }
        if (elements == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(57);
        }
        throw new RuntimeException("Not implemented");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedExpressionChooser";
                break;
            }
            case 1: 
            case 24: 
            case 28: 
            case 29: 
            case 32: 
            case 39: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 42: 
            case 47: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 17: 
            case 18: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler";
                break;
            }
            case 15: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 21: 
            case 25: 
            case 26: 
            case 30: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorStatement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacer";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsStatement";
                break;
            }
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 43: 
            case 48: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presenter";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findOccurrences";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "derefPointers";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "introduceWithExpression";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "introduceWithScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOccurrences";
                break;
            }
            case 10: 
            case 36: 
            case 37: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doPreprocess";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findIntroducedScope";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCandidateExpressions";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "validateSelectedExpression";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "adjustContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "adjustParenthesizedOccurrences";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "adjustLambdaContext";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "beforeInvoke";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "afterInvoke";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "fixFormat";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "performIntroduce";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "chooseElement";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "showDefaultErrorHint";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IntroduceInfo {
        final JSVariable createdVariable;
        final JSExpression expression;
        final List<JSExpression> occurrences;
        final boolean isFromExpressionStatement;

        public IntroduceInfo(JSVariable variable, JSExpression expression, List<JSExpression> occurrences, boolean isForExpressionStatement) {
            this.createdVariable = variable;
            this.expression = expression;
            this.occurrences = occurrences;
            this.isFromExpressionStatement = isForExpressionStatement;
        }
    }

    public static final class BaseIntroduceContext<S extends BaseIntroduceSettings> {
        public final S settings;
        public final JSExpression[] occurrences;
        public final PsiElement scope;
        public final Pair<JSExpression, TextRange> expressionDescriptor;

        public BaseIntroduceContext(Pair<JSExpression, TextRange> _mainOccurrence, JSExpression[] _occurrences, PsiElement _scope, S _settings) {
            this.occurrences = _occurrences;
            this.expressionDescriptor = _mainOccurrence;
            this.settings = _settings;
            this.scope = _scope;
        }
    }
}

