/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractSuperClassHandler
extends BaseJSRefactoringHandler {
    private final BiFunction<? super JSClass, ? super JSElement, ? extends RefactoringDialog> myDialogFactory;

    public JSExtractSuperClassHandler(BiFunction<? super JSClass, ? super JSElement, ? extends RefactoringDialog> dialogFactory) {
        super(JSExtractSuperClassHandler.getRefactoringName(), JSExtractSuperClassHandler.getCannotRefactorReason());
        this.myDialogFactory = dialogFactory;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(1);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        JSClass aClass = JSExtractSuperClassHandler.getClass(element);
        if (aClass != null) {
            if (aClass.isInterface()) {
                JSExtractSuperClassHandler.showErrorHint(project, dataContext, RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.interface"));
            } else if (aClass instanceof TypeScriptTypeAlias) {
                JSExtractSuperClassHandler.showErrorHint(project, dataContext, JavaScriptBundle.message((String)"superclass.cannot.be.extracted.from.type.alias", (Object[])new Object[0]));
            } else if (aClass instanceof TypeScriptEnum) {
                JSExtractSuperClassHandler.showErrorHint(project, dataContext, JavaScriptBundle.message((String)"superclass.cannot.be.extracted.from.enum", (Object[])new Object[0]));
            } else if (aClass instanceof XmlBackedJSClassImpl) {
                JSExtractSuperClassHandler.showErrorHint(project, dataContext, JavaScriptBundle.message((String)"superclass.cannot.be.extracted.from.mxml.component", (Object[])new Object[0]));
            } else {
                JSElement selected = element instanceof JSElement ? (JSElement)element : null;
                RefactoringDialog dialog = this.myDialogFactory.apply((JSClass)aClass, (JSElement)selected);
                dialog.show();
            }
        } else {
            JSExtractSuperClassHandler.showErrorHint(project, null, RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.interface"));
        }
    }

    private static void showErrorHint(@NotNull Project project, @Nullable DataContext data, @NlsContexts.DialogMessage @NotNull String message) {
        if (project == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(2);
        }
        if (message == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(3);
        }
        Editor editor = data != null ? (Editor)CommonDataKeys.EDITOR.getData(data) : null;
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JSExtractSuperClassHandler.getRefactoringName(), null);
    }

    @NlsContexts.DialogMessage
    @NotNull
    private static String getCannotRefactorReason() {
        String string = RefactoringBundle.message((String)"error.wrong.caret.position.class");
        if (string == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NlsContexts.DialogTitle
    @NotNull
    public static String getRefactoringName() {
        String string = RefactoringBundle.message((String)"extract.superclass.title");
        if (string == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperClassHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperClassHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCannotRefactorReason";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

