/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSChangeSignatureUtil {
    @Nullable
    public static FormatFixer setParameters(@NotNull JSFunction function2, MultiMap<JSParameter, UsageInfo> paramsUsages, JSChangeSignatureProcessor.RequiredImportProcessor importProcessor, JSLanguageDialect lang, JSParameterInfo ... parameters) {
        PsiElement prev;
        List<Object> newParameters;
        if (function2 == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JSParameterList oldParamList = function2.getParameterList();
        if (oldParamList == null) {
            return null;
        }
        for (JSParameterInfo p : parameters) {
            String type;
            if (!p.isNew()) {
                JSChangeSignatureProcessor.LOG.assertTrue(oldParamList.getParameters().length > p.getOldIndex());
                JSChangeSignatureUtil.rename(oldParamList.getParameters()[p.getOldIndex()], p.getDeclarationText(), paramsUsages);
            }
            if (!(!StringUtil.isNotEmpty((String)(type = p.getTypeText())) || p.isRest() && DialectDetector.isActionScript((PsiElement)function2))) {
                importProcessor.computeImportsForType(type, (PsiElement)function2);
            }
            if (!StringUtil.isNotEmpty((String)p.getInitializer())) continue;
            importProcessor.computeImportsForExpression(p.getInitializer(), (PsiElement)function2);
        }
        DialectOptionHolder holder = lang != null ? lang.getOptionHolder() : null;
        boolean isArrowFunction = function2.isArrowFunction();
        if (parameters.length > 0) {
            StringBuilder b = new StringBuilder("function dummy");
            JSChangeSignatureDialog.buildParameterListText(Arrays.asList(parameters), b, holder);
            b.append(";");
            JSFunction dummy = (JSFunction)JSChangeUtil.createJSTreeFromText(function2.getProject(), b.toString(), lang).getPsi();
            newParameters = Arrays.asList(dummy.getParameters());
        } else {
            newParameters = Collections.emptyList();
        }
        for (int i = 0; i < newParameters.size(); ++i) {
            if (i < oldParamList.getParameters().length) {
                oldParamList.getParameters()[i].replace((PsiElement)newParameters.get(i));
                continue;
            }
            if (i > 0) {
                PsiElement prevElement;
                if (isArrowFunction) {
                    oldParamList = JSChangeSignatureUtil.addParenthesesIfNeeded(oldParamList);
                }
                if ((prevElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)oldParamList.getLastChild())) == null || prevElement.getNode().getElementType() != JSTokenTypes.COMMA) {
                    oldParamList.addBefore(JSChangeUtil.createCommaPsiElement((PsiElement)oldParamList), oldParamList.getLastChild());
                }
            }
            oldParamList.addBefore((PsiElement)newParameters.get(i), oldParamList.getLastChild());
        }
        while (oldParamList.getParameters().length > newParameters.size()) {
            PsiElement prev2;
            JSParameterListElement parameter;
            JSParameterListElement removeFrom = parameter = oldParamList.getParameters()[newParameters.size()];
            while (removeFrom.getNode().getElementType() != JSTokenTypes.COMMA && (prev2 = removeFrom.getPrevSibling()) != null && prev2.getNode().getElementType() != JSTokenTypes.LPAR) {
                removeFrom = prev2;
            }
            oldParamList.deleteChildRange((PsiElement)removeFrom, (PsiElement)parameter);
        }
        if (isArrowFunction) {
            if (oldParamList.getParameters().length == 1) {
                boolean parensRequired = JSPsiImplUtils.parensAroundArrowFunctionParametersRequired(oldParamList, function2);
                oldParamList = !parensRequired ? JSChangeSignatureUtil.removeParentheses(oldParamList) : JSChangeSignatureUtil.addParenthesesIfNeeded(oldParamList);
            } else if (oldParamList.getParameters().length == 0) {
                oldParamList = JSChangeSignatureUtil.addParenthesesIfNeeded(oldParamList);
            }
        }
        for (int i = parameters.length - 1; i >= 0; --i) {
            if (!parameters[i].isOptional() || holder != null && JSChangeSignatureUtil.supportsDefaultParameterInitializer(lang)) continue;
            JSIntroduceParameterHandler.addOptionalParameterInitializer(function2, ((JSParameterListElement)newParameters.get(i)).getName(), parameters[i].getDefaultValue(), null);
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)function2);
        if (docComment instanceof JSDocComment) {
            JSChangeSignatureUtil.updateJSDocParameters(function2, (JSDocComment)docComment);
        }
        int startOffset = (prev = oldParamList.getPrevSibling()) != null ? prev.getTextRange().getStartOffset() : oldParamList.getTextRange().getStartOffset();
        int endOffset = oldParamList.getTextRange().getEndOffset();
        PsiFile file2 = function2.getContainingFile();
        return FormatFixer.create(file2, TextRange.create((int)startOffset, (int)endOffset), FormatFixer.Mode.ReformatExactRange);
    }

    private static void updateJSDocParameters(JSFunction newFunction, JSDocComment docComment) {
        int insertionIndex;
        JSDocumentationUtils.JSTagToParameterMap tagToParameterMap = JSDocumentationUtils.getTagToParameterMap(docComment, newFunction, null);
        Int2ObjectMap<JSParameterListElement> map2 = tagToParameterMap.getMatchedTags();
        IntArrayList currentTagOrder = new IntArrayList(map2.size());
        IntArrayList requiredTagOrder = new IntArrayList(map2.size());
        for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(map2)) {
            currentTagOrder.add(entry.getIntKey());
            requiredTagOrder.add(entry.getIntKey());
        }
        currentTagOrder.addAll(tagToParameterMap.getNonMatchedTags());
        if (tagToParameterMap.getRestDocTagIndex() != -1) {
            currentTagOrder.add(tagToParameterMap.getRestDocTagIndex());
        }
        currentTagOrder.sort(null);
        requiredTagOrder.sort((k1, k2) -> ((JSParameterListElement)map2.get(k1)).getTextOffset() - ((JSParameterListElement)map2.get(k2)).getTextOffset());
        ArrayList<Pair<Integer, String>> tagsToCreate = new ArrayList<Pair<Integer, String>>();
        IntOpenHashSet tagsToRemove = new IntOpenHashSet();
        int requiredTagOrderIndex = 0;
        JSDocTag[] tags = docComment.getTags();
        for (int currentTagOrderIndex = 0; currentTagOrderIndex < currentTagOrder.size(); ++currentTagOrderIndex) {
            if (requiredTagOrderIndex < requiredTagOrder.size() && currentTagOrder.getInt(currentTagOrderIndex) == requiredTagOrder.getInt(requiredTagOrderIndex)) {
                ++requiredTagOrderIndex;
                continue;
            }
            tagsToRemove.add(currentTagOrder.getInt(currentTagOrderIndex));
            for (int associatedTag = currentTagOrderIndex + 1; !map2.containsKey(associatedTag) && associatedTag < tags.length && "param".equals(tags[associatedTag].getName()); ++associatedTag) {
                tagsToRemove.add(associatedTag);
            }
        }
        int n = insertionIndex = currentTagOrder.isEmpty() ? 0 : currentTagOrder.getInt(currentTagOrder.size() - 1) + 1;
        while (requiredTagOrderIndex < requiredTagOrder.size()) {
            int requiredTagIndex = requiredTagOrder.getInt(requiredTagOrderIndex);
            JSDocTag requiredTag = tags[requiredTagIndex];
            tagsToCreate.add((Pair<Integer, String>)Pair.create((Object)insertionIndex, (Object)JSChangeSignatureUtil.getTagTextWithComment(requiredTag)));
            for (int associatedTag = requiredTagIndex + 1; !map2.containsKey(associatedTag) && associatedTag < tags.length && "param".equals(tags[associatedTag].getName()); ++associatedTag) {
                tagsToCreate.add((Pair<Integer, String>)Pair.create((Object)insertionIndex, (Object)JSChangeSignatureUtil.getTagTextWithComment(tags[associatedTag])));
            }
            ++requiredTagOrderIndex;
        }
        if (!tagsToRemove.isEmpty() || !tagsToCreate.isEmpty()) {
            JSDocumentationUtils.createOrUpdateTagsWithInsertionIndexes((PsiElement)docComment, tagsToCreate, null, (Set<Integer>)tagsToRemove);
        }
    }

    private static String getTagTextWithComment(JSDocTag requiredTag) {
        StringBuilder tagText = new StringBuilder(requiredTag.getText().substring(1));
        for (ASTNode node = requiredTag.getNode().getTreeNext(); node != null && (node.getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA || node.getElementType() == JSTokenTypes.WHITE_SPACE && node.getTreeNext() != null && node.getTreeNext().getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA); node = node.getTreeNext()) {
            tagText.append(node.getText());
        }
        return tagText.toString();
    }

    private static void rename(@NotNull JSParameterListElement parameter, @NotNull String newName, @NotNull MultiMap<JSParameter, UsageInfo> paramsUsages) {
        if (parameter == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(2);
        }
        if (paramsUsages == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (newName.equals(parameter.getName())) {
            return;
        }
        JSChangeSignatureUtil.updateDeclaration(parameter, newName);
        if (parameter instanceof JSParameter) {
            JSChangeSignatureUtil.rebindParameterUsages((JSParameter)parameter, newName, paramsUsages);
        }
    }

    private static void rebindParameterUsages(@NotNull JSParameter parameter, @NotNull String newName, @NotNull MultiMap<JSParameter, UsageInfo> paramsUsages) {
        if (parameter == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(5);
        }
        if (paramsUsages == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(6);
        }
        for (UsageInfo parameterUsage : paramsUsages.get((Object)parameter)) {
            if (parameterUsage.getElement() instanceof JSReferenceExpression) {
                ((JSReferenceExpression)parameterUsage.getElement()).bindToElement((PsiElement)parameter);
                continue;
            }
            if (parameterUsage.getReference() == null) continue;
            parameterUsage.getReference().handleElementRename(newName);
        }
    }

    private static void updateDeclaration(@NotNull JSParameterListElement parameter, @NotNull String newDeclarationText) {
        PsiElement declarationElement;
        if (parameter == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(7);
        }
        if (newDeclarationText == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(8);
        }
        if ((declarationElement = parameter.getDeclarationElement()) == null) {
            return;
        }
        JSFunction function2 = JSPsiElementFactory.createJSSourceElement("function(" + newDeclarationText + "){}", (PsiElement)parameter, JSFunction.class);
        if (function2.getParameters()[0].getDeclarationElement() == null) {
            return;
        }
        parameter.getDeclarationElement().replace(function2.getParameters()[0].getDeclarationElement());
    }

    @NotNull
    public static JSParameterList addParenthesesIfNeeded(@NotNull JSParameterList paramList) {
        if (paramList == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiElement lastChild = paramList.getLastChild();
        if (lastChild != null && lastChild.getNode().getElementType() == JSTokenTypes.RPAR) {
            JSParameterList jSParameterList = paramList;
            if (jSParameterList == null) {
                JSChangeSignatureUtil.$$$reportNull$$$0(10);
            }
            return jSParameterList;
        }
        String text = "function dummy(" + paramList.getText() + "){}";
        JSFunction root = JSPsiElementFactory.createJSSourceElement(text, (PsiElement)paramList, JSFunction.class);
        JSParameterList jSParameterList = (JSParameterList)paramList.replace((PsiElement)Objects.requireNonNull(root.getParameterList()));
        if (jSParameterList == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(11);
        }
        return jSParameterList;
    }

    @NotNull
    private static JSParameterList removeParentheses(@NotNull JSParameterList paramList) {
        if (paramList == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(12);
        }
        Object text = paramList.getText();
        text = StringUtil.trimStart((String)text, (String)"(");
        text = StringUtil.trimEnd((String)text, (String)")");
        text = "let dummy = " + (String)text + " => x";
        JSVarStatement root = JSPsiElementFactory.createJSStatement((String)text, (PsiElement)paramList, JSVarStatement.class);
        JSExpression initializer = root.getVariables()[0].getInitializer();
        JSParameterList jSParameterList = (JSParameterList)paramList.replace((PsiElement)((JSFunction)initializer).getParameterList());
        if (jSParameterList == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(13);
        }
        return jSParameterList;
    }

    private static boolean supportsDefaultParameterInitializer(@Nullable JSLanguageDialect lang) {
        if (lang == null) {
            return false;
        }
        DialectOptionHolder optionHolder = lang.getOptionHolder();
        return optionHolder.isTypeScript || optionHolder.isECMA6 || optionHolder.isECMA4;
    }

    @Nullable
    public static JSFunction getFunctionFromMember(@Nullable PsiElement element) {
        JSFunction possibleFunction = JSPsiImplUtils.getPossibleFunction(element);
        if (possibleFunction != null) {
            return possibleFunction;
        }
        if (element instanceof TypeScriptPropertySignature) {
            return (JSFunction)ObjectUtils.tryCast((Object)((TypeScriptPropertySignature)element).getTypeDeclaration(), TypeScriptFunctionType.class);
        }
        return null;
    }

    @NotNull
    public static JSQualifiedNamedElement getMemberFromFunction(@NotNull JSFunction method) {
        PsiElement parent;
        if (method == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(14);
        }
        if (method instanceof JSFunctionExpression) {
            JSQualifiedNamedElement namedElement = ((JSFunctionExpression)method).getElementAssignedTo();
            if (namedElement != null) {
                JSQualifiedNamedElement jSQualifiedNamedElement = namedElement;
                if (jSQualifiedNamedElement == null) {
                    JSChangeSignatureUtil.$$$reportNull$$$0(15);
                }
                return jSQualifiedNamedElement;
            }
        } else if (method instanceof TypeScriptFunctionType && (parent = method.getParent()) instanceof TypeScriptPropertySignature) {
            TypeScriptPropertySignature typeScriptPropertySignature = (TypeScriptPropertySignature)parent;
            if (typeScriptPropertySignature == null) {
                JSChangeSignatureUtil.$$$reportNull$$$0(16);
            }
            return typeScriptPropertySignature;
        }
        JSFunction jSFunction = method;
        if (jSFunction == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(17);
        }
        return jSFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramsUsages";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDeclarationText";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramList";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addParenthesesIfNeeded";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removeParentheses";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberFromFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rebindParameterUsages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addParenthesesIfNeeded";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeParentheses";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMemberFromFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

