/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.RecursionVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public final class RecursionUtils {
    private RecursionUtils() {
    }

    public static boolean statementMayReturnBeforeRecursing(JSStatement statement, JSFunction function2) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof JSBreakStatement || statement instanceof JSContinueStatement || statement instanceof JSThrowStatement || statement instanceof JSExpressionStatement || statement instanceof JSEmptyStatement || statement instanceof JSVarStatement) {
            return false;
        }
        if (statement instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)statement;
            JSExpression returnValue = returnStatement.getExpression();
            return returnValue == null || !RecursionUtils.expressionDefinitelyRecurses(returnValue, function2);
        }
        if (statement instanceof JSForStatement) {
            return RecursionUtils.forStatementMayReturnBeforeRecursing((JSForStatement)statement, function2);
        }
        if (statement instanceof JSForInStatement) {
            return RecursionUtils.foreachStatementMayReturnBeforeRecursing((JSForInStatement)statement, function2);
        }
        if (statement instanceof JSWhileStatement) {
            return RecursionUtils.whileStatementMayReturnBeforeRecursing((JSWhileStatement)statement, function2);
        }
        if (statement instanceof JSDoWhileStatement) {
            return RecursionUtils.doWhileStatementMayReturnBeforeRecursing((JSDoWhileStatement)statement, function2);
        }
        if (statement instanceof JSBlockStatement) {
            JSBlockStatement blockStatement = (JSBlockStatement)statement;
            return RecursionUtils.codeBlockMayReturnBeforeRecursing(blockStatement, function2, false);
        }
        if (statement instanceof JSLabeledStatement) {
            return RecursionUtils.labeledStatementMayReturnBeforeRecursing((JSLabeledStatement)statement, function2);
        }
        if (statement instanceof JSIfStatement) {
            return RecursionUtils.ifStatementMayReturnBeforeRecursing((JSIfStatement)statement, function2);
        }
        if (statement instanceof JSTryStatement) {
            return RecursionUtils.tryStatementMayReturnBeforeRecursing((JSTryStatement)statement, function2);
        }
        if (statement instanceof JSSwitchStatement) {
            return RecursionUtils.switchStatementMayReturnBeforeRecursing((JSSwitchStatement)statement, function2);
        }
        return true;
    }

    private static boolean doWhileStatementMayReturnBeforeRecursing(JSDoWhileStatement loopStatement, JSFunction function2) {
        JSStatement body = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body, function2);
    }

    private static boolean whileStatementMayReturnBeforeRecursing(JSWhileStatement loopStatement, JSFunction function2) {
        JSExpression test = loopStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(test, function2)) {
            return false;
        }
        JSStatement body = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body, function2);
    }

    private static boolean forStatementMayReturnBeforeRecursing(JSForStatement loopStatement, JSFunction function2) {
        JSExpression initialization = loopStatement.getInitialization();
        if (RecursionUtils.expressionDefinitelyRecurses(initialization, function2)) {
            return false;
        }
        JSExpression test = loopStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(test, function2)) {
            return false;
        }
        JSStatement body = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body, function2);
    }

    private static boolean foreachStatementMayReturnBeforeRecursing(JSForInStatement loopStatement, JSFunction function2) {
        JSExpression test = loopStatement.getCollectionExpression();
        if (RecursionUtils.expressionDefinitelyRecurses(test, function2)) {
            return false;
        }
        JSStatement body = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body, function2);
    }

    private static boolean switchStatementMayReturnBeforeRecursing(JSSwitchStatement switchStatement, JSFunction function2) {
        JSCaseClause[] clauses;
        for (JSCaseClause clause : clauses = switchStatement.getCaseClauses()) {
            JSSourceElement[] statements;
            for (JSSourceElement statement : statements = clause.getStatementListItems()) {
                if (!(statement instanceof JSStatement) || !RecursionUtils.statementMayReturnBeforeRecursing((JSStatement)statement, function2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryStatementMayReturnBeforeRecursing(JSTryStatement tryStatement, JSFunction function2) {
        JSStatement tryBlock;
        JSStatement finallyBlock = tryStatement.getFinallyStatement();
        if (finallyBlock != null) {
            if (RecursionUtils.statementMayReturnBeforeRecursing(finallyBlock, function2)) {
                return true;
            }
            if (RecursionUtils.statementDefinitelyRecurses(finallyBlock, function2)) {
                return false;
            }
        }
        if (RecursionUtils.statementMayReturnBeforeRecursing(tryBlock = tryStatement.getStatement(), function2)) {
            return true;
        }
        JSCatchBlock catchBlock = tryStatement.getCatchBlock();
        if (catchBlock == null) {
            return false;
        }
        JSStatement catchBlockStatement = catchBlock.getStatement();
        return RecursionUtils.statementMayReturnBeforeRecursing(catchBlockStatement, function2);
    }

    private static boolean ifStatementMayReturnBeforeRecursing(JSIfStatement ifStatement, JSFunction function2) {
        JSExpression test = ifStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(test, function2)) {
            return false;
        }
        JSStatement thenBranch = ifStatement.getThen();
        if (RecursionUtils.statementMayReturnBeforeRecursing(thenBranch, function2)) {
            return true;
        }
        JSStatement elseBranch = ifStatement.getElse();
        return elseBranch != null && RecursionUtils.statementMayReturnBeforeRecursing(elseBranch, function2);
    }

    private static boolean labeledStatementMayReturnBeforeRecursing(JSLabeledStatement labeledStatement, JSFunction function2) {
        JSStatement statement = labeledStatement.getStatement();
        return RecursionUtils.statementMayReturnBeforeRecursing(statement, function2);
    }

    private static boolean codeBlockMayReturnBeforeRecursing(JSBlockStatement block, JSFunction function2, boolean endsInImplicitReturn) {
        JSSourceElement[] statements;
        if (block == null) {
            return true;
        }
        for (JSSourceElement statement : statements = block.getStatementListItems()) {
            if (!(statement instanceof JSStatement)) continue;
            if (RecursionUtils.statementMayReturnBeforeRecursing((JSStatement)statement, function2)) {
                return true;
            }
            if (!RecursionUtils.statementDefinitelyRecurses((JSStatement)statement, function2)) continue;
            return false;
        }
        return endsInImplicitReturn;
    }

    public static boolean functionMayRecurse(@NotNull JSFunction function2) {
        if (function2 == null) {
            RecursionUtils.$$$reportNull$$$0(0);
        }
        RecursionVisitor recursionVisitor = new RecursionVisitor(function2);
        function2.accept((PsiElementVisitor)recursionVisitor);
        return recursionVisitor.isRecursive();
    }

    private static boolean expressionDefinitelyRecurses(JSExpression exp, JSFunction function2) {
        if (exp == null) {
            return false;
        }
        if (exp instanceof JSCallExpression) {
            return RecursionUtils.functionCallExpressionDefinitelyRecurses((JSCallExpression)exp, function2);
        }
        if (exp instanceof JSAssignmentExpression) {
            return RecursionUtils.assignmentExpressionDefinitelyRecurses((JSAssignmentExpression)exp, function2);
        }
        if (exp instanceof JSArrayLiteralExpression) {
            return RecursionUtils.arrayInitializerExpressionDefinitelyRecurses((JSArrayLiteralExpression)exp, function2);
        }
        if (exp instanceof JSPrefixExpression) {
            return RecursionUtils.prefixExpressionDefinitelyRecurses((JSPrefixExpression)exp, function2);
        }
        if (exp instanceof JSPostfixExpression) {
            return RecursionUtils.postfixExpressionDefinitelyRecurses((JSPostfixExpression)exp, function2);
        }
        if (exp instanceof JSBinaryExpression) {
            return RecursionUtils.binaryExpressionDefinitelyRecurses((JSBinaryExpression)exp, function2);
        }
        if (exp instanceof JSConditionalExpression) {
            return RecursionUtils.conditionalExpressionDefinitelyRecurses((JSConditionalExpression)exp, function2);
        }
        if (exp instanceof JSParenthesizedExpression) {
            return RecursionUtils.parenthesizedExpressionDefinitelyRecurses((JSParenthesizedExpression)exp, function2);
        }
        if (exp instanceof JSReferenceExpression) {
            return RecursionUtils.referenceExpressionDefinitelyRecurses((JSReferenceExpression)exp, function2);
        }
        if (exp instanceof JSDefinitionExpression) {
            return RecursionUtils.expressionDefinitelyRecurses(((JSDefinitionExpression)exp).getExpression(), function2);
        }
        if (exp instanceof JSLiteralExpression || exp instanceof JSThisExpression) {
            return false;
        }
        return false;
    }

    private static boolean conditionalExpressionDefinitelyRecurses(JSConditionalExpression expression, JSFunction function2) {
        JSExpression condExpression = expression.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condExpression, function2)) {
            return true;
        }
        JSExpression thenExpression = expression.getThen();
        JSExpression elseExpression = expression.getElse();
        return RecursionUtils.expressionDefinitelyRecurses(thenExpression, function2) && RecursionUtils.expressionDefinitelyRecurses(elseExpression, function2);
    }

    private static boolean binaryExpressionDefinitelyRecurses(JSBinaryExpression expression, JSFunction function2) {
        JSExpression lhs = expression.getLOperand();
        if (RecursionUtils.expressionDefinitelyRecurses(lhs, function2)) {
            return true;
        }
        IElementType tokenType = expression.getOperationSign();
        if (JSTokenTypes.ANDAND.equals(tokenType) || JSTokenTypes.OROR.equals(tokenType)) {
            return false;
        }
        JSExpression rhs = expression.getROperand();
        return RecursionUtils.expressionDefinitelyRecurses(rhs, function2);
    }

    private static boolean arrayInitializerExpressionDefinitelyRecurses(JSArrayLiteralExpression expression, JSFunction function2) {
        JSExpression[] initializers;
        for (JSExpression initializer : initializers = expression.getExpressions()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(initializer, function2)) continue;
            return true;
        }
        return false;
    }

    private static boolean prefixExpressionDefinitelyRecurses(JSPrefixExpression expression, JSFunction function2) {
        JSExpression operand = expression.getExpression();
        return RecursionUtils.expressionDefinitelyRecurses(operand, function2);
    }

    private static boolean postfixExpressionDefinitelyRecurses(JSPostfixExpression expression, JSFunction function2) {
        JSExpression operand = expression.getExpression();
        return RecursionUtils.expressionDefinitelyRecurses(operand, function2);
    }

    private static boolean parenthesizedExpressionDefinitelyRecurses(JSParenthesizedExpression expression, JSFunction function2) {
        JSExpression innerExpression = expression.getInnerExpression();
        return RecursionUtils.expressionDefinitelyRecurses(innerExpression, function2);
    }

    private static boolean referenceExpressionDefinitelyRecurses(JSReferenceExpression expression, JSFunction function2) {
        if (JSPsiImplUtils.isGetterOrSetter((JSFunctionItem)function2) && RecursionUtils.processRefExpr(expression, function2)) {
            return true;
        }
        JSExpression qualifierExpression = expression.getQualifier();
        return qualifierExpression != null && RecursionUtils.expressionDefinitelyRecurses(qualifierExpression, function2);
    }

    private static boolean assignmentExpressionDefinitelyRecurses(JSAssignmentExpression assignmentExpression, JSFunction function2) {
        JSExpression rhs = assignmentExpression.getROperand();
        JSExpression lhs = assignmentExpression.getLOperand();
        return RecursionUtils.expressionDefinitelyRecurses(rhs, function2) || RecursionUtils.expressionDefinitelyRecurses(lhs, function2);
    }

    private static boolean functionCallExpressionDefinitelyRecurses(JSCallExpression exp, JSFunction function2) {
        JSExpression[] args;
        JSExpression functionExpression = exp.getMethodExpression();
        if (functionExpression instanceof JSReferenceExpression && RecursionUtils.processRefExpr((JSReferenceExpression)functionExpression, function2)) {
            return true;
        }
        if (RecursionUtils.expressionDefinitelyRecurses(functionExpression, function2)) {
            return true;
        }
        for (JSExpression arg : args = exp.getArguments()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(arg, function2)) continue;
            return true;
        }
        return false;
    }

    private static boolean processRefExpr(JSReferenceExpression reference, JSFunction function2) {
        PsiElement referent = reference.resolve();
        if (referent != null) {
            return referent.equals(function2);
        }
        JSExpression qualifier = reference.getQualifier();
        if (qualifier == null || qualifier instanceof JSThisExpression) {
            return reference.getText().equals(function2.getName());
        }
        return false;
    }

    private static boolean statementDefinitelyRecurses(JSStatement statement, JSFunction function2) {
        if (statement == null) {
            return false;
        }
        if (statement instanceof JSBreakStatement || statement instanceof JSContinueStatement || statement instanceof JSThrowStatement || statement instanceof JSEmptyStatement) {
            return false;
        }
        if (statement instanceof JSExpressionStatement) {
            JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
            JSExpression expression = expressionStatement.getExpression();
            return RecursionUtils.expressionDefinitelyRecurses(expression, function2);
        }
        if (statement instanceof JSVarStatement) {
            JSVariable[] declaredElements;
            JSVarStatement declaration = (JSVarStatement)statement;
            for (JSVariable variable : declaredElements = declaration.getVariables()) {
                JSExpression initializer = variable.getInitializer();
                if (!RecursionUtils.expressionDefinitelyRecurses(initializer, function2)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)statement;
            JSExpression returnValue = returnStatement.getExpression();
            return returnValue != null && RecursionUtils.expressionDefinitelyRecurses(returnValue, function2);
        }
        if (statement instanceof JSForStatement) {
            return RecursionUtils.forStatementDefinitelyRecurses((JSForStatement)statement, function2);
        }
        if (statement instanceof JSForInStatement) {
            return RecursionUtils.foreachStatementDefinitelyRecurses((JSForInStatement)statement, function2);
        }
        if (statement instanceof JSWhileStatement) {
            return RecursionUtils.whileStatementDefinitelyRecurses((JSWhileStatement)statement, function2);
        }
        if (statement instanceof JSDoWhileStatement) {
            return RecursionUtils.doWhileStatementDefinitelyRecurses((JSDoWhileStatement)statement, function2);
        }
        if (statement instanceof JSBlockStatement) {
            return RecursionUtils.codeBlockDefinitelyRecurses((JSBlockStatement)statement, function2);
        }
        if (statement instanceof JSLabeledStatement) {
            return RecursionUtils.labeledStatementDefinitelyRecurses((JSLabeledStatement)statement, function2);
        }
        if (statement instanceof JSIfStatement) {
            return RecursionUtils.ifStatementDefinitelyRecurses((JSIfStatement)statement, function2);
        }
        if (statement instanceof JSTryStatement) {
            return RecursionUtils.tryStatementDefinitelyRecurses((JSTryStatement)statement, function2);
        }
        if (statement instanceof JSSwitchStatement) {
            return RecursionUtils.switchStatementDefinitelyRecurses((JSSwitchStatement)statement, function2);
        }
        return false;
    }

    private static boolean switchStatementDefinitelyRecurses(JSSwitchStatement switchStatement, JSFunction function2) {
        JSExpression switchExpression = switchStatement.getSwitchExpression();
        return RecursionUtils.expressionDefinitelyRecurses(switchExpression, function2);
    }

    private static boolean tryStatementDefinitelyRecurses(JSTryStatement tryStatement, JSFunction function2) {
        JSStatement tryBlock = tryStatement.getStatement();
        if (RecursionUtils.statementDefinitelyRecurses(tryBlock, function2)) {
            return true;
        }
        JSStatement finallyBlock = tryStatement.getFinallyStatement();
        return RecursionUtils.statementDefinitelyRecurses(finallyBlock, function2);
    }

    private static boolean codeBlockDefinitelyRecurses(JSBlockStatement block, JSFunction function2) {
        JSSourceElement[] statements;
        if (block == null) {
            return false;
        }
        for (JSSourceElement statement : statements = block.getStatementListItems()) {
            if (!(statement instanceof JSStatement)) continue;
            if (RecursionUtils.statementDefinitelyRecurses((JSStatement)statement, function2)) {
                return true;
            }
            if (!RecursionUtils.statementMayReturnBeforeRecursing((JSStatement)statement, function2)) continue;
            return false;
        }
        return false;
    }

    private static boolean ifStatementDefinitelyRecurses(JSIfStatement ifStatement, JSFunction function2) {
        JSExpression condition = ifStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition, function2)) {
            return true;
        }
        JSStatement thenBranch = ifStatement.getThen();
        JSStatement elseBranch = ifStatement.getElse();
        if (thenBranch == null || elseBranch == null) {
            return false;
        }
        return RecursionUtils.statementDefinitelyRecurses(thenBranch, function2) && RecursionUtils.statementDefinitelyRecurses(elseBranch, function2);
    }

    private static boolean forStatementDefinitelyRecurses(JSForStatement forStatement, JSFunction function2) {
        JSExpression initialization = forStatement.getInitialization();
        if (RecursionUtils.expressionDefinitelyRecurses(initialization, function2)) {
            return true;
        }
        JSExpression condition = forStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition, function2)) {
            return true;
        }
        if (ControlFlowUtils.isTrue(condition)) {
            JSStatement body = forStatement.getBody();
            return RecursionUtils.statementDefinitelyRecurses(body, function2);
        }
        return false;
    }

    private static boolean foreachStatementDefinitelyRecurses(JSForInStatement foreachStatement, JSFunction function2) {
        JSExpression iteration = foreachStatement.getCollectionExpression();
        return RecursionUtils.expressionDefinitelyRecurses(iteration, function2);
    }

    private static boolean whileStatementDefinitelyRecurses(JSWhileStatement whileStatement, JSFunction function2) {
        JSExpression condition = whileStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition, function2)) {
            return true;
        }
        if (ControlFlowUtils.isTrue(condition)) {
            JSStatement body = whileStatement.getBody();
            return RecursionUtils.statementDefinitelyRecurses(body, function2);
        }
        return false;
    }

    private static boolean doWhileStatementDefinitelyRecurses(JSDoWhileStatement doWhileStatement, JSFunction function2) {
        JSStatement body = doWhileStatement.getBody();
        if (RecursionUtils.statementDefinitelyRecurses(body, function2)) {
            return true;
        }
        JSExpression condition = doWhileStatement.getCondition();
        return RecursionUtils.expressionDefinitelyRecurses(condition, function2);
    }

    private static boolean labeledStatementDefinitelyRecurses(JSLabeledStatement labeledStatement, JSFunction function2) {
        JSStatement body = labeledStatement.getStatement();
        return RecursionUtils.statementDefinitelyRecurses(body, function2);
    }

    public static boolean functionDefinitelyRecurses(@NotNull JSFunction function2) {
        if (function2 == null) {
            RecursionUtils.$$$reportNull$$$0(1);
        }
        return RecursionUtils.statementDefinitelyRecurses((JSStatement)function2.getBlock(), function2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "function";
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/RecursionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "functionMayRecurse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "functionDefinitelyRecurses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

