/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.psi.impl.ES6DecoratorDeclarationImpl;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierAliasBase;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierBase;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportedExportedDefaultBindingImpl;
import com.intellij.lang.ecmascript6.psi.impl.ES6NamespaceExportImpl;
import com.intellij.lang.ecmascript6.types.ES6ClassElementType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImportStatementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptPropertySignatureImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.types.JSEmbeddedContentElementType;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTreeUtil {
    private static final Logger LOG = Logger.getInstance(JSTreeUtil.class);

    public static boolean hasBlockScope(@NotNull TreeElement element) {
        if (element == null) {
            JSTreeUtil.$$$reportNull$$$0(0);
        }
        return JSExtendedLanguagesTokenSetProvider.VARIABLES.contains(element.getElementType()) && (JSVariableBaseImpl.hasBlockScope((ASTNode)element) || JSPsiImplUtils.isCatchParameter(element.getPsi()));
    }

    @NotNull
    private static JSScopeNamesUsages calcScopeNameUsage(final @NotNull CompositeElement scope) {
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(ScopeTypesHolder.isScopeNamesUsagesHolder((TreeElement)scope));
        final JSScopeNamesUsages result2 = new JSScopeNamesUsages();
        final ArrayDeque blocksStack = new ArrayDeque();
        IElementType type = scope.getElementType();
        if (JSElementTypes.CLASS_EXPRESSIONS.contains(type) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(type)) {
            ASTNode nameNode;
            ASTNode aSTNode = nameNode = JSElementTypes.FUNCTION_EXPRESSIONS.contains(type) ? JSPsiImplUtils.findNameIdentifierOfFunction((ASTNode)scope, true) : JSClassBase.findOwnNameIdentifier((ASTNode)scope);
            if (nameNode != null) {
                String name = JSPsiImplUtils.getNameFromIdentifier(nameNode);
                JSScopeDeclarationsAndAssignments declarationsAndAssignments = new JSScopeDeclarationsAndAssignments();
                declarationsAndAssignments.add(scope);
                result2.rootUsages.put(name, declarationsAndAssignments);
            }
        }
        scope.acceptTree((TreeElementVisitor)new RecursiveTreeElementWalkingVisitor(){

            public void visitLeaf(LeafElement leaf) {
            }

            protected void visitNode(TreeElement element) {
                String declaredName;
                if (element == scope) {
                    super.visitNode(element);
                    return;
                }
                IElementType type = element.getElementType();
                if (ScopeTypesHolder.BLOCK_SCOPE_TYPES.contains(type)) {
                    blocksStack.push(element);
                }
                if ((declaredName = JSTreeUtil.getDeclaredOrAssignedName(element)) != null) {
                    Map usages = result2.rootUsages;
                    if (JSTreeUtil.hasBlockScope(element) && !blocksStack.isEmpty()) {
                        usages = result2.blockUsages.computeIfAbsent((TreeElement)blocksStack.peek(), it -> new THashMap());
                    }
                    JSScopeDeclarationsAndAssignments declaredNameUsage = usages.computeIfAbsent((String)declaredName, it -> new JSScopeDeclarationsAndAssignments());
                    declaredNameUsage.add((CompositeElement)element);
                }
                if (!result2.hasES6ModuleElement && JSExtendedLanguagesTokenSetProvider.ES6_MODULE_IMPORTS_AND_EXPORTS.contains(type)) {
                    result2.hasES6ModuleElement = true;
                }
                if (ScopeTypesHolder.isScopeNamesUsagesHolder(element)) {
                    if (element instanceof CompositeElement) {
                        result2.directChildScopes.add((CompositeElement)element);
                    }
                    return;
                }
                super.visitNode(element);
            }

            protected void elementFinished(@NotNull ASTNode element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ScopeTypesHolder.BLOCK_SCOPE_TYPES.contains(element.getElementType())) {
                    TreeElement pop = (TreeElement)blocksStack.pop();
                    LOG.assertTrue(element == pop);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSTreeUtil$1", "elementFinished"));
            }
        });
        LOG.assertTrue(blocksStack.isEmpty());
        JSScopeNamesUsages jSScopeNamesUsages = result2;
        if (jSScopeNamesUsages == null) {
            JSTreeUtil.$$$reportNull$$$0(2);
        }
        return jSScopeNamesUsages;
    }

    public static boolean definesScope(@NotNull ASTNode element) {
        if (element == null) {
            JSTreeUtil.$$$reportNull$$$0(3);
        }
        return ScopeTypesHolder.SCOPE_TYPES.contains(element.getElementType()) || element.getTreeParent() == null;
    }

    public static boolean definedInScopeAndUp(@NotNull String name, @NotNull ASTNode scopeElement) {
        if (name == null) {
            JSTreeUtil.$$$reportNull$$$0(4);
        }
        if (scopeElement == null) {
            JSTreeUtil.$$$reportNull$$$0(5);
        }
        for (ASTNode parent = scopeElement; parent != null; parent = parent.getTreeParent()) {
            JSScopeDeclarationsAndAssignments declarationsAndAssignments;
            if (!JSTreeUtil.definesScope(parent) || !(declarationsAndAssignments = JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)parent)).hasDeclarationOrAssignment(false)) continue;
            return true;
        }
        return false;
    }

    public static void processDuplicateDeclarations(@NotNull PsiElement context, @NotNull JSResolveProcessor processor) {
        TreeElement contextNode;
        TreeElement scopeElement;
        if (context == null) {
            JSTreeUtil.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            JSTreeUtil.$$$reportNull$$$0(7);
        }
        if ((scopeElement = ScopeTypesHolder.getBlockOrScopeNamesUsagesHolder(contextNode = (TreeElement)context.getNode())) == null) {
            return;
        }
        TreeElement stopAt = ScopeTypesHolder.getScopeNamesUsagesHolder(contextNode);
        while (scopeElement != null) {
            if (JSTreeUtil.definesScope((ASTNode)scopeElement)) {
                JSTreeUtil.processDeclarationsInScope(scopeElement.getPsi(), scopeElement.getPsi(), processor, processor.getName(), false);
            }
            if (scopeElement == stopAt) break;
            scopeElement = scopeElement.getTreeParent();
        }
    }

    public static boolean processDeclarationsInScope(@NotNull PsiElement context, @NotNull PsiElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name, boolean includeParentScopes) {
        boolean startFromNearest;
        ASTNode node;
        if (context == null) {
            JSTreeUtil.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            JSTreeUtil.$$$reportNull$$$0(10);
        }
        if (context.getNode() == null) {
            if (!(context instanceof JSImplicitElement)) {
                Logger.getInstance(JSStubBasedPsiTreeUtil.class).error("Element without node " + context + ", isValid " + context.isValid());
                return true;
            }
            context = context.getParent();
        }
        if ((node = context.getNode()) == null) {
            return true;
        }
        boolean bl = startFromNearest = context != scope;
        if (includeParentScopes && name == null) {
            JSTreeUtil.processDeclarationsAndAssignmentsInScopeAndUp(null, scope.getNode(), (Processor<? super JSScopeDeclarationsAndAssignments>)((Processor)definitions -> definitions == null || definitions.processElements(node, processor, startFromNearest)));
            return true;
        }
        if (includeParentScopes) {
            return JSTreeUtil.processDeclarationsAndAssignmentsInScopeAndUp(name, scope.getNode(), (Processor<? super JSScopeDeclarationsAndAssignments>)((Processor)scopeDeclarationsAndAssignments -> scopeDeclarationsAndAssignments.processElements(node, processor, startFromNearest)));
        }
        return JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)scope.getNode()).processElements(node, processor, startFromNearest);
    }

    public static boolean processDeclarationsAndAssignmentsInScopeAndUp(@Nullable String name, @NotNull ASTNode scopeElement, @NotNull Processor<? super JSScopeDeclarationsAndAssignments> processor) {
        if (scopeElement == null) {
            JSTreeUtil.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            JSTreeUtil.$$$reportNull$$$0(12);
        }
        for (ASTNode parent = scopeElement; parent != null; parent = parent.getTreeParent()) {
            JSScopeDeclarationsAndAssignments declarationsAndAssignments;
            if (!JSTreeUtil.definesScope(parent) || !(declarationsAndAssignments = JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)parent)).hasDeclarationOrAssignment(true) || processor.process((Object)declarationsAndAssignments)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static JSScopeDeclarationsAndAssignments getDeclarationsAndAssignmentsInScopeAndUp(@NotNull String name, @NotNull ASTNode scopeElement) {
        if (name == null) {
            JSTreeUtil.$$$reportNull$$$0(13);
        }
        if (scopeElement == null) {
            JSTreeUtil.$$$reportNull$$$0(14);
        }
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        JSTreeUtil.processDeclarationsAndAssignmentsInScopeAndUp(name, scopeElement, (Processor<? super JSScopeDeclarationsAndAssignments>)processor);
        return (JSScopeDeclarationsAndAssignments)processor.getFoundValue();
    }

    @NotNull
    public static JSScopeDeclarationsAndAssignments getDeclarationsAndAssignmentsInScope(@Nullable String name, @NotNull CompositeElement scope) {
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(15);
        }
        assert (JSTreeUtil.definesScope((ASTNode)scope)) : scope.getElementType() + " doesn't provide scope";
        return JSTreeUtil.getDeclarationsAndAssignmentsInCodeBlockInner(scope, name);
    }

    @NotNull
    private static JSScopeDeclarationsAndAssignments getDeclarationsAndAssignmentsInCodeBlockInner(@NotNull CompositeElement scope, @Nullable String name) {
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(16);
        }
        Map<String, JSScopeDeclarationsAndAssignments> scopeNameUsage = JSTreeUtil.getScopeNameUsage(scope);
        if (name != null) {
            JSScopeDeclarationsAndAssignments assignments = scopeNameUsage.get(name);
            JSScopeDeclarationsAndAssignments jSScopeDeclarationsAndAssignments = assignments != null ? assignments : JSScopeDeclarationsAndAssignments.EMPTY;
            if (jSScopeDeclarationsAndAssignments == null) {
                JSTreeUtil.$$$reportNull$$$0(17);
            }
            return jSScopeDeclarationsAndAssignments;
        }
        JSScopeDeclarationsAndAssignments result2 = new JSScopeDeclarationsAndAssignments();
        for (JSScopeDeclarationsAndAssignments nameUsages : scopeNameUsage.values()) {
            result2.myElements.addAll(nameUsages.myElements);
        }
        JSScopeDeclarationsAndAssignments jSScopeDeclarationsAndAssignments = result2;
        if (jSScopeDeclarationsAndAssignments == null) {
            JSTreeUtil.$$$reportNull$$$0(18);
        }
        return jSScopeDeclarationsAndAssignments;
    }

    @NotNull
    private static Map<String, JSScopeDeclarationsAndAssignments> getScopeNameUsage(@NotNull CompositeElement scopeOrBlock) {
        if (scopeOrBlock == null) {
            JSTreeUtil.$$$reportNull$$$0(19);
        }
        CompositeElement baseScope = scopeOrBlock;
        if (ScopeTypesHolder.BLOCK_SCOPE_TYPES.contains(scopeOrBlock.getElementType())) {
            baseScope = ScopeTypesHolder.getScopeNamesUsagesHolder((TreeElement)scopeOrBlock);
        }
        if (!(baseScope instanceof CompositeElement)) {
            Map<String, JSScopeDeclarationsAndAssignments> map2 = Collections.emptyMap();
            if (map2 == null) {
                JSTreeUtil.$$$reportNull$$$0(20);
            }
            return map2;
        }
        CompositeElement scope = baseScope;
        JSScopeNamesUsages scopeNamesUsages = JSTreeUtil.getScopeNamesUsages(scope);
        Map<String, JSScopeDeclarationsAndAssignments> map3 = scope == scopeOrBlock ? scopeNamesUsages.rootUsages : scopeNamesUsages.blockUsages.getOrDefault(scopeOrBlock, Collections.emptyMap());
        if (map3 == null) {
            JSTreeUtil.$$$reportNull$$$0(21);
        }
        return map3;
    }

    @NotNull
    public static JSScopeNamesUsages getScopeNamesUsages(CompositeElement scope) {
        ProgressManager.checkCanceled();
        if (!ScopeTypesHolder.isScopeNamesUsagesHolder((TreeElement)scope)) {
            JSScopeNamesUsages jSScopeNamesUsages = JSScopeNamesUsages.EMPTY;
            if (jSScopeNamesUsages == null) {
                JSTreeUtil.$$$reportNull$$$0(22);
            }
            return jSScopeNamesUsages;
        }
        JSScopeNamesUsages jSScopeNamesUsages = (JSScopeNamesUsages)CachedValuesManager.getManager((Project)scope.getManager().getProject()).getCachedValue((UserDataHolder)scope, () -> new CachedValueProvider.Result((Object)JSTreeUtil.calcScopeNameUsage(scope), new Object[]{scope.getPsi().getContainingFile()}));
        if (jSScopeNamesUsages == null) {
            JSTreeUtil.$$$reportNull$$$0(23);
        }
        return jSScopeNamesUsages;
    }

    public static boolean hasUseStrictPragma(@NotNull ASTNode scope) {
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(24);
        }
        if (scope.getElementType() instanceof ES6ClassElementType) {
            return true;
        }
        if (!(scope instanceof CompositeElement)) {
            return false;
        }
        JSScopeNamesUsages scopeNamesUsages = JSTreeUtil.getScopeNamesUsages((CompositeElement)scope);
        if (scopeNamesUsages.hasES6ModuleElement) {
            return true;
        }
        JSScopeDeclarationsAndAssignments declarationsAndAssignments = scopeNamesUsages.rootUsages.get("\"use strict\"");
        return declarationsAndAssignments != null && declarationsAndAssignments.hasDeclarationOrAssignment(false);
    }

    @Nullable
    public static String getDeclaredOrAssignedName(@NotNull TreeElement element) {
        if (element == null) {
            JSTreeUtil.$$$reportNull$$$0(25);
        }
        IElementType type = element.getElementType();
        ASTNode identifier = null;
        if (JSExtendedLanguagesTokenSetProvider.VARIABLES.contains(type)) {
            identifier = JSVariableBaseImpl.findVariableNameIdentifier((ASTNode)element);
        } else if (JSElementTypes.FUNCTION_DECLARATIONS.contains(type) || type == JSStubElementTypes.FUNCTION_SIGNATURE || type == FlowJSElementTypes.FUNCTION_SIGNATURE) {
            identifier = JSPsiImplUtils.findNameIdentifierOfFunction((ASTNode)element);
        } else if (type == ES6StubElementTypes.ES6_DECORATOR_DECLARATION) {
            identifier = element.findChildByType(ES6DecoratorDeclarationImpl.IDENTIFIER);
        } else if (type == JSStubElementTypes.DEFINITION_EXPRESSION) {
            ASTNode expressionNode = JSDefinitionExpressionImpl.getExpressionNode((ASTNode)element);
            if (expressionNode != null && expressionNode.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode(expressionNode) == null) {
                identifier = JSReferenceExpressionImpl.getNameElement(expressionNode);
            }
        } else if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(type) && !JSElementTypes.CLASS_EXPRESSIONS.contains(type) || type == JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS) {
            identifier = JSClassBase.findOwnNameIdentifier((ASTNode)element);
        } else if (type == ES6StubElementTypes.IMPORT_SPECIFIER || type == ES6StubElementTypes.EXPORT_SPECIFIER) {
            if (element.findChildByType((IElementType)ES6StubElementTypes.IMPORT_SPECIFIER_ALIAS) == null && element.findChildByType((IElementType)ES6StubElementTypes.EXPORT_SPECIFIER_ALIAS) == null) {
                identifier = ES6ImportExportSpecifierBase.getDeclarationNameElement((ASTNode)element);
            }
        } else if (type == ES6StubElementTypes.NAMESPACE_EXPORT) {
            identifier = ES6NamespaceExportImpl.findNameIdentifier((ASTNode)element);
        } else if (type == JSStubElementTypes.TYPESCRIPT_MODULE) {
            ASTNode moduleIdentifier = TypeScriptModuleImpl.findNameIdentifier((ASTNode)element);
            if (moduleIdentifier != null && !StringUtil.isQuotedString((String)moduleIdentifier.getText())) {
                identifier = moduleIdentifier;
            }
        } else {
            if (type == TypeScriptStubElementTypes.IMPLICIT_MODULE) {
                return ((TypeScriptImplicitModule)element.getPsi()).getName();
            }
            if (type == TypeScriptElementTypes.IMPORT_STATEMENT) {
                identifier = TypeScriptImportStatementImpl.findNameIdentifier((ASTNode)element);
            } else if (type == ES6StubElementTypes.IMPORT_SPECIFIER_ALIAS || type == ES6StubElementTypes.EXPORT_SPECIFIER_ALIAS) {
                identifier = ES6ImportExportSpecifierAliasBase.findNameIdentifier((ASTNode)element);
            } else if (type == ES6StubElementTypes.IMPORTED_BINDING || type == ES6StubElementTypes.EXPORTED_DEFAULT_BINDING) {
                identifier = ES6ImportedExportedDefaultBindingImpl.findNameIdentifier((ASTNode)element);
            } else if (type == TypeScriptStubElementTypes.PROPERTY_SIGNATURE) {
                identifier = TypeScriptPropertySignatureImpl.findNameIdentifier((ASTNode)element);
            } else if (JSStubElementTypes.CALL_SIGNATURE != type && TypeScriptStubElementTypes.INDEX_SIGNATURE != type && type != FlowJSElementTypes.MODULE) {
                if (type == JSStubElementTypes.LITERAL_EXPRESSION) {
                    TreeElement childNode = element.getFirstChildNode();
                    if (childNode == element.getLastChildNode() && childNode instanceof LeafPsiElement) {
                        String text;
                        String rawText = childNode.getText();
                        boolean isUseStrict = false;
                        if ("'use strict'".equals(rawText) || "\"use strict\"".equals(rawText)) {
                            isUseStrict = true;
                        } else if (rawText.contains("use strict") && ("'use strict'".equals(text = InjectedLanguageManager.getInstance((Project)((LeafPsiElement)childNode).getProject()).getUnescapedText((PsiElement)((LeafPsiElement)childNode))) || "\"use strict\"".equals(text))) {
                            isUseStrict = true;
                        }
                        if (isUseStrict) {
                            return "\"use strict\"";
                        }
                    }
                } else if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(type) || JSElementTypes.CLASS_EXPRESSIONS.contains(type)) {
                    CompositeElement parent = element.getTreeParent();
                    if (parent != null && parent.getElementType() == ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
                        identifier = JSElementTypes.CLASS_EXPRESSIONS.contains(type) ? JSClassBase.findOwnNameIdentifier((ASTNode)element) : JSPsiImplUtils.findNameIdentifierOfFunction((ASTNode)element);
                    }
                } else assert (!JSStubBasedPsiTreeUtil.DECLARATIONS_TOKEN_SET.contains(type)) : type + " is not handled";
            }
        }
        return identifier != null ? JSPsiImplUtils.getNameFromIdentifier(identifier) : null;
    }

    public static boolean hasDeclarationOrAssignmentInNestedScopes(@NotNull CompositeElement scope, @NotNull String name) {
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(26);
        }
        if (name == null) {
            JSTreeUtil.$$$reportNull$$$0(27);
        }
        return JSTreeUtil.hasDeclarationOrAssignmentInScopeAndNestedScopes(scope, name, true);
    }

    public static boolean hasDeclarationOrAssignmentInScopeAndNestedScopes(@NotNull CompositeElement scope, @NotNull String name, boolean nestedOnly) {
        JSScopeDeclarationsAndAssignments assignments;
        if (scope == null) {
            JSTreeUtil.$$$reportNull$$$0(28);
        }
        if (name == null) {
            JSTreeUtil.$$$reportNull$$$0(29);
        }
        JSScopeNamesUsages usages = JSTreeUtil.getScopeNamesUsages(scope);
        if (!nestedOnly && (assignments = usages.rootUsages.get(name)) != null && assignments.hasDeclarationOrAssignment(true)) {
            return true;
        }
        for (CompositeElement nested : usages.directChildScopes) {
            if (!JSTreeUtil.hasDeclarationOrAssignmentInScopeAndNestedScopes(nested, name, false)) continue;
            return true;
        }
        return false;
    }

    public static Language getLanguage(@NotNull ASTNode element) {
        JSLanguageDialect forcedLanguage;
        JSEmbeddedContentElementType type;
        ASTNode embeddedContent;
        if (element == null) {
            JSTreeUtil.$$$reportNull$$$0(30);
        }
        if ((embeddedContent = TreeUtil.findParent((ASTNode)element, (TokenSet)JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS)) != null && (type = (JSEmbeddedContentElementType)ObjectUtils.tryCast((Object)embeddedContent.getElementType(), JSEmbeddedContentElementType.class)) != null && (forcedLanguage = type.getForcedLanguage()) != null) {
            return forcedLanguage;
        }
        FileElement fileElement = element instanceof TreeElement ? TreeUtil.getFileElement((TreeElement)((TreeElement)element)) : null;
        return fileElement != null ? fileElement.getElementType().getLanguage() : null;
    }

    @Nullable
    public static String getName(@NotNull ASTNode namedElement) {
        ASTNode identifier;
        IElementType type;
        if (namedElement == null) {
            JSTreeUtil.$$$reportNull$$$0(31);
        }
        if (JSExtendedLanguagesTokenSetProvider.VARIABLES.contains(type = namedElement.getElementType())) {
            ASTNode identifier2 = JSVariableBaseImpl.findVariableNameIdentifier(namedElement);
            if (identifier2 != null) {
                return identifier2.getText();
            }
        } else if (JSExtendedLanguagesTokenSetProvider.PROPERTIES.contains(type) && (identifier = JSPropertyImpl.findNameIdentifier(namedElement)) != null) {
            return identifier.getText();
        }
        return null;
    }

    public static boolean withinWithStatement(@NotNull ASTNode element) {
        if (element == null) {
            JSTreeUtil.$$$reportNull$$$0(32);
        }
        return TreeUtil.findParent((ASTNode)element, (IElementType)JSElementTypes.WITH_STATEMENT) != null;
    }

    public static ASTNode getInitializerNode(ASTNode ownerNode) {
        ASTNode eqNode;
        IElementType elementType = ownerNode.getElementType();
        ASTNode initializer = null;
        if (JSExtendedLanguagesTokenSetProvider.PROPERTIES.contains(elementType)) {
            initializer = ownerNode.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        } else if (elementType == JSStubElementTypes.DEFINITION_EXPRESSION) {
            ASTNode parent = ownerNode.getTreeParent();
            if (parent != null && parent.getElementType() == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
                initializer = JSBinaryExpressionImpl.getROperandNode(parent);
            }
        } else if (elementType != JSStubElementTypes.ASSIGNMENT_EXPRESSION && (eqNode = ownerNode.findChildByType(JSTokenTypes.EQ)) != null) {
            initializer = ownerNode.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS, eqNode);
        }
        return initializer;
    }

    public static boolean hasLocalReassignments(@NotNull TreeElement declaration, boolean hasBlockScope) {
        TreeElement cachingScopeNode;
        String name;
        if (declaration == null) {
            JSTreeUtil.$$$reportNull$$$0(33);
        }
        if ((name = JSTreeUtil.getDeclaredOrAssignedName(declaration)) == null) {
            return false;
        }
        TreeElement scopeNode = ScopeTypesHolder.getBlockOrScopeNamesUsagesHolder(declaration);
        if (scopeNode == null) {
            LOG.warn("Can't find containing scope node, topmost parent is " + TreeUtil.getFileElement((TreeElement)declaration));
            return false;
        }
        TreeElement treeElement = cachingScopeNode = ScopeTypesHolder.isScopeNamesUsagesHolder(scopeNode) ? scopeNode : ScopeTypesHolder.getScopeNamesUsagesHolder(scopeNode);
        if (cachingScopeNode == null) {
            LOG.error("Can't find containing scope node");
            return false;
        }
        if (!hasBlockScope) {
            scopeNode = cachingScopeNode;
        }
        JSScopeNamesUsages scopeNamesUsages = JSTreeUtil.getScopeNamesUsages((CompositeElement)cachingScopeNode);
        Map<String, JSScopeDeclarationsAndAssignments> rootMap = scopeNode == cachingScopeNode ? scopeNamesUsages.rootUsages : scopeNamesUsages.blockUsages.getOrDefault(scopeNode, Collections.emptyMap());
        JSScopeDeclarationsAndAssignments assignments = rootMap.get(name);
        if (assignments == null) {
            LOG.error("Can't find assignments");
            return false;
        }
        List<CompositeElement> rootElements = assignments.getElements();
        if (rootElements.isEmpty() || rootElements.size() == 1 && rootElements.get(0) != declaration) {
            LOG.error("Can't find declaration in current scope assignment");
            return false;
        }
        if (rootElements.size() > 1) {
            return true;
        }
        Set<CompositeElement> childScopesWithAssignment = scopeNamesUsages.getChildScopesHavingAssignmentWithoutDeclaration(name);
        if (childScopesWithAssignment.isEmpty()) {
            return false;
        }
        if (scopeNode == cachingScopeNode) {
            return true;
        }
        for (TreeElement treeElement2 : childScopesWithAssignment) {
            if (!JSTreeUtil.isParentUpTo(treeElement2, scopeNode, cachingScopeNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isParentUpTo(@NotNull TreeElement child, @NotNull TreeElement parent, @NotNull TreeElement stopAt) {
        if (child == null) {
            JSTreeUtil.$$$reportNull$$$0(34);
        }
        if (parent == null) {
            JSTreeUtil.$$$reportNull$$$0(35);
        }
        if (stopAt == null) {
            JSTreeUtil.$$$reportNull$$$0(36);
        }
        while (child != null) {
            if (child == parent) {
                return true;
            }
            if (child == stopAt) {
                return false;
            }
            child = child.getTreeParent();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 9: 
            case 15: 
            case 16: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSTreeUtil";
                break;
            }
            case 4: 
            case 13: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeOrBlock";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSTreeUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcScopeNameUsage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsAndAssignmentsInCodeBlockInner";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeNameUsage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeNamesUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasBlockScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calcScopeNameUsage";
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "definesScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "definedInScopeAndUp";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicateDeclarations";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScope";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsAndAssignmentsInScopeAndUp";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsAndAssignmentsInScopeAndUp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsAndAssignmentsInScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsAndAssignmentsInCodeBlockInner";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getScopeNameUsage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasUseStrictPragma";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredOrAssignedName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasDeclarationOrAssignmentInNestedScopes";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasDeclarationOrAssignmentInScopeAndNestedScopes";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "withinWithStatement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalReassignments";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isParentUpTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class JSScopeNamesUsages {
        static final JSScopeNamesUsages EMPTY = new JSScopeNamesUsages();
        @NotNull
        public Map<String, JSScopeDeclarationsAndAssignments> rootUsages = new THashMap();
        @NotNull
        public Map<TreeElement, Map<String, JSScopeDeclarationsAndAssignments>> blockUsages = new THashMap();
        @NotNull
        final Set<CompositeElement> directChildScopes = new HashSet<CompositeElement>();
        public boolean hasES6ModuleElement = false;
        @Nullable
        private volatile Set<String> namesAssignedWithoutDeclaration = null;
        @Nullable
        private volatile Map<String, Set<CompositeElement>> childScopesHavingAssignmentWithoutDeclaration = null;

        @NotNull
        private Set<CompositeElement> getChildScopesHavingAssignmentWithoutDeclaration(@NotNull String name) {
            if (name == null) {
                JSScopeNamesUsages.$$$reportNull$$$0(0);
            }
            Set<CompositeElement> set = this.getChildScopesHavingAssignmentWithoutDeclaration().getOrDefault(name, Collections.emptySet());
            if (set == null) {
                JSScopeNamesUsages.$$$reportNull$$$0(1);
            }
            return set;
        }

        @NotNull
        private Map<String, Set<CompositeElement>> getChildScopesHavingAssignmentWithoutDeclaration() {
            THashMap childScopesByName = this.childScopesHavingAssignmentWithoutDeclaration;
            if (childScopesByName != null) {
                THashMap tHashMap = childScopesByName;
                if (tHashMap == null) {
                    JSScopeNamesUsages.$$$reportNull$$$0(2);
                }
                return tHashMap;
            }
            if (this.directChildScopes.isEmpty()) {
                this.childScopesHavingAssignmentWithoutDeclaration = Collections.emptyMap();
                Map<String, Set<CompositeElement>> map2 = Collections.emptyMap();
                if (map2 == null) {
                    JSScopeNamesUsages.$$$reportNull$$$0(3);
                }
                return map2;
            }
            childScopesByName = new THashMap();
            for (CompositeElement childScope : this.directChildScopes) {
                JSScopeNamesUsages childNamesUsages = JSTreeUtil.getScopeNamesUsages(childScope);
                Set<String> childScopeNamesWithoutDeclarations = childNamesUsages.getNamesAssignedWithoutDeclaration();
                for (String childScopeNameWithoutDeclaration : childScopeNamesWithoutDeclarations) {
                    Set elements = (Set)childScopesByName.get(childScopeNameWithoutDeclaration);
                    if (elements == null) {
                        elements = new THashSet();
                        childScopesByName.put(childScopeNameWithoutDeclaration, elements);
                    }
                    elements.add(childScope);
                }
            }
            this.childScopesHavingAssignmentWithoutDeclaration = childScopesByName;
            THashMap tHashMap = childScopesByName;
            if (tHashMap == null) {
                JSScopeNamesUsages.$$$reportNull$$$0(4);
            }
            return tHashMap;
        }

        @NotNull
        private Set<String> getNamesAssignedWithoutDeclaration() {
            THashSet namesWithoutDeclaration = this.namesAssignedWithoutDeclaration;
            if (namesWithoutDeclaration != null) {
                THashSet tHashSet = namesWithoutDeclaration;
                if (tHashSet == null) {
                    JSScopeNamesUsages.$$$reportNull$$$0(5);
                }
                return tHashSet;
            }
            namesWithoutDeclaration = new THashSet();
            for (CompositeElement compositeElement : this.directChildScopes) {
                JSScopeNamesUsages childNamesUsages = JSTreeUtil.getScopeNamesUsages(compositeElement);
                namesWithoutDeclaration.addAll(childNamesUsages.getNamesAssignedWithoutDeclaration());
            }
            for (Map.Entry entry : this.rootUsages.entrySet()) {
                if (((JSScopeDeclarationsAndAssignments)entry.getValue()).hasAssignmentWithoutDeclaration()) {
                    namesWithoutDeclaration.add((String)entry.getKey());
                    continue;
                }
                namesWithoutDeclaration.remove(entry.getKey());
            }
            this.namesAssignedWithoutDeclaration = namesWithoutDeclaration;
            THashSet tHashSet = namesWithoutDeclaration;
            if (tHashSet == null) {
                JSScopeNamesUsages.$$$reportNull$$$0(6);
            }
            return tHashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeNamesUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeNamesUsages";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildScopesHavingAssignmentWithoutDeclaration";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamesAssignedWithoutDeclaration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildScopesHavingAssignmentWithoutDeclaration";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class JSScopeDeclarationsAndAssignments {
        static final JSScopeDeclarationsAndAssignments EMPTY = new JSScopeDeclarationsAndAssignments();
        @NotNull
        private final List<CompositeElement> myElements = new SmartList();
        private static final Comparator<ASTNode> POSITIONS_COMPARATOR = Comparator.comparing(ASTNode::getStartOffset).thenComparing(ASTNode::getTextLength, Comparator.reverseOrder());

        public boolean hasDeclarationOrAssignment(boolean includeAssignments) {
            if (includeAssignments) {
                return !this.myElements.isEmpty();
            }
            int size = this.myElements.size();
            for (int i = 0; i < size; ++i) {
                CompositeElement element = this.myElements.get(i);
                if (element.getElementType() == JSStubElementTypes.DEFINITION_EXPRESSION) continue;
                return true;
            }
            return false;
        }

        public boolean hasAssignments() {
            int size = this.myElements.size();
            for (int i = 0; i < size; ++i) {
                CompositeElement element = this.myElements.get(i);
                if (element.getElementType() != JSStubElementTypes.DEFINITION_EXPRESSION) continue;
                return true;
            }
            return false;
        }

        public boolean hasAssignmentWithoutDeclaration() {
            int size = this.myElements.size();
            for (int i = 0; i < size; ++i) {
                CompositeElement element = this.myElements.get(i);
                if (element.getElementType() == JSStubElementTypes.DEFINITION_EXPRESSION) continue;
                return false;
            }
            return !this.myElements.isEmpty();
        }

        public void add(@NotNull CompositeElement element) {
            if (element == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(0);
            }
            this.myElements.add(element);
        }

        private int findNearestDefinitionIndex(@NotNull ASTNode context) {
            if (context == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(1);
            }
            if (this.myElements.isEmpty()) {
                return -1;
            }
            if (this.myElements.size() == 1) {
                return 0;
            }
            int i = Collections.binarySearch(this.myElements, context, POSITIONS_COMPARATOR);
            if (i < 0) {
                i = -i - 2;
            }
            if (i == -1) {
                return i;
            }
            CompositeElement element = this.myElements.get(i);
            if (element.getElementType() == JSStubElementTypes.DEFINITION_EXPRESSION) {
                element = element.getTreeParent();
            }
            return element.getTextRange().contains(context.getTextRange()) ? i - 1 : i;
        }

        @Nullable
        public CompositeElement findNearestDefinition(@NotNull ASTNode context) {
            int i;
            if (context == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(2);
            }
            return (i = this.findNearestDefinitionIndex(context)) >= 0 ? this.myElements.get(i) : null;
        }

        public boolean processElements(@NotNull ASTNode context, @NotNull PsiScopeProcessor processor, boolean startFromNearest) {
            if (context == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(3);
            }
            if (processor == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(4);
            }
            if (this.myElements.isEmpty()) {
                return true;
            }
            if (!startFromNearest) {
                for (CompositeElement element : this.myElements) {
                    PsiElement psi = element.getPsi();
                    if (processor.execute(psi, ResolveState.initial())) continue;
                    return false;
                }
                return true;
            }
            int start = this.findNearestDefinitionIndex(context);
            if (start == -1) {
                start = this.myElements.size() - 1;
            }
            int i = start;
            do {
                PsiElement psi;
                if (!processor.execute(psi = this.myElements.get(i).getPsi(), ResolveState.initial())) {
                    return false;
                }
                if (--i != -1) continue;
                i = this.myElements.size() - 1;
            } while (i != start);
            return true;
        }

        @NotNull
        public List<CompositeElement> getElements() {
            List<CompositeElement> list2 = this.myElements;
            if (list2 == null) {
                JSScopeDeclarationsAndAssignments.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeDeclarationsAndAssignments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeDeclarationsAndAssignments";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestDefinitionIndex";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestDefinition";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processElements";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class ScopeTypesHolder {
        private static final TokenSet SCOPE_TYPES_FOR_CACHING = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS, TokenSet.forAllMatching(type -> type instanceof JSFileElementType), JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS, TypeScriptElementTypes.CALLABLE_TYPE_MEMBERS, TokenSet.create((IElementType[])new IElementType[]{TypeScriptStubElementTypes.INDEX_SIGNATURE})});
        private static final TokenSet BLOCK_SCOPE_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.FOR_STATEMENT, JSElementTypes.FOR_IN_STATEMENT, JSElementTypes.CATCH_BLOCK})});
        static final TokenSet SCOPE_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{SCOPE_TYPES_FOR_CACHING, BLOCK_SCOPE_TYPES});

        ScopeTypesHolder() {
        }

        private static TreeElement getBlockOrScopeNamesUsagesHolder(@NotNull TreeElement element) {
            if (element == null) {
                ScopeTypesHolder.$$$reportNull$$$0(0);
            }
            for (CompositeElement parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
                if (!BLOCK_SCOPE_TYPES.contains(parent.getElementType()) && !ScopeTypesHolder.isScopeNamesUsagesHolder((TreeElement)parent)) continue;
                return parent;
            }
            return null;
        }

        private static TreeElement getScopeNamesUsagesHolder(@NotNull TreeElement element) {
            if (element == null) {
                ScopeTypesHolder.$$$reportNull$$$0(1);
            }
            for (CompositeElement parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
                if (!ScopeTypesHolder.isScopeNamesUsagesHolder((TreeElement)parent)) continue;
                return parent;
            }
            return null;
        }

        private static boolean isScopeNamesUsagesHolder(@NotNull TreeElement element) {
            if (element == null) {
                ScopeTypesHolder.$$$reportNull$$$0(2);
            }
            return SCOPE_TYPES_FOR_CACHING.contains(element.getElementType()) || element.getTreeParent() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSTreeUtil$ScopeTypesHolder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBlockOrScopeNamesUsagesHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getScopeNamesUsagesHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isScopeNamesUsagesHolder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

