/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSCompositeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSConditionalTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSDecoratorsOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSUnionOperation;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMergeOperation
extends JSCompositeOperation {
    @NotNull
    private final Collection<JSTypeOperation> myOperations;

    @NotNull
    public static JSTypeOperation create(@NotNull Collection<JSTypeOperation> operations, JSTypeOperation whenEmpty) {
        if (operations == null) {
            JSMergeOperation.$$$reportNull$$$0(0);
        }
        if (operations.isEmpty()) {
            JSTypeOperation jSTypeOperation = whenEmpty;
            if (jSTypeOperation == null) {
                JSMergeOperation.$$$reportNull$$$0(1);
            }
            return jSTypeOperation;
        }
        int size = operations.size();
        if (size == 1) {
            JSTypeOperation jSTypeOperation = operations.iterator().next();
            if (jSTypeOperation == null) {
                JSMergeOperation.$$$reportNull$$$0(2);
            }
            return jSTypeOperation;
        }
        if (size == 2) {
            Iterator<JSTypeOperation> iterator = operations.iterator();
            return JSMergeOperation.mergeOperations(operations, iterator.next(), iterator.next());
        }
        return new JSMergeOperation(operations);
    }

    @NotNull
    private static JSTypeOperation mergeOperations(@NotNull Collection<JSTypeOperation> collection, @NotNull JSTypeOperation first, @NotNull JSTypeOperation second) {
        JSConditionalTypeOperation conditionalOperation;
        if (collection == null) {
            JSMergeOperation.$$$reportNull$$$0(3);
        }
        if (first == null) {
            JSMergeOperation.$$$reportNull$$$0(4);
        }
        if (second == null) {
            JSMergeOperation.$$$reportNull$$$0(5);
        }
        Set<Object> left = Collections.emptySet();
        boolean hasDecorated = false;
        if (first instanceof JSDecoratorsOperation) {
            JSDecoratorsOperation decorated = (JSDecoratorsOperation)first;
            first = decorated.getPrev();
            left = decorated.getDecorators();
            hasDecorated = true;
        }
        Set<Object> right = Collections.emptySet();
        if (second instanceof JSDecoratorsOperation) {
            JSDecoratorsOperation decorated = (JSDecoratorsOperation)second;
            second = decorated.getPrev();
            right = decorated.getDecorators();
            hasDecorated = true;
        }
        if (first == second) {
            if (!hasDecorated) {
                JSTypeOperation jSTypeOperation = first;
                if (jSTypeOperation == null) {
                    JSMergeOperation.$$$reportNull$$$0(6);
                }
                return jSTypeOperation;
            }
            Set decorators = right.isEmpty() || left.isEmpty() ? Collections.emptySet() : ContainerUtil.intersection(left, right);
            EnumSet<Object> resultDecorators = decorators.isEmpty() ? EnumSet.noneOf(JSDecoratedType.TypeDecoration.class) : EnumSet.copyOf(decorators);
            JSTypeOperation jSTypeOperation = JSDecoratorsOperation.create(first, resultDecorators);
            if (jSTypeOperation == null) {
                JSMergeOperation.$$$reportNull$$$0(7);
            }
            return jSTypeOperation;
        }
        if (first instanceof JSConditionalTypeOperation && (conditionalOperation = (JSConditionalTypeOperation)first).isInverse(second)) {
            JSTypeOperation jSTypeOperation = conditionalOperation.mergeCondition();
            if (jSTypeOperation == null) {
                JSMergeOperation.$$$reportNull$$$0(8);
            }
            return jSTypeOperation;
        }
        return new JSMergeOperation(collection);
    }

    private JSMergeOperation(@NotNull Collection<JSTypeOperation> operations) {
        if (operations == null) {
            JSMergeOperation.$$$reportNull$$$0(9);
        }
        this.myOperations = operations;
    }

    @Override
    @NotNull
    public Collection<JSTypeOperation> getOperations() {
        Collection<JSTypeOperation> collection = this.myOperations;
        if (collection == null) {
            JSMergeOperation.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @Override
    @NotNull
    protected JSType applyWithoutCache(@NotNull JSApplyTypeOperationContext context, @NotNull JSType type) {
        List<JSType> types2;
        if (context == null) {
            JSMergeOperation.$$$reportNull$$$0(11);
        }
        if (type == null) {
            JSMergeOperation.$$$reportNull$$$0(12);
        }
        if ((types2 = JSMergeOperation.getTypeFromOperations(context, this.myOperations, type)).size() == 1) {
            JSType jSType = context.isAutoArrayType() ? JSUnionOperation.processEvolvingArrays(context, types2) : types2.get(0);
            if (jSType == null) {
                JSMergeOperation.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        JSType jSType = TypeScriptTypeRelations.subtypeReduction(JSUnionOperation.processEvolvingArrays(context, types2), context.getContextElement());
        if (jSType == null) {
            JSMergeOperation.$$$reportNull$$$0(14);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected Set<JSDecoratedType.TypeDecoration> inferTypeDecoratorsImpl(@NotNull JSInferDecoratorsContext context) {
        if (context == null) {
            JSMergeOperation.$$$reportNull$$$0(15);
        }
        Set<JSDecoratedType.TypeDecoration> decorators = Collections.emptySet();
        boolean isFirst = true;
        for (JSTypeOperation operation : this.getOperations()) {
            Set<JSDecoratedType.TypeDecoration> newDecorators = operation.inferTypeDecorators(context);
            if (isFirst) {
                decorators = newDecorators;
                isFirst = false;
                continue;
            }
            decorators = JSMergeOperation.mergeDecorators(decorators, newDecorators);
        }
        Set<JSDecoratedType.TypeDecoration> set = decorators;
        if (set == null) {
            JSMergeOperation.$$$reportNull$$$0(16);
        }
        return set;
    }

    @NotNull
    private static Set<JSDecoratedType.TypeDecoration> mergeDecorators(@NotNull Set<JSDecoratedType.TypeDecoration> old, @NotNull Set<JSDecoratedType.TypeDecoration> newDecorators) {
        if (old == null) {
            JSMergeOperation.$$$reportNull$$$0(17);
        }
        if (newDecorators == null) {
            JSMergeOperation.$$$reportNull$$$0(18);
        }
        if (old.isEmpty() && newDecorators.isEmpty()) {
            Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
            if (set == null) {
                JSMergeOperation.$$$reportNull$$$0(19);
            }
            return set;
        }
        EnumSet<JSDecoratedType.TypeDecoration> result2 = EnumSet.noneOf(JSDecoratedType.TypeDecoration.class);
        if (old.contains(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED) || newDecorators.contains(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED)) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED);
            if (enumSet == null) {
                JSMergeOperation.$$$reportNull$$$0(20);
            }
            return enumSet;
        }
        for (JSDecoratedType.TypeDecoration decoration : old) {
            if (!newDecorators.contains(decoration)) continue;
            result2.add(decoration);
        }
        if (!result2.isEmpty()) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = result2;
            if (enumSet == null) {
                JSMergeOperation.$$$reportNull$$$0(21);
            }
            return enumSet;
        }
        Set<JSDecoratedType.TypeDecoration> notEmpty = old.isEmpty() ? newDecorators : old;
        Set<JSDecoratedType.TypeDecoration> toCompare = old.isEmpty() ? old : newDecorators;
        notEmpty = JSMergeOperation.reMapToPossibly(notEmpty);
        toCompare = JSMergeOperation.reMapToPossibly(toCompare);
        if (notEmpty.contains(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED) || toCompare.contains(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED)) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED);
            if (enumSet == null) {
                JSMergeOperation.$$$reportNull$$$0(22);
            }
            return enumSet;
        }
        if (notEmpty.contains(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL)) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = toCompare.contains(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED) ? EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED) : EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL);
            if (enumSet == null) {
                JSMergeOperation.$$$reportNull$$$0(23);
            }
            return enumSet;
        }
        if (notEmpty.contains(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED)) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = toCompare.contains(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL) ? EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED) : EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL);
            if (enumSet == null) {
                JSMergeOperation.$$$reportNull$$$0(24);
            }
            return enumSet;
        }
        EnumSet<JSDecoratedType.TypeDecoration> enumSet = result2;
        if (enumSet == null) {
            JSMergeOperation.$$$reportNull$$$0(25);
        }
        return enumSet;
    }

    @NotNull
    private static EnumSet<JSDecoratedType.TypeDecoration> reMapToPossibly(Set<JSDecoratedType.TypeDecoration> notEmpty) {
        List result2 = ContainerUtil.mapNotNull(notEmpty, JSMergeOperation::simpleReMapToPossibly);
        EnumSet<Object> enumSet = result2.isEmpty() ? EnumSet.noneOf(JSDecoratedType.TypeDecoration.class) : EnumSet.copyOf(result2);
        if (enumSet == null) {
            JSMergeOperation.$$$reportNull$$$0(26);
        }
        return enumSet;
    }

    @Nullable
    private static JSDecoratedType.TypeDecoration simpleReMapToPossibly(@NotNull JSDecoratedType.TypeDecoration el) {
        if (el == null) {
            JSMergeOperation.$$$reportNull$$$0(27);
        }
        if (el == JSDecoratedType.TypeDecoration.INFERRED_NULL) {
            return JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL;
        }
        if (el == JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED) {
            return JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED;
        }
        if (el == JSDecoratedType.TypeDecoration.INFERRED_NULL_OR_UNDEFINED) {
            return JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED;
        }
        if (el == JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL || el == JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED || el == JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED) {
            return el;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSMergeOperation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDecorators";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSMergeOperation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeOperations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperations";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "applyWithoutCache";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDecoratorsImpl";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeDecorators";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "reMapToPossibly";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergeOperations";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyWithoutCache";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDecoratorsImpl";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mergeDecorators";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "simpleReMapToPossibly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

