/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeGuardEvaluator;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeStructuralPartEvaluator;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeWithDeclarations;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQualifiedReferenceType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType,
JSTypeWithDeclarations,
JSReferenceItem {
    @NotNull
    private final String myReferenceName;
    @NotNull
    private final JSType myQualifierType;

    public JSQualifiedReferenceType(@NotNull String referenceName, @NotNull JSType qualifierType, @NotNull JSTypeSource source) {
        if (referenceName == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(0);
        }
        if (qualifierType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(1);
        }
        if (source == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(2);
        }
        super(source);
        this.myReferenceName = referenceName;
        this.myQualifierType = qualifierType;
    }

    public JSQualifiedReferenceType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(4);
        }
        super(source);
        this.myReferenceName = JSTypeSerializer.readString(inputStream);
        this.myQualifierType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(5);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeString(this.myReferenceName, outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myQualifierType, outputStream);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(6);
        }
        this.myQualifierType.accept(visitor);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(7);
        }
        return new JSQualifiedReferenceType(this.myReferenceName, this.myQualifierType, source);
    }

    @NotNull
    public String getReferenceName() {
        String string = this.myReferenceName;
        if (string == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean hasQualifier() {
        return true;
    }

    @NotNull
    public JSType getQualifierType() {
        JSType jSType = this.myQualifierType;
        if (jSType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myReferenceName, this.getSourceElement(), this.myQualifierType);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(10);
        }
        JSQualifiedReferenceType other = (JSQualifiedReferenceType)type;
        return this.myReferenceName.equals(other.myReferenceName) && Objects.equals(this.getSourceElement(), other.getSourceElement()) && this.myQualifierType.isEquivalentTo(other.myQualifierType, context, allowResolve);
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarations() {
        PsiElement element = this.getSourceElement();
        if (element == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(11);
            }
            return list2;
        }
        ArrayList<PsiElement> results = new ArrayList<PsiElement>();
        JSType substitute = this.substitute();
        if (substitute instanceof JSTypeWithDeclarations && substitute != this) {
            results.addAll(((JSTypeWithDeclarations)substitute).getDeclarations());
        }
        String name = this.getReferenceName();
        JSType rawQualifierType = this.getQualifierType();
        results.addAll(JSQualifiedReferenceType.resolveNamespaceElements(element, name, rawQualifierType));
        ArrayList<PsiElement> arrayList = results;
        if (arrayList == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<PsiElement> resolveNamespaceElements(@NotNull PsiElement context, @NotNull String name, @NotNull JSType rawQualifierType) {
        if (context == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(13);
        }
        if (name == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(14);
        }
        if (rawQualifierType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(15);
        }
        if (DialectDetector.isTypeScript(context)) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(16);
            }
            return list2;
        }
        PsiFile targetFile = context.getContainingFile();
        if (targetFile == null) {
            List<PsiElement> list3 = Collections.emptyList();
            if (list3 == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(17);
            }
            return list3;
        }
        Ref result2 = Ref.create(Collections.emptyList());
        JSEvaluatorComplexityTracker.getDefaultInstance().runTask(1, () -> {
            result2.set(JSQualifiedReferenceType.doResolveNamespaceElements(name, rawQualifierType, targetFile));
            return true;
        });
        Collection collection = (Collection)result2.get();
        if (collection == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @NotNull
    private static Collection<PsiElement> doResolveNamespaceElements(@NotNull String name, @NotNull JSType rawQualifierType, @NotNull PsiFile targetFile) {
        if (name == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(19);
        }
        if (rawQualifierType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(20);
        }
        if (targetFile == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(21);
        }
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(name, targetFile, (PsiElement)targetFile);
        processor.setAddOnlyCompleteMatches();
        JSType qualifierType = rawQualifierType.substitute();
        if (qualifierType instanceof JSNamespace) {
            processor.addTypeHierarchy((JSNamespace)qualifierType);
            JSIndexBasedResolveUtil.processAllSymbols(processor);
            List list2 = ((StreamEx)StreamEx.of(JSResolveResult.toElements(processor.getResults(), true)).limit((long)JSReferenceExpressionResolver.MAX_RESULTS_COUNT_TO_KEEP)).toList();
            if (list2 == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(22);
            }
            return list2;
        }
        List<PsiElement> list3 = Collections.emptyList();
        if (list3 == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(23);
        }
        return list3;
    }

    @Nullable
    public JSReferenceItem getReferenceItemQualifier() {
        return (JSReferenceItem)ObjectUtils.tryCast((Object)this.myQualifierType, JSReferenceItem.class);
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext context) {
        if (context == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(24);
        }
        JSType qualifierType = this.getQualifierType();
        ArrayList<JSEvaluationTask> tasks = new ArrayList<JSEvaluationTask>();
        tasks.add(new JSQualifierEvaluator().evaluate(qualifierType, context));
        if (JSSymbolUtil.isGlobalNamedType(qualifierType)) {
            tasks.add(JSEvaluationResultElement.fromType(new JSReferenceType(this.getReferenceName(), this.getSource()), context));
        }
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(tasks);
        if (jSEvaluationTask == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(25);
        }
        return jSEvaluationTask;
    }

    @NotNull
    private static StreamEx<JSType> resolveTypesFromElements(@NotNull JSType type, String propertyName) {
        Collection<PsiElement> declarations;
        PsiElement sourceElement;
        if (type == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(26);
        }
        if (type instanceof JSNamedType && ((JSNamedType)type).getJSContext() == JSContext.INSTANCE && (sourceElement = type.getSourceElement()) != null && !(declarations = JSQualifiedReferenceType.resolveNamespaceElements(sourceElement, propertyName, type)).isEmpty()) {
            StreamEx streamEx = StreamEx.of(declarations).select(JSTypeOwner.class).map(JSTypeOwner::getJSType).nonNull();
            if (streamEx == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(27);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.empty();
        if (streamEx == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(28);
        }
        return streamEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSQualifiedReferenceType";
                break;
            }
            case 10: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifierType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSQualifiedReferenceType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNamespaceElements";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveNamespaceElements";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypesFromElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveNamespaceElements";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doResolveNamespaceElements";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypesFromElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JSQualifierEvaluator
    extends JSTypeStructuralPartEvaluator {
        private JSQualifierEvaluator() {
        }

        @Override
        protected boolean processSpecialTypes(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, @NotNull List<JSEvaluationTask> outTasks) {
            JSRecordType candidate;
            if (type == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(0);
            }
            if (evaluateContext == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(1);
            }
            if (outTasks == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(2);
            }
            if (type instanceof JSEvaluableOnlyType) {
                return true;
            }
            if (!(type instanceof JSRecordType) && !type.isEcma() && ((candidate = type.asRecordType()).hasProperties() || type.isTypeScript())) {
                type = candidate;
            }
            List<JSType> types2 = this.applyToType(type);
            outTasks.addAll(ContainerUtil.map(types2, t -> JSEvaluationResultElement.fromType(t, evaluateContext)));
            return false;
        }

        @Override
        @NotNull
        protected List<JSType> applyToType(@NotNull JSType type) {
            String propertyName;
            if (type == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(3);
            }
            if (StringUtil.isEmpty((String)(propertyName = JSQualifiedReferenceType.this.getReferenceName()))) {
                List<JSType> list2 = Collections.emptyList();
                if (list2 == null) {
                    JSQualifierEvaluator.$$$reportNull$$$0(4);
                }
                return list2;
            }
            ArrayList<JSType> types2 = new ArrayList<JSType>();
            if (type instanceof JSRecordType) {
                this.evaluateRecordTypeDestructuringProperty((JSRecordType)type, propertyName, types2);
            } else if (type instanceof JSNamedType && !(type instanceof JSObjectType)) {
                String resolvedTypeText = type.getTypeText(JSType.TypeTextFormat.RESOLVED);
                JSQualifiedNameImpl newTypeName = JSQualifiedNameImpl.create(propertyName, JSQualifiedNameImpl.fromQualifiedName(resolvedTypeText));
                JSTypeSource newTypeSource = type.getSource();
                boolean isLocal = ((JSNamedType)type).isLocal();
                JSDestructuringProperty property = (JSDestructuringProperty)ObjectUtils.tryCast((Object)JSQualifiedReferenceType.this.getSourceElement(), JSDestructuringProperty.class);
                if (property != null && !isLocal) {
                    newTypeSource = JSTypeSourceFactory.copyTypeSource(newTypeSource, (PsiElement)property);
                }
                JSNamespace newType = JSNamedTypeFactory.createNamespace((JSQualifiedName)newTypeName, newTypeSource, JSTypeContext.STATIC, isLocal);
                types2.add((JSType)newType);
                List typesFromElements = JSQualifiedReferenceType.resolveTypesFromElements(type, propertyName).toList();
                if (!typesFromElements.isEmpty()) {
                    types2.add(JSCompositeTypeFactory.createUnionType(type.getSource(), typesFromElements));
                }
            } else if (type instanceof JSAnyType) {
                types2.add(type);
            }
            ArrayList<JSType> arrayList = types2;
            if (arrayList == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private void evaluateRecordTypeDestructuringProperty(@NotNull JSRecordType _type, @NotNull String propertyName, @NotNull List<JSType> outTypes) {
            JSRecordType.PropertySignature signature;
            if (_type == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(6);
            }
            if (propertyName == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(7);
            }
            if (outTypes == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(8);
            }
            if ((signature = _type.findPropertySignature(propertyName)) != null) {
                JSType type;
                JSType jSType = type = signature.isOptional() ? TypeScriptTypeGuard.wrapWithUndefined(signature.getJSType(), null) : signature.getJSType();
                if (type == null && signature instanceof TypeScriptField && JSTypeGuardUtil.isAutoTypeField((PsiElement)((TypeScriptField)signature))) {
                    TypeScriptField field = (TypeScriptField)signature;
                    type = JSTypeGuardEvaluator.applyToResolveResultType(null, (PsiElement)field, new JSEvaluateContext(field.getContainingFile()));
                }
                this.acceptMemberType(type, outTypes);
                return;
            }
            JSRecordType.IndexSignature numericIndexer = _type.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
            if (numericIndexer != null && JSNumberParser.tryParseNumericValue(propertyName, false) != null) {
                this.acceptMemberType(numericIndexer.getMemberType(), outTypes);
                return;
            }
            JSRecordType.IndexSignature stringIndexer = _type.findIndexer(JSRecordType.IndexSignatureKind.STRING);
            if (stringIndexer != null) {
                this.acceptMemberType(stringIndexer.getMemberType(), outTypes);
            }
        }

        private void acceptMemberType(@Nullable JSType propertyType, @NotNull List<JSType> outTypes) {
            if (outTypes == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(9);
            }
            if (propertyType != null) {
                outTypes.add(propertyType);
            }
        }

        @Override
        @NotNull
        protected JSType copyOwnerType(@NotNull JSType baseType) {
            if (baseType == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(10);
            }
            return new JSQualifiedReferenceType(JSQualifiedReferenceType.this.myReferenceName, baseType, JSQualifiedReferenceType.this.getSource());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outTasks";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSQualifiedReferenceType$JSQualifierEvaluator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_type";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outTypes";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSQualifiedReferenceType$JSQualifierEvaluator";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyToType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processSpecialTypes";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyToType";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateRecordTypeDestructuringProperty";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptMemberType";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "copyOwnerType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

