/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptTypeMemberParser {
    @Nullable
    public static JSRecordType.TypeMember buildTypeMember(@NotNull TypeScriptTypeMember member, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(0);
        }
        if (TypeScriptTypeMemberParser.isEmptySubstitutor(typeSubstitutor)) {
            if (TypeScriptTypeMemberParser.isPropertyNameEmpty((PsiElement)member)) {
                return TypeScriptTypeMemberParser.buildComputedPropertySignature((PsiElement)member);
            }
            return member;
        }
        JSRecordType.TypeMember typeMember = null;
        if (member instanceof TypeScriptPropertySignature) {
            typeMember = TypeScriptTypeMemberParser.copyPropertySignature((TypeScriptPropertySignature)member, typeSubstitutor);
        } else if (member instanceof TypeScriptFunctionSignature) {
            typeMember = TypeScriptTypeMemberParser.copyFunctionSignature((TypeScriptFunctionSignature)member, typeSubstitutor);
        } else if (member instanceof TypeScriptCallSignature) {
            typeMember = TypeScriptTypeMemberParser.copyCallSignature((TypeScriptCallSignature)member, typeSubstitutor);
        } else if (member instanceof TypeScriptIndexSignature) {
            typeMember = TypeScriptTypeMemberParser.copyIndexSignature((TypeScriptIndexSignature)member, typeSubstitutor);
        }
        return typeMember;
    }

    @Nullable
    public static JSRecordType.TypeMember buildComputedPropertySignature(@NotNull PsiElement member) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(1);
        }
        if (member instanceof JSComputedPropertyNameOwner && member instanceof JSRecordType.PropertySignature) {
            String referenceName;
            ES6ComputedName name = ((JSComputedPropertyNameOwner)member).getComputedPropertyName();
            String string = referenceName = name == null ? null : name.getExpressionAsReferenceName();
            if (referenceName != null) {
                return new JSRecordTypeImpl.ComputedPropertySignatureImpl(referenceName, ((JSRecordType.PropertySignature)member).getJSType(), ((JSRecordType.PropertySignature)member).isOptional(), ((JSRecordType.PropertySignature)member).isConst(), ((JSRecordType.PropertySignature)member).getMemberSource());
            }
        }
        return null;
    }

    @Nullable
    public static String tryGetComputedName(@NotNull JSComputedPropertyNameOwner member) {
        ES6ComputedName computedName;
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(2);
        }
        JSType type = (computedName = member.getComputedPropertyName()) == null ? null : TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression(computedName);
        return TypeScriptTypeMemberParser.getComputedPropNameFromType(type);
    }

    @Nullable
    public static String getComputedPropNameFromType(JSType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSNumberLiteralTypeImpl) {
            return type.getTypeText();
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            return ((JSStringLiteralTypeImpl)type).getLiteral();
        }
        return null;
    }

    static boolean isEmptySubstitutor(@Nullable JSTypeSubstitutor typeSubstitutor) {
        return typeSubstitutor == null || typeSubstitutor == JSTypeSubstitutor.EMPTY || typeSubstitutor.isEmpty();
    }

    @NotNull
    private static JSRecordType.TypeMember copyIndexSignature(@NotNull TypeScriptIndexSignature indexSignature, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (indexSignature == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(3);
        }
        JSType signatureType = indexSignature.getMemberType();
        JSType parameterType = indexSignature.getMemberParameterType();
        JSType appliedParameterType = JSTypeUtils.applyGenericArguments(parameterType, typeSubstitutor);
        JSType appliedSignatureType = JSTypeUtils.applyGenericArguments(signatureType, typeSubstitutor);
        if (signatureType == appliedSignatureType && parameterType == appliedParameterType) {
            TypeScriptIndexSignature typeScriptIndexSignature = indexSignature;
            if (typeScriptIndexSignature == null) {
                TypeScriptTypeMemberParser.$$$reportNull$$$0(4);
            }
            return typeScriptIndexSignature;
        }
        return new JSRecordTypeImpl.IndexSignatureImpl(appliedParameterType, appliedSignatureType, (PsiElement)indexSignature, indexSignature.isForComputedProperty());
    }

    @NotNull
    private static JSRecordType.TypeMember copyCallSignature(@NotNull TypeScriptCallSignature member, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSFunctionTypeImpl appliedType;
        JSFunctionType type;
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(5);
        }
        return (type = member.getFunctionType()) == (appliedType = (JSFunctionTypeImpl)JSTypeUtils.applyGenericArguments((JSType)type, typeSubstitutor)) ? member : new JSRecordTypeImpl.CallSignatureImpl(member.isConstructor(), appliedType);
    }

    @Nullable
    private static JSRecordType.TypeMember copyFunctionSignature(@NotNull TypeScriptFunctionSignature functionSignature, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSType appliedType;
        String name;
        if (functionSignature == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)(name = functionSignature.getMemberName()))) {
            return null;
        }
        JSType type = functionSignature.getJSType();
        return type == (appliedType = JSTypeUtils.applyGenericArguments(type, typeSubstitutor)) ? functionSignature : new JSRecordTypeImpl.PropertySignatureImpl(name, appliedType, functionSignature.isOptional(), functionSignature.isConst(), (PsiElement)functionSignature);
    }

    @Nullable
    private static JSRecordType.TypeMember copyPropertySignature(@NotNull TypeScriptPropertySignature propertySignature, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (propertySignature == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(7);
        }
        JSType type = propertySignature.getJSType();
        String name = propertySignature.getMemberName();
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        JSType appliedType = JSTypeUtils.applyGenericArguments(type, typeSubstitutor);
        return type == appliedType ? propertySignature : new JSRecordTypeImpl.PropertySignatureImpl(name, appliedType, propertySignature.isOptional(), propertySignature.isConst(), (PsiElement)propertySignature);
    }

    static boolean isPropertyNameEmpty(@NotNull PsiElement member) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(8);
        }
        return member instanceof JSRecordType.PropertySignature && StringUtil.isEmpty((String)((JSRecordType.PropertySignature)member).getMemberName());
    }

    public static JSRecordType.TypeMember buildTypeMember(@NotNull TypeScriptTypeMember member) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(9);
        }
        return TypeScriptTypeMemberParser.buildTypeMember(member, JSTypeSubstitutor.EMPTY);
    }

    @Nullable
    public static JSRecordType.TypeMember buildTypeMemberFromElement(@Nullable JSClass ownerClass, @NotNull PsiElement member, boolean isStatic, @NotNull JSTypeSource source, @Nullable JSTypeSubstitutor typeSubstitutor) {
        String name;
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(10);
        }
        if (source == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(11);
        }
        if (ownerClass != null && JSResolveUtil.isConstructorFunction(member)) {
            if (isStatic) {
                JSType constructorReturnType = TypeScriptTypeParser.createConstructorReturnType(ownerClass, source);
                TypeScriptJSFunctionTypeImpl functionType = TypeScriptTypeParser.buildFunctionTypeImpl((JSFunctionItem)((JSFunction)member), constructorReturnType);
                TypeScriptJSFunctionTypeImpl type = (TypeScriptJSFunctionTypeImpl)JSTypeUtils.applyGenericArguments(functionType, typeSubstitutor);
                return new JSRecordTypeImpl.CallSignatureImpl(true, type);
            }
            return null;
        }
        if (!TypeScriptTypeMemberParser.checkStatics(member, isStatic)) {
            return null;
        }
        if (member instanceof TypeScriptTypeMember) {
            return TypeScriptTypeMemberParser.buildTypeMember((TypeScriptTypeMember)member, typeSubstitutor);
        }
        if (TypeScriptTypeMemberParser.isEmptySubstitutor(typeSubstitutor) && member instanceof JSRecordType.TypeMember) {
            if (TypeScriptTypeMemberParser.isPropertyNameEmpty(member)) {
                return TypeScriptTypeMemberParser.buildComputedPropertySignature(member);
            }
            return (JSRecordType.TypeMember)member;
        }
        String string = name = member instanceof PsiNamedElement ? ((PsiNamedElement)member).getName() : null;
        if (name == null && member instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)member);
        }
        if (name == null) {
            return null;
        }
        JSType typeForProperty = TypeScriptTypeParser.buildTypeFromClassMember(member);
        JSType type = JSTypeUtils.applyGenericArguments(typeForProperty, typeSubstitutor);
        boolean optional = member instanceof JSOptionalOwner && ((JSOptionalOwner)member).isOptional();
        boolean isReadonly = member instanceof JSConstStatusOwner && ((JSConstStatusOwner)member).isConst();
        return new JSRecordTypeImpl.PropertySignatureImpl(name, type, optional, isReadonly, member);
    }

    private static boolean checkStatics(@NotNull PsiElement member, boolean isStatic) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(12);
        }
        if (!(member instanceof JSElementBase)) {
            return true;
        }
        JSContext context = ((JSElementBase)member).getJSContext();
        boolean isContextStatic = context == JSContext.STATIC;
        return isStatic == isContextStatic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSignature";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSignature";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "copyIndexSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeMember";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildComputedPropertySignature";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryGetComputedName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyIndexSignature";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyCallSignature";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyFunctionSignature";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyPropertySignature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyNameEmpty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeMemberFromElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkStatics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

