/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTemplateLiteralJSTypeImpl
extends JSTypeBaseImpl
implements JSTemplateLiteralType,
JSType.CompositeStructure,
JSEvaluableType {
    @NotNull
    private final List<String> myTexts;
    @NotNull
    private final List<JSType> myTypes;
    private final boolean myAllowWidening;

    @NotNull
    public static JSType createType(@NotNull List<String> texts, @NotNull List<JSType> types2, boolean allowWidening, @NotNull JSTypeSource source) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(2);
        }
        if (ContainerUtil.exists(types2, t -> t instanceof TypeScriptNeverJSTypeImpl)) {
            return new TypeScriptNeverJSTypeImpl(source);
        }
        return new TypeScriptTemplateLiteralJSTypeImpl(texts, types2, allowWidening, source);
    }

    private TypeScriptTemplateLiteralJSTypeImpl(@NotNull List<String> texts, @NotNull List<JSType> types2, boolean allowWidening, @NotNull JSTypeSource source) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(3);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(4);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(5);
        }
        super(source);
        this.myTexts = ContainerUtil.immutableList(texts);
        this.myTypes = ContainerUtil.immutableList(types2);
        this.myAllowWidening = allowWidening;
    }

    @NotNull
    public JSType widen(boolean allowResolve) {
        JSTypeBaseImpl jSTypeBaseImpl = this.allowWidening() ? new JSStringType(true, this.getSource(), JSTypeContext.INSTANCE) : this;
        if (jSTypeBaseImpl == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(6);
        }
        return jSTypeBaseImpl;
    }

    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    @NotNull
    public JSType copyWithAllowWidening(boolean allowWidening) {
        return new TypeScriptTemplateLiteralJSTypeImpl(this.myTexts, this.myTypes, allowWidening, this.getSource());
    }

    @Override
    @NotNull
    public List<String> getTexts() {
        List<String> list2 = this.myTexts;
        if (list2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<JSType> getTypes() {
        List<JSType> list2 = this.myTypes;
        if (list2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        List types2;
        if (childTransform == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(9);
        }
        return ContainerUtil.equalsIdentity(this.myTypes, (List)(types2 = ContainerUtil.map(this.myTypes, type -> JSTypeUtils.transformTypeHierarchySafe(type, childTransform)))) ? this : TypeScriptTemplateLiteralJSTypeImpl.createType(this.myTexts, types2, this.myAllowWidening, this.getSource());
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(10);
        }
        return new TypeScriptTemplateLiteralJSTypeImpl(this.myTexts, this.myTypes, this.myAllowWidening, source);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(11);
        }
        TypeScriptTemplateLiteralJSTypeImpl literalType = (TypeScriptTemplateLiteralJSTypeImpl)type;
        if (this.myTypes.size() != literalType.getTypes().size() || this.myTexts.size() != literalType.getTexts().size()) {
            return false;
        }
        if (!JSTypeCastUtil.areListsEquivalent(this.myTypes, literalType.getTypes(), context, allowResolve)) {
            return false;
        }
        return this.myTexts.equals(literalType.getTexts());
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(13);
        }
        builder.append("`");
        builder.append((String)ContainerUtil.getFirstItem(this.myTexts, (Object)""));
        for (int i = 0; i < this.myTypes.size(); ++i) {
            builder.append("${");
            JSType type = this.myTypes.get(i);
            builder.append(type, format);
            builder.append("}");
            String text = this.myTexts.get(i + 1);
            builder.append(text);
        }
        builder.append("`");
    }

    @Override
    @Nullable
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        JSType substitute;
        if (context == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(14);
        }
        if ((substitute = this.substituteTypes(context)) != this) {
            return substitute;
        }
        JSType distributedType = this.distributeTemplateLiteralType();
        if (distributedType != this) {
            return distributedType;
        }
        return this.substituteTemplateLiteral();
    }

    @NotNull
    private JSType substituteTypes(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(15);
        }
        SmartList substitutedTypes = new SmartList();
        boolean substituted = false;
        for (JSType type : this.myTypes) {
            JSType newType = context.substituteNested(type);
            if (newType == null) {
                JSAnyType jSAnyType = JSAnyType.get(this.getSource());
                if (jSAnyType == null) {
                    TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(16);
                }
                return jSAnyType;
            }
            if (type != newType) {
                substituted = true;
            }
            substitutedTypes.add(newType);
        }
        TypeScriptTemplateLiteralJSTypeImpl typeScriptTemplateLiteralJSTypeImpl = substituted ? TypeScriptTemplateLiteralJSTypeImpl.createType(this.myTexts, (List<JSType>)substitutedTypes, this.myAllowWidening, this.getSource()) : this;
        if (typeScriptTemplateLiteralJSTypeImpl == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(17);
        }
        return typeScriptTemplateLiteralJSTypeImpl;
    }

    @NotNull
    private JSType substituteTemplateLiteral() {
        SmartList newTexts = new SmartList();
        SmartList newTypes = new SmartList();
        StringBuilder text = new StringBuilder();
        text.append(this.myTexts.get(0));
        if (!TypeScriptTemplateLiteralJSTypeImpl.addSpans(this.myTexts, this.myTypes, (List<String>)newTexts, (List<JSType>)newTypes, text)) {
            return new JSStringType(true, this.getSource(), JSTypeContext.INSTANCE);
        }
        if (newTypes.isEmpty()) {
            return new JSStringLiteralTypeImpl(text.toString(), this.myAllowWidening, this.getSource());
        }
        newTexts.add(text.toString());
        JSType literalType = TypeScriptTemplateLiteralJSTypeImpl.createType((List<String>)newTexts, (List<JSType>)newTypes, this.myAllowWidening, this.getSource());
        TypeScriptTemplateLiteralJSTypeImpl typeScriptTemplateLiteralJSTypeImpl = this.isEquivalentToWithSameClass(literalType, null, true) ? this : literalType;
        if (typeScriptTemplateLiteralJSTypeImpl == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(18);
        }
        return typeScriptTemplateLiteralJSTypeImpl;
    }

    @NotNull
    private JSType distributeTemplateLiteralType() {
        if (!TypeScriptTypeRelations.checkCrossProductUnion(this.myTypes)) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource());
            if (jSAnyType == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(19);
            }
            return jSAnyType;
        }
        boolean distribute = false;
        for (JSType type : this.myTypes) {
            if (type instanceof JSUnionType) {
                distribute = true;
                continue;
            }
            if (!(type instanceof TypeScriptNeverJSTypeImpl)) continue;
            return new TypeScriptNeverJSTypeImpl(this.getSource());
        }
        if (!distribute) {
            TypeScriptTemplateLiteralJSTypeImpl typeScriptTemplateLiteralJSTypeImpl = this;
            if (typeScriptTemplateLiteralJSTypeImpl == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(20);
            }
            return typeScriptTemplateLiteralJSTypeImpl;
        }
        SmartList constituents = new SmartList();
        this.distributeTypeLiteralConstituents((Collection<JSType>)constituents, new ArrayDeque<JSType>(this.myTypes.size()), 0);
        JSType jSType = JSCompositeTypeFactory.createUnionType(this.getSource(), (Collection<? extends JSType>)constituents);
        if (jSType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(21);
        }
        return jSType;
    }

    private void distributeTypeLiteralConstituents(@NotNull Collection<JSType> constituents, @NotNull Deque<JSType> types2, int idx) {
        if (constituents == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(22);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(23);
        }
        if (idx == this.myTypes.size()) {
            constituents.add(TypeScriptTemplateLiteralJSTypeImpl.createType(this.myTexts, new ArrayList<JSType>(types2), this.myAllowWidening, this.getSource()));
            return;
        }
        JSType type = this.myTypes.get(idx);
        if (type instanceof JSUnionType) {
            List<JSType> childConstituents = ((JSUnionType)type).getTypes();
            for (JSType constituent : childConstituents) {
                types2.addLast(constituent);
                this.distributeTypeLiteralConstituents(constituents, types2, idx + 1);
                types2.removeLast();
            }
        } else {
            types2.addLast(type);
            this.distributeTypeLiteralConstituents(constituents, types2, idx + 1);
            types2.removeLast();
        }
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myTexts, this.myTypes);
    }

    private static boolean addSpans(@NotNull List<String> texts, @NotNull List<JSType> types2, @NotNull List<String> newTexts, @NotNull List<JSType> newTypes, @NotNull StringBuilder text) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(24);
        }
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(25);
        }
        if (newTexts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(26);
        }
        if (newTypes == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(27);
        }
        if (text == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(28);
        }
        for (int i = 0; i < types2.size(); ++i) {
            JSType type = types2.get(i);
            if (type instanceof JSPrimitiveLiteralType || type instanceof JSNullType || type instanceof JSUndefinedType) {
                text.append(TypeScriptTemplateLiteralJSTypeImpl.getTemplateStringForType(type));
                text.append(texts.get(i + 1));
                continue;
            }
            if (type instanceof JSTemplateLiteralType) {
                JSTemplateLiteralType literalType = (JSTemplateLiteralType)type;
                text.append(literalType.getTexts().get(0));
                if (!TypeScriptTemplateLiteralJSTypeImpl.addSpans(literalType.getTexts(), literalType.getTypes(), newTexts, newTypes, text)) {
                    return false;
                }
                text.append(texts.get(i + 1));
                continue;
            }
            if (TypeScriptTypeRelations.isGenericIndexType(type) || TypeScriptTypeRelations.isPatternLiteralPlaceholderType(type)) {
                newTypes.add(type);
                newTexts.add(text.toString());
                text.setLength(0);
                text.append(texts.get(i + 1));
                continue;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static String getTemplateStringForType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(29);
        }
        if (type instanceof JSBooleanLiteralTypeImpl || type instanceof JSNumberLiteralTypeImpl) {
            String string = ((JSPrimitiveLiteralType)type).getValueAsString();
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(30);
            }
            return string;
        }
        if (type instanceof JSBigIntLiteralTypeImpl) {
            String string = ((JSBigIntLiteralTypeImpl)type).getLiteral().toString();
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(31);
            }
            return string;
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            String string = ((JSStringLiteralTypeImpl)type).getLiteral();
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(32);
            }
            return string;
        }
        if (type instanceof JSNullType || type instanceof JSUndefinedType) {
            String string = type.getTypeText(JSType.TypeTextFormat.CODE);
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(33);
            }
            return string;
        }
        return "";
    }

    @Override
    public void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(34);
        }
        visitor.visitTypeScriptTemplateLiteralType((JSType)this);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(35);
        }
        for (JSType type : this.getTypes()) {
            type.accept(visitor);
        }
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTemplateLiteralType literalType;
        if (elementType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(36);
        }
        if (processingContext == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(37);
        }
        boolean isProcessingGenerics = JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext);
        boolean isPatternLiteral = TypeScriptTypeRelations.isPatternLiteralType(this);
        if (elementType instanceof JSStringLiteralTypeImpl && (isPatternLiteral || !isProcessingGenerics)) {
            List<JSType> inferred = this.inferLiterals((JSStringLiteralTypeImpl)elementType);
            if (this.myTypes.size() != inferred.size()) {
                return false;
            }
            if (isPatternLiteral) {
                return TypeScriptTypeRelations.everyType(this.myTypes, inferred, TypeScriptTemplateLiteralJSTypeImpl::isStringLiteralTypeValueParsableAsType);
            }
            return this.areTypesAssignableWithoutApply(inferred, processingContext);
        }
        if (elementType instanceof JSTemplateLiteralType && this.myTexts.equals((literalType = (JSTemplateLiteralType)elementType).getTexts()) && this.areTypesAssignableWithoutApply(literalType.getTypes(), processingContext)) {
            return true;
        }
        if (!isProcessingGenerics) {
            return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
        }
        this.inferAndApplyGenerics(elementType, processingContext);
        return false;
    }

    private boolean areTypesAssignableWithoutApply(@NotNull List<JSType> types2, @NotNull ProcessingContext processingContext) {
        if (types2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(38);
        }
        if (processingContext == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(39);
        }
        return TypeScriptTypeRelations.everyType(this.myTypes, types2, (target, source) -> target instanceof JSAnyType || target instanceof JSStringType || target.isDirectlyAssignableType(source, processingContext));
    }

    private void inferAndApplyGenerics(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(40);
        }
        if (processingContext == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(41);
        }
        List<Object> inferredTypes = elementType instanceof JSStringLiteralTypeImpl ? this.inferLiterals((JSStringLiteralTypeImpl)elementType) : (elementType instanceof JSTemplateLiteralType && ((JSTemplateLiteralType)elementType).getTexts().equals(this.myTexts) ? ((JSTemplateLiteralType)elementType).getTypes() : Collections.emptyList());
        JSGenericMappings genericMappings = JSGenericTypesEvaluator.getGenericMappings(processingContext);
        assert (genericMappings != null);
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> mapping = genericMappings.getMapping();
        TypeScriptNeverJSTypeImpl defaultType = new TypeScriptNeverJSTypeImpl(this.getSource());
        for (int i = 0; i < this.myTypes.size(); ++i) {
            JSGenericParameterImpl parameterType = (JSGenericParameterImpl)ObjectUtils.tryCast((Object)this.myTypes.get(i), JSGenericParameterImpl.class);
            if (parameterType == null || !parameterType.isApplying()) continue;
            JSType inferredType = (JSType)ContainerUtil.getOrElse(inferredTypes, (int)i, (Object)defaultType);
            mapping.putValue((Object)parameterType.getGenericId(), (Object)inferredType);
        }
    }

    @NotNull
    private List<JSType> inferLiterals(@NotNull JSStringLiteralTypeImpl stringLiteralType) {
        if (stringLiteralType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(42);
        }
        String value = stringLiteralType.getLiteral();
        int lastIndex = this.myTexts.size() - 1;
        int startIndex = 0;
        String startText = this.myTexts.get(startIndex);
        String endText = this.myTexts.get(lastIndex);
        if (!value.startsWith(startText) || !value.substring(startText.length()).endsWith(endText)) {
            List<JSType> list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(43);
            }
            return list2;
        }
        ArrayList<JSType> matches = new ArrayList<JSType>(this.myTypes.size());
        String str = value.substring(startText.length(), value.length() - endText.length());
        int pos = 0;
        for (int i = 1; i < lastIndex; ++i) {
            int delimPos;
            String delim = this.myTexts.get(i);
            int n = delim.length() > 0 ? str.indexOf(delim, pos) : (delimPos = pos < str.length() ? pos + 1 : -1);
            if (delimPos < 0) {
                List<JSType> list3 = Collections.emptyList();
                if (list3 == null) {
                    TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(44);
                }
                return list3;
            }
            matches.add(new JSStringLiteralTypeImpl(str.substring(pos, delimPos), false, this.getSource()));
            pos = delimPos + delim.length();
        }
        matches.add(new JSStringLiteralTypeImpl(str.substring(pos), false, this.getSource()));
        ArrayList<JSType> arrayList = matches;
        if (arrayList == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    public static boolean isStringLiteralTypeValueParsableAsType(@NotNull JSType target, @NotNull JSType source) {
        if (target == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(46);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(47);
        }
        if (!(source instanceof JSStringLiteralTypeImpl)) {
            return false;
        }
        if (target instanceof JSUnionType) {
            return ((JSUnionType)target).getTypes().stream().anyMatch(t -> TypeScriptTemplateLiteralJSTypeImpl.isStringLiteralTypeValueParsableAsType(t, source));
        }
        String literal = ((JSStringLiteralTypeImpl)source).getLiteral();
        if (target instanceof JSStringType) {
            return true;
        }
        if (target instanceof JSNumberType) {
            return TypeScriptTemplateLiteralJSTypeImpl.isValidNumberString(literal);
        }
        if (target instanceof JSBigIntType) {
            return TypeScriptTemplateLiteralJSTypeImpl.isValidNumberString(literal + "n");
        }
        if (target instanceof JSBooleanType) {
            return literal.equals("true") || literal.equals("false");
        }
        if (target instanceof JSUndefinedType) {
            return literal.equals("undefined");
        }
        if (target instanceof JSNullType) {
            return literal.equals("null");
        }
        return target instanceof JSAnyType;
    }

    private static boolean isValidNumberString(@NotNull String literal) {
        if (literal == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(48);
        }
        JSFlexAdapter flexAdapter = new JSFlexAdapter(DialectOptionHolder.TS);
        flexAdapter.start(literal);
        if (flexAdapter.getTokenType() == JSTokenTypes.MINUS) {
            flexAdapter.advance();
        }
        if (flexAdapter.getTokenType() != JSTokenTypes.NUMERIC_LITERAL) {
            return false;
        }
        flexAdapter.advance();
        return flexAdapter.getTokenType() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 1: 
            case 4: 
            case 23: 
            case 25: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTemplateLiteralJSTypeImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 11: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constituents";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTexts";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTypes";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 37: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteralType";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTemplateLiteralJSTypeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "widen";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTexts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTypes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTemplateLiteral";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeTemplateLiteralType";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateStringForType";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "inferLiterals";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "substituteTypes";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "distributeTypeLiteralConstituents";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addSpans";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateStringForType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "areTypesAssignableWithoutApply";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "inferAndApplyGenerics";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "inferLiterals";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteralTypeValueParsableAsType";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isValidNumberString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

