/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfoImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeImpl
extends JSNamedType
implements JSResolvableType,
JSTypeWithWidening {
    private static final Key<JSType> ourTypedefsExpandedKey = Key.create((String)"typedefs.expanded");
    @NotNull
    private final String myType;
    private final boolean myAllowWidening;
    private final boolean myIsLocal;
    @NotNull
    private final NullableLazyValue<PsiElement> myLocalScope;
    @NotNull
    private final CachedValue<JSResolvedTypeInfo> myCachedValue;

    JSTypeImpl(@NotNull String type, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean isLocal) {
        if (type == null) {
            JSTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(1);
        }
        if (staticOrInstance == null) {
            JSTypeImpl.$$$reportNull$$$0(2);
        }
        this(type, source, staticOrInstance, false, isLocal, null);
    }

    JSTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator serialized) {
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(3);
        }
        if (serialized == null) {
            JSTypeImpl.$$$reportNull$$$0(4);
        }
        super(source, serialized);
        this.myLocalScope = NullableLazyValue.createValue(() -> JSTypeUtils.getLocalScopeFromSource(this));
        this.myType = JSTypeSerializer.readString(serialized);
        this.myAllowWidening = JSTypeSerializer.readBoolean(serialized);
        this.myIsLocal = JSTypeSerializer.readBoolean(serialized);
        this.myCachedValue = JSTypeImpl.createResolvedTypeInfoCachedValue(source.getSourceElement(), (Getter<JSResolvedTypeInfo>)((Getter)() -> this.resolveTypeImpl()), null);
    }

    private JSTypeImpl(@NotNull String type, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean allowWidening, boolean isLocal, @Nullable JSResolvedTypeInfo prevInfo) {
        if (type == null) {
            JSTypeImpl.$$$reportNull$$$0(5);
        }
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(6);
        }
        if (staticOrInstance == null) {
            JSTypeImpl.$$$reportNull$$$0(7);
        }
        super(source, staticOrInstance);
        this.myLocalScope = NullableLazyValue.createValue(() -> JSTypeUtils.getLocalScopeFromSource(this));
        this.myType = type;
        this.myAllowWidening = allowWidening;
        this.myIsLocal = isLocal;
        PsiElement element = source.getSourceElement();
        this.myCachedValue = JSTypeImpl.createResolvedTypeInfoCachedValue(element, (Getter<JSResolvedTypeInfo>)((Getter)() -> this.resolveTypeImpl()), prevInfo);
        assert (!type.startsWith("import("));
    }

    @Override
    public void serialize(@NotNull StringBuilder builder) {
        if (builder == null) {
            JSTypeImpl.$$$reportNull$$$0(8);
        }
        super.serialize(builder);
        JSTypeSerializer.writeString(this.myType, builder);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, builder);
        JSTypeSerializer.writeBoolean(this.myIsLocal, builder);
    }

    private static long calcModification(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeImpl.$$$reportNull$$$0(9);
        }
        return PsiModificationTracker.SERVICE.getInstance((Project)element.getProject()).getModificationCount();
    }

    @NotNull
    private static CachedValue<JSResolvedTypeInfo> createResolvedTypeInfoCachedValue(@Nullable PsiElement element, @NotNull Getter<JSResolvedTypeInfo> builder, @Nullable JSResolvedTypeInfo prevValue) {
        if (builder == null) {
            JSTypeImpl.$$$reportNull$$$0(10);
        }
        if (JSTypeImpl.isSourceElementNotValid(element)) {
            return new CachedValueImpl(() -> CachedValueProvider.Result.create((Object)((JSResolvedTypeInfo)builder.get()), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
        }
        long startModification = prevValue == null ? -1L : JSTypeImpl.calcModification(element);
        CachedValue cachedValue = CachedValuesManager.getManager((Project)element.getProject()).createCachedValue(() -> {
            if (prevValue != null && JSTypeImpl.calcModification(element) == startModification) {
                return CachedValueProvider.Result.create((Object)prevValue, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            return CachedValueProvider.Result.create((Object)((JSResolvedTypeInfo)builder.get()), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }, false);
        if (cachedValue == null) {
            JSTypeImpl.$$$reportNull$$$0(11);
        }
        return cachedValue;
    }

    @Override
    @NotNull
    public final JSResolvedTypeInfo resolveType() {
        JSResolvedTypeInfo jSResolvedTypeInfo = (JSResolvedTypeInfo)this.myCachedValue.getValue();
        if (jSResolvedTypeInfo == null) {
            JSTypeImpl.$$$reportNull$$$0(12);
        }
        return jSResolvedTypeInfo;
    }

    @NotNull
    private JSResolvedTypeInfo resolveTypeImpl() {
        JSTypeResolveResult result2;
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            return new JSResolvedTypeInfoImpl(this.myType, ContainerUtil.emptyList());
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler();
        if (this.myIsLocal && this.isJavaScript()) {
            result2 = importHandler.resolveName(this.myType, sourceElement, this.getLocalScope());
        } else {
            JSContext context = this.getTypeContext().toJSContext();
            result2 = importHandler.resolveMainElementName(this.myType, sourceElement, context);
        }
        return new JSResolvedTypeInfoImpl(result2.getQualifiedName(), result2.getElements());
    }

    @Override
    @Deprecated
    @Nullable
    public JSClass resolveClass() {
        PsiElement clazz;
        if (!this.isEcma()) {
            return null;
        }
        ProgressManager.checkCanceled();
        String qualifiedType = this.myType;
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        PsiElement resolvedElement = null;
        if (element != null) {
            JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)this.getScope()).getImportHandler();
            JSTypeResolveResult result2 = importHandler.resolveTypeName(this.myType, element);
            qualifiedType = result2.getQualifiedName();
            Iterator<? extends PsiElement> iterator = result2.getElements().iterator();
            if (iterator.hasNext()) {
                resolvedElement = iterator.next();
            }
        }
        PsiElement psiElement = clazz = resolvedElement != null ? resolvedElement : JSResolveUtil.findType(qualifiedType, (PsiElement)this.getScope(), true);
        if (clazz instanceof JSClass) {
            return (JSClass)clazz;
        }
        return null;
    }

    public static boolean isSourceElementNotValid(PsiElement sourceElement) {
        return sourceElement == null || !sourceElement.isValid();
    }

    @Nullable
    public static JSType fromElement(PsiElement element, PsiElement context) {
        JSType type = null;
        if (element instanceof JSVariable) {
            type = ((JSVariable)element).getJSType();
        } else if (element instanceof JSFunction) {
            type = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)((JSFunction)element), JSTypeUtils.getScopeInOriginalTree(context));
        }
        return type;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSTypeImpl.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            JSTypeImpl.$$$reportNull$$$0(14);
        }
        if (format == JSType.TypeTextFormat.RESOLVED || format == JSType.TypeTextFormat.CODE) {
            String qualifiedName = this.getSimpleResolvedTypeText();
            if (format == JSType.TypeTextFormat.CODE && TypeScriptUtil.hasAmbientExternalModuleInQName(qualifiedName)) {
                builder.append(this.myType);
                return;
            }
            builder.append(qualifiedName);
            return;
        }
        builder.append(this.myType);
    }

    @NotNull
    private String getSimpleResolvedTypeText() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            String string = this.myType;
            if (string == null) {
                JSTypeImpl.$$$reportNull$$$0(15);
            }
            return string;
        }
        JSResolvedTypeInfo resolvedType = this.resolveType();
        String string = resolvedType.getResolvedTypeText();
        if (string == null) {
            JSTypeImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        String qualifiedName;
        TypeScriptEnum parentEnumElement;
        TypeScriptEnumField field;
        JSType typedefValue;
        if (elementType == null) {
            JSTypeImpl.$$$reportNull$$$0(17);
        }
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(18);
        }
        if (this.isSourceStrict() && !this.isEcma() && (typedefValue = this.getJSTypedef()) != null) {
            return typedefValue.isDirectlyAssignableType(elementType, processingContext);
        }
        JSResolvedTypeInfo resolvedType = this.resolveType();
        if (elementType instanceof JSNumberType && resolvedType.isEnum()) {
            return true;
        }
        boolean isEnumLiteral = resolvedType.isEnumLiteral();
        boolean otherIsEnumLiteral = false;
        boolean otherIsEnum = false;
        JSResolvedTypeInfo resolvedOtherType = null;
        if (elementType instanceof JSTypeImpl) {
            resolvedOtherType = ((JSTypeImpl)elementType).resolveType();
            otherIsEnumLiteral = resolvedOtherType.isEnumLiteral();
            otherIsEnum = resolvedOtherType.isEnum();
        }
        if (isEnumLiteral && otherIsEnumLiteral) {
            TypeScriptEnum otherEnum;
            if (!JSTypeImpl.enumValuesIdentical(resolvedType.getEnumConstValue(), resolvedOtherType.getEnumConstValue())) {
                return false;
            }
            TypeScriptEnumField ownField = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
            TypeScriptEnumField otherField = resolvedOtherType.getDeclarationOfType(TypeScriptEnumField.class);
            if (ownField == null || otherField == null) {
                return false;
            }
            TypeScriptEnum ownEnum = ownField.getOwner();
            return Objects.equals(ownEnum, otherEnum = otherField.getOwner());
        }
        if (otherIsEnumLiteral && resolvedType.isEnum() && (field = resolvedOtherType.getDeclarationOfType(TypeScriptEnumField.class)) != null && (parentEnumElement = (TypeScriptEnum)PsiTreeUtil.getContextOfType((PsiElement)field, (Class[])new Class[]{TypeScriptEnum.class})) != null && (qualifiedName = parentEnumElement.getQualifiedName()) != null) {
            return this.isDirectlyAssignableType(JSNamedTypeFactory.createExplicitlyDeclaredType(qualifiedName, (PsiElement)parentEnumElement), processingContext);
        }
        if (isEnumLiteral && otherIsEnum) {
            return false;
        }
        if (elementType instanceof JSNumberType && isEnumLiteral) {
            field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
            if (field == null) {
                return false;
            }
            Double value = field.getConstantValue().getNumericValue();
            return value != null;
        }
        if (elementType instanceof JSStringLiteralTypeImpl && isEnumLiteral) {
            return false;
        }
        if (!otherIsEnum && isEnumLiteral && !JSTypeUtils.hasForeignGenericParameter(elementType)) {
            return false;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private static boolean enumValuesIdentical(EnumConstantValue ownConstantValue, EnumConstantValue otherConstantValue) {
        Double ownDouble = ownConstantValue.getNumericValue();
        Double otherDouble = otherConstantValue.getNumericValue();
        if (ownDouble != null && otherDouble != null && Objects.equals(ownDouble, otherDouble)) {
            return true;
        }
        String ownString = ownConstantValue.getStringValue();
        String otherString = otherConstantValue.getStringValue();
        if (ownString != null && otherString != null && Objects.equals(ownString, otherString)) {
            return true;
        }
        BigInteger ownBigInt = ownConstantValue.getBigIntValue();
        BigInteger otherBigInt = otherConstantValue.getBigIntValue();
        return ownBigInt != null && otherBigInt != null && Objects.equals(ownBigInt, otherBigInt);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSTypeImpl.$$$reportNull$$$0(19);
        }
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(20);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSTypeImpl.$$$reportNull$$$0(21);
            }
            return assignableResult;
        }
        if (elementType instanceof JSTypeImpl) {
            JSTypeImpl elementTypeImpl = (JSTypeImpl)elementType;
            JSTypeContext elementTypeContext = elementTypeImpl.getTypeContext();
            if (this.getTypeContext() == JSTypeContext.STATIC && elementTypeContext == JSTypeContext.STATIC) {
                JSResolvedTypeInfo resolvedType1 = this.resolveType();
                JSResolvedTypeInfo resolvedType2 = ((JSTypeImpl)elementType).resolveType();
                if (!resolvedType1.isAbstract() && resolvedType2.isAbstract()) {
                    JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
                    if (assignableResult == null) {
                        JSTypeImpl.$$$reportNull$$$0(22);
                    }
                    return assignableResult;
                }
            }
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.getTypeHelper().isAssignableToNamedType(this, elementType, processingContext));
        if (assignableResult == null) {
            JSTypeImpl.$$$reportNull$$$0(23);
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSTypeImpl.$$$reportNull$$$0(24);
        }
        if (!super.isEquivalentToWithSameClass(type, processingContext, allowResolve)) {
            return false;
        }
        if (this.getSource().getLanguage() != type.getSource().getLanguage()) {
            return false;
        }
        JSTypeImpl jsType = (JSTypeImpl)type;
        if (this.getJSContext() != jsType.getJSContext()) {
            return false;
        }
        if (!Objects.equals(this.getLocalScope(), jsType.getLocalScope())) {
            return false;
        }
        if (!(this.isEcma() && allowResolve || this.myType.equals(((JSTypeImpl)type).myType))) {
            return false;
        }
        if (!allowResolve) {
            return true;
        }
        return this.getSimpleResolvedTypeText().equals(((JSTypeImpl)type).getSimpleResolvedTypeText()) && (this.isEcma() || Objects.equals(this.resolveType(), jsType.resolveType()));
    }

    @Nullable
    public final JSType getJSTypedef() {
        if (this.isTypeScript()) {
            return null;
        }
        JSResolvedTypeInfo resolvedType = this.resolveType();
        if (resolvedType.getAliasedType() != null) {
            return null;
        }
        String text = resolvedType.getResolvedTypeText();
        JSResolvedTypeId id = this.getResolvedTypeId();
        return id.getLocalCachedValue(ourTypedefsExpandedKey, () -> JSTypeEvaluateManager.expandTypedefs((PsiElement)this.getScope(), text));
    }

    @Override
    public void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSTypeImpl.$$$reportNull$$$0(25);
        }
        visitor.visitJSTypeImpl((JSType)this);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(26);
        }
        boolean sameContext = source.getSourceElement() == this.getSource().getSourceElement();
        return new JSTypeImpl(this.getTypeText(), source, this.getTypeContext(), false, this.myIsLocal, sameContext ? this.getCachedResolvedTypeInfo() : null);
    }

    @Nullable
    private JSResolvedTypeInfo getCachedResolvedTypeInfo() {
        return this.myCachedValue.hasUpToDateValue() ? this.resolveType() : null;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        JSType expanded;
        if (context == null) {
            JSTypeImpl.$$$reportNull$$$0(27);
        }
        JSResolvedTypeInfo info = this.resolveType();
        Collection<? extends PsiElement> declarations = info.getDeclarations();
        List<JSType> genericArguments = context.getGenerics();
        TypeScriptTypeAlias alias = (TypeScriptTypeAlias)ContainerUtil.findInstance(declarations, TypeScriptTypeAlias.class);
        if (alias == null) {
            JSType typedefValue;
            JSTypeSource source = this.getSource();
            if (source.isStrict() && source.getLanguage() == JSTypeSource.SourceLanguage.JS && (typedefValue = this.getJSTypedef()) != null) {
                return typedefValue.substitute(context);
            }
            return JSTypeImpl.expandDefaultGenericsForSingleType(this, genericArguments, declarations);
        }
        if (!JSTypeImpl.validateAliases(info, alias)) {
            return this;
        }
        JSType declaration = info.getAliasedType();
        if (declaration == null) {
            return this;
        }
        if (genericArguments.isEmpty() && (expanded = JSTypeImpl.expandDefaultGenericsForSingleType(this, genericArguments, declarations)) instanceof JSGenericTypeImpl) {
            genericArguments = ((JSGenericTypeImpl)expanded).getArguments();
        }
        if (!genericArguments.isEmpty()) {
            JSTypeSubstitutor generics = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)alias, (List<? extends JSType>)genericArguments);
            declaration = JSTypeUtils.applyGenericArguments(declaration, generics, false, null);
        }
        JSType afterProcessing = declaration.substitute(context.withGenerics(ContainerUtil.emptyList()));
        return JSTypeImpl.wrapWithAliasIfNeeded(this, afterProcessing, genericArguments);
    }

    @Nullable
    private static JSType wrapWithAliasIfNeeded(JSType type, JSType afterProcessing, List<JSType> genericArguments) {
        if (JSAliasTypeImpl.shouldPreserveAlias(afterProcessing)) {
            JSType aliasType = type;
            if (!genericArguments.isEmpty()) {
                aliasType = new JSGenericTypeImpl(type.getSource(), aliasType, genericArguments);
            }
            return new JSAliasTypeImpl(aliasType, afterProcessing, afterProcessing.getSource());
        }
        return afterProcessing;
    }

    @NotNull
    public static JSType expandDefaultGenericsForSingleType(@NotNull JSType selfType, @NotNull List<JSType> genericArguments, @NotNull Collection<? extends PsiElement> declarations) {
        if (selfType == null) {
            JSTypeImpl.$$$reportNull$$$0(28);
        }
        if (genericArguments == null) {
            JSTypeImpl.$$$reportNull$$$0(29);
        }
        if (declarations == null) {
            JSTypeImpl.$$$reportNull$$$0(30);
        }
        if (!genericArguments.isEmpty() || declarations.isEmpty() || !TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(selfType) || !selfType.isTypeScript()) {
            JSType jSType = selfType;
            if (jSType == null) {
                JSTypeImpl.$$$reportNull$$$0(31);
            }
            return jSType;
        }
        for (PsiElement psiElement : declarations) {
            List<JSType> types2;
            TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(psiElement);
            if (parameters.length == 0 || (types2 = TypeScriptGenericTypesEvaluator.getArgumentsListForTypeWithOwner(selfType, psiElement)).isEmpty()) continue;
            return new JSGenericTypeImpl(selfType.getSource(), selfType, types2);
        }
        JSType jSType = selfType;
        if (jSType == null) {
            JSTypeImpl.$$$reportNull$$$0(32);
        }
        return jSType;
    }

    @Override
    @NotNull
    public final String getTypeText(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSTypeImpl.$$$reportNull$$$0(33);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            String string = this.myType;
            if (string == null) {
                JSTypeImpl.$$$reportNull$$$0(34);
            }
            return string;
        }
        String string = super.getTypeText(format);
        if (string == null) {
            JSTypeImpl.$$$reportNull$$$0(35);
        }
        return string;
    }

    private static boolean validateAliases(@NotNull JSResolvedTypeInfo info, @NotNull TypeScriptTypeAlias alias) {
        if (info == null) {
            JSTypeImpl.$$$reportNull$$$0(36);
        }
        if (alias == null) {
            JSTypeImpl.$$$reportNull$$$0(37);
        }
        Collection<? extends PsiElement> declarations = info.getDeclarations();
        String name = alias.getName();
        if (name == null) {
            return false;
        }
        boolean hasAliases = false;
        for (PsiElement psiElement : declarations) {
            if (!(psiElement instanceof PsiNamedElement) || !name.equals(((PsiNamedElement)psiElement).getName())) {
                return false;
            }
            if (psiElement instanceof TypeScriptTypeAlias) {
                hasAliases = true;
                continue;
            }
            if (!JSTypeImpl.isInvalidForAlias(psiElement)) continue;
            return false;
        }
        return hasAliases;
    }

    private static boolean isInvalidForAlias(@NotNull PsiElement e) {
        if (e == null) {
            JSTypeImpl.$$$reportNull$$$0(38);
        }
        if (e instanceof TypeScriptTypeAlias) {
            return false;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)e);
        return virtualFile != null && !JSLibraryUtil.hasDirectoryInPath(virtualFile, JSLibraryUtil.LIBRARY_DIR_NAMES, null);
    }

    @NotNull
    public JSTypeImpl copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSTypeImpl jSTypeImpl = this;
            if (jSTypeImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(39);
            }
            return jSTypeImpl;
        }
        if (allowWidening && !this.myType.contains(".")) {
            JSTypeImpl jSTypeImpl = this;
            if (jSTypeImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(40);
            }
            return jSTypeImpl;
        }
        JSResolvedTypeInfo info = this.getCachedResolvedTypeInfo();
        return new JSTypeImpl(this.getTypeText(), this.getSource(), this.getTypeContext(), allowWidening, this.myIsLocal, info);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.isTypeScript(), super.hashCodeImpl(), this.allowWidening(), this.getLocalScope());
    }

    @NotNull
    public JSType widen(boolean allowResolve) {
        if (!this.myAllowWidening) {
            JSTypeImpl jSTypeImpl = this;
            if (jSTypeImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(41);
            }
            return jSTypeImpl;
        }
        if (allowResolve) {
            JSResolvedTypeInfo info = this.resolveType();
            if (info.isEnumLiteral()) {
                JSType jSType = TypeScriptUtil.getBaseTypeOfEnumLiteralType(this);
                if (jSType == null) {
                    JSTypeImpl.$$$reportNull$$$0(42);
                }
                return jSType;
            }
            JSTypeImpl jSTypeImpl = this;
            if (jSTypeImpl == null) {
                JSTypeImpl.$$$reportNull$$$0(43);
            }
            return jSTypeImpl;
        }
        JSType jSType = JSWidenType.createWidening(this, null);
        if (jSType == null) {
            JSTypeImpl.$$$reportNull$$$0(44);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(45);
        }
        Stream<JSType> stream = JSTypeImpl.getFunctionTypesForNamedType(this, processingContext, newCallSignatures);
        if (stream == null) {
            JSTypeImpl.$$$reportNull$$$0(46);
        }
        return stream;
    }

    public static Stream<JSType> getFunctionTypesForNamedType(@NotNull JSNamespace type, @NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        Stream types2;
        List collect;
        JSRecordType substitute;
        Collection<TypeScriptInterface> interfaces;
        boolean isStaticContext;
        if (type == null) {
            JSTypeImpl.$$$reportNull$$$0(47);
        }
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(48);
        }
        JSTypeSource source = type.getSource();
        boolean bl = isStaticContext = type.getTypeContext() == JSTypeContext.STATIC;
        if (source.isJavaScript() && isStaticContext && source.getSourceElement() instanceof JSFunctionItem) {
            return Stream.of(type);
        }
        if (source.isJavaScript() && !isStaticContext && (interfaces = JSTypeUtils.getTypeScriptInterfaceInJavaScriptContext((JSType)type)).size() > 0) {
            return interfaces.stream().flatMap(anInterface -> TypeScriptSignatureChooser.getCallSignatures(anInterface, ThreeState.fromBoolean((boolean)newCallSignatures)).stream()).map(function2 -> TypeScriptTypeParser.buildFunctionType(function2.myFunctionItem));
        }
        Object object = substitute = !type.isJavaScript() || isStaticContext ? type.asRecordType() : type;
        if (substitute != type && !(collect = (types2 = substitute.getFunctionTypes(processingContext, newCallSignatures)).collect(Collectors.toList())).isEmpty()) {
            return collect.stream();
        }
        if (newCallSignatures && isStaticContext) {
            JSNamespace instanceType = type.copyWithTypeContext(JSTypeContext.INSTANCE);
            return Stream.of(new JSFunctionTypeImpl(type.getSource(), ContainerUtil.emptyList(), (JSType)instanceType));
        }
        return Stream.empty();
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarations() {
        JSType typedef = this.getJSTypedef();
        if (typedef != null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSTypeImpl.$$$reportNull$$$0(49);
            }
            return list2;
        }
        Collection<PsiElement> collection = JSResolvableType.super.getDeclarations();
        if (collection == null) {
            JSTypeImpl.$$$reportNull$$$0(50);
        }
        return collection;
    }

    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    public boolean isLocal() {
        return this.myIsLocal;
    }

    @Nullable
    public PsiElement getLocalScope() {
        return this.myIsLocal ? (PsiElement)this.myLocalScope.getValue() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeImpl";
                break;
            }
            case 13: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 18: 
            case 20: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolvedTypeInfoCachedValue";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleResolvedTypeText";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "expandDefaultGenericsForSingleType";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "widen";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcModification";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createResolvedTypeInfoCachedValue";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 50: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "expandDefaultGenericsForSingleType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "validateAliases";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidForAlias";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesForNamedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

